dnl ##
dnl ##  aclocal.m4 -- Pth Autoconf macros
dnl ##
dnl ##  Copyright (c) 1999 Ralf S. Engelschall <rse@engelschall.com>
dnl ##
dnl ##  This file is part of GNU Pth, a non-preemptive thread scheduling
dnl ##  library which can be found at http://www.gnu.org/software/pth/.
dnl ##
dnl ##  This library is free software; you can redistribute it and/or
dnl ##  modify it under the terms of the GNU Library General Public
dnl ##  License as published by the Free Software Foundation; either
dnl ##  version 2 of the License, or (at your option) any later version.
dnl ##
dnl ##  This library is distributed in the hope that it will be useful,
dnl ##  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl ##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
dnl ##  Library General Public License for more details.
dnl ##
dnl ##  You should have received a copy of the GNU Library General Public
dnl ##  License along with this library; if not, write to the Free Software
dnl ##  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
dnl ##  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
dnl ##

divert(-1)

dnl ##
dnl ##  Display Configuration Headers
dnl ##
dnl ##  configure.in:
dnl ##    AC_MSG_PART(<text>)
dnl ##

define(AC_MSG_PART,[dnl
AC_MSG_RESULT()
AC_MSG_RESULT(${TB}$1:${TN})
])dnl

dnl ##
dnl ##  Display a message under --verbose
dnl ##
dnl ##  configure.in:
dnl ##    AC_MSG_VERBOSE(<text>)
dnl ##

define(AC_MSG_VERBOSE,[dnl
if test ".$verbose" = .yes; then
    AC_MSG_RESULT([  $1])
fi
])

dnl ##
dnl ##  Do not display message for a command
dnl ##
dnl ##  configure.in:
dnl ##    AC_MSG_SILENT(...)
dnl ##

define(AC_FD_TMP, 9)
define(AC_MSG_SILENT,[dnl
exec AC_FD_TMP>&AC_FD_MSG AC_FD_MSG>/dev/null
$1
exec AC_FD_MSG>&AC_FD_TMP AC_FD_TMP>&-
])

dnl ##
dnl ##  Perform something only once
dnl ##
dnl ##  configure.in:
dnl ##    AC_ONCE(<action>)
dnl ##

define(AC_ONCE,[
ifelse(ac_once_$1, already_done, ,[
    define(ac_once_$1, already_done)
    $2
])dnl
])

dnl ##
dnl ##  Minimalistic Libtool Glue Code
dnl ##
dnl ##  configure.in:
dnl ##    AC_PROG_LIBTOOL(<platform-variable>)
dnl ##

AC_DEFUN(AC_PROG_LIBTOOL,[dnl
AC_ARG_ENABLE(static,dnl
[  --enable-static         build static libraries (default=yes)],
enable_static="$enableval",
if test ".$enable_static" = .; then
    enable_static=yes
fi
)dnl
AC_ARG_ENABLE(shared,dnl
[  --enable-shared         build shared libraries (default=yes)],
enable_shared="$enableval",
if test ".$enable_shared" = .; then
    enable_shared=yes
fi
)dnl
libtool_flags=''
dnl libtool_flags="$libtool_flags --cache-file=$cache_file"
test ".$enable_static"     = .no  && libtool_flags="$libtool_flags --disable-static"
test ".$enable_shared"     = .no  && libtool_flags="$libtool_flags --disable-shared"
test ".$ac_cv_prog_gcc"    = .yes && libtool_flags="$libtool_flags --with-gcc"
test ".$ac_cv_prog_gnu_ld" = .yes && libtool_flags="$libtool_flags --with-gnu-ld"
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" LD="$LD" \
${CONFIG_SHELL-/bin/sh} $srcdir/ltconfig --no-reexec \
$libtool_flags --srcdir=$srcdir --no-verify $srcdir/ltmain.sh $1 ||\
AC_MSG_ERROR([libtool configuration failed])
dnl (AC_CACHE_LOAD) >/dev/null 2>&1
])dnl

dnl ##
dnl ##  Debugging Support  
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_DEBUGGING
dnl ##  

AC_DEFUN(AC_CHECK_DEBUGGING,[dnl
AC_MSG_CHECKING(for compilation debug mode)
AC_ARG_ENABLE(debug,dnl
[  --enable-debug          build for debugging (default=no)],
[dnl
if test ".$ac_cv_prog_gcc" = ".yes"; then
    case "$CFLAGS" in
        *-O2* ) ;;
            * ) CFLAGS="$CFLAGS -O2" ;;
    esac
    case "$CFLAGS" in
        *-g* ) ;;
           * ) CFLAGS="$CFLAGS -g" ;;
    esac
    case "$CFLAGS" in
        *-pipe* ) ;;
              * ) CFLAGS="$CFLAGS -pipe" ;;
    esac
    CFLAGS="$CFLAGS -ggdb3"
    CFLAGS="$CFLAGS -pedantic"
    CFLAGS="$CFLAGS -Wall -Wshadow -Wpointer-arith -Wcast-align"
    CFLAGS="$CFLAGS -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Winline"
else
    case "$CFLAGS" in
        *-g* ) ;;
           * ) CFLAGS="$CFLAGS -g" ;;
    esac
fi
msg="enabled"
AC_DEFINE(PTH_DEBUG)
],[
if test ".$ac_cv_prog_gcc" = ".yes"; then
case "$CFLAGS" in
    *-pipe* ) ;;
          * ) CFLAGS="$CFLAGS -pipe" ;;
esac
fi
case "$CFLAGS" in
    *-g* ) CFLAGS=`echo "$CFLAGS" |\
                   sed -e 's/ -g / /g' -e 's/ -g$//' -e 's/^-g //g' -e 's/^-g$//'` ;;
esac
case "$CXXFLAGS" in
    *-g* ) CFXXLAGS=`echo "$CFXXLAGS" |\
                     sed -e 's/ -g / /g' -e 's/ -g$//' -e 's/^-g //g' -e 's/^-g$//'` ;;
esac
msg=disabled
])dnl
AC_MSG_RESULT([$msg])
if test ".$msg" = .enabled; then
    enable_shared=no
fi
])

dnl ##
dnl ##  Profiling Support  
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_PROFILING
dnl ##

AC_DEFUN(AC_CHECK_PROFILING,[dnl
AC_MSG_CHECKING(for compilation profile mode)
AC_ARG_ENABLE(profile,dnl
[  --enable-profile        build for profiling (default=no)],
[dnl
if test ".$ac_cv_prog_gcc" = ".no"; then
    AC_MSG_ERROR([profiling requires gcc and gprof])
fi
CFLAGS=`echo "$CFLAGS" | sed -e 's/-O2//g'`
CFLAGS="$CFLAGS -O0 -pg"
LDFLAGS="$LDFLAGS -pg"
msg="enabled"
],[
msg="disabled"
])dnl
AC_MSG_RESULT([$msg])
if test ".$msg" = .enabled; then
    enable_shared=no
fi
])

dnl ##
dnl ##  Check for a pre-processor define in a header
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_DEFINE(<define>, <header>)
dnl ##  acconfig.h:
dnl ##    #undef HAVE_<define>
dnl ##

AC_DEFUN(AC_CHECK_DEFINE,[dnl
AC_MSG_CHECKING(for define $1 in $2)
AC_CACHE_VAL(ac_cv_define_$1,
[AC_EGREP_CPP([YES_IS_DEFINED], [
#include <$2>
#ifdef $1
YES_IS_DEFINED
#endif
], ac_cv_define_$1=yes, ac_cv_define_$1=no)])dnl
AC_MSG_RESULT($ac_cv_define_$1)
if test $ac_cv_define_$1 = yes; then
    AC_DEFINE(HAVE_[]translit($1, [a-z], [A-Z]))
fi
])

dnl ##
dnl ##  Check for an ANSI C typedef in a header
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_TYPEDEF(<typedef>, <header>)
dnl ##  acconfig.h:
dnl ##    #undef HAVE_<typedef>
dnl ##

AC_DEFUN(AC_CHECK_TYPEDEF,[dnl
AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for typedef $1)
AC_CACHE_VAL(ac_cv_typedef_$1,
[AC_EGREP_CPP(dnl
changequote(<<,>>)dnl
<<(^|[^a-zA-Z_0-9])$1[^a-zA-Z_0-9]>>dnl
changequote([,]), [
#include <$2>
], ac_cv_typedef_$1=yes, ac_cv_typedef_$1=no)])dnl
AC_MSG_RESULT($ac_cv_typedef_$1)
if test $ac_cv_typedef_$1 = yes; then
    AC_DEFINE(HAVE_[]translit($1, [a-z], [A-Z]))
fi
])

dnl ##
dnl ##  Check for argument type of a function
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_ARGTYPE(<header>, <func>, <arg-number>, <action-with-$type>)
dnl ##

AC_DEFUN(AC_CHECK_ARGTYPE,[dnl
AC_REQUIRE_CPP()dnl
AC_MSG_CHECKING([for type of arg $3 in $2()])
AC_CACHE_VAL([ac_cv_argtype_$2$3],[
cat >conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
EOF
for ifile in $1; do
    echo "#include <$ifile>" >>conftest.$ac_ext
done
gpat=''
spat=''
i=1
changequote(, )dnl
while test $i -le $3; do
    gpat="$gpat[^,]*"
    if test $i -eq $3; then
        spat="$spat\\([^,]*\\)"
    else
        spat="$spat[^,]*"
    fi
    if test $i -lt $3; then
        gpat="$gpat,"
        spat="$spat,"
    fi
    i=`expr $i + 1`
done
(eval "$ac_cpp conftest.$ac_ext") 2>&AC_FD_CC |\
egrep "[^a-zA-Z0-9_]$2[     ]*\($gpat\)" | head -1 |\
sed -e "s/.*[^a-zA-Z0-9_]$2[    ]*($spat).*/\\1/" >conftest.output
changequote([, ])dnl
ac_cv_argtype_$2$3=`cat conftest.output | awk '{ printf("%s", [$]1); }'`
rm -f conftest*
dnl#
])
AC_MSG_RESULT([$ac_cv_argtype_$2$3])
type="$ac_cv_argtype_$2$3"
[$4]
])

dnl ##
dnl ##  Decision Hierachy
dnl ##

define(AC_IFALLYES,[dnl
ac_rc=yes
for ac_spec in $1; do
    ac_type=`echo "$ac_spec" | sed -e 's/:.*$//'`
    ac_item=`echo "$ac_spec" | sed -e 's/^.*://'`
    case $ac_type in
        header [)]
            ac_item=`echo "$ac_item" | sed 'y%./+-%__p_%'`
            ac_var="ac_cv_header_$ac_item"
            ;;
        file [)]
            ac_item=`echo "$ac_item" | sed 'y%./+-%__p_%'`
            ac_var="ac_cv_file_$ac_item"
            ;;
        func    [)] ac_var="ac_cv_func_$ac_item"   ;;
        lib     [)] ac_var="ac_cv_lib_$ac_item"    ;;
        define  [)] ac_var="ac_cv_define_$ac_item" ;;
        typedef [)] ac_var="ac_cv_typedef_$ac_item" ;;
        custom  [)] ac_var="$ac_item" ;;
    esac
    eval "ac_val=\$$ac_var"
    if test ".$ac_val" != .yes; then
        ac_rc=no
        break
    fi
done
if test ".$ac_rc" = .yes; then
    :
    $2
else
    :
    $3
fi
])

define(AC_BEGIN_DECISION,[dnl
ac_decision_item='$1'
ac_decision_msg='FAILED'
ac_decision=''
])

define(AC_DECIDE,[dnl
ac_decision='$1'
ac_decision_msg='$2'
ac_decision_$1=yes
ac_decision_$1_msg='$2'
])

define(AC_DECISION_OVERRIDE,[dnl
    ac_decision=''
    for ac_item in $1; do
         eval "ac_decision_this=\$ac_decision_${ac_item}"
         if test ".$ac_decision_this" = .yes; then
             ac_decision=$ac_item
             eval "ac_decision_msg=\$ac_decision_${ac_item}_msg"
         fi
    done
])

define(AC_DECISION_FORCE,[dnl
ac_decision="$1"
eval "ac_decision_msg=\"\$ac_decision_${ac_decision}_msg\""
])

define(AC_END_DECISION,[dnl
if test ".$ac_decision" = .; then
    echo "[$]0:Error: decision on $ac_decision_item failed" 1>&2
    exit 1
else
    if test ".$ac_decision_msg" = .; then
        ac_decision_msg="$ac_decision"
    fi
    AC_MSG_RESULT([decision on $ac_decision_item... ${TB}$ac_decision_msg${TN}])
fi
])

dnl ##
dnl ##  Check for existance of a file
dnl ##
dnl ##  configure.in:
dnl ##    AC_TEST_FILE(<file>, <success-action>, <failure-action>)
dnl ##

AC_DEFUN(AC_TEST_FILE, [
ac_safe=`echo "$1" | sed 'y%./+-%__p_%'`
AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_file_$ac_safe, [
if test -r $1; then
    eval "ac_cv_file_$ac_safe=yes"
else
    eval "ac_cv_file_$ac_safe=no"
fi
])dnl
if eval "test \"`echo '$ac_cv_file_'$ac_safe`\" = yes"; then
    AC_MSG_RESULT(yes)
    ifelse([$2], , :, [$2])
else
    AC_MSG_RESULT(no)
    ifelse([$3], , :, [$3])
fi
])

dnl ##
dnl ##  Check for direction of stack growth
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_STACKGROWTH(<define>)
dnl ##  acconfig.h:
dnl ##    #undef <define>
dnl ##  source.c:
dnl ##    #include "config.h"
dnl ##    #if <define> < 0
dnl ##        ...stack grow down...
dnl ##    #else
dnl ##        ...stack grow up...
dnl ##    #endif
dnl ##

AC_DEFUN(AC_CHECK_STACKGROWTH,[dnl
AC_MSG_CHECKING(for direction of stack growth)
AC_CACHE_VAL(ac_cv_check_stackgrowth, [
cross_compile=no
AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#include <stdio.h>
static int growsdown(int *x)
{
    int y;
    return (x > &y);
}
int main(int argc, char *argv[])
{
    FILE *f;
    int x;
    if ((f = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(f, "%s\n", growsdown(&x) ? "down" : "up");;
    fclose(f);
    exit(0);
}
>>
changequote([, ])dnl
,
ac_cv_check_stackgrowth=`cat conftestval`,
ac_cv_check_stackgrowth=down,
ac_cv_check_stackgrowth=down
)dnl
])dnl
AC_MSG_RESULT([$ac_cv_check_stackgrowth])
if test ".$ac_cv_check_stackgrowth" = ".down"; then
    val="-1"
else
    val="+1"
fi
AC_DEFINE_UNQUOTED($1, $val)
])

dnl ##
dnl ##  Check whether and how a POSIX compliant sigsetjmp(3) can be achieved
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_SJLJ(<success-action>, <failure-action>, <type-var>)
dnl ##

AC_DEFUN(AC_CHECK_SJLJ,[dnl
AC_MSG_CHECKING(for signal-mask aware setjmp(3)/longjmp(3))
AC_CACHE_VAL(ac_cv_check_sjlj, [
AC_IFALLYES(func:setjmp func:longjmp, ac_cv_check_sjlj=sjlje, ac_cv_check_sjlj=none)
cross_compile=no
for testtype in ssjlj sjlj usjlj; do
OCFLAGS="$CFLAGS"
CFLAGS="$CFLAGS -DTEST_${testtype}"
AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#if defined(TEST_ssjlj)
#define __JMP_BUF          sigjmp_buf
#define __SETJMP(buf)      sigsetjmp(buf,1)
#define __LONGJMP(buf,val) siglongjmp(buf,val)
#elif defined(TEST_sjlj)
#define __JMP_BUF          jmp_buf
#define __SETJMP(buf)      setjmp(buf)
#define __LONGJMP(buf,val) longjmp(buf,val)
#elif defined(TEST_usjlj)
#define __JMP_BUF          jmp_buf
#define __SETJMP(buf)      _setjmp(buf)
#define __LONGJMP(buf,val) _longjmp(buf,val)
#endif

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>
#include <unistd.h>

static __JMP_BUF jb;

static void sighandler(int sig)
{
    sigset_t sigs;
    
    /* get signal mask */
    sigprocmask(SIG_SETMASK, NULL, &sigs);

    /* make sure USR1 is still blocked */
    if (!sigismember(&sigs, SIGUSR1))
        exit(1);

    /* block USR2 for us */
    sigaddset(&sigs, SIGUSR2);
    sigprocmask(SIG_SETMASK, &sigs, NULL);

    /* jump back to main */
    __LONGJMP(jb, 1);
    exit(1);
}

int main(int argc, char *argv[]) 
{
    FILE *fp;
    sigset_t sigs;
    struct sigaction sa;
    
    /* the default is that it fails */
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "failed\n");
    fclose(fp);

    /* block USR1 and unblock USR2 signal */
    sigprocmask(SIG_SETMASK, NULL, &sigs);
    sigaddset(&sigs, SIGUSR1);
    sigdelset(&sigs, SIGUSR2);
    sigprocmask(SIG_SETMASK, &sigs, NULL);

    /* set jump buffer */
    if (__SETJMP(jb) == 0) {

        /* install signal handler for USR1 */
        memset((void *)&sa, 0, sizeof(struct sigaction));
        sigemptyset(&sa.sa_mask);
        sa.sa_handler = sighandler;
        sa.sa_flags = 0;
        sigaction(SIGUSR1, &sa, NULL);

        /* send USR1 signal (which is still blocked) */
        kill(getpid(), SIGUSR1);
        
        /* unblock USR1 and wait for it */
        sigprocmask(SIG_SETMASK, NULL, &sigs);
        sigdelset(&sigs, SIGUSR1);
        sigsuspend(&sigs);
        exit(1);
    }

    /* get signal mask again */
    sigprocmask(SIG_SETMASK, NULL, &sigs);

    /* make sure USR2 is again unblocked */
    if (sigismember(&sigs, SIGUSR2))
        exit(1);

    /* Fine... */
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "ok\n");
    fclose(fp);
    exit(0);
}
>>
changequote([, ]),
rc=`cat conftestval`,
rc=failed,
rc=failed
)dnl
CFLAGS="$OCFLAGS"
if test ".$rc" = .ok; then
    ac_cv_check_sjlj=$testtype
    break
fi
done
case $PLATFORM in
    *-*-linux* ) ac_cv_check_sjlj=sjljlx ;;
esac
])dnl
$3="$ac_cv_check_sjlj"
if test ".$ac_cv_check_sjlj" != .none; then
    AC_MSG_RESULT([yes: $ac_cv_check_sjlj])
    ifelse([$1], , :, [$1])
else
    AC_MSG_RESULT([no])
    ifelse([$2], , :, [$2])
fi
])dnl

dnl ##
dnl ##  Check for number of signals (NSIG)
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_NSIG(<define>)
dnl ##  acconfig.h:
dnl ##    #undef <define>
dnl ##  source.c:
dnl ##    #include "config.h"
dnl ##    ...<define>...

AC_DEFUN(AC_CHECK_NSIG,[dnl
AC_MSG_CHECKING(for number of signals)
cross_compile=no
AC_TRY_RUN(
changequote(<<, >>)dnl
<<
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>

int main(int argc, char *argv[]) 
{
    FILE *fp;
    int nsig;

#if defined(NSIG)
    nsig = NSIG;
#elif defined(_NSIG)
    nsig = _NSIG;
#else
    nsig = (sizeof(sigset_t)*8);
    if (nsig < 32)
        nsig = 32;
#endif
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "%d\n", nsig);
    fclose(fp);
    exit(0);
}
>>
changequote([, ])dnl
,
nsig=`cat conftestval`,
nsig=32,
nsig=32
)dnl
AC_MSG_RESULT([$nsig])
AC_DEFINE_UNQUOTED($1, $nsig)
])

dnl ##
dnl ##  Check for an external/extension library.
dnl ##  - is aware of <libname>-config style scripts
dnl ##  - searches under standard paths include, lib, etc.
dnl ##  - searches under subareas like .libs, etc.
dnl ##
dnl ##  configure.in:
dnl ##      AC_CHECK_EXTLIB(<realname>, <libname>, <func>, <header>,
dnl ##                      [<success-action> [, <fail-action>]])
dnl ##  Makefile.in:
dnl ##      CFLAGS  = @CFLAGS@
dnl ##      LDFLAGS = @LDFLAGS@
dnl ##      LIBS    = @LIBS@
dnl ##  shell:
dnl ##      $ ./configure --with-<libname>[=DIR]
dnl ##

AC_DEFUN(AC_CHECK_EXTLIB,[dnl
AC_ARG_WITH($2,dnl
[  --with-]substr([$2[[=DIR]]                 ], 0, 19)[build against $1 library (default=no)],
    if test ".$with_$2" = .yes; then
        #   via config script
        $2_version=`($2-config --version) 2>/dev/null`
        if test ".$$2_version" != .; then
            CPPFLAGS="$CPPFLAGS `$2-config --cflags`"
            CFLAGS="$CFLAGS `$2-config --cflags`"
            LDFLAGS="$LDFLAGS `$2-config --ldflags`"
        fi
    else
        if test -d "$with_$2"; then
            found=0
            #   via config script
            for dir in $with_$2/bin $with_$2; do
                if test -f "$dir/$2-config"; then
                    $2_version=`($2-config --version) 2>/dev/null`
                    if test ".$$2_version" != .; then
                        CPPFLAGS="$CPPFLAGS `$2-config --cflags`"
                        CFLAGS="$CFLAGS `$2-config --cflags`"
                        LDFLAGS="$LDFLAGS `$2-config --ldflags`"
                        found=1
                        break
                    fi
                fi
            done
            #   via standard paths
            if test ".$found" = .0; then
                for dir in $with_$2/include/$2 $with_$2/include $with_$2; do
                    if test -f "$dir/$4"; then
                        CPPFLAGS="$CPPFLAGS -I$dir"
                        CFLAGS="$CFLAGS -I$dir"
                        found=1
                        break
                    fi
                done
                for dir in $with_$2/lib/$2 $with_$2/lib $with_$2; do
                    if test -f "$dir/lib$2.a" -o -f "$dir/lib$2.so"; then
                        LDFLAGS="$LDFLAGS -L$dir"
                        found=1
                        break
                    fi
                done
            fi
            #   in any subarea
            if test ".$found" = .0; then
changequote(, )dnl
                for file in x `find $with_$2 -name "$4" -type f -print`; do
                    test .$file = .x && continue
                    dir=`echo $file | sed -e 's;[[^/]]*$;;' -e 's;\(.\)/$;\1;'`
                    CPPFLAGS="$CPPFLAGS -I$dir"
                    CFLAGS="$CFLAGS -I$dir"
                done
                for file in x `find $with_$2 -name "lib$2.[[aso]]" -type f -print`; do
                    test .$file = .x && continue
                    dir=`echo $file | sed -e 's;[[^/]]*$;;' -e 's;\(.\)/$;\1;'`
                    LDFLAGS="$LDFLAGS -L$dir"
                done
changequote([, ])dnl
            fi
        fi
    fi
    AC_HAVE_HEADERS($4)
    AC_CHECK_LIB($2, $3)
    AC_IFALLYES(header:$4 lib:$2_$3, with_$2=yes, with_$2=no)
    if test ".$with_$2" = .no; then
        AC_ERROR([Unable to find $1 library])
    fi
,
if test ".$with_$2" = .; then
    with_$2=no
fi
)dnl
AC_MSG_CHECKING(whether to build against $1 library)
if test ".$with_$2" = .yes; then
    ifelse([$5], , :, [$5])
else
    ifelse([$6], , :, [$6])
fi
AC_MSG_RESULT([$with_$2])
])dnl

dnl ##
dnl ##  Check whether SVR4/SUSv2 makecontext(2), swapcontext(2) and 
dnl ##  friends can be used for user-space context switching
dnl ##
dnl ##  configure.in:
dnl ##     AC_CHECK_MCSC(<success-action>, <failure-action>)
dnl ##

AC_DEFUN(AC_CHECK_MCSC, [
AC_MSG_CHECKING(for usable SVR4/SUSv2 makecontext(2)/swapcontext(2))
AC_CACHE_VAL(ac_cv_check_mcsc, [
AC_TRY_RUN([

#include <stdio.h>
#include <stdlib.h>
#include <ucontext.h>

ucontext_t uc_child;
ucontext_t uc_main;

void child(void *arg)
{
    if (arg != (void *)12345)
        exit(1);
    if (swapcontext(&uc_child, &uc_main) != 0)
        exit(1);
}

int main(int argc, char *argv[]) 
{
    FILE *fp;
    void *stack;
    
    /* the default is that it fails */
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "no\n");
    fclose(fp);

    /* configure a child user-space context */
    if ((stack = malloc(32768)) == NULL)
        exit(1);
    if (getcontext(&uc_child) != 0)
        exit(1);
    makecontext(&uc_child, child, 2, (void *)12345);

    /* switch into the user context */
    if (swapcontext(&uc_main, &uc_child) != 0)
        exit(1);

    /* Fine, child came home */
    if ((fp = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(fp, "yes\n");
    fclose(fp);

    /* die successfully */
    exit(0);
}
],
ac_cv_check_mcsc=`cat conftestval`,
ac_cv_check_mcsc=no,
ac_cv_check_mcsc=no
)dnl
])dnl
AC_MSG_RESULT([$ac_cv_check_mcsc])
if test ".$ac_cv_check_mcsc" = .yes; then
    ifelse([$1], , :, [$1])
else
    ifelse([$2], , :, [$2])
fi
])dnl

dnl ##
dnl ##  Check how stacks have to be setup for the functions
dnl ##  sigstack(2), sigaltstack(2) and makecontext(2).
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_STACKSETUP(sigstack|sigaltstack|makecontext, <macro-addr>, <macro-size>)
dnl ##  acconfig.h:
dnl ##    #undef HAVE_{SIGSTACK|SIGALTSTACK|MAKECONTEXT}
dnl ##    #undef HAVE_STACK_T
dnl ##  header.h.in:
dnl ##    @<macro-addr>@
dnl ##    @<macro-size>@
dnl ##  source.c:
dnl ##    #include "header.h"
dnl ##    xxx.sp_ss   = <macro-addr>(skaddr, sksize);
dnl ##    xxx.sp_size = <macro-size>(skaddr, sksize);
dnl ##

AC_DEFUN(AC_CHECK_STACKSETUP,[dnl
dnl #   check for consistent usage
ifelse($1,[sigstack],,[
ifelse($1,[sigaltstack],,[
ifelse($1,[makecontext],,[
errprint(__file__:__line__: [AC_CHECK_STACKSETUP: only sigstack, sigaltstack and makecontext supported
])])])])
dnl #   we require the C compiler and the standard headers
AC_REQUIRE([AC_HEADER_STDC])dnl
dnl #   we at least require the function to check
AC_CHECK_FUNCS($1)
dnl #   sigaltstack on some platforms uses stack_t instead of struct sigaltstack
ifelse($1, sigaltstack, [
    AC_ONCE(stacksetup_stack_t, [
        AC_CHECK_TYPEDEF(stack_t, signal.h)
    ])
])
dnl #   display processing header
AC_MSG_CHECKING(for stack setup via $1)
dnl #   but cache the whole results
AC_CACHE_VAL(ac_cv_stacksetup_$1,[
if test ".$ac_cv_func_$1" = .no; then
    dnl #   no need to check anything when function is already missing
    ac_cv_stacksetup_$1="N.A.:/*N.A.*/,/*N.A.*/"
else
    dnl #   setup compile environment
    OCFLAGS="$CFLAGS"
    CFLAGS="$CFLAGS -DTEST_$1"
    cross_compile=no
    dnl #   compile and run the test program
    AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(TEST_sigstack) || defined(TEST_sigaltstack)
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#endif
#if defined(TEST_makecontext)
#include <ucontext.h>
#endif
union alltypes {
    long   l;
    double d;
    void  *vp;
    void (*fp)(void);
    char  *cp;
};
static volatile char *handler_addr = (char *)0xDEAD;
#if defined(TEST_sigstack) || defined(TEST_sigaltstack)
static volatile int handler_done = 0;
void handler(int sig)
{
    char garbage[1024];
    int i;
    auto int dummy;
    for (i = 0; i < 1024; i++)
        garbage[i] = 'X';
    handler_addr = (char *)&dummy;
    handler_done = 1;
    return;
}
#endif
#if defined(TEST_makecontext)
static ucontext_t uc_handler;
static ucontext_t uc_main;
void handler(void)
{
    char garbage[1024];
    int i;
    auto int dummy;
    for (i = 0; i < 1024; i++)
        garbage[i] = 'X';
    handler_addr = (char *)&dummy;
    swapcontext(&uc_handler, &uc_main);
    return;
}
#endif
int main(int argc, char *argv[])
{
    FILE *f;
    char *skaddr;
    char *skbuf;
    int sksize;
    char result[1024];
    int i;
    sksize = 32768;
    skbuf = (char *)malloc(sksize*2+2*sizeof(union alltypes));
    if (skbuf == NULL)
        exit(1);
    for (i = 0; i < sksize*2+2*sizeof(union alltypes); i++)
        skbuf[i] = 'A';
    skaddr = skbuf+sizeof(union alltypes);
#if defined(TEST_sigstack) || defined(TEST_sigaltstack)
    {
        struct sigaction sa;
#if defined(TEST_sigstack)
        struct sigstack ss;
#elif defined(TEST_sigaltstack) && defined(HAVE_STACK_T)
        stack_t ss;
#else
        struct sigaltstack ss;
#endif
#if defined(TEST_sigstack)
        ss.ss_sp      = (void *)(skaddr + sksize);
        ss.ss_onstack = 0;
        if (sigstack(&ss, NULL) < 0)
            exit(1);
#elif defined(TEST_sigaltstack)
        ss.ss_sp    = (void *)(skaddr + sksize); 
        ss.ss_size  = sksize;
        ss.ss_flags = 0;
        if (sigaltstack(&ss, NULL) < 0)
            exit(1);
#endif
        memset((void *)&sa, 0, sizeof(struct sigaction));
        sa.sa_handler = handler;
        sa.sa_flags = SA_ONSTACK;
        sigemptyset(&sa.sa_mask);
        sigaction(SIGUSR1, &sa, NULL);
        kill(getpid(), SIGUSR1);
        while (!handler_done)
            /*nop*/;
    }
#endif
#if defined(TEST_makecontext)
    {
        if (getcontext(&uc_handler) != 0)
            exit(1);
        uc_handler.uc_link = NULL;
        uc_handler.uc_stack.ss_sp    = (void *)(skaddr + sksize);
        uc_handler.uc_stack.ss_size  = sksize;
        uc_handler.uc_stack.ss_flags = 0;
        makecontext(&uc_handler, handler, 1);
        swapcontext(&uc_main, &uc_handler);
    }
#endif
    if (handler_addr == (char *)0xDEAD)
        exit(1);
    if (handler_addr < skaddr+sksize) {
        /* stack was placed into lower area */
        if (*(skaddr+sksize) != 'A')
             sprintf(result, "(skaddr)+(sksize)-%d,(sksize)-%d",
                     sizeof(union alltypes), sizeof(union alltypes)); 
        else
             strcpy(result, "(skaddr)+(sksize),(sksize)"); 
    }
    else {
        /* stack was placed into higher area */
        if (*(skaddr+sksize*2) != 'A')
            sprintf(result, "(skaddr),(sksize)-%d", sizeof(union alltypes));
        else
            strcpy(result, "(skaddr),(sksize)");
    }
    if ((f = fopen("conftestval", "w")) == NULL)
        exit(1);
    fprintf(f, "%s\n", result);
    fclose(f);
    exit(0);
}
],[
dnl #   test successully passed
ac_cv_stacksetup_$1=`cat conftestval`
ac_cv_stacksetup_$1="ok:$ac_cv_stacksetup_$1"
],[
dnl #   test failed
ac_cv_stacksetup_$1='guessed:(skaddr),(sksize)'
],[
dnl #   cross-platform => failed
ac_cv_stacksetup_$1='guessed:(skaddr),(sksize)'
])dnl
dnl #   restore original compile environment
CFLAGS="$OCFLAGS"
])dnl
fi
dnl #   extract result ingredients of single cached result value
type=`echo $ac_cv_stacksetup_$1 | sed -e 's;:.*$;;'`
addr=`echo $ac_cv_stacksetup_$1 | sed -e 's;^.*:;;' -e 's;,.*$;;'`
size=`echo $ac_cv_stacksetup_$1 | sed -e 's;^.*:;;' -e 's;^.*,;;'`
dnl #   export result ingredients
$2="#define $2(skaddr,sksize) ($addr)"
$3="#define $3(skaddr,sksize) ($size)"
AC_SUBST($2)dnl
AC_SUBST($3)dnl
dnl #   display result indicator
AC_MSG_RESULT([$type])
dnl #   display results in detail
AC_MSG_VERBOSE([$]$2)
AC_MSG_VERBOSE([$]$3)
])

divert

