<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

    class Resource
    {
        // Properties
        public $ID;
        public $Code;
        public $Value;
        public $DropDownItemValue;
        public $StyleClass;
        public $SortOrder;
        public $LFT;
        public $RGT;

        // Constructor
        public function __construct($id = null, $code = null, $value = null, $dropdownitemvalue = null, $styleclass = null, $sortorder = null, $lft = null, $rgt = null)
        {
            $this->ID = $id;
            $this->Code = $code;
            $this->Value = $value;
            $this->DropDownItemValue = $dropdownitemvalue;
            $this->StyleClass = $styleclass;
            $this->SortOrder = $sortorder;
            $this->LFT = $lft;
            $this->RGT = $rgt;
        }
        
        // Methods
        public function LoadByCode($resCode, $langCode)
        {
            $this->Code = $resCode;
            
            $dataAccess = new MySqlDataAccess(Common::ConnectionString);
            $dataAccess->Command->CommandType = CommandType::StoredProcedure;  
            
            $dataAccess->Command->CommandText = "CALL sp_Resource_Load_By_Code('$resCode', '$langCode')";
            $dataAccess->GetData();
            
            if($dataAccess->ResultSet)
            {
                while($row = $dataAccess->ResultSet->fetch_assoc())
                {
                    $this->ID = $row['ResourceID'];
                    $this->Value = $row['Value'];
                    $this->DropDownItemValue = $row['DropDownItemValue'];
                    $this->StyleClass = $row['StyleClass'];
                    $this->SortOrder = $row['SortOrder'];
                    $this->LFT = $row['LFT'];
                    $this->RGT = $row['RGT'];
                }
            }

            $dataAccess->Cleanup();            
        }
    }

?>
