@c  Copyright (C) 2000, 2001 by Tom Cato Amundsen
@c  Permission is granted to copy, distribute and/or modify this document
@c  under the terms of the GNU Free Documentation License, Version 1.1
@c  or any later version published by the Free Software Foundation;
@c  with no Invariant Sections.

@c  $Id: chord-help.texi.m4,v 1.7 2001/12/15 10:44:36 tom Exp $

m4_include(texidefinitions.m4)

@settitle Chord

@section Identify chord

@subsection Practise

Solfege play a chord, and you identify it. The idea is that
you do this in three steps:

@itemize @bullet
@item
First identify chord type. Is the chord minor/major/diminished/septim?
@item
Then, what inversion?
@item
Finally, what tone is the toptone?
@end itemize

It is important that you take you time, maybe sing the chord, and
identify the chord type before you try to find the inversion.

Also note that this exercise use lesson files, and some
lessonfiles only ask for chord type, or chord type and inversion.

@subsection Key bindings
@itemize @bullet
@item
New: _ctrl_key(chord/new_ak, n)
@item
Repeat chord: _ctrl_key(chord/repeat_ak, r)
@item
Repeat arpeggio: _ctrl_key(chord/repeat_arpeggio_ak, a)
@item
Give up: _ctrl_key(chord/give_up_ak, g)
@end itemize

@subsection Config
On the top the the config page there is a frame labeled @emph{Lesson
file}, that selects what lessonfile to use. This frame is the same on all
exercises that use lessonfiles. There are two combo boxes. The one on the
let you select what collection of lession files to use. The collection
'solfege' contains the files distributed with the program. The 'user'
collection is files created by you, by default located in
@file{$HOME/lesson-files}.
It is possible to define other
collecitons by editing @file{$HOME/.solfegerc`'SOLFEGESHORTVERSION}.

Below that there is a frame labeled @emph{Change midi instrument
for this exercise}. If the @emph{Enable} checkbutton is checked,
the frame let you select three different instrument.
The first will be used for the highest tone in the chord, the
second for the middle tones and the last for the lowest tone in the chord.
If not enabled, Solfege will use the instrument set from the Preferences
window.
