#ifndef swsControlFile_19980901jhl_h
#define swsControlFile_19980901jhl_h

/*  

   Copyright (C) 1998  James H. Lowe, Jr.  <jhl@richmond.infi.net>

*/

/*
//
//  COPYING TERMS AND CONDITIONS
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#include "swstruct_i.h"
#include "swexstruct.h"

class swControlFile;

class swsControlFile: public swStruct_i {
    swControlFile * controlfile_;
public:
	swsControlFile (void);
	virtual ~swsControlFile(void);
	static swsControlFile * make_swstructure(void);

	int doProcess(swExStruct * swexdist)
	{
		swDefinition * swdef = get_swdefinition();
		swExStruct * parent = getSwExStructContext(swexdist);
		//Dead code return parent->addPackageFile(swdef);
		return -1;
	}

	virtual char * determineTag(void)
	{
		swDefinition * swdef = get_swdefinition();
		char * tag = swdef->find(SW_A_tag);
		if (!tag) {
			char *r;
			char * path = swdef->find("path");
			if (!path) {
				return static_cast<char*>(NULL);
			}
			r = strrchr(path, '/');
			if (!r) {
				r = path;
			}
			swdef->add(SW_A_tag, r);
			tag = swdef->find(SW_A_tag);
		}
		return tag;
	}
};
#endif
