/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { AmountString, MerchantContractTerms } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import {
  ErrorView,
  HiddenView,
  LoadingView,
  ShowView,
} from "./ShowFullContractTermPopup.js";

export default {
  title: "ShowFullContractTermPopup",
};

const cd: MerchantContractTerms = {
  products: [],
  nonce: "123",
  amount: "ARS:2" as AmountString,
  merchant_base_url: "https://merchant-backend.taler.ar/",
  merchant_pub: "JZYHJ13M91GMSQMT75J8Q6ZN0QP8XF8CRHR7K5MMWYE8JQB6AAPG",
  order_id: "2022.220-0281XKKB8W7YE",
  summary: "w",
  pay_deadline: {
    t_s: 1660002673,
  },
  refund_deadline: {
    t_s: 1660002673,
  },
  exchanges: [
    {
      master_pub: "1C2EYE90PYDNVRTQ25A3PA0KW5W4WPAJNNQHVHV49PT6W5CERFV0",
      url: "https://exchange.taler.ar/",
      priority: 1,
    },
  ],
  timestamp: {
    t_s: 1659972710,
  },
  wire_transfer_deadline: {
    t_s: 1659972710,
  },
  wire_method: "x-taler-bank",
  h_wire:
    "QDT28374ZHYJ59WQFZ3TW1D5WKJVDYHQT86VHED3TNMB15ANJSKXDYPPNX01348KDYCX6T4WXA5A8FJJ8YWNEB1JW726C1JPKHM89DR",
  max_fee: "ARS:1" as AmountString,
  merchant: {
    name: "Default",
    address: {
      country: "ar",
    },
    jurisdiction: {
      country: "ar",
    },
  },
  // products: [],
  auto_refund: undefined,
  summary_i18n: undefined,
  // deliveryDate: undefined,
  // deliveryLocation: undefined,
};

export const ShowingSimpleOrder = tests.createExample(ShowView, {
  contractTerms: cd,
});
export const Error = tests.createExample(ErrorView, {
  transactionId: "asd",
  error: {
    hasError: true,
    message: "message",
    // details: {
    //   co
    // },
    type: "error",
    // details: {
    //   code: 123,
    // },
  },
});
export const Loading = tests.createExample(LoadingView, {});
export const Hidden = tests.createExample(HiddenView, {});
