#!/usr/bin/perl

# Generate build_info.c.

# Copyright (C) 2009 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

use strict;
use warnings;

use FindBin qw($Bin);
use File::Spec ();

my $file = shift @ARGV;

{
    my $data = parse_config();
    output_code($data);
}

sub parse_config
{
    my (%block, @defines, %feature);

    open(my $fh, '<', $file) or die "Cannot open $file: $!";
    my $cfg = do { local $/; <$fh> };
    close($fh);

    while ($cfg =~ /^\ *? (\w+) (?:\s+?)? (\w+?)? \s*$/gmx) {
        $feature{$1} = $2 || '_MISSING';
        push @defines, $1;
    }
    while ($cfg =~ /^(\ *? \#\w+? \s+? (\w+) .+ \#\w+)/gmsx) {
        $block{$2} = $1;
    }

    my %data = (
        block   => \%block,
        defines => \@defines,
        feature => \%feature,
    );

    return \%data;
}

sub output_code
{
    my ($block, $defines, $feature) =
      map $_[0]->{$_}, qw(block defines feature);

    print do { local $/; <DATA> }, "\n";
    print <<EOC;
const char* (compiled_features[]) =
{

EOC
    my @output;
    foreach my $define (@$defines) {
        if (!exists $block->{$define}) {
            push @output, <<EOC;
#ifdef $define
  "+$feature->{$define}",
#else
  "-$feature->{$define}",
#endif
EOC
        }
        else {
            push @output, <<EOC;
$block->{$define}
EOC
        }
    }
    print join "\n", @output;
    print <<EOC;

  /* sentinel value */
  NULL
};


EOC
}

__DATA__
/* Autogenerated by build_info.pl - DO NOT EDIT */

/* This stores global variables that are initialized with
   preprocessor declarations for output with the --version flag.

   Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003,
   2004, 2005, 2006, 2007, 2008, 2009 Free Software Foundation, Inc.  */

#include "wget.h"
#include <stdio.h>
