#ifndef IMPORT_H
#define IMPORT_H
/*

  "libimport.a" include file for the Xlogmaster
  
  The libimport.a is basically consists of several functions that I had to grab out
  of the GNU C library because they don't exist on all systems.

  For clean separation between the "real" Xlogmaster source and the imported
  functions I created this directory where the libimport.a is built that is linked
  to the Xlogmaster in the end.

  Currently this supplies the following functions the Xlogmaster uses:

  - getopt_long_only()

  - all REGEXP functions from rx.h - rx.c is only built into libimport.a if it couldn't
  be found on the system to keep the Xlogmaster as small as possible


*/

/*
  first include the data from the configuration package if you
  haven't done so already... we need this to assure the flags
  like HAVE_RX_H are being set properly.
*/
#ifdef PACKAGE
#include "../config.h"
#endif /*PACKAGE */



/* 
   include file for proper GNUish commandline parsing 
*/
#if HAVE_GETOPT_H
/* take system wide include file */
#include <getopt.h>
#else
/* take our local one because system wide one doesn't exist */
#include "getopt.h"
#endif /* HAVE_GETOPT_H */




/* 
   include file for the REGEXP functions from the local system if possible,
   otherwise use our local version of it.
*/
#if HAVE_RX_H
/* take system wide include file */
#include <rx.h>
#else
/* take our local one because system wide one doesn't exist */
#include "rx.h"
#endif /* HAVE_RX_H */








#endif /* IMPORT_H */
