/*
 * Decompiled with CFR 0.152.
 */
package jde.ui.design;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jde.ui.design.DesignAction;
import jde.ui.design.Main;
import jde.ui.design.ResourceBrowser;
import jde.ui.design.StringBundleView;
import jde.ui.design.UI;
import jde.ui.design.UIEvent;
import jde.ui.design.UIEventListener;

public class MainFrame
extends JFrame {
    JDesktopPane fDesktop = new JDesktopPane();
    ResourceBrowser fResourceBrowser;

    public MainFrame() {
        ((Component)this).setSize(300, 500);
        this.setDefaultCloseOperation(3);
        this.getContentPane().add(this.fDesktop);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.getAccessibleContext().setAccessibleDescription("File menu");
        DesignAction action = new DesignAction("New", "new_ui");
        JMenuItem menuItem = menu.add(action);
        menuItem.getAccessibleContext().setAccessibleDescription("Creates a new user interface.");
        menuItem = new JMenuItem("Open");
        menuItem.getAccessibleContext().setAccessibleDescription("Opens a user interface.");
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menuItem.getAccessibleContext().setAccessibleDescription("Saves a user interface.");
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As");
        menuItem.getAccessibleContext().setAccessibleDescription("Saves a user interface under a new name.");
        menu.add(menuItem);
        menu.addSeparator();
        action = new DesignAction("Exit", "exit");
        menuItem = menu.add(action);
        menuItem.getAccessibleContext().setAccessibleDescription("Exits the UI Designer.");
        menuBar.add(menu);
        menu = new JMenu("Create");
        action = new DesignAction("String Bundle", "create_string_bundle");
        menuItem = menu.add(action);
        menuItem.getAccessibleContext().setAccessibleDescription("Create a string resource.");
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        Main.getMain().addPropertyChangeListener("ActiveUI", new ActiveUIListener());
        ((Component)this).setVisible(true);
    }

    public ResourceBrowser getResourceBrowser() {
        return this.fResourceBrowser;
    }

    class UIEventHandler
    implements UIEventListener {
        public void handleEvent(UIEvent event) {
            switch (event.getType()) {
                case 0: {
                    StringBundleView v = new StringBundleView(event.getStringBundle());
                    MainFrame.this.fDesktop.add(v);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    class ActiveUIListener
    implements PropertyChangeListener {
        ActiveUIListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            UI newUI = (UI)event.getNewValue();
            if (newUI != null) {
                MainFrame.this.fResourceBrowser = new ResourceBrowser(newUI);
                newUI.addUIEventListener(new UIEventHandler());
                MainFrame.this.fDesktop.add(MainFrame.this.fResourceBrowser);
            }
        }
    }
}

