/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;

public class DebuggeeSIO
implements Protocol {
    DebuggeeProcess proc;
    Integer procID;
    JDE jde = JDE.getJDE();
    Socket sioSocket = null;
    Thread standardIOConnectThread;
    StandardInputProcessor standardInputProcessor;
    StandardOutputProcessor standardOutputProcessor;
    StandardErrorProcessor standardErrorProcessor;
    StandardOutputWriter standardOutputWriter;

    public DebuggeeSIO(DebuggeeProcess proc) {
        this.proc = proc;
        this.procID = proc.getId();
    }

    public int initConnect(final Integer cmdId) throws JDEException {
        this.jde.signal(this.procID, "message", "initSIOConnect: starting standard I/O handshake.");
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
        }
        catch (IOException ex) {
            throw new JDEException("Unable to create a server socket");
        }
        final ServerSocket sstmp = ss;
        final int port = ss.getLocalPort();
        this.standardIOConnectThread = new Thread("Standard I/O Thread for App #" + this.procID){

            public void run() {
                try {
                    sstmp.setSoTimeout(15000);
                    DebuggeeSIO.this.jde.signalCommandResult(DebuggeeSIO.this.procID, cmdId, new Integer(port));
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "message", "Debugger waiting for Emacs to connect to app SIO port " + port + ".");
                    DebuggeeSIO.this.sioSocket = sstmp.accept();
                    sstmp.close();
                    DebuggeeSIO.this.initTransport();
                }
                catch (IOException ex) {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Gave up waiting for Emacs to connect to SIO port: " + port);
                }
                catch (SecurityException ex1) {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Security exception occurred while connecting to app SIO port " + port);
                }
            }
        };
        this.jde.signal(this.procID, "message", "initSIOConnect: starting SIO connect thread.");
        this.standardIOConnectThread.start();
        return port;
    }

    public void initTransport() {
        this.jde.signal(this.procID, "message", "Debugger connected to standard I/O socket.");
        Process process = this.proc.getVM().process();
        this.standardInputProcessor = new StandardInputProcessor(process.getOutputStream());
        this.standardInputProcessor.start();
        this.standardOutputWriter = new StandardOutputWriter(this.sioSocket);
        this.standardOutputWriter.println("*** Process Standard I/O ***");
        this.standardOutputProcessor = new StandardOutputProcessor(process.getInputStream());
        this.standardOutputProcessor.start();
        this.standardErrorProcessor = new StandardErrorProcessor(process.getErrorStream());
        this.standardErrorProcessor.start();
    }

    public void shutdown() {
        try {
            this.sioSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class StandardErrorProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardErrorProcessor(InputStream fromVMStream) {
            super("Standard Error Processor for App #" + DebuggeeSIO.this.procID);
            this.fromVM = new BufferedReader(new InputStreamReader(fromVMStream));
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                int len;
                char[] cbuf = new char[256];
                while ((len = this.fromVM.read(cbuf, 0, 256)) != -1) {
                    StandardOutputWriter standardOutputWriter = DebuggeeSIO.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (DebuggeeSIO.this.standardOutputWriter != null) {
                            void var3_4;
                            DebuggeeSIO.this.standardOutputWriter.write(cbuf, (int)var3_4);
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!DebuggeeSIO.this.proc.isShuttingDown()) {
                try {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "message", "Closed transport for application's standard error output.");
                }
                catch (Exception ex) {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Could not close application standard error output transport.");
                }
            }
        }
    }

    private class StandardOutputProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardOutputProcessor(InputStream fromVMStream) {
            this.fromVM = new BufferedReader(new InputStreamReader(fromVMStream));
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                int len;
                char[] cbuf = new char[256];
                while ((len = this.fromVM.read(cbuf, 0, 256)) != -1) {
                    StandardOutputWriter standardOutputWriter = DebuggeeSIO.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (DebuggeeSIO.this.standardOutputWriter != null) {
                            void var3_4;
                            DebuggeeSIO.this.standardOutputWriter.write(cbuf, (int)var3_4);
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!DebuggeeSIO.this.proc.isShuttingDown()) {
                try {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "message", "Closed transport for application's standard output.");
                }
                catch (Exception ex) {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Could not close application standard output transport.");
                }
            }
        }
    }

    private class StandardOutputWriter {
        BufferedWriter toEmacs;

        public StandardOutputWriter(Socket sioSocket) {
            OutputStream toEmacsStream;
            if (sioSocket == null) {
                DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Could not transport app output. Transport socket does not exist.");
                return;
            }
            try {
                toEmacsStream = sioSocket.getOutputStream();
                if (toEmacsStream == null) {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Could not transport app output. Transport socket closed.");
                    return;
                }
            }
            catch (IOException ex1) {
                DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Could not transport app output. Transport socket closed.");
                return;
            }
            this.toEmacs = new BufferedWriter(new OutputStreamWriter(toEmacsStream));
        }

        public void write(char[] cbuf, int len) {
            if (this.toEmacs != null) {
                try {
                    this.toEmacs.write(cbuf, 0, len);
                    this.toEmacs.flush();
                }
                catch (IOException ex1) {
                    DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "I/O error: cannot write process output to Emacs.");
                }
            }
        }

        public void println(String line) {
            try {
                this.toEmacs.write(line);
                this.toEmacs.newLine();
            }
            catch (IOException e) {
                DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "I/O error: cannot write process output to Emacs.");
            }
        }
    }

    private class StandardInputProcessor
    extends Thread {
        PrintStream toVM;
        BufferedReader fromEmacs;

        public StandardInputProcessor(OutputStream toVmStream) {
            super("Input Processor for App #" + DebuggeeSIO.this.procID);
            this.toVM = new PrintStream(toVmStream, true);
            try {
                this.fromEmacs = new BufferedReader(new InputStreamReader(DebuggeeSIO.this.sioSocket.getInputStream()));
            }
            catch (IOException ex1) {
                DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Could not get standard input stream from Emacs.");
            }
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            block9: {
                if (this.fromEmacs == null) {
                    return;
                }
                try {
                    String line;
                    while ((line = this.fromEmacs.readLine()) != null) {
                        void var1_1;
                        this.toVM.println((String)var1_1);
                        this.toVM.flush();
                    }
                    if (!DebuggeeSIO.this.proc.isShuttingDown()) {
                        try {
                            DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "message", "Process closed its standard input.");
                        }
                        catch (Exception ex) {
                            DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "message", "Couldn't close socket to standard input.");
                        }
                    }
                }
                catch (IOException ex) {
                    if (DebuggeeSIO.this.proc.isShuttingDown()) break block9;
                    try {
                        DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Input error; application I/O closed");
                    }
                    catch (Exception e) {
                        DebuggeeSIO.this.jde.signal(DebuggeeSIO.this.procID, "error", "Input error; couldn't close application I/O");
                    }
                }
            }
        }
    }
}

