;;; DO NOT MODIFY THIS FILE
(if (featurep 'vhdl-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "vhdl/_pkg.el")

(package-provide 'vhdl :version 1.16 :type 'regular)

;;;***

;;;### (autoloads (vhdl-mode) "vhdl-mode" "vhdl/vhdl-mode.el")

(autoload 'vhdl-mode "vhdl-mode" "\
Major mode for editing VHDL code.

Usage:
------

  TEMPLATE INSERTION (electrification):
    After typing a VHDL keyword and entering `SPC', you are prompted for
    arguments while a template is generated for that VHDL construct.  Typing
    `RET' or `C-g' at the first (mandatory) prompt aborts the current
    template generation.  Optional arguments are indicated by square
    brackets and removed if the queried string is left empty.  Prompts for
    mandatory arguments remain in the code if the queried string is left
    empty.  They can be queried again by `C-c C-t C-q'.  Enabled
    electrification is indicated by `/e' in the modeline.

      Typing `M-SPC' after a keyword inserts a space without calling the
    template generator.  Automatic template generation (i.e.
    electrification) can be disabled (enabled) by typing `C-c C-m C-e' or by
    setting option `vhdl-electric-mode' (see OPTIONS).

      Template generators can be invoked from the VHDL menu, by key
    bindings, by typing `C-c C-i C-c' and choosing a construct, or by typing
    the keyword (i.e. first word of menu entry not in parenthesis) and
    `SPC'.  The following abbreviations can also be used: arch, attr, cond,
    conf, comp, cons, func, inst, pack, sig, var.

      Template styles can be customized in customization group
    `vhdl-template' (see OPTIONS).


  HEADER INSERTION:
    A file header can be inserted by `C-c C-t C-h'.  A file footer
    (template at the end of the file) can be inserted by `C-c C-t C-f'.
    See customization group `vhdl-header'.


  STUTTERING:
    Double striking of some keys inserts cumbersome VHDL syntax elements.
    Stuttering can be disabled (enabled) by typing `C-c C-m C-s' or by
    option `vhdl-stutter-mode'.  Enabled stuttering is indicated by `/s' in
    the modeline.  The stuttering keys and their effects are:

      ;;   -->  \" : \"       [   -->  (        --    -->  comment
      ;;;  -->  \" := \"      [[  -->  [        --CR  -->  comment-out code
      ..   -->  \" => \"      ]   -->  )        ---   -->  horizontal line
      ,,   -->  \" <= \"      ]]  -->  ]        ----  -->  display comment
      ==   -->  \" == \"      ''  -->  \\\"


  WORD COMPLETION:
    Typing `TAB' after a (not completed) word looks for a VHDL keyword or a
    word in the buffer that starts alike, inserts it and adjusts case.
    Re-typing `TAB' toggles through alternative word completions.  This also
    works in the minibuffer (i.e. in template generator prompts).

      Typing `TAB' after `(' looks for and inserts complete parenthesized
    expressions (e.g. for array index ranges).  All keywords as well as
    standard types and subprograms of VHDL have predefined abbreviations
    (e.g. type \"std\" and `TAB' will toggle through all standard types
    beginning with \"std\").

      Typing `TAB' after a non-word character indents the line if at the
    beginning of a line (i.e. no preceding non-blank characters), and
    inserts a tabulator stop otherwise.  `M-TAB' always inserts a tabulator
    stop.


  COMMENTS:
        `--'       puts a single comment.
        `---'      draws a horizontal line for separating code segments.
        `----'     inserts a display comment, i.e. two horizontal lines
                   with a comment in between.
        `--CR'     comments out code on that line.  Re-hitting CR comments
                   out following lines.
        `C-c C-c'  comments out a region if not commented out,
                   uncomments a region if already commented out.

      You are prompted for comments after object definitions (i.e. signals,
    variables, constants, ports) and after subprogram and process
    specifications if option `vhdl-prompt-for-comments' is non-nil.
    Comments are automatically inserted as additional labels (e.g. after
    begin statements) and as help comments if `vhdl-self-insert-comments' is
    non-nil.

      Inline comments (i.e. comments after a piece of code on the same line)
    are indented at least to `vhdl-inline-comment-column'.  Comments go at
    maximum to `vhdl-end-comment-column'.  `RET' after a space in a comment
    will open a new comment line.  Typing beyond `vhdl-end-comment-column'
    in a comment automatically opens a new comment line.  `M-q' re-fills
    multi-line comments.


  INDENTATION:
    `TAB' indents a line if at the beginning of the line.  The amount of
    indentation is specified by option `vhdl-basic-offset'.  `C-c C-i C-l'
    always indents the current line (is bound to `TAB' if option
    `vhdl-intelligent-tab' is nil).

      Indentation can be done for a group of lines (`C-c C-i C-g'), a region
    (`M-C-\\') or the entire buffer (menu).  Argument and port lists are
    indented normally (nil) or relative to the opening parenthesis (non-nil)
    according to option `vhdl-argument-list-indent'.

      If option `vhdl-indent-tabs-mode' is nil, spaces are used instead of
    tabs.  `M-x tabify' and `M-x untabify' allow to convert spaces to tabs
    and vice versa.

|     Syntax-based indentation can be very slow in large files.  Option
|   `vhdl-indent-syntax-based' allows to use faster but simpler indentation.


  ALIGNMENT:
    The alignment functions align operators, keywords, and inline comments
    to beautify the code.  `C-c C-a C-a' aligns a group of consecutive lines
|   separated by blank lines, `C-c C-a C-i' a block of lines with same
|   indent.  `C-c C-a C-l' aligns all lines belonging to a list enclosed by
    a pair of parentheses (e.g. port clause/map, argument list), and `C-c
    C-a C-d' all lines within the declarative part of a design unit.  `C-c
    C-a M-a' aligns an entire region.  `C-c C-a C-c' aligns inline comments
    for a group of lines, and `C-c C-a M-c' for a region.

      If option `vhdl-align-groups' is non-nil, groups of code lines
|   separated by special lines (see option `vhdl-align-group-separate') are
    aligned individually.  If option `vhdl-align-same-indent' is non-nil,
    blocks of lines with same indent are aligned separately.  Some templates
    are automatically aligned after generation if option `vhdl-auto-align'
    is non-nil.

|     Alignment tries to align inline comments at
|   `vhdl-inline-comment-column' and tries inline comment not to exceed
|   `vhdl-end-comment-column'.

      `C-c C-x M-w' fixes up whitespace in a region.  That is, operator
    symbols are surrounded by one space, and multiple spaces are eliminated.


| CODE BEAUTIFICATION:
|   `C-c M-b' and `C-c C-b' beautify the code of a region or of the entire
|   buffer respectively.  This inludes indentation, alignment, and case
|   fixing.  Code beautification can also be run non-interactively using the
|   command:
|
|     emacs -batch -l ~/.emacs filename.vhd -f vhdl-beautify-buffer


  PORT TRANSLATION:
    Generic and port clauses from entity or component declarations can be
    copied (`C-c C-p C-w') and pasted as entity and component declarations,
    as component instantiations and corresponding internal constants and
    signals, as a generic map with constants as actual parameters, and as
|   internal signal initializations (menu).

      To include formals in component instantiations, see option
    `vhdl-association-list-with-formals'.  To include comments in pasting,
    see options `vhdl-include-...-comments'.

      A clause with several generic/port names on the same line can be
    flattened (`C-c C-p C-f') so that only one name per line exists.  Names
    for actual ports, instances, test benches, and design-under-test
    instances can be derived from existing names according to options
    `vhdl-...-name'.  See customization group `vhdl-port'.


| TEST BENCH GENERATION:
|   A copied port can also be pasted as a test bench.  The generated test
|   bench includes an entity, an architecture, and an optional
|   configuration.  The architecture contains the component declaration and
|   instantiation of the DUT as well as internal constant and signal
|   declarations.  Additional user-defined templates can be inserted.  The
|   names used for entity/architecture/configuration/DUT as well as the file
|   structure to be generated can be customized. See customization group
|  `vhdl-testbench'.


  KEY BINDINGS:
    Key bindings (`C-c ...') exist for most commands (see in menu).


  VHDL MENU:
    All commands can be found in the VHDL menu including their key bindings.


  FILE BROWSER:
    The speedbar allows browsing of directories and file contents.  It can
    be accessed from the VHDL menu and is automatically opened if option
    `vhdl-speedbar-auto-open' is non-nil.

      In speedbar, open files and directories with `mouse-2' on the name and
    browse/rescan their contents with `mouse-2'/`S-mouse-2' on the `+'.


  DESIGN HIERARCHY BROWSER:
    The speedbar can also be used for browsing the hierarchy of design units
    contained in the source files of the current directory or the specified
    projects (see option `vhdl-project-alist').

|     The speedbar can be switched between file, directory hierarchy and
|   project hierarchy browsing mode in the speedbar menu or by typing `f',
|   `h' or `H' in speedbar.

      In speedbar, open design units with `mouse-2' on the name and browse
|   their hierarchy with `mouse-2' on the `+'.  Ports can directly be copied
|   from entities and components (in packages).  Individual design units and
|   complete designs can directly be compiled (\"Make\" menu entry).

|     The hierarchy is automatically updated upon saving a modified source
|   file when option `vhdl-speedbar-update-on-saving' is non-nil.  The
|   hierarchy is only updated for projects that have been opened once in the
|   speedbar.  The hierarchy is cached between Emacs sessions in a file (see
|   options in group `vhdl-speedbar').
|
|     Simple design consistency checks are done during scanning, such as
|   multiple declarations of the same unit or missing primary units that are
|   required by secondary units.


  SOURCE FILE COMPILATION:
    The syntax of the current buffer can be analyzed by calling a VHDL
    compiler (menu, `C-c C-k').  The compiler to be used is specified by
    option `vhdl-compiler'.  The available compilers are listed in option
    `vhdl-compiler-alist' including all required compilation command,
    command options, compilation directory, and error message syntax
    information.  New compilers can be added.

      All the source files of an entire design can be compiled by the `make'
    command (menu, `C-c M-C-k') if an appropriate Makefile exists.


| MAKEFILE GENERATION:
|   Makefiles can be generated automatically by an internal generation
|   routine (`C-c M-k').  The library unit dependency information is
|   obtained from the hierarchy browser.  Makefile generation can be
|   customized for each compiler in option `vhdl-compiler-alist'.
|
|     Makefile generation can also be run non-interactively using the
|   command:
|
|       emacs -batch -l ~/.emacs -l vhdl-mode
|             [-compiler compilername] [-project projectname]
|             -f vhdl-generate-makefile
|
|     The Makefile's default target \"all\" compiles the entire design, the
|   target \"clean\" removes it and the target \"library\" creates the
|   library directory if not existent.  The Makefile also includes a target
|   for each primary library unit which allows selective compilation of this
|   unit, its secondary units and its subhierarchy (example: compilation of
|   a design specified by a configuration).  User specific parts can be
|   inserted into a Makefile with option `vhdl-makefile-generation-hook'.
|
|   Limitations:
|     - Only library units and dependencies within the current library are
|       considered.  Makefiles for designs that span multiple libraries are
|       not (yet) supported.
|     - Only one-level configurations are supported (also hierarchical),
|       but configurations that go down several levels are not.
|     - The \"others\" keyword in configurations is not supported.


  PROJECTS:
|   Projects can be defined in option `vhdl-project-alist' and a current
|   project be selected using option `vhdl-project' (permanently) or from
|   the menu or speedbar (temporarily).  For each project, title and
|   description strings (for the file headers), source files/directories
|   (for the hierarchy browser and Makefile generation), library name, and
|   compiler-dependent options, exceptions and compilation directory can be
|   specified.  Compilation settings overwrite the settings of option
|   `vhdl-compiler-alist'.
|
|     Project setups can be exported (i.e. written to a file) and imported.
|   Imported setups are not automatically saved in `vhdl-project-alist' but
|   can be saved afterwards in its customization buffer.  When starting
|   Emacs with VHDL Mode (i.e. load a VHDL file or use \"emacs -l
|   vhdl-mode\") in a directory with an existing project setup file, it is
|   automatically loaded and its project activated if option
|   `vhdl-project-auto-load' is non-nil.  Names/paths of the project setup
|   files can be specified in option `vhdl-project-file-name'.  Multiple
|   project setups can be automatically loaded from global directories.
|   This is an alternative to specifying project setups with option
|   `vhdl-project-alist'.


  SPECIAL MENUES:
    As an alternative to the speedbar, an index menu can be added (set
    option `vhdl-index-menu' to non-nil) or made accessible as a mouse menu
    (e.g. add \"(global-set-key '[S-down-mouse-3] 'imenu)\" to your start-up
    file) for browsing the file contents.  Also, a source file menu can be
    added (set option `vhdl-source-file-menu' to non-nil) for browsing the
    current directory for VHDL source files.


  VHDL STANDARDS:
    The VHDL standards to be used are specified in option `vhdl-standard'.
    Available standards are: VHDL'87/'93, VHDL-AMS, and Math Packages.


  KEYWORD CASE:
    Lower and upper case for keywords and standardized types, attributes,
    and enumeration values is supported.  If the option
    `vhdl-upper-case-keywords' is set to non-nil, keywords can be typed in
    lower case and are converted into upper case automatically (not for
    types, attributes, and enumeration values).  The case of keywords,
    types, attributes,and enumeration values can be fixed for an entire
    region (menu) or buffer (`C-c C-x C-c') according to the options
    `vhdl-upper-case-{keywords,types,attributes,enum-values}'.


  HIGHLIGHTING (fontification):
    Keywords and standardized types, attributes, enumeration values, and
    function names (controlled by option `vhdl-highlight-keywords'), as well
    as comments, strings, and template prompts are highlighted using
    different colors.  Unit, subprogram, signal, variable, constant,
    parameter and generic/port names in declarations as well as labels are
    highlighted if option `vhdl-highlight-names' is non-nil.

      Additional reserved words or words with a forbidden syntax (e.g. words
    that should be avoided) can be specified in option
    `vhdl-forbidden-words' or `vhdl-forbidden-syntax' and be highlighted in
    a warning color (option `vhdl-highlight-forbidden-words').  Verilog
    keywords are highlighted as forbidden words if option
    `vhdl-highlight-verilog-keywords' is non-nil.

      Words with special syntax can be highlighted by specifying their
    syntax and color in option `vhdl-special-syntax-alist' and by setting
    option `vhdl-highlight-special-words' to non-nil.  This allows to
    establish some naming conventions (e.g. to distinguish different kinds
    of signals or other objects by using name suffices) and to support them
    visually.

      Option `vhdl-highlight-case-sensitive' can be set to non-nil in order
    to support case-sensitive highlighting.  However, keywords are then only
    highlighted if written in lower case.

      Code between \"translate_off\" and \"translate_on\" pragmas is
    highlighted using a different background color if option
    `vhdl-highlight-translate-off' is non-nil.

      For documentation and customization of the used colors see
    customization group `vhdl-highlight-faces' (`M-x customize-group').  For
    highlighting of matching parenthesis, see customization group
    `paren-showing'.


  USER MODELS:
    VHDL models (templates) can be specified by the user and made accessible
    in the menu, through key bindings (`C-c C-m ...'), or by keyword
    electrification.  See option `vhdl-model-alist'.


  HIDE/SHOW:
    The code of blocks, processes, subprograms, component declarations and
    instantiations, generic/port clauses, and configuration declarations can
    be hidden using the `Hide/Show' menu or by pressing `S-mouse-2' within
    the code (see customization group `vhdl-menu').  XEmacs: limited
    functionality due to old `hideshow.el' package.


  CODE UPDATING:
    - Sensitivity List: `C-c C-u C-s' updates the sensitivity list of the
      current process, `C-c C-u M-s' of all processes in the current buffer.
      Limitations:
        - Only declared local signals (ports, signals declared in
          architecture and blocks) are automatically inserted.
        - Global signals declared in packages are not automatically inserted.
          Insert them once manually (will be kept afterwards).
        - Out parameters of procedures are considered to be read.
      Use option `vhdl-entity-file-name' to specify the entity file name
      (used to obtain the port names).


  CODE FIXING:
    `C-c C-x C-p' fixes the closing parenthesis of a generic/port clause
    (e.g. if the closing parenthesis is on the wrong line or is missing).


  PRINTING:
    Postscript printing with different faces (an optimized set of faces is
    used if `vhdl-print-customize-faces' is non-nil) or colors (if
    `ps-print-color-p' is non-nil) is possible using the standard Emacs
    postscript printing commands.  Option `vhdl-print-two-column' defines
    appropriate default settings for nice landscape two-column printing.
    The paper format can be set by option `ps-paper-type'.  Do not forget to
    switch `ps-print-color-p' to nil for printing on black-and-white
    printers.


| OPTIONS:
|   User options allow customization of VHDL Mode.  All options are
|   accessible from the \"Options\" menu entry.  Simple options (switches
|   and choices) can directly be changed, while for complex options a
|   customization buffer is opened.  Changed options can be saved for future
|   sessions using the \"Save Options\" menu entry.
|
|     Options and their detailed descriptions can also be accessed by using
|   the \"Customize\" menu entry or the command `M-x customize-option' (`M-x
|   customize-group' for groups).  Some customizations only take effect
    after some action (read the NOTE in the option documentation).
    Customization can also be done globally (i.e. site-wide, read the
    INSTALL file).

|     Not all options are described in this documentation, so go and see
|   what other useful user options there are (`M-x vhdl-customize' or menu)!


  FILE EXTENSIONS:
    As default, files with extensions \".vhd\" and \".vhdl\" are
    automatically recognized as VHDL source files.  To add an extension
    \".xxx\", add the following line to your Emacs start-up file (`.emacs'):

      (setq auto-mode-alist (cons '(\"\\\\.xxx\\\\'\" . vhdl-mode) auto-mode-alist))


  HINTS:
|   - To start Emacs with open VHDL hierarchy browser without having to load
|     a VHDL file first, use the command:
|
|       emacs -l vhdl-mode -f speedbar-frame-mode

    - Type `C-g C-g' to interrupt long operations or if Emacs hangs.

    - Some features only work on properly indented code.


  RELEASE NOTES:
    See also the release notes (menu) for added features in new releases.


Maintenance:
------------

To submit a bug report, enter `M-x vhdl-submit-bug-report' within VHDL Mode.
Add a description of the problem and include a reproducible test case.

Questions and enhancement requests can be sent to <reto@gnu.org>.

The `vhdl-mode-announce' mailing list informs about new VHDL Mode releases.
The `vhdl-mode-victims' mailing list informs about new VHDL Mode beta
releases.  You are kindly invited to participate in beta testing.  Subscribe
to above mailing lists by sending an email to <reto@gnu.org>.

VHDL Mode is officially distributed at
http://opensource.ethz.ch/emacs/vhdl-mode.html
where the latest version can be found.


Known problems:
---------------

- Indentation bug in simultaneous if- and case-statements (VHDL-AMS).
- XEmacs: Incorrect start-up when automatically opening speedbar.


                                                The VHDL Mode Authors
                                            Reto Zimmermann and Rod Whitby

Key bindings:
-------------

\\{vhdl-mode-map}" t nil)

;;;***

(provide 'vhdl-autoloads)
