;;; mh-unit.el --- Unit tests for MH-E

;; Copyright (C) 2003 Bill Wohler

;; Author: Bill Wohler <wohler@newt.com>
;; Maintainer: Bill Wohler <wohler@newt.com>
;; Keywords: mail
;; See: mh-e.el

;; This file is part of MH-E.

;; MH-E is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MH-E is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with MH-E; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Currently, this file contains unit tests that are useful when releasing
;; software. I have a dream that we can add unit tests to actually test code.

;;; Change Log:

;;; Code:

(require 'lisp-mnt)

(defvar mh-files '("mh-alias.el" "mh-comp.el" "mh-customize.el" "mh-e.el"
                   "mh-funcs.el" "mh-identity.el" "mh-inc.el" "mh-index.el"
                   "mh-junk.el" "mh-loaddefs.el" "mh-mime.el" "mh-pick.el"
                   "mh-seq.el" "mh-speed.el" "mh-utils.el"
                   "mh-xemacs-compat.el" "mh-xemacs-icons.el"))

(defun mh-unit ()
  "Run unit tests on MH-E.
Currently, the tests are all release related, including:
- Run `lm-verify' on all files.
- Run `checkdoc' on all files.
- Removing trailing space on all files (per GNU Emacs conventions)."
  (interactive)
  (dolist (file mh-files)
    (find-file file)
    (let ((lm-out (lm-verify file)))
      (if lm-out
          (error lm-out)))
    (checkdoc)
    (mh-prune-trailing-spaces)))


(defun mh-prune-trailing-spaces ()
  "Remove all trailing spaces in buffer."
  (save-excursion
    (goto-char (point-min))
    (while (re-search-forward "[ \t]+$" nil t)
      (delete-region (match-beginning 0) (match-end 0)))))

(provide 'mh-unit)

;;; Local Variables:
;;; indent-tabs-mode: nil
;;; sentence-end-double-space: nil
;;; End:

;;; mh-unit.el ends here
