;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; File:          dired-faces.el
;; Dired Version: #Revision:  $
;; RCS:
;; Description:   rudimentary face customization support for dired
;; Author:        Mike Sperber <sperber@informatik.uni-tuebingen.de>
;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'dired-faces)

(require 'custom)
(require 'dired)

;;; Variables

(defgroup dired-faces nil
  "Dired faces."
  :group 'dired)

(defcustom dired-do-highlighting t
  "Set if we should use highlighting according to filetype."
  :type 'boolean
  :group 'dired-faces)

(defcustom dired-do-interactive-permissions t
  "Set if we should allow interactive chmod."
  :type 'boolean
  :group 'dired-faces)


(defface dired-face-marked '((((type x pm mswindows)
			       (class color))
			      (:background "PaleVioletRed"))
			     (((type tty)
			       (class color mono))
			      (:bold t)))
  "Face used for marked files."
  :group 'dired)

(defface dired-face-flagged '((((type x pm mswindows)
				(class color)
				(background light))
			       (:background "LightSlateGray"))
			      (((type x pm mswindows)
				(class color)
				(background dark))
			       (:background "DarkSlateGray"
				:underline t)))
  "Face used for flagged files."
  :group 'dired)

(defface dired-face-directory '((((type x pm mswindows tty)
				  (class color))
				 (:bold t)))
  "Face used for directories."
  :group 'dired)

(defface dired-face-executable '((((type x pm mswindows)
				   (class color)
				   (background light))
				  (:foreground "green4"))
				 (((type tty)
				   (class color))
				  (:foreground "green"))
				 (((type x pm mswindows)
				   (class color)
				   (background dark))
				  (:foreground "green"))
				 (t
				  (:bold t)))
  "Face used for executables."
  :group 'dired)

(defface dired-face-setuid '((((class color))
			      (:foreground "Red"))
			     (t
			      (:bold t)))
  "Face used for setuid executables."
  :group 'dired)

(defface dired-face-boring '((((type x pm mswindows)
			       (class color grayscale)
			       (background light))
			      (:foreground "gray30"))
			     (((type x pm mswindows)
			       (class color grayscale)
			       (background dark))
			      (:foreground "gray65"))
			     (((type tty)
			       (class color)
			       (background dark))
			      (:foreground "white"
			       :dim t))
			     (((type tty)
			       (class color)
			       (background light))
			      (:foreground "gray65")))
  "Face used for unimportant files."
  :group 'dired)

(defface dired-face-permissions '((((type tty)
				    (class color))
				   (:foreground "black"
				    :background "cyan"))
				  (((type x pm mswindows)
				    (class color))
				   (:foreground "black"
				    :background "grey75")))
  "Face used for interactive permissions."
  :group 'dired)

(defface dired-face-header '((t (:background "grey75"
                                 :foreground "black")))
  "Face used for directory header."
  :group 'dired)

(defface dired-face-socket '((((class color))
			      (:foreground "magenta"))
			     (t
			      (:bold nil)))
  "Face used to indicate sockets."
  :group 'dired)

(defface dired-face-symlink  '((((type x pm mswindows)
				 (class color)
				 (background light))
				(:foreground "cyan4"))
			       (((class color))
				(:foreground "cyan"))
			       (t
				(:bold t)))
  "Face used to indicate symbolic links."
  :group 'dired)

;;; end of dired-faces.el
