/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server file support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node111.text,v $ */

static char rcsid[] = "file.c $Revision: 1.1 $ $Date: 92/05/08 15:26:01 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/Form.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
/* ------------------------------------------------------------------------ */
extern void
  FileRemove(), FileUpdate(), FileReply(), FileRealized(),
  FileTransmit(), FileEditable();

extern t_generic_widget FileHandle();

struct widget_class_struct FileClassRecord =
{
  WS_FILE, "file",
  FileHandle, FileRemove, NULL, FileUpdate, FileReply,
  FileRealized, FileTransmit, FileEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct file_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  Widget w_file;			/* actual file selection box */
  Widget w_form;
  Widget w_title;
  char *key;
} * t_file_widget;

/* ------------------------------------------------------------------------ */
/* Create a file button. The sexp should be of the form
 * (file "id" <key> &key)
 */
static struct keyword_entry_struct FileKeywords[] =
{
  { ":title", NULL, KEYWORD_COOKED },
  { ":dir", NULL, KEYWORD_COOKED },
  { ":type", NULL, KEYWORD_SEXP },
};

t_generic_widget
FileHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_file_widget file;
  t_sexp s_key, s_id, s_type;
  char *dir, *title;
  XmString xm_str;
  Widget w;
  int n;
  Arg argl[10];

  /* check required arguments first */
  s_id = MBnth(sexp,1);
  s_key = MBnth(sexp,2);

  if (NULL == s_id || (!MB_STRINGP(s_key) && !MB_NAMEP(s_key)))
    return NULL;

  file = NEW_STRUCT(file_widget_struct);
  file->type = WS_FILE;
  file->next = NULL;
  file->parent = parent;
  file->top = parent->top;
  file->class = &FileClassRecord;
  file->id = Getnth(sexp, 1);
  file->key = MBCstring(s_key);
  
  /* get the keywords */
  MBparse_keywords(MBnthcdr(sexp,3), FileKeywords, ARRAY_SIZE(FileKeywords));
  title = (char *)FileKeywords[0].result;
  dir = (char *)FileKeywords[1].result;
  s_type = (t_sexp)FileKeywords[2].result;

  /* a form to bind the title to the file selection box */
  file->w_form = XtCreateWidget("form", xmFormWidgetClass,
				parent->widget, NULL, 0);

  file->w_title = CreateTitle(NULL == title ? "" : title, file->w_form);
  n = 0;
  XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNalignment, XmALIGNMENT_CENTER), ++n;
  XtSetValues(file->w_title, argl, n);

  n = 0;
  xm_str = CtoXmString(dir);
  XtSetArg(argl[n], XmNdirectory, xm_str), ++n;
  if (NULL != title)
    {
      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
      XtSetArg(argl[n], XmNtopWidget, file->w_title), ++n;
    }
  else
    XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;

  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  if (!MBcompare_Cstring(s_type, ":regular"))
    XtSetArg(argl[n], XmNfileTypeMask, XmFILE_REGULAR), ++n;
  else if (!MBcompare_Cstring(s_type, ":directory"))
    XtSetArg(argl[n], XmNfileTypeMask, XmFILE_DIRECTORY), ++n;
  else if (!MBcompare_Cstring(s_type, ":any"))
    XtSetArg(argl[n], XmNfileTypeMask, XmFILE_ANY_TYPE), ++n;
  file->w_file = XtCreateWidget("file", xmFileSelectionBoxWidgetClass,
				file->w_form, argl, n);

  w = XmFileSelectionBoxGetChild(file->w_file, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(w);
  w = XmFileSelectionBoxGetChild(file->w_file, XmDIALOG_OK_BUTTON);
  XtUnmanageChild(w);
  w = XmFileSelectionBoxGetChild(file->w_file, XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(w);

#if 0
  /* just leaves an annoying blank space, doesn't let the directory
   * list get bigger
   */
  if (!MBcompare_Cstring(s_type, ":directory"))
    {
      XtUnmanageChild(XmFileSelectionBoxGetChild(file->w_file, XmDIALOG_LIST));
      XtUnmanageChild(XmFileSelectionBoxGetChild(file->w_file,
						 XmDIALOG_LIST_LABEL));
    }
#endif

  XtManageChild(file->w_file);
  if (NULL != title) XtManageChild(file->w_title);
  file->widget = file->w_form;

  XtFree(title); XtFree(dir); XtFree(xm_str);

  return (t_generic_widget)file;
}
/* ------------------------------------------------------------------------ */
void
FileRemove(self) t_file_widget self;
{
  XtFree(self->key);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the file */
static struct keyword_entry_struct FileUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },
  { ":tag", NULL, KEYWORD_RAW },
  { ":value", NULL, KEYWORD_RAW },
};

void
FileUpdate(self,sexp)
     t_file_widget self;
     t_sexp sexp;
{
}
/* ------------------------------------------------------------------------ */
void
FileReply(self, reply)
     t_file_widget self;
     t_mbus_reply reply;
{
}
/* ------------------------------------------------------------------------ */
void
FileRealized(self) t_file_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
FileTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_file_widget self;
{
  Widget w;
  char *tmp = "", *str;

  w = XmFileSelectionBoxGetChild(self->w_file, XmDIALOG_TEXT);
  if (XtIsSubclass(w, xmTextWidgetClass))
    tmp = XmTextGetString(w);
  else if (XtIsSubclass(w, xmTextFieldWidgetClass))
    tmp = XmTextFieldGetString(w);

  str = QuotifyString(tmp);
  MBput_Cstring(message, " ");
  MBput_Cstring(message, self->key);
  MBput_Cstring(message, " ");
  MBput_Cstring(message, str);
  XtFree(tmp); XtFree(str);
}
/* ------------------------------------------------------------------------ */
void
FileEditable(self, flag)
     t_file_widget self;
     int flag;
{
  XtSetSensitive(self->widget, flag ? True : False);
}
/* ------------------------------------------------------------------------ */
