#!/bin/sh  
#
# NAME
#	CGI/1.0 script for collecting customer information
#
# ALGORITHM
#		calls cgi_parse to get the form information
#		Check if all we need is filled out
#			if no the returns a warning web page to the user
#		Sends a mail correctly formatted to MAILTO 
#
#		Returns a confirmation web page to the user
#
#
# CONDITIONS
#	QUERY_STRING environment variable must be of form:
#
#		name=name&email=email&body=body  ...
#
# WRITTEN
#     Susana Fernandez Jan 1995 - susana@www.cern.ch 
#
##################################################################
Variables to set up depending on the machine:

CGIPARSE=/nnnn/nnn/www/bin/cgiparse
SIGN="<a href="/CERN/People.html#susana">SFV </a> www-support@www.cern.ch"
#TOMAIL=malvarez@afsmail.cern.ch
##################################################################


echo "Content-Type: text/html"
echo
echo "<HEAD><TITLE>Mail to the WWW Support Service at CERN </TITLE></HEAD><BODY>"

#
#       Set the QUERY_STRING variable
#
 
eval `$CGIPARSE -init -quiet`
#
#       Parse QUERY_STRING
#
PARSED=`$CGIPARSE -form -quiet`
if [ $? -ne 0 ]
then
        echo "<H1>Internal Error Parsing QUERY_STRING</H1>"
        echo "<CODE>cgiparse</CODE> complains: <PRE>"
        echo "    $PARSED"
        echo "</PRE></BODY>"
        exit 0
fi
eval $PARSED
 
#
#       Check if all the necessary info is entered
# 	if not exit and do mail error info
#
if [ $FORM_subject = "form" ]
then
FORM_text="."
fi

if [ \( -z "$FORM_from_mail" \)   -o \( -z "$FORM_division" \) -o \( -z "$FORM_subject" \) -o \( -z "$FORM_to_mail" \) -o  \( -z "$FORM_text" \)  ]
then
cat <<until_1 

	<H1>Sorry</H1>
	<P>
	Your message was not processed because some information was
	missing in the filled out form.
	<P>
	Please go back, complete the form and resubmit your request.
	
	<P>
	<HR>
	<ADDRESS> $SIGN </ADDRESS>
	</BODY>
until_1

exit
fi
TOMAIL=$FORM_to_mail

#
#	Create the file to send by e-mail
#
echo "From: $FORM_from_mail" > /tmp/send-mail$$ 
echo "Subject: $FORM_subject" >> /tmp/send-mail$$ 
echo "NAME = $FORM_from_name" >> /tmp/send-mail$$
echo "DIVISION/GROUP= $FORM_division" >> /tmp/send-mail$$
echo "EMAIL = $FORM_from_mail" >> /tmp/send-mail$$
echo "CONTENT= " >> /tmp/send-mail$$
$CGIPARSE -value "text" >> /tmp/send-mail$$
echo "SUBJECT=$FORM_subject" >> /tmp/send-mail$$

# Following lines were to support the registration form for printers
#if [ $FORM_subject = "form" ]
#then
# fill_form="/nnnn/nnn/www/cgi-bin/printer.fill.form"
#cat  $fill_form >> /tmp/send-mail$$
#fi



/usr/lib/sendmail -oi -t  $TOMAIL > /dev/null 2>&1 < /tmp/send-mail$$ 

rm /tmp/send-mail$$
#
# send the mail to TOMAIL 
#

#/usr/ucb/mail  $TOMAIL > /dev/null 2>&1 << ENDMAIL
#~s Request for a WWW Service

#NAME = $FORM_from_name
#EMAIL = $FORM_from_mail
#CONTENT= $FORM_text
#ENDMAIL

#	how can I keep the newlines sending the mail?
#	$CGIPARSE -value "text"

#
# echo the message
#

cat <<until_2
<H1>MAIL SENT!</H1>
Your message has been sent to<STRONG> $TOMAIL </STRONG> with 
the following information:
<P>
<HR>

<PRE>
<B>Name: </B>$FORM_from_name
<B>Division/Group</B> = $FORM_division
<B>E-mail: </B>$FORM_from_mail
<B>Subject: </B>$FORM_subject
<B>Content: </B>$fill_form
until_2

$CGIPARSE -value "text"

cat <<until_3
</PRE>

<HR>
<ADDRESS> $SIGN </ADDRESS>
</BODY>

until_3


















