#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# IncVers:  Increment Version number and update build name
# Usage:  IncVers MAJOR MINOR BUILD

setopt extendedglob
set -e # Exit at the first sign of trouble

if [ $# != 3 ]; then
	echo "Usage: $0: MAJOR MINOR BUILD"
	exit 1
fi

export MAJOR=$1
export MINOR=$2
export BUILD=$3

export CODENAME=$(grep '^'"$BUILD" Codenames-${MAJOR}.${MINOR} | cut -f2)
export BUILDDIR=xemacs-${MAJOR}.${MINOR}

if [ ! -f ${BUILDDIR}/version.sh ]; then
	echo "Error: ${BUILDDIR}/version.sh: does not exist"
	exit 1
fi

# Just do it.
ed ${BUILDDIR}/version.sh <<=altair=
1
/emacs_beta_version/s/=.*$/=${BUILD}
1
/xemacs_codename/s/".*"/"${CODENAME}"
w
q
=altair=

exit 0
