;;; Copyright (C) 1990 Roland McGrath
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 1, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from this
;;; program's author (send electronic mail to roland@ai.mit.edu) or from
;;; the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
;;; 02139, USA.
;;;
;;; Send bug reports to roland@ai.mit.edu.

;; To use this file, byte-compile it and put it somewhere in your load path.
;; Then put:
;;    (load "after-save")
;; in your .emacs.

(or (fboundp 'real-save-buffer)
    (fset 'real-save-buffer (symbol-function 'save-buffer)))

(defvar after-save-buffer-hooks nil
  "A function or list of functions to be run after saving the current buffer.")

(defun save-buffer (&optional args)
  "Save the current buffer, and then run `after-save-buffer-hooks'.
The hooks are only run if the buffer was actually written.
For more documentation, do \\[describe-function] real-save-buffer RET."
  (interactive "p")
  (let ((modp (buffer-modified-p)))
    (real-save-buffer args)
    (if modp
	(run-hooks 'after-save-buffer-hooks))))
