/*
  Modified on 6-Jan-90 by Leonard N. Zubkoff:
    With GPR support, use GNU Emacs termcap rather than system termcap.
    Added support for unexec on Apollo.

  Modified on 10-Jan-90 by John Vasta (vasta@apollo.hp.com):
    Add cpu and systype switches so that Emacs doesn't force the systype.

  6-Nov-90 Jim Rees: Take out the -g compiler switch, put in -O.
*/

/* m- file for Apollo machine.
   Copyright (C) 1985, 1986 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* The following three symbols give information on
 the size of various data types.  */

#define SHORTBITS 16		/* Number of bits in a short */

#define INTBITS 32		/* Number of bits in an int */

#define LONGBITS 32		/* Number of bits in a long */

/* 68020/68030 and PRISM have lowest-numbered byte as most significant */

#define BIG_ENDIAN

/* Define how to take a char and sign-extend into an int.
   On machines where char is signed, this is a no-op.  */

#define SIGN_EXTEND_CHAR(c) (c)

#define APOLLO

/* Use type int rather than a union, to represent Lisp_Object */

#define NO_UNION_TYPE

/* Do not define LOAD_AVE_TYPE or LOAD_AVE_CVT
   since there is no /dev/kmem. */

/* Undefine VIRT_ADDR_VARIES because the virtual addresses of
   pure and impure space as loaded do not vary.  */

#undef VIRT_ADDR_VARIES

/* Define HAVE_ALLOCA because we use the system's version of alloca.  */

#define HAVE_ALLOCA

/* Allow Emacs's larger than 16 megabytes. */

#define VALBITS 26
#define GCTYPEBITS 5

/* Prevent -lg from being used for debugging. */

#define LIBS_DEBUG

/* Must not use the system's termcap with GPR support. */

#undef LIBS_TERMCAP

/* Need not use the system's malloc. */

#undef SYSTEM_MALLOC

/* System Type is Domain/OS. */

#undef SYSTEM_TYPE
#define SYSTEM_TYPE "Domain/OS"

/* Define the file we use for UNEXEC. */

#define UNEXEC unexapollo.o

/* In SR10.2 we use our own version of crt0. */

#define START_FILES crt0.o

/* Define C_SWITCH_MACHINE to compile for 68020/68030 or PRISM. */

/* Define LD_SWITCH_MACHINE to save space by stripping symbols
   and use X11 libraries. */

#if _ISP__A88K
#define C_SWITCH_MACHINE -A cpu,a88k -A sys,any -A run,bsd4.3
#define LD_SWITCH_MACHINE -L/usr/lib/X11 -A cpu,a88k -A sys,any -A run,bsd4.3
#else
#define C_SWITCH_MACHINE -A cpu,3000 -A sys,any -A run,bsd4.3
#define LD_SWITCH_MACHINE -L/usr/lib/X11 -A cpu,m68k -A sys,any -A run,bsd4.3
#endif

#define C_DEBUG_SWITCH

#define LIB_STANDARD

/* Define machine-specific symbol interning functions. */

#ifndef NO_COED

#endif
/* Define machine-specific modifications to ymakefile. */

#ifndef NO_COED
#define OBJECTS_MACHINE /sys/traits/io_traits.3
#endif NO_COED
