/* Definitions file for GNU Emacs running on AT&T's System V Release 4
   Copyright (C) 1987, 1990 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Hacked for SunOS 5.0 by Steve Byrne -- sbb@eng.sun.com
 * and by Brendan Lynch - blynch@east.sun.com
 */

/* Use the SysVr4 file for at least base configuration. */

#include "s-usg5-4.h"

/* Get rid of unneeded definitions in s-usg5-3.h */
#undef LIBX10_SYSTEM
#undef LIBX11_SYSTEM

/* Define our SVr4 identity */
#define USG5_4
/* And our Sun-nature */
#define SUNOS_5
/* But deny any BSD-isms */
#undef BSD

#define subprocesses

#define HAVE_SOCKETS
#define SYS_SIGLIST  _sys_siglist

/* SunOS5 CAN use SIGIO (really SIGPOLL) along with interrupting input */
#define SIGIO SIGPOLL


/* We dont need any of the loader magic */
#undef START_FILES
#define START_FILES

#undef LIB_STANDARD
#define LIB_STANDARD -lkvm -lsocket -lnsl -lelf

/* Don't need data_seg bits */
#undef DATA_SEG_BITS

/* Don't do any mucking with the loader -- use cc to link */
#define LINKER cc

#define C_OPTIMIZE_SWITCH -fast

/* Cause the compilation of oldxmenu to use the right -I option.  */
#define OLDXMENU_OPTIONS CFLAGS=C_SWITCH_SYSTEM

/* The following is needed to work with the "Open Windows"
   version of X windows.  But it should do no harm if you don't have that.  */
#if 1  /* The -I and -L options should be harmless otherwise.  */
#undef LD_SWITCH_SYSTEM
#define LD_SWITCH_SYSTEM -L/usr/openwin/lib

#define C_SWITCH_SYSTEM -I/usr/openwin/include
#endif 
