/* Mark end of data space to dump as pure, for GNU Emacs.
   Copyright (C) 1985 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * $Revision: 1.2 $
 * $Source: /import/kaplan/stable/distrib/epoch-4.2/src/RCS/lastfile.c,v $
 * $Author: love $
 * $Date: 92/02/23 11:01:24 $
 */
#ifndef LINT
static char rcsid[] = "$Author: love $ $Date: 92/02/23 11:01:24 $ $Source: /import/kaplan/stable/distrib/epoch-4.2/src/RCS/lastfile.c,v $ $Revision: 1.2 $";
#endif

/* How this works:

 Fdump_emacs dumps everything up to my_edata as text space (pure).

 The files of Emacs are written so as to have no initialized
 data that can ever need to be altered except at the first startup.
 This is so that those words can be dumped as sharable text.

 It is not possible to exercise such control over library files.
 So it is necessary to refrain from making their data areas shared.
 Therefore, this file is loaded following all the files of Emacs
 but before library files.
 As a result, the symbol my_edata indicates the point
 in data space between data coming from Emacs and data
 coming from libraries.
*/

#ifdef VMS
/* Prevent the file from being totally empty.  */
static dummy () {}
#endif

char my_edata = 0;
