;;; about.el --- the About The Authors page (shameless self promotion.)
;;;
;;; This is kind of a kludge.  We were going to use W3 to do this, but
;;; it's too slow to load, and HTML gives you too little control over
;;; the layout (especially indentation and inter-paragraph spacing).
;;; Maybe the text should have been written in limited HTML anyway,
;;; and I should have hacked up a simple and fast parser for it, but
;;; it's done now...
;;;
;;; Code: Jamie Zawinski <jwz@lucid.com>
;;; Text: Ben Wing <wing@netcom.com> and Jamie Zawinski <jwz@lucid.com>
;;; Hard: Amiga 1000, Progressive Peripherals Frame Grabber.
;;; Soft: FG 2.0, DigiPaint 3.0, pbmplus (dec 91), xv 3.0.
;;; Modified for 19.11 by Eduardo Pelegri-Llopart <pelegri@eng.sun.com>
;;;		      and Chuck Thompson <cthomp@cs.uiuc.edu>

(require 'advice)

(defvar about-xref-map (let ((map (make-sparse-keymap)))
			 (define-key map 'button1 'about-xemacs-xref)
			 (define-key map 'button2 'about-xemacs-xref)
			 map))

(defvar what-are-we-calling-it-today "XEmacs") ; historically significant var name

(defun about-face (text face)
  (let ((p (point))
	e)
    (insert text)
    (setq e (make-extent p (point)))
    ;;(set-extent-property e 'start-open t)
    (set-extent-face e face)
    e))

(defun about-xref (text xref help)
  (let ((e (about-face text 'bold)))
    (set-extent-property e 'keymap about-xref-map)
    (set-extent-property e 'highlight t)
    (set-extent-property e 'xref xref)
    (set-extent-property e 'help-echo help)
    e))

;;;###autoload
(defun about-xemacs ()
  (interactive)
  (delete-other-windows)
  (switch-to-buffer (get-buffer-create
		     (concat "About " what-are-we-calling-it-today)))
  (buffer-disable-undo (current-buffer))
  (widen)
  (set (make-local-variable 'tab-width) 8)
  (setq buffer-read-only t)
  (view-mode)
  (set (make-local-variable 'view-kill-on-exit) t)	     ; for view-less.el
  (set (make-local-variable 'view-exit-action) 'kill-buffer) ;for view.el
  (let* ((buffer-read-only nil)
	 (indent-tabs-mode t)
	 )
    (erase-buffer)
    (insert "\n")
    (if (and (eq 0 (pixmap-depth xemacs-logo)) (featurep 'xpm))
	(let ((logo-file (format "%s%s" data-directory "xemacs.xpm")))
	  ;; if something goes wrong with loading the XPM logo,
	  ;; oh well
	  (condition-case nil
	      (if (file-readable-p logo-file)
		  (setq xemacs-logo (make-pixmap logo-file)))
	    (error nil))))
    (indent-to (startup-center-spaces xemacs-logo))
    (let ((e (make-extent (point) (point))))
      (set-extent-begin-glyph e xemacs-logo))
    (insert "\n\n")
    (indent-to (startup-center-spaces "(formerly known as Lucid Emacs)"))
    (insert "(formerly known as Lucid Emacs)")
    (insert "\n\n")
    (indent-to (startup-center-spaces "version 19.11; September 1994"))
    (about-xref "version 19.11; September 1994" 'news "The latest NEWS of XEmacs")
    (insert "\n\n")

    (insert "\n\t")
    (about-face what-are-we-calling-it-today 'italic)
    (insert " is a powerful, extensible text editor with full GUI
	support, based on an early version of GNU Emacs 19 from
	the Free Software Foundation. ")
    (insert what-are-we-calling-it-today " stems from a ")
    (about-xref "collaboration" 'history "An XEmacs History Lesson")
    (insert "\n\tof Lucid, Inc. with Sun Microsystems, Inc. and the University
	of Illinois.\n\n\t")

	(insert "In almost all circumstances, Emacs-Lisp code written for
	either of GNU Emacs versions 18 and 19 will run	under\n\t"
     what-are-we-calling-it-today
     " without requiring any modifications, or at most will
	require small changes to accommodate an improved functional
	interface.\n\n\t")

    (insert what-are-we-calling-it-today " provides a great number of ")
    (about-xref "new features" 'features "See a list of the new features")
    (insert ", but does not yet
	support TTY's.  It will starting with version 19.12, due out at
	the end of 1994.  More details on XEmacs's functionality, including
	bundled packages can be obtained through the ")

    (about-xref "`info`" 'info "Look at the info pages") (insert " on-line
	information system.

	The WWW page for " what-are-we-calling-it-today
    " can be browsed, using any HTML tool, at\n\t\t")
    (about-xref "http://xemacs.cs.uiuc.edu/" 'w3-xemacs "Go to the XEmacs World Wide Web page")
    (insert "\n\n\tNote that w3 (" what-are-we-calling-it-today "'s own browser), might need customization
	(due to firewalls) in order to work correctly.\n\n\t")

    (insert what-are-we-calling-it-today " is the result of the time and effort of ")
    (about-xref "many users and" 'others "Read about other contributors") (insert "\n\t")
    (about-xref "contributors." 'others "Read about other contributors")

    (insert "  The core group of XEmacs developers responsible
	for release 19.11 is:

		 * ") (about-xref "Chuck Thompson" 'cthomp "Find out more about Chuck Thompson") (insert "  <cthomp@cs.uiuc.edu>
		 * ") (about-xref "Ben Wing" 'wing "Find out more about Ben Wing") (insert "  <wing@netcom.com>
		 * ") (about-xref "Vladimir Ivanovic" 'vladimir "Find out more about Vladimir Ivanovic") (insert "  <vladimir@eng.sun.com>

	Jamie Zawinski was Mr. Lucid Emacs through many releases; and
	Richard Mlynarik was crucial to most of the latest releases:

		 * ") (about-xref "Jamie Zawinski" 'jwz "Find out more about Jamie Zawinski") (insert "  <jwz@mcom.com>
		 * ")  (about-xref "Richard Mlynarik" 'mly "Find out more about Richard Mlynarik")  (insert "  <mly@adoc.xerox.com>")
   (insert "\n\n\tClick ")
   (about-xref "here" 'kill-buffer "Exit the About page")
   (insert " to remove (kill) this buffer.")
   (goto-char (point-min)))
  )

(defun about-load-mosaic (&optional who-to-load)
  (save-excursion
    (set-buffer (get-buffer-create
		 (concat "About " what-are-we-calling-it-today)))
    (toggle-read-only 0)

    ;; add wmperry when it arrives
    (let ((rest (if who-to-load (list who-to-load)
		  '(jwz cthomp wing mly vladimir baw)))
	  (got-error nil))
      (while rest
	(let* ((who (car rest))
	       (who-xpm (expand-file-name
			 (concat (symbol-name who)
				 (if (or (x-color-display-p)
					 (x-grayscale-display-p))
				     ""
				   "m")
				 ".xpm")
			 data-directory)))
	  (or (file-exists-p who-xpm) (setq who-xpm (concat who-xpm ".Z")))
	  (if (eq nil (assoc who (buffer-local-variables)))
	      (make-local-variable who))
	  (if (and (boundp who)
		   (pixmapp (symbol-value who)))
	      nil
	    (message "One moment please...")
	    (condition-case c
		(save-restriction
		  (set who nil)
		  (narrow-to-region (point) (point))
		  (insert-file-contents who-xpm)
		  (if (looking-at "\037\235") ;may already be decompressed...
		      (call-process-region (point-min) (point-max)
					   "zcat" t t nil))
		  (set who (make-pixmap
			    (prog1 (buffer-string)
			      (delete-region (point-min) (point-max)))))
		  )
	      (error
	       (setq got-error t)
	       (message nil)
	       (display-error c nil)
	       (sit-for 2)))))
	(setq rest (cdr rest)))
      (or got-error (message nil)))
    (toggle-read-only 1)
    ))

(defun about-add-mosaic ()
  (goto-char (point-min))
  (about-load-mosaic)

  ;; HERE TO PLACE ADDITIONAL MUGSHOTS

  (goto-char (point-max))
  (insert "\n   ")
  ;; add wmperry when it arrives
  (let ((rest '(jwz cthomp wing mly linebreak vladimir baw))
	(got-error nil))
    (while rest
      (if (eq (car rest) 'linebreak)
	  (insert "\n\n  ")
	(let* ((who (car rest))
	       (b (get-buffer (concat "About " what-are-we-calling-it-today)))
	       (p (symbol-value-in-buffer who b nil)))
	  (or (pixmapp p) (setq p nil))
	  (and p
	       (let ((e (make-extent (point) (point))))
		 (set-extent-begin-glyph e p)
		 (set-extent-property e 'keymap about-xref-map)
		 (set-extent-property e 'xref who)))
	  (insert " ")
	  (sit-for 0)))
      (setq rest (cdr rest)))
    (insert "\n")
    (goto-char (point-min))
    (or got-error (message nil)))
  )

(defun about-xemacs-xref (e)
  (interactive "@e")
  (let* ((extent (or (event-glyph e)
 		     (extent-at (event-point e)
				(window-buffer (event-window e))
				'xref)))
	 (xref (extent-property extent 'xref))
	 prev-page)
    ;; prev-page is used for the core people's pages since they can be
    ;; reached from two different locations
    (if (equal (buffer-name) (concat "About " what-are-we-calling-it-today))
	(setq prev-page 'about)
      ;; Kill the sub-buffers when going back to the top, so that we
      ;; don't hold pointers to the bitmaps longer than necessary.
      (kill-buffer (current-buffer))
      (setq prev-page 'others))
    (cond
     ((eq xref 'about)
      (about-xemacs))
     ((eq xref 'info)
      (info))
     ((eq xref 'w3-xemacs)
      (w3-fetch "http://xemacs.cs.uiuc.edu/"))
     ((eq xref 'w3-jamie)
      (w3-fetch "http://mosaic.mcom.com/people/jwz/."))
     ((eq xref 'kill-buffer)
      (kill-buffer (current-buffer)))
     ((eq xref 'news)
      (view-emacs-news)
      (view-mode)
      (set (make-local-variable 'view-kill-on-exit) t)	     ; for view-less.el
      (set (make-local-variable 'view-exit-action) 'kill-buffer) ; for view.el
      (save-excursion
	(goto-char (point-min))
	(let ((buffer-read-only nil))
	  (insert "\nClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n\n")
	  (set-buffer-modified-p nil)
	  )))
     (t
      (switch-to-buffer (get-buffer-create
			 (cond ((eq xref 'jwz) "About Jamie Zawinski")
			       ((eq xref 'cthomp) "About Chuck Thompson")
			       ((eq xref 'wing) "About Ben Wing")
			       ((eq xref 'mly) "About Richard Mlynarik")
			       ((eq xref 'vladimir) "About Vladimir Ivanovic")
			       ((eq xref 'baw) "About Barry Warsaw")
			       ((eq xref 'others) "About Everyone")
			       ((eq xref 'features) "News XEmacs Features")
			       ((eq xref 'history)
				(concat what-are-we-calling-it-today
					" History"))
			       )))
      (delete-other-windows)
      (buffer-disable-undo (current-buffer))
      (widen)
      (setq buffer-read-only t)
      (view-mode)
      (set (make-local-variable 'view-kill-on-exit) t)	     ; for view-less.el
      (set (make-local-variable 'view-exit-action) 'kill-buffer) ; for view.el
      (let ((buffer-read-only nil)
	    (case-fold-search nil)
	    )
	(if (and (not (eq xref 'others)) (not (eq xref 'history))
		 (not (eq xref 'features)))
	    (about-load-mosaic xref))
	(erase-buffer)
	(let* ((b (get-buffer (concat "About " what-are-we-calling-it-today)))
	       (p (and b (symbol-value-in-buffer xref b nil))))
	  (or (pixmapp p) (setq p nil))
	  (cond (p
		 (insert "\n\t")
		 (set-extent-begin-glyph (make-extent (point) (point)) p)
		 (insert "\n\t"))
		(t
		 (insert "\n\t"))))
	(cond
	 ((eq xref 'history)
	  (insert "Click ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n\n\t")

	  (about-face what-are-we-calling-it-today 'bold)
	  (insert "\n\n\n\t")
	  (about-face "The Lucid, Inc. Point of View" 'italic)
	  (insert "

	Lucid's latest product, Energize, is a C/C++ development
	environment.  Rather than invent (and force our users to learn)
	a new user interface, we chose to build part of our environment
	on top of the world's best editor, GNU Emacs.  (Though our
	product is commercial, the work we did on GNU Emacs is free
	software, and is useful without having to purchase our product.
	For information about Energize, other Lucid products, or
	support contracts, send mail to ")
	  (about-face "lucid-info@lucid.com" 'italic)
	  (insert " or call\n\tus at (800) 223-9322.)

	We needed a version of Emacs with mouse-sensitive regions,
	multiple fonts, the ability to mark sections of a buffer as
	read-only, the ability to detect which parts of a buffer has
	been modified, and many other features.

	For our purposes, the existing version of Epoch was not
	sufficient; it did not allow us to put arbitrary pixmaps/icons
	in buffers, `undo' did not restore changes to regions, regions
	did not overlap and merge their attributes in the way we needed,
	and several other things.

	We could have devoted our time to making Epoch do what we needed
	(and, in fact, we spent some time doing that in 1990) but, since
	the FSF planned to include Epoch-like features in their version
	19, we decided that our efforts would be better spent improving
	Emacs 19 instead of Epoch.

	Our original hope was that our changes to Emacs would be
	incorporated into the \"official\" v19.  However, scheduling
	conflicts arose, and we found that, given the amount of work
	still remaining to be done, we didn't have the time or manpower
	to do the level of coordination that would be necessary to get
	our changes accepted by the FSF.  Consequently, we released our
	work as a forked branch of Emacs, instead of delaying any
	longer.

	Roughly a year after Lucid Emacs 19.0 was released, a beta
	version of the FSF branch of Emacs 19 was released.  The FSF
	version is better in some areas, and worse in others, as
	reflects the differing focus of our development efforts.

	We plan to continue developing and supporting Lucid Emacs, and
	merging in bug fixes and new features from the FSF branch as
	appropriate; we do not plan to discard any of the functionality
	that we implemented which RMS has chosen not to include in his
	version.

	Certain elements of Lucid Emacs, or derivatives of them, have
	been ported to the FSF version.  We have not been doing work in
	this direction, because we feel that Lucid Emacs has a cleaner
	and more extensible substrate, and that any kind of merger
	between the two branches would be far easier by merging the FSF
	changes into our version than the other way around.

	We have been working closely with the Epoch developers to merge
	in the remaining Epoch functionality which Lucid Emacs does not
	yet have.  Epoch and Lucid Emacs will soon be one and the same
	thing.  Work is being done on a compatibility package which will
	allow Epoch 4 code to run in XEmacs with little or no change.
	(Lucid Emacs is now running a descendant of the Epoch redisplay
	engine.)")

	  (insert "\n\n\n\t")
	  (about-face "The SunPro Point of View" 'italic)
	  (insert "

	Emacs 18 has been around for a long, long time.  Version 19 was
	supposed to be the successor to v18 with X support.  It was
	going to be available \"real soon\" for a long time (some
	people remember hearing about v19 as early as 1984!), but it
	never came out.  v19 development was going very, very slowly,
	and from the outside it seemed that it was not moving at all.
	In the meantime other people gave up waiting for v19 and
	decided to build their own X-aware Emacsen.  The most important
	of these was probably Epoch, which came from University of
	Illinois (\"UofI\") and was based on v18.

	Around two years ago SunPro (a division of Sun Microsystems,
	Inc.) decided that it wanted an integrated editor.  They contracted
	with UofI to provide a number of basic enhancements to the
	functionality in Epoch.  UofI initially was planning to deliver
	this on top of Epoch code.

	In the meantime (actually some time before they talked with UofI)
	Lucid had decided that it also wanted to provide an integrated
	environment with an integrated editor.  Lucid decided that the
	v19 basis was a better one than v18 and thus decided not to use
	Epoch but instead work with Richard Stallman, the head of the
	Free Software Foundation and principle author of Emacs, on
	getting v19 out.  At some point Stallman and Lucid parted ways.
	Lucid kept working and got a v19 out that they called Lucid
	Emacs 19.

	After Lucid's v19 came out it became clear to UofI and SunPro
	that the right thing to do was to push for an integration of
	both Lucid Emacs and Epoch, and to get the deliverables that
	SunPro was asking from UofI on top of this integrated platform.
	Through the last two years, SunPro has been actively supporting
	this product and has been investing a comparable amount of
	effort into it, as Lucid has.  Substantial portions of the
	current code have originated under the support of SunPro, either
	directly in SunPro, or in UofI but paid for by SunPro.  This
	code was kept away from Lucid for a while, but later was made
	available to them.  Initially Lucid didn't know that SunPro was
	supporting UofI, but later they were open about it.

	Around 6 months ago the SunPro-related code started showing up
	in Lucid Emacs.  This started with the infusion of the Epoch
	redisplay code.

	At this moment there is basically no difference in the source
	trees between what is at UofI, SunPro, or Lucid.  All the
	development sites are in sync.

	SunPro originally called the integrated product ERA, for
	\"Emacs Rewritten Again\".  SunPro and Lucid recently came to
	an agreement to find a name for the product that was not
	specific to either company.  An additional constraint that
	Lucid placed on the name was that it must contain the word
	\"Emacs\" in it -- thus \"ERA\" was not acceptable.  The
	tentatively agreed-upon name is \"XEmacs\", and, if all goes
	according to plan, this is what the product will be called
	after the release of 19.10.  (SunPro is already calling the
	product XEmacs, but Lucid is still calling it Lucid Emacs.)\n\n")

	  (insert "\n\t")
	  (about-face "SunPro is now SunSoft Developer Products\n" 'italic)
	  (insert "
	In mid-'94 Sun completed a reorganization where SunPro moved to
	SunSoft.  As a consequence, SunPro is now called SunSoft Developer
	Products. ")

	  (insert "\n\n\n\t")
	  (about-face "Lucid undergoes major changes\n" 'italic)
	  (insert "
	Around mid-'94, Lucid underwent major changes.	As of
	the last update of this document, the new situation is not
	yet final, but no XEmacs development is done by Lucid.\n\n\n")

	  (insert "\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n\n\t")
	  )
	 ((eq xref 'jwz)
	  (about-face "Jamie Zawinski" 'bold)
	  (insert "\t\t\"")
	  (about-face "So much to do, so little time." 'italic)
	  (insert "\"\n")
	  (insert "\n
	Jamie Zawinski was primarily to blame for Lucid Emacs from its
	inception in 1991, to 1994 when Lucid Inc. finally died.  He is
	now to be found at Mosaic Communications, where he works on
	things that he can't tell you about yet, but that he promises
	are really stinking cool.

	He has a funny haircut.  Suburbia horrifies him.  He finds it a
	great relief to be working on a project which is not, even
	tangentially, related to Richard Stallman.  He strongly believes
	that sleep is most effectively dealt with when viewed as a disease,
	and will leave the room if anyone says the words \"postmodern\" or
	\"deconstructionist.\"

	Come visit his glorified .plan file at

		")
	  (about-xref "http://mosaic.mcom.com/people/jwz/." 'w3-jamie "Visit Jamie's WWW page")
	  (insert "\n\n\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )
	 ((eq xref 'cthomp)
	  (about-face "Chuck Thompson" 'bold)
	  (insert " <cthomp@cs.uiuc.edu>

	Chuck, through being in the wrong place at the right time, has
	gotten stuck with being Jamie's replacement as the primary
	maintainer of " what-are-we-calling-it-today
	".  This has caused his hair to begin
	falling out and quadrupled his daily coffee dosage.

	He is currently busy implementing TTY and multiple X display
	capabilities as well as many other mondo-bitchin' new features
	for the 19.12 release.  In his spare time he has Burritos as
	Big As Your Head with his nominal boss, Simon Kaplan (the
	originator of Epoch).  His real boss is Sun Microsystems since
	their funding is responsible for his paycheck.

	Favorite video game:  ")
	  (about-face "Super Menendez Bros." 'italic)

	  (insert "\n\n\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )
	 ((eq xref 'wing)
	  (about-face "Ben Wing" 'bold)
	  (insert " <wing@netcom.com>

	I'm not a thug -- I just play one on video.
	I'm a San Francisco \"Mission Critter\" and a hacker.\n\n\t")
	  (about-face "Gory stuff follows:" 'italic)
	  (insert "

	In 1992 I left a stuffy university that shall remain nameless
	(but which is sometimes known as Princeton), set out into the
	real world, and ended up a co-founder of Pearl Software.  As
	part of this company, I am the principal architect of
	Win-Emacs, a port of Lucid Emacs to Microsoft Windows and
	Windows NT (for more info, e-mail to ")
	  (about-face "info@pearlsoft.com" 'italic)
	  (insert ").

	Since April 1993, I've worked on " what-are-we-calling-it-today
	" as a contractor
	for SunPro, a division of Sun Microsystems.  My main
	contributions to the product include more robust cooperation
	between Emacs and Xt/Motif, user interface improvements,
	improved documentation (especially the Emacs Lisp manual),
	and the ability to run an Emacs screen as a widget inside of
	another Motif or Xt client.")
	  (insert "\n\n\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )
	 ((eq xref 'mly)
	  (about-face "Richard Mlynarik" 'bold)
	  (insert " <mly@adoc.xerox.com>

	Richard Mlynarik has many clever things to say.")

	  (insert "\n\n\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )
	 ((eq xref 'vladimir)
	  (about-face "Vladimir Ivanovic" 'bold)
	  (insert " <vladimir@eng.sun.com>

	Technical lead for XEmacs at SunPro.  Responsible for
	overseeing SunPro's development effort and getting XEmacs
	onto the SunPro Friends CD, thus greatly increasing the
	distribution of the product.  Also provided a great deal
	of testing, quality assurance, and user interface
	improvements.")

	  (insert "\n\n\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )

	 ((eq xref 'baw)
	  (about-face "Barry Warsaw" 'bold)
	  (insert " <bwarsaw@cnri.reston.va.us>

	Author of cc-mode for C++, C, and Objective-C editing, and
	Supercite for mail and news citing.  Also various and sundry other
	Emacs utilities, fixes, enhancements and kludgery as whimsy,
	boredom, and ToT dictate (but not necessarily in that order).


	Daddy
	 1994 Warsaw
	========
	Drive me Daddy, drive me quick
	Push my pedal, shift my stick
	Fill me up with golden gas
	My rubber squeals, I go real fast

	Milk me Daddy, milk me now
	Milk me like a big ol' cow
	I've got milk inside my udder
	Churn it up and make some butter")

	  (insert "\n\n\tClick ")
	  (about-xref "here" prev-page "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )

	 ((eq xref 'others)
	  (insert "Click ")
	  (about-xref "here" 'about "Return to previous page")
	  (insert " to go back to the previous page\n\n\t")

	  (about-face (concat "Other Contributors to "
			      what-are-we-calling-it-today)
		      'italic)

	  (insert "

	Like most free software, " what-are-we-calling-it-today
	" is a collaborative effort.
	These are some of the contributors; we have no doubt forgotten
	someone; we apologize!  You can see some of our faces further below.

	") (about-xref "Jamie Zawinski" 'jwz "Find out more about Jamie Zawinski") (insert " <jwz@mcom.com>
	 Jamie was the main implementor of XEmacs for many releases while
	 XEmacs was still called Lucid Emacs.  Now at Mosaic Communications.

	") (about-xref "Richard Mlynarik" 'mly "Find out more about Richard Mlynarik") (insert " <mly@adoc.xerox.com>
	 Main contributor to several releases of Lucid Emacs.  Contributed much
	 to maintaining compatibility between "
	what-are-we-calling-it-today " and GNU emacs 19

	") (about-xref "Vladimir Ivanovic" 'vladimir "Find out more about Vladimir Ivanovic") (insert " <vladimir@eng.sun.com>
	 Technical lead for XEmacs at SunPro.

	") (about-xref "Barry Warsaw" 'baw "Find out more about Barry Warsaw") (insert " <bwarsaw@cnri.reston.va.us>
	 Author of cc-mode for C++, C, and Objective-C editing, and
	 Supercite for mail and news citing.  Also various and sundry other
	 Emacs utilities, fixes, enhancements and kludgery as whimsy,
	 boredom, and ToT dictate (but not necessarily in that order).

	") (about-xref "Chuck Thompson" 'cthomp "Find out more about Chuck Thompson") (insert " <cthomp@cs.uiuc.edu>
	 Working at University of Illinois with funding from Sun Microsystems.
	 Main implementor for 19.11 and 19.12.

	") (about-xref "Ben Wing" 'wing "Find out more about Ben Wing") (insert " <wing@netcom.com>
	 The principal architect of Win-Emacs, a port of Lucid Emacs
	 to Microsoft Windows and Windows NT.  Has been a contractor
	 for SunPro, contributing to many areas in " what-are-we-calling-it-today "

	Matthieu Devin <devin@rs.com>
	  Part of the original (pre-19.0) Lucid Emacs development team.
	  Matthieu wrote the initial Energize interface, designed the
	  toolkit-independent Lucid Widget library, and fixed enough
	  redisplay bugs to last a lifetime.  The features in Lucid
	  Emacs were largely inspired by Matthieu's initial prototype
	  of an Energize interface using Epoch.

	Harlan Sexton <hbs@odi.com>
	  Part of the original (pre-19.0) Lucid Emacs development team.
	  Harlan designed and implemented many of the low level data
	  structures which are original to the Lucid version of Emacs,
	  including extents and hash tables.

	Eric Benson <eb@kaleida.com>
	  Part of the original (pre-19.0) Lucid Emacs development team.
	  Eric played a big part in the design of many aspects of the
	  system, including the new command loop and keymaps, fixed
	  numerous bugs, and has been a reliable beta tester ever
	  since.

	Eduardo Pelegri-Llopart <pelegri@eng.sun.com>
	  Author of EOS, a package included in the standard XEmacs
	  distribution that integrates XEmacs with the SPARCworks
	  development environment from SunPro.  Past lead for XEmacs
	  at SunPro; advocated the validity of using Epoch, and later
	  Lemacs, at SunPro through several early prototypes.

	John Rose <john.rose@sun.com>
	  Author of many extensions to the `extents' code, including
	  the initial implementation of `duplicable' properties.

	Hans Muller <hmuller@eng.sun.com>
	 Author of the code used to connect " what-are-we-calling-it-today
	  " with ToolTalk,
	 and of an early client of the external Emacs widget.

	William Perry <wmperry@indiana.edu>
	  Author of W3, a package for browsing the World Wide Web
	  which is included in the standard " what-are-we-calling-it-today
	  " distribution.
	  Although W3 runs on all versions of Emacs, Bill has been
	  quick to take advantage of the unique features of "
	  what-are-we-calling-it-today "
	  (such as embedded images and windows).  Thus, the "
	  what-are-we-calling-it-today "
	  version of W3 is significantly more powerful than versions
	  running in other Emacs variants.

	Kyle Jones <kyle@crystal.wonderworks.com>
	  Author of VM (View Mail), a mail-reading package that is
	  included in the standard " what-are-we-calling-it-today
	  " distribution, and
	  contributor of many improvements and bug fixes.  Unlike most
	  other mail-reading packages, VM uses the standard Unix-mail
	  format for its mailboxes; thus, you can use VM concurrently
	  with standard mail readers such as Unix mail and ELM.


	In addition to those just mentioned, the following people have
	spent a great deal of effort providing feedback, testing beta
	versions of " what-are-we-calling-it-today
	", providing patches to the source code,
	or doing all of the above.  We couldn't have done it without
	them.

	  Mark Allender <allender@vnet.IBM.COM>
	  Nagi M. Aboulenein <aboulene@cs.wisc.edu>
	  Butch Anton <butch@taligent.com>
	  Tor Arntsen <tor@spacetec.no>
	  Mike Battaglia <mbattagl@dsccc.com>
	  Neal Becker <neal@ctd.comsat.com>
	  Tim Bradshaw <tfb@edinburgh.ac.uk>
	  Matthew J. Brown <mjb@doc.ic.ac.uk>
	  Rick Busdiecker <rfb@lehman.com>
	  Richard Caley <rjc@cstr.edinburgh.ac.uk>
	  Philippe Charton <charton@lmd.ens.fr>
	  Jin S. Choi <jin@archetype.prospect.com>
	  Serenella Ciongoli <czs00@ladybug.oes.amdahl.com>
	  Richard Cognot <cognot@ensg.u-nancy.fr>
	  Andy Cohen <cohen@andy.bu.edu>
	  Christopher Davis <ckd@kei.com>
	  William G. Dubuque <wgd@martigny.ai.mit.edu>
	  Samuel J. Eaton <samuele@cogs.susx.ac.uk>
	  Eric Eide <eeide@asylum.cs.utah.edu>
	  David Fletcher <frodo@tsunami.com>
	  Paul Flinders <ptf@delcam.co.uk>
	  Jerry Frain <jerry@sneffels.tivoli.com>
	  Barry Friedman <friedman@bnr.ca>
	  Tim Geisler <tmgeisle@immd8.informatik.uni-erlangen.de>
	  Dave Gillespie <daveg@synaptics.com>
	  James Grinter <jrg@doc.ic.ac.uk>
	  Dirk Grunwald <grunwald@foobar.cs.Colorado.EDU>
	  Dipankar Gupta <dg@hplb.hpl.hp.com>
	  Adam Hammer <hammer@cs.purdue.edu>
	  Magnus Hammerin <magnush@isy.liu.se>
	  Derek Harding <dharding@lssec.bt.co.uk>
	  John Haxby <J.Haxby@isode.com>
	  David Hughes <djh@harston.cv.com>
	  Robin Jeffries <robin.jeffries@sun.com>
	  Doug Keller <dkeller@vnet.ibm.com>
	  Gregor Kennedy <gregork@dadd.ti.com>
	  Darrell Kindred <Darrell.Kindred@cmu.edu>
	  Simon Leinen <simon@lia.di.epfl.ch>
	  Hamish Macdonald <hamish@bnr.ca>
	  Patrick MacRoberts <macro@hpcobr30.cup.hp.com>
	  Steve March <smarch@quaver.urbana.mcd.mot.com>
	  Dave Mason <dmason@plg.uwaterloo.ca>
	  Jaye Mathisen <osyjm@schizo.coe.montana.edu>
	  Michael Meissner <meissner@osf.org>
	  David M. Meyer <meyer@ns.uoregon.edu>
	  John Morey <jmorey@crl.com>
	  Rob Mori <rob.mori@sun.com>
	  Heiko Muenkel <muenkel@tnt.uni-hannover.de>
	  Arup Mukherjee <arup+@cs.cmu.edu>
	  Colas Nahaboo <Colas.Nahaboo@sophia.inria.fr>
	  Lynn D. Newton <lynn@ives.phx.mcd.mot.com>
	  Georg Nikodym <Georg.Nikodym@canada.sun.com>
	  Andy Norman <ange@hplb.hpl.hp.com>
	  David Ofelt <ofelt@getalife.Stanford.EDU>
	  Greg Onufer <Greg.Onufer@eng.sun.com>
	  Marc Paquette <paquette@crim.ca>
	  Thomas A. Peterson <tap@src.honeywell.com>
	  Andy Piper <ajp@parallax.demon.co.uk>
	  Tibor Polgar <tlp00@eng.amdahl.com>
	  E. Rehmi Post <rehmi@asylum.sf.ca.us>
	  Daniel Rich <drich@corp.sgi.com>
	  Roland Rieke <rol@darmstadt.gmd.de>
	  Russell Ritchie <russell@gssec.bt.co.uk>
	  Mike Russell <mjruss@rchland.vnet.ibm.com>
	  Jan Sandquist <etxquist@iqa.ericsson.se>
	  Marty Sasaki <sasaki@netop3.harvard.edu>
	  Mike Scheidler <c23mts@kocrsv01.delcoelect.com>
	  Darrel Schneider <darrel@slc.com>
	  Hayden Schultz <haydens@ll.mit.edu>
	  Cotton Seed <cottons@mit.edu>
	  John Shen <zfs60@cas.org>
	  Jeffrey Sparkes <jsparkes@bnr.ca>
	  Michael Sperber <sperber@informatik.uni-tuebingen.de>
	  Francois Staes <frans@kiwi.uia.ac.be>
	  Jonathan Stigelman <stig@netcom.com>
	  Raymond L. Toy <toy@rtp.ericsson.se>
	  La Monte Yarroll <piggy@hilbert.maths.utas.edu.au>
	  Bob Weiner <bob_weiner@pts.mot.com>
	  Rod Whitby <rwhitby@research.canon.oz.au>
	  Blair Zajac <blair@olympia.gps.caltech.edu>
	  and the makers of Jolt Cola (tm)")
	  (goto-char (point-min))
	  (while (re-search-forward "^[ \t]*\\([^<>\n]+\\) <[^>\n]+>$"
				    nil t)
	    (set-extent-face (make-extent (match-beginning 1) (match-end 1))
			     'bold))
	  (goto-char (point-min))
	  (while (re-search-forward "^[ \t]*<\\([^>\n]+\\)>$" nil t)
	    (set-extent-face (make-extent (match-beginning 1) (match-end 1))
			     'bold))

	  (goto-char (point-max))
	  (insert "\n")
	  (about-add-mosaic)
	  (goto-char (point-max))
	  (insert "\n\n\tClick ")
	  (about-xref "here" 'about "Return to previous page")
	  (insert " to go back to the previous page.\n")
	  )
	 ((eq xref 'features)
	  (insert "Click ")
	  (about-xref "here" 'about "Return to previous page")
	  (insert " to go back to the previous page\n\n\t")

	  (about-face (concat "New Features in "
			      what-are-we-calling-it-today)
		      'italic)

	  (insert "\n
	 * Support for arbitrary pixmaps in a buffer.
	 * Access to the ToolTalk API.
	 * Proper integration with Xt and Motif (including Motif menubars
	   and scrollbars).
	 * Support for using XEmacs screens as Xt widgets.
	 * Support for overlapping regions (or extents) and efficient handling
	   of a large number of such extents in a single buffer.
	 * Support for variable-width and variable height fonts.
	 * A clean interface to the menubar, window-system events, and key
	   combinations."))
	 ))
      (goto-char (point-min))
      ))))
