/* Generic glyph data structures + display tables
   Copyright (C) 1994 Board of Trustees, University of Illinois
   Copyright (C) 1995 Ben Wing

This file is part of XEmacs.

XEmacs is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Synched up with: Not in FSF. */

#ifndef _XEMACS_GLYPHS_H_
#define _XEMACS_GLYPHS_H_

#include "specifier.h"

struct Lisp_Glyph
{
  struct lcrecord_header header;

  /* specifiers: */
  Lisp_Object image;		/* the actual image */
  Lisp_Object contrib_p;	/* whether to figure into line height */
  Lisp_Object baseline;		/* percent above baseline */

  Lisp_Object face;		/* if non-nil, face to use when displaying */

  Lisp_Object plist;
};

DECLARE_LRECORD (glyph, struct Lisp_Glyph);
#define XGLYPH(x) XRECORD (x, glyph, struct Lisp_Glyph)
#define XSETGLYPH(x, p) XSETRECORD (x, p, glyph)
#define GLYPHP(x) RECORDP (x, glyph)
#define CHECK_GLYPH(x, i) CHECK_RECORD (x, glyph)

#define GLYPH_IMAGE(g) ((g)->image)
#define GLYPH_CONTRIB_P(g) ((g)->contrib_p)
#define GLYPH_BASELINE(g) ((g)->baseline)
#define GLYPH_FACE(g) ((g)->face)

struct glyph_cache_element
{
  Lisp_Object glyph;

  unsigned int updated :1;
  unsigned short width;
  unsigned short ascent;
  unsigned short descent;
};

extern Lisp_Object Vtruncation_glyph, Vcontinuation_glyph, Voctal_escape_glyph;
extern Lisp_Object Vcontrol_arrow_glyph, Vinvisible_text_glyph, Vhscroll_glyph;
extern Lisp_Object Vxemacs_logo;

extern Lisp_Object Q_data, Q_file, Qautodetect;

DECLARE_SPECIFIER_OBJECT (image);
extern Lisp_Object Qimage;
#define XIMAGE_SPECIFIER(x) XSPECIFIER_OBJECT (x, image)
#define XSETIMAGE_SPECIFIER(x, p) XSETSPECIFIER_OBJECT (x, p, image)
#define IMAGE_SPECIFIERP(x) SPECIFIER_OBJECTP (x, image)
#define CHECK_IMAGE_SPECIFIER(x, i) CHECK_SPECIFIER_OBJECT (x, i, image)

extern unsigned short glyph_width (Lisp_Object glyph, face_index findex,
				   int framep, Lisp_Object window);
extern unsigned short glyph_ascent (Lisp_Object glyph, face_index findex,
				    int framep, Lisp_Object window);
extern unsigned short glyph_descent (Lisp_Object glyph, face_index findex,
				     int framep, Lisp_Object window);
extern unsigned short glyph_height (Lisp_Object glyph, face_index findex,
				    int framep, Lisp_Object window);
extern Lisp_Object glyph_baseline (Lisp_Object glyph, Lisp_Object domain);
extern Lisp_Object glyph_face (Lisp_Object glyph, Lisp_Object domain);
extern int glyph_contrib_p (Lisp_Object glyph, Lisp_Object domain);
extern Lisp_Object glyph_image_instance (Lisp_Object glyph,
					 Lisp_Object domain,
					 int no_errors_or_quit);

#define CONT_GLYPH_INDEX	(glyph_index) 0
#define TRUN_GLYPH_INDEX	(glyph_index) 1
#define HSCROLL_GLYPH_INDEX	(glyph_index) 2
#define CONTROL_GLYPH_INDEX	(glyph_index) 3
#define OCT_ESC_GLYPH_INDEX	(glyph_index) 4
#define INVIS_GLYPH_INDEX	(glyph_index) 5

#define GLYPH_CACHE_ELEMENT(window, index)				\
  Dynarr_atp (window->glyph_cache_elements, index)
#define GLYPH_CACHE_ELEMENT_GLYPH(window, index)			\
  Dynarr_atp (window->glyph_cache_elements, index)->glyph
#define GLYPH_CACHE_ELEMENT_WIDTH(window, index)			\
  Dynarr_atp (window->glyph_cache_elements, index)->width
#define GLYPH_CACHE_ELEMENT_ASCENT(window, index)			\
  Dynarr_atp (window->glyph_cache_elements, index)->ascent
#define GLYPH_CACHE_ELEMENT_DESCENT(window, index)			\
  Dynarr_atp (window->glyph_cache_elements, index)->descent

extern void mark_glyph_cache_elements (glyph_cache_element_dynarr *elements,
				       void (*markobj) (Lisp_Object));
extern void mark_glyph_cache_elements_as_not_updated (struct window *w);
extern void reset_glyph_cache_elements (struct window *w);
extern Lisp_Object process_image_string_instantiator (Lisp_Object data,
						      Lisp_Object device_type,
						      int no_errors_or_quit);

/* Display tables
   It no longer makes sense to have a separate header for these 3
   items and since the display tables are most closely related to
   glyphs, they get stuck here. */

#define DISP_TABLE_SIZE	256
#define DISP_CHAR_ENTRY(dp, c)	((dp)->contents[c])

/* Display table to use for vectors that don't specify their own.  */
extern Lisp_Object Vstandard_display_table;

extern struct Lisp_Vector *get_display_table (struct window *, face_index);

#endif /* _XEMACS_GLYPHS_H_ */
