/* Synched up with: FSF 19.28. */

/* XEmacs change from Georg Nikodym <Georg.Nikodym@Canada.sun.com>:
   need this before usg* include for gettimeofday() in Solaris 2.5 */
#define _SVID_GETTOD

#include "usg5-4-2.h"		/* XEmacs change from 5-4 to 5-4-2 */

#define SOLARIS2

/* SIGIO seems to be working under Solaris and it makes ^G work better... */
#undef BROKEN_SIGIO

/* eggert@twinsun.com said these work in Solaris.
   Perhaps they work in all kinds of SVR4, but this is more conservative.  */
#undef BROKEN_TIOCGETC
#undef BROKEN_TIOCGWINSZ

/* This triggers a conditional in xfaces.c.  */
#define XOS_NEEDS_TIME_H

#define POSIX

/* FSF uses LD_SWITCH_X_SITE_AUX in the following definitions to deal with
   the -R flags.  While the intention is good, it doesn't seem to work that
   well -- Solaris is just too damn screwy.  So we go ahead and let
   configure have special checks for Solaris. */

/* Here is how to find X Windows.  The -R option says where
   to find X windows at run time.  */
#ifndef __GNUC__
#define LD_SWITCH_SYSTEM -R/usr/openwin/lib
#else /* GCC */
#define LD_SWITCH_SYSTEM -Xlinker -R/usr/openwin/lib
#endif /* GCC */

/* XEmacs change -- Sun CC needs this to default to ANSI */
#ifdef __SUNPRO_C
#define C_SWITCH_SYSTEM -Xa
#endif /* __SUNPRO_C */

#ifndef NOT_C_CODE
/* The standard Solaris library nsl has this function in it which is
   supposed to only be in the BSD compat stuff.  Yuck.  Of course,
   there isn't a prototype for it other than in /usr/ucbinclude. */
int gethostname (char *, int);
/* Same thing for this damn function. */
int getdomainname (char *, int);
#endif

/* XEmacs change -- removed flags to force K & R compilation */

/* Karl Berry writes:
If you have the misfortune to be running Solaris 2.1, you may have
noticed that the access system call does not check the readonlyness of
the filesystem the path refers to.  This is a bug, according to
access(2), but in the meantime, some of us need the right behavior.  */

/* Well, we released Emacs with this change, and fixed a typo, but
   people keep saying that it doesn't work, and that the patch is easy
   to install.  Patch number is 100947-02.  */
#undef SOLARIS_BROKEN_ACCESS

/* We can't use libX11 from X11R6 with ralloc.c, because libX11
   includes libthread.so and that calls sbrk directly.  */
#if defined (HAVE_X_WINDOWS) && defined (THIS_IS_X11R6)
#undef REL_ALLOC
#endif

/*
 * XEmacs change -- some Motif packages need -lgen to get regex and regcmp
 */

#undef LIBS_SYSTEM
#define LIBS_SYSTEM -lsocket -lnsl -lelf -lkvm -lgen -ldl


/* #### XEmacs change: until we've gotten the Energize builds converted
   over to use configure instead of ymakefile, we still need this.
 */
#ifdef THIS_IS_YMAKEFILE

# define LIB_INTL -L/usr/openwin/lib -lintl -lw
# define LIBS_TERMCAP -ltermlib 
# define LIBS_DEBUG
# undef LIBS_SYSTEM
# define LIBS_SYSTEM -lsocket -lnsl -lintl -lelf -lkvm -lgen -ldl
# define START_FILES
# define LD_CMD $(CC)

#endif

/* SYSTEM_MALLOC must be defined if dbx/RTC is going to be used.  dbx/RTC does
   not work with a static definition of malloc(). */
/* We want to be able to test out ralloc.c. */
/* #define SYSTEM_MALLOC */

/* XEmacs addition: */

#ifdef PTY_TTY_NAME_SPRINTF
#undef PTY_TTY_NAME_SPRINTF
#endif

#define PTY_TTY_NAME_SPRINTF					\
	{							\
	    char *ptyname;					\
	    if (grantpt (fd) == -1)				\
	      { close (fd); return -1; }			\
	    if (unlockpt (fd) == -1)				\
	      { close (fd); return -1; }			\
	    if (!(ptyname = ptsname (fd)))			\
	      { close (fd); return -1; }			\
	    strncpy(pty_name, ptyname, sizeof (pty_name));	\
	    pty_name[sizeof (pty_name) - 1] = 0;		\
	}

/* XEmacs change from Georg.Nikodym@Canada.Sun.COM. */
#ifdef UNEXEC 
#undef UNEXEC 
#endif
#define UNEXEC unexsol2.o
