.\" $NCDId: @(#)auctl.man,v 1.6 1994/06/01 17:43:34 greg Exp $
.TH AUCTL 1 "" ""
.SH NAME
auctl \- control various audio server parameters
.SH SYNOPSYS
.B auctl
[\-audio \fIservername\fP] [\-q] [\fIcommand...\fP]
.SH DESCRIPTION
The \fIauctl\fP program can be used to control various audio server parameters.
It is typically used when connecting up new devices, or to set user
preferences.  If no command is specified on the program command line,
.I auctl
reads commands from the standard output.  If the standard input and standard
output are both attached to a terminal, an interactive prompt is provided.
.SH OPTIONS
The following options may be used with \fIauctl\fP:
.TP 8
.BI "\-audio " servername
This option specifies the Network Audio System server on which the files should be played.
.TP 8
.B -q
This option indicates that no prompt should be given when reading commands
from the standard input.
.SH COMMANDS
The following commands may be used with \fIauctl\fP:
.TP 8
.B "help"
This command prints a list of the commands that may be given.
.TP 8
.B "set device \fIid\fP gain [=,+,-] \fIpercent\fP"
With \fI=\fP, this command sets the gain on the device specified by
\fIid\fP to the indicated percentage, or alters it by the given number
of percentage points if \fI+\fP or \fI-\fP is used.
If the \fIid\fP is a decimal number \fBn\fP, the \fInth\fP 
device returned by the server (see \fIauinfo\fP) is used.  Otherwise, \fIid\fP
should be a hexidecimal number specifying the resource identifier of the
desired device.
.TP 8
.B "set device \fIid\fP linemode = low"
This command sets the linemode of the device specified by \fIid\fP to the
lower setting appropriate for microphones.
.TP 8
.B "set device \fIid\fP linemode = hi"
This command sets the linemode of the device specified by \fIid\fP to the
higher setting appropriate for CD players.
.TP 8
.B "list device \fIid\fP gain"
This command lists the gain of the specified device in the form needed to
set it.
.TP 8
.B "list device \fIid\fP linemode"
This command lists the line mode of the specified device in the form needed to
set it.
.TP 8
.B "list device \fIid\fP"
This command lists the gain and line mode of the specified device.
.TP 8
.B "quit\fR, \fPexit\fR, or \fP^D"
Either of these commands or an end of file causes the program to exit.
.SH "ENVIRONMENT VARIABLES"
.PP
The following environment variables are used by \fIauctl\fP:
.TP 8
.B AUDIOSERVER
This specifies the name of default audio server to contact if no name is 
explicitly given on the command line.
.TP 8
.B DISPLAY
This specifies the name of an X Window System display that should be assumed
to also have a corresponding Network Audio System server.
.SH "SEE ALSO"
nas(1), auplay(1), audial(1), audemo(1), autool(1)
.SH COPYRIGHT
Copyright 1993, 1994 Network Computing Devices, Inc.
.SH AUTHOR
Jim Fulton, Network Computing Devices, Inc.



