/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.wizards.DefaultNameFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;
import jde.wizards.SignatureContainer;
import jde.wizards.SignatureVisitor;

public class DelegateFactory
extends MethodFactory {
    private SignatureContainer signatures = new SignatureContainer();
    private static DelegateFactory delegateFactory;
    private String delegee;

    public DelegateFactory() {
    }

    public DelegateFactory(NameFactory factory) {
        super(factory);
    }

    public SignatureContainer getSignatures() {
        return this.signatures;
    }

    public void setSignatures(SignatureContainer argSignatures) {
        this.signatures = argSignatures;
    }

    public static DelegateFactory getTheFactory() {
        return delegateFactory;
    }

    public static void setTheFactory(DelegateFactory argDelegateFactory) {
        delegateFactory = argDelegateFactory;
    }

    public String getDelegee() {
        return this.delegee;
    }

    public void setDelegee(String argDelegee) {
        this.delegee = argDelegee;
    }

    public void flush() {
        super.flush();
        this.signatures.clear();
    }

    public void process(String interfaceName) throws ClassNotFoundException {
        this.process(interfaceName, true);
    }

    public void process(String delegeeClassName, boolean truncate) throws ClassNotFoundException {
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        Class<?> aclass = Class.forName(delegeeClassName);
        Method[] methods = aclass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].getDeclaringClass().getName().equals("java.lang.Object") || !Modifier.isFinal(methods[i].getModifiers())) {
                this.signatures.add(new Signature(methods[i], this, truncate, true));
            }
            ++i;
        }
    }

    private void makeDelegatorMethodsInternal(String delegeeFieldName, String delegeeClassName, boolean truncate) {
        this.delegee = delegeeFieldName;
        try {
            this.process(delegeeClassName, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find class named: " + delegeeClassName + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (Exception e) {
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.outputMethods(new PrintWriter(System.out, true), truncate);
    }

    public static void makeDelegatorMethods(String delegeeFieldName, String delegeeClassName, boolean truncate) {
        if (delegateFactory == null) {
            delegateFactory = new DelegateFactory();
        }
        delegateFactory.flush();
        delegateFactory.makeDelegatorMethodsInternal(delegeeFieldName, delegeeClassName, truncate);
    }

    public static void getImportedClasses() {
        MethodFactory.println(delegateFactory.getImportsAsList());
    }

    protected String getDefaultBody(Signature sig) {
        Method m = sig.getMethod();
        Class<?> cl = m.getReturnType();
        String defBody = "";
        defBody = this.delegee + "." + m.getName() + "(" + sig.getParameterNames() + ");";
        if (!cl.getName().equals("void")) {
            defBody = "return " + defBody;
        }
        return defBody;
    }

    public void outputMethods(PrintWriter out, boolean truncate) {
        final StringBuffer buf = new StringBuffer("(jde-wiz-gen-delegation-methods (list ");
        this.signatures.visit(new SignatureVisitor(){

            public void visit(Signature sig, boolean firstOfClass) {
                if (firstOfClass) {
                    buf.append("(quote ");
                    buf.append("\"Code for delegation of ");
                    buf.append(sig.getDeclaringClass().getName());
                    buf.append(" methods to ");
                    buf.append(DelegateFactory.this.delegee);
                    buf.append("\")");
                }
                buf.append("(quote ");
                buf.append(DelegateFactory.this.getMethodSkeletonExpression(sig));
                buf.append(")");
            }
        });
        buf.append("))");
        MethodFactory.println(buf.toString());
    }
}

