/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] m_buckets;
    private Lock[] m_locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int n) {
        int n2 = Math.max(17, n);
        if (n2 % 2 == 0) {
            --n2;
        }
        this.m_buckets = new Node[n2];
        this.m_locks = new Lock[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_locks[n3] = new Lock();
            ++n3;
        }
    }

    public void atomic(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.atomic(runnable, 0);
    }

    private void atomic(Runnable runnable, int n) {
        if (n >= this.m_buckets.length) {
            runnable.run();
            return;
        }
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            this.atomic(runnable, n + 1);
        }
    }

    public final void clear() {
        int n = 0;
        while (n < this.m_buckets.length) {
            Lock lock;
            Lock lock2 = lock = this.m_locks[n];
            synchronized (lock2) {
                this.m_buckets[n] = null;
                lock.size = 0;
            }
            ++n;
        }
    }

    public boolean containsKey(Object object) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    boolean bl = true;
                    Object var5_6 = null;
                    return bl;
                }
                node = node.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        int n = 0;
        while (n < this.m_buckets.length) {
            Lock lock = this.m_locks[n];
            synchronized (lock) {
                Node node = this.m_buckets[n];
                while (node != null) {
                    if (node.value == object || node.value != null && node.value.equals(object)) {
                        boolean bl = true;
                        Object var5_6 = null;
                        return bl;
                    }
                    node = node.next;
                }
            }
            ++n;
        }
        return false;
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.entrySet().equals(map.entrySet());
    }

    public Object get(Object object) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object2 = node.value;
                    Object var5_6 = null;
                    return object2;
                }
                node = node.next;
            }
        }
        return null;
    }

    private final int getHash(Object object) {
        if (object == null) {
            return 0;
        }
        int n = object.hashCode();
        n += ~(n << 15);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return (n %= this.m_buckets.length) < 0 ? n * -1 : n;
    }

    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Lock lock = this.m_locks[n2];
            synchronized (lock) {
                Node node = this.m_buckets[n2];
                while (node != null) {
                    n += node.hashCode();
                    node = node.next;
                }
            }
            ++n2;
        }
        return n;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new KeySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object object, Object object2) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            if (node == null) {
                node = new Node();
                node.key = object;
                node.value = object2;
                this.m_buckets[n] = node;
                ++this.m_locks[n].size;
                return null;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object3 = node.value;
                    node.value = object2;
                    return object3;
                }
                node2 = node2.next;
            }
            Node node3 = new Node();
            node3.key = object;
            node3.value = object2;
            node.next = node3;
            ++this.m_locks[n].size;
            return null;
        }
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public Object remove(Object object) {
        int n = this.getHash(object);
        Lock lock = this.m_locks[n];
        synchronized (lock) {
            Node node = this.m_buckets[n];
            Node node2 = null;
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    if (node2 == null) {
                        this.m_buckets[n] = node.next;
                    } else {
                        node2.next = node.next;
                    }
                    --this.m_locks[n].size;
                    Object object2 = node.value;
                    Object var5_7 = null;
                    return object2;
                }
                node2 = node;
                node = node.next;
            }
        }
        return null;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            n += this.m_locks[n2].size;
            ++n2;
        }
        return n;
    }

    public Collection values() {
        return new Values();
    }

    private final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;

        Node() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl = this.key.equals(entry.getKey());
                if (!bl) return false;
            }
            if (this.value == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl = this.value.equals(entry.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }

    private static final class Lock {
        public int size;

        Lock() {
        }
    }

    private class EntryIterator
    implements Iterator {
        private ArrayList current = new ArrayList();
        private int bucket;
        private Map.Entry last;

        EntryIterator() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.current.size() <= 0) ** GOTO lbl21
            return true;
lbl-1000:
            // 1 sources

            {
                var2_1 = StaticBucketMap.access$1(StaticBucketMap.this)[this.bucket];
                synchronized (var2_1) {
                    var4_2 = StaticBucketMap.access$0(StaticBucketMap.this)[this.bucket];
                    while (var4_2 != null) {
                        this.current.add(var4_2);
                        var4_2 = var4_2.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        var1_3 = true;
                        var3_4 = null;
                        return var1_3;
                    }
                    continue;
                }
lbl21:
                // 2 sources

                ** while (this.bucket < StaticBucketMap.access$0((StaticBucketMap)StaticBucketMap.this).length)
            }
lbl22:
            // 1 sources

            return false;
        }

        public Object next() {
            return this.nextEntry();
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            StaticBucketMap.this.remove(this.last.getKey());
            this.last = null;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends EntryIterator {
        KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public boolean contains(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[n];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n];
                while (node != null) {
                    if (node.equals(entry)) {
                        boolean bl = true;
                        Object var6_7 = null;
                        return bl;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean remove(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[n];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n];
                while (node != null) {
                    if (node.equals(entry)) {
                        StaticBucketMap.this.remove(node.getKey());
                        boolean bl = true;
                        Object var6_7 = null;
                        return bl;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public int size() {
            return StaticBucketMap.this.size();
        }
    }

    private class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public boolean contains(Object object) {
            return StaticBucketMap.this.containsKey(object);
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean remove(Object object) {
            int n = StaticBucketMap.this.getHash(object);
            Lock lock = StaticBucketMap.this.m_locks[n];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n];
                while (node != null) {
                    Object object2 = node.getKey();
                    if (object2 == object || object2 != null && object2.equals(object)) {
                        StaticBucketMap.this.remove(object2);
                        boolean bl = true;
                        Object var5_7 = null;
                        return bl;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public int size() {
            return StaticBucketMap.this.size();
        }
    }

    private class Values
    extends AbstractCollection {
        Values() {
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return StaticBucketMap.this.size();
        }
    }
}

