;;; thai-xtis.el --- Quail package for Thai in XTIS

;; Keywords: multilingual, Thai

;; This file is NOT part of GNU Emacs.

;; Author: TAKAHASHI Naoto <ntakahas@etl.go.jp>

;; Last modified: 10 June 1999

;;; Commentary:

;; Intended to be installed as leim/quail/xtis.el

;;; Code:

(require 'quail)

;; The inverted list.  Used in quail-thai-update-translation.

(defconst
  thai-reverse-map
  '(
;    (?$(?_0(B . " ")
;    (?$(?o0(B . " ")
    (?$(?m0(B . "!")
    (?$(?r0(B . "#")
    (?$(?s0(B . "$")
    (?$(?t0(B . "%")
    (?$(?'7(B . "'!")
    (?$(?'0(B . "'")
    (?$(?'`(B . "'6")
    (?$(?'e(B . "'6J")
    (?$(?'d(B . "'6U")
    (?$(?'c(B . "'6h")
    (?$(?'b(B . "'6j")
    (?$(?'P(B . "'7")
    (?$(?'U(B . "'7J")
    (?$(?'T(B . "'7U")
    (?$(?'S(B . "'7h")
    (?$(?'R(B . "'7j")
    (?$(?'1(B . "'H")
    (?$(?'5(B . "'J")
    (?$(?'x(B . "'M")
    (?$(?'6(B . "'N")
    (?$(?'4(B . "'U")
    (?$(?'p(B . "'\"")
    (?$(?'h(B . "'^")
    (?$(?'m(B . "'^J")
    (?$(?'l(B . "'^U")
    (?$(?'k(B . "'^h")
    (?$(?'j(B . "'^j")
    (?$(?'@(B . "'b")
    (?$(?'E(B . "'bJ")
    (?$(?'D(B . "'bU")
    (?$(?'C(B . "'bh")
    (?$(?'B(B . "'bj")
    (?$(?'3(B . "'h")
    (?$(?'2(B . "'j")
    (?$(?'X(B . "'n")
    (?$(?'](B . "'nJ")
    (?$(?'\(B . "'nU")
    (?$(?'[(B . "'nh")
    (?$(?'Z(B . "'nj")
    (?$(?'H(B . "'u")
    (?$(?'M(B . "'uJ")
    (?$(?'L(B . "'uU")
    (?$(?'K(B . "'uh")
    (?$(?'J(B . "'uj")
    (?$(?'8(B . "'y")
    (?$(?'=(B . "'yJ")
    (?$(?'<(B . "'yU")
    (?$(?';(B . "'yh")
    (?$(?':(B . "'yj")
    (?$(?v0(B . "(")
    (?$(?w0(B . ")")
    (?$(?u0(B . "*")
    (?$(?y0(B . "+")
    (?$(?A7(B . ",!")
    (?$(?A0(B . ",")
    (?$(?A`(B . ",6")
    (?$(?Ae(B . ",6J")
    (?$(?Ad(B . ",6U")
    (?$(?Ac(B . ",6h")
    (?$(?Ab(B . ",6j")
    (?$(?AP(B . ",7")
    (?$(?AU(B . ",7J")
    (?$(?AT(B . ",7U")
    (?$(?AS(B . ",7h")
    (?$(?AR(B . ",7j")
    (?$(?A1(B . ",H")
    (?$(?A5(B . ",J")
    (?$(?Ax(B . ",M")
    (?$(?A6(B . ",N")
    (?$(?A4(B . ",U")
    (?$(?Ap(B . ",\"")
    (?$(?Ah(B . ",^")
    (?$(?Am(B . ",^J")
    (?$(?Al(B . ",^U")
    (?$(?Ak(B . ",^h")
    (?$(?Aj(B . ",^j")
    (?$(?A@(B . ",b")
    (?$(?AE(B . ",bJ")
    (?$(?AD(B . ",bU")
    (?$(?AC(B . ",bh")
    (?$(?AB(B . ",bj")
    (?$(?A3(B . ",h")
    (?$(?A2(B . ",j")
    (?$(?AX(B . ",n")
    (?$(?A](B . ",nJ")
    (?$(?A\(B . ",nU")
    (?$(?A[(B . ",nh")
    (?$(?AZ(B . ",nj")
    (?$(?AH(B . ",u")
    (?$(?AM(B . ",uJ")
    (?$(?AL(B . ",uU")
    (?$(?AK(B . ",uh")
    (?$(?AJ(B . ",uj")
    (?$(?A8(B . ",y")
    (?$(?A=(B . ",yJ")
    (?$(?A<(B . ",yU")
    (?$(?A;(B . ",yh")
    (?$(?A:(B . ",yj")
    (?$(?"7(B . "-!")
    (?$(?"0(B . "-")
    (?$(?"`(B . "-6")
    (?$(?"c(B . "-6h")
    (?$(?"b(B . "-6j")
    (?$(?"P(B . "-7")
    (?$(?"S(B . "-7h")
    (?$(?"R(B . "-7j")
    (?$(?"1(B . "-H")
    (?$(?"x(B . "-M")
    (?$(?"6(B . "-N")
    (?$(?"p(B . "-\"")
    (?$(?"h(B . "-^")
    (?$(?"k(B . "-^h")
    (?$(?"j(B . "-^j")
    (?$(?"@(B . "-b")
    (?$(?"C(B . "-bh")
    (?$(?"B(B . "-bj")
    (?$(?"3(B . "-h")
    (?$(?"2(B . "-j")
    (?$(?"X(B . "-n")
    (?$(?"[(B . "-nh")
    (?$(?"Z(B . "-nj")
    (?$(?"H(B . "-u")
    (?$(?"K(B . "-uh")
    (?$(?"J(B . "-uj")
    (?$(?"8(B . "-y")
    (?$(?";(B . "-yh")
    (?$(?":(B . "-yj")
    (?$(?c0(B . ".")
    (?$(?=7(B . "/!")
    (?$(?=0(B . "/")
    (?$(?=`(B . "/6")
    (?$(?=c(B . "/6h")
    (?$(?=b(B . "/6j")
    (?$(?=P(B . "/7")
    (?$(?=S(B . "/7h")
    (?$(?=R(B . "/7j")
    (?$(?=1(B . "/H")
    (?$(?=x(B . "/M")
    (?$(?=6(B . "/N")
    (?$(?=p(B . "/\"")
    (?$(?=h(B . "/^")
    (?$(?=k(B . "/^h")
    (?$(?=j(B . "/^j")
    (?$(?=@(B . "/b")
    (?$(?=C(B . "/bh")
    (?$(?=B(B . "/bj")
    (?$(?=3(B . "/h")
    (?$(?=2(B . "/j")
    (?$(?=X(B . "/n")
    (?$(?=[(B . "/nh")
    (?$(?=Z(B . "/nj")
    (?$(?=H(B . "/u")
    (?$(?=K(B . "/uh")
    (?$(?=J(B . "/uj")
    (?$(?=8(B . "/y")
    (?$(?=;(B . "/yh")
    (?$(?=:(B . "/yj")
    (?$(?(7(B . "0!")
    (?$(?(0(B . "0")
    (?$(?(`(B . "06")
    (?$(?(e(B . "06J")
    (?$(?(d(B . "06U")
    (?$(?(c(B . "06h")
    (?$(?(b(B . "06j")
    (?$(?(P(B . "07")
    (?$(?(U(B . "07J")
    (?$(?(T(B . "07U")
    (?$(?(S(B . "07h")
    (?$(?(R(B . "07j")
    (?$(?(1(B . "0H")
    (?$(?(5(B . "0J")
    (?$(?(x(B . "0M")
    (?$(?(6(B . "0N")
    (?$(?(4(B . "0U")
    (?$(?(p(B . "0\"")
    (?$(?(h(B . "0^")
    (?$(?(m(B . "0^J")
    (?$(?(l(B . "0^U")
    (?$(?(k(B . "0^h")
    (?$(?(j(B . "0^j")
    (?$(?(@(B . "0b")
    (?$(?(E(B . "0bJ")
    (?$(?(D(B . "0bU")
    (?$(?(C(B . "0bh")
    (?$(?(B(B . "0bj")
    (?$(?(3(B . "0h")
    (?$(?(2(B . "0j")
    (?$(?(X(B . "0n")
    (?$(?(](B . "0nJ")
    (?$(?(\(B . "0nU")
    (?$(?([(B . "0nh")
    (?$(?(Z(B . "0nj")
    (?$(?(H(B . "0u")
    (?$(?(M(B . "0uJ")
    (?$(?(L(B . "0uU")
    (?$(?(K(B . "0uh")
    (?$(?(J(B . "0uj")
    (?$(?(8(B . "0y")
    (?$(?(=(B . "0yJ")
    (?$(?(<(B . "0yU")
    (?$(?(;(B . "0yh")
    (?$(?(:(B . "0yj")
    (?$(?@7(B . "4!")
    (?$(?@0(B . "4")
    (?$(?@`(B . "46")
    (?$(?@d(B . "46U")
    (?$(?@c(B . "46h")
    (?$(?@b(B . "46j")
    (?$(?@P(B . "47")
    (?$(?@T(B . "47U")
    (?$(?@S(B . "47h")
    (?$(?@R(B . "47j")
    (?$(?@1(B . "4H")
    (?$(?@x(B . "4M")
    (?$(?@6(B . "4N")
    (?$(?@4(B . "4U")
    (?$(?@p(B . "4\"")
    (?$(?@h(B . "4^")
    (?$(?@l(B . "4^U")
    (?$(?@k(B . "4^h")
    (?$(?@j(B . "4^j")
    (?$(?@@(B . "4b")
    (?$(?@D(B . "4bU")
    (?$(?@C(B . "4bh")
    (?$(?@B(B . "4bj")
    (?$(?@3(B . "4h")
    (?$(?@2(B . "4j")
    (?$(?@X(B . "4n")
    (?$(?@\(B . "4nU")
    (?$(?@[(B . "4nh")
    (?$(?@Z(B . "4nj")
    (?$(?@H(B . "4u")
    (?$(?@L(B . "4uU")
    (?$(?@K(B . "4uh")
    (?$(?@J(B . "4uj")
    (?$(?@8(B . "4y")
    (?$(?@<(B . "4yU")
    (?$(?@;(B . "4yh")
    (?$(?@:(B . "4yj")
    (?$(?67(B . "5!")
    (?$(?60(B . "5")
    (?$(?6`(B . "56")
    (?$(?6f(B . "56N")
    (?$(?6c(B . "56h")
    (?$(?6b(B . "56j")
    (?$(?6P(B . "57")
    (?$(?6S(B . "57h")
    (?$(?6R(B . "57j")
    (?$(?61(B . "5H")
    (?$(?6x(B . "5M")
    (?$(?66(B . "5N")
    (?$(?6p(B . "5\"")
    (?$(?6h(B . "5^")
    (?$(?6k(B . "5^h")
    (?$(?6j(B . "5^j")
    (?$(?6@(B . "5b")
    (?$(?6C(B . "5bh")
    (?$(?6B(B . "5bj")
    (?$(?63(B . "5h")
    (?$(?62(B . "5j")
    (?$(?6X(B . "5n")
    (?$(?6[(B . "5nh")
    (?$(?6Z(B . "5nj")
    (?$(?6H(B . "5u")
    (?$(?6K(B . "5uh")
    (?$(?6J(B . "5uj")
    (?$(?68(B . "5y")
    (?$(?6;(B . "5yh")
    (?$(?6:(B . "5yj")
    (?$(?X0(B . "6")
    (?$(?V0(B . "7")
    (?$(?$7(B . "8!")
    (?$(?$0(B . "8")
    (?$(?$`(B . "86")
    (?$(?$d(B . "86U")
    (?$(?$c(B . "86h")
    (?$(?$b(B . "86j")
    (?$(?$P(B . "87")
    (?$(?$T(B . "87U")
    (?$(?$S(B . "87h")
    (?$(?$R(B . "87j")
    (?$(?$1(B . "8H")
    (?$(?$x(B . "8M")
    (?$(?$6(B . "8N")
    (?$(?$4(B . "8U")
    (?$(?$p(B . "8\"")
    (?$(?$h(B . "8^")
    (?$(?$l(B . "8^U")
    (?$(?$k(B . "8^h")
    (?$(?$j(B . "8^j")
    (?$(?$@(B . "8b")
    (?$(?$D(B . "8bU")
    (?$(?$C(B . "8bh")
    (?$(?$B(B . "8bj")
    (?$(?$3(B . "8h")
    (?$(?$2(B . "8j")
    (?$(?$X(B . "8n")
    (?$(?$\(B . "8nU")
    (?$(?$[(B . "8nh")
    (?$(?$Z(B . "8nj")
    (?$(?$H(B . "8u")
    (?$(?$L(B . "8uU")
    (?$(?$K(B . "8uh")
    (?$(?$J(B . "8uj")
    (?$(?$8(B . "8y")
    (?$(?$<(B . "8yU")
    (?$(?$;(B . "8yh")
    (?$(?$:(B . "8yj")
    (?$(?57(B . "9!")
    (?$(?50(B . "9")
    (?$(?5`(B . "96")
    (?$(?5e(B . "96J")
    (?$(?5d(B . "96U")
    (?$(?5c(B . "96h")
    (?$(?5b(B . "96j")
    (?$(?5P(B . "97")
    (?$(?5U(B . "97J")
    (?$(?5T(B . "97U")
    (?$(?5S(B . "97h")
    (?$(?5R(B . "97j")
    (?$(?51(B . "9H")
    (?$(?55(B . "9J")
    (?$(?5x(B . "9M")
    (?$(?56(B . "9N")
    (?$(?54(B . "9U")
    (?$(?5p(B . "9\"")
    (?$(?5h(B . "9^")
    (?$(?5m(B . "9^J")
    (?$(?5l(B . "9^U")
    (?$(?5k(B . "9^h")
    (?$(?5j(B . "9^j")
    (?$(?5@(B . "9b")
    (?$(?5E(B . "9bJ")
    (?$(?5F(B . "9bN")
    (?$(?5D(B . "9bU")
    (?$(?5C(B . "9bh")
    (?$(?5B(B . "9bj")
    (?$(?53(B . "9h")
    (?$(?52(B . "9j")
    (?$(?5X(B . "9n")
    (?$(?5](B . "9nJ")
    (?$(?5\(B . "9nU")
    (?$(?5[(B . "9nh")
    (?$(?5Z(B . "9nj")
    (?$(?5H(B . "9u")
    (?$(?5M(B . "9uJ")
    (?$(?5L(B . "9uU")
    (?$(?5K(B . "9uh")
    (?$(?5J(B . "9uj")
    (?$(?58(B . "9y")
    (?$(?5=(B . "9yJ")
    (?$(?5<(B . "9yU")
    (?$(?5;(B . "9yh")
    (?$(?5:(B . "9yj")
    (?$(?+7(B . ":!")
    (?$(?+0(B . ":")
    (?$(?+`(B . ":6")
    (?$(?+d(B . ":6U")
    (?$(?+c(B . ":6h")
    (?$(?+b(B . ":6j")
    (?$(?+P(B . ":7")
    (?$(?+T(B . ":7U")
    (?$(?+S(B . ":7h")
    (?$(?+R(B . ":7j")
    (?$(?+1(B . ":H")
    (?$(?+x(B . ":M")
    (?$(?+6(B . ":N")
    (?$(?+4(B . ":U")
    (?$(?+p(B . ":\"")
    (?$(?+h(B . ":^")
    (?$(?+l(B . ":^U")
    (?$(?+k(B . ":^h")
    (?$(?+j(B . ":^j")
    (?$(?+@(B . ":b")
    (?$(?+D(B . ":bU")
    (?$(?+C(B . ":bh")
    (?$(?+B(B . ":bj")
    (?$(?+3(B . ":h")
    (?$(?+2(B . ":j")
    (?$(?+X(B . ":n")
    (?$(?+\(B . ":nU")
    (?$(?+[(B . ":nh")
    (?$(?+Z(B . ":nj")
    (?$(?+H(B . ":u")
    (?$(?+L(B . ":uU")
    (?$(?+K(B . ":uh")
    (?$(?+J(B . ":uj")
    (?$(?+8(B . ":y")
    (?$(?+<(B . ":yU")
    (?$(?+;(B . ":yh")
    (?$(?+:(B . ":yj")
    ("$(?G7(B" . ";!")
    ("$(?G0(B" . ";")
    ("$(?G`(B" . ";6")
    ("$(?Ge(B" . ";6J")
    ("$(?Gd(B" . ";6U")
    ("$(?Gc(B" . ";6h")
    ("$(?Gb(B" . ";6j")
    ("$(?GP(B" . ";7")
    ("$(?GU(B" . ";7J")
    ("$(?GT(B" . ";7U")
    ("$(?GS(B" . ";7h")
    ("$(?GR(B" . ";7j")
    ("$(?G1(B" . ";H")
    ("$(?G5(B" . ";J")
    ("$(?Gx(B" . ";M")
    ("$(?G6(B" . ";N")
    ("$(?G4(B" . ";U")
    ("$(?Gp(B" . ";\"")
    ("$(?Gh(B" . ";^")
    ("$(?Gm(B" . ";^J")
    ("$(?Gl(B" . ";^U")
    ("$(?Gk(B" . ";^h")
    ("$(?Gj(B" . ";^j")
    ("$(?G@(B" . ";b")
    ("$(?GE(B" . ";bJ")
    ("$(?GD(B" . ";bU")
    ("$(?GC(B" . ";bh")
    ("$(?GB(B" . ";bj")
    ("$(?G3(B" . ";h")
    ("$(?G2(B" . ";j")
    ("$(?GX(B" . ";n")
    ("$(?G](B" . ";nJ")
    ("$(?G\(B" . ";nU")
    ("$(?G[(B" . ";nh")
    ("$(?GZ(B" . ";nj")
    ("$(?GH(B" . ";u")
    ("$(?GM(B" . ";uJ")
    ("$(?GL(B" . ";uU")
    ("$(?GK(B" . ";uh")
    ("$(?GJ(B" . ";uj")
    ("$(?G8(B" . ";y")
    ("$(?G=(B" . ";yJ")
    ("$(?G<(B" . ";yU")
    ("$(?G;(B" . ";yh")
    ("$(?G:(B" . ";yj")
    (?$(?27(B . "<!")
    (?$(?20(B . "<")
    (?$(?2`(B . "<6")
    (?$(?2d(B . "<6U")
    (?$(?2c(B . "<6h")
    (?$(?2b(B . "<6j")
    (?$(?2P(B . "<7")
    (?$(?2T(B . "<7U")
    (?$(?2S(B . "<7h")
    (?$(?2R(B . "<7j")
    (?$(?21(B . "<H")
    (?$(?2x(B . "<M")
    (?$(?26(B . "<N")
    (?$(?24(B . "<U")
    (?$(?2p(B . "<\"")
    (?$(?2h(B . "<^")
    (?$(?2l(B . "<^U")
    (?$(?2k(B . "<^h")
    (?$(?2j(B . "<^j")
    (?$(?2@(B . "<b")
    (?$(?2D(B . "<bU")
    (?$(?2C(B . "<bh")
    (?$(?2B(B . "<bj")
    (?$(?23(B . "<h")
    (?$(?22(B . "<j")
    (?$(?2X(B . "<n")
    (?$(?2\(B . "<nU")
    (?$(?2[(B . "<nh")
    (?$(?2Z(B . "<nj")
    (?$(?2H(B . "<u")
    (?$(?2L(B . "<uU")
    (?$(?2K(B . "<uh")
    (?$(?2J(B . "<uj")
    (?$(?28(B . "<y")
    (?$(?2<(B . "<yU")
    (?$(?2;(B . "<yh")
    (?$(?2:(B . "<yj")
    (?$(?*7(B . "=!")
    (?$(?*0(B . "=")
    (?$(?*`(B . "=6")
    (?$(?*d(B . "=6U")
    (?$(?*c(B . "=6h")
    (?$(?*b(B . "=6j")
    (?$(?*P(B . "=7")
    (?$(?*T(B . "=7U")
    (?$(?*S(B . "=7h")
    (?$(?*R(B . "=7j")
    (?$(?*1(B . "=H")
    (?$(?*x(B . "=M")
    (?$(?*6(B . "=N")
    (?$(?*4(B . "=U")
    (?$(?*p(B . "=\"")
    (?$(?*h(B . "=^")
    (?$(?*l(B . "=^U")
    (?$(?*k(B . "=^h")
    (?$(?*j(B . "=^j")
    (?$(?*@(B . "=b")
    (?$(?*D(B . "=bU")
    (?$(?*C(B . "=bh")
    (?$(?*B(B . "=bj")
    (?$(?*3(B . "=h")
    (?$(?*2(B . "=j")
    (?$(?*X(B . "=n")
    (?$(?*\(B . "=nU")
    (?$(?*[(B . "=nh")
    (?$(?*Z(B . "=nj")
    (?$(?*H(B . "=u")
    (?$(?*L(B . "=uU")
    (?$(?*K(B . "=uh")
    (?$(?*J(B . "=uj")
    (?$(?*8(B . "=y")
    (?$(?*<(B . "=yU")
    (?$(?*;(B . "=yh")
    (?$(?*:(B . "=yj")
    (?$(?L7(B . ">!")
    (?$(?L0(B . ">")
    (?$(?L`(B . ">6")
    (?$(?Le(B . ">6J")
    (?$(?Ld(B . ">6U")
    (?$(?Lc(B . ">6h")
    (?$(?Lb(B . ">6j")
    (?$(?LP(B . ">7")
    (?$(?LU(B . ">7J")
    (?$(?LT(B . ">7U")
    (?$(?LS(B . ">7h")
    (?$(?LR(B . ">7j")
    (?$(?L1(B . ">H")
    (?$(?L5(B . ">J")
    (?$(?Lx(B . ">M")
    (?$(?L6(B . ">N")
    (?$(?L4(B . ">U")
    (?$(?Lp(B . ">\"")
    (?$(?Lh(B . ">^")
    (?$(?Lm(B . ">^J")
    (?$(?Ll(B . ">^U")
    (?$(?Lk(B . ">^h")
    (?$(?Lj(B . ">^j")
    (?$(?L@(B . ">b")
    (?$(?LE(B . ">bJ")
    (?$(?LD(B . ">bU")
    (?$(?LC(B . ">bh")
    (?$(?LB(B . ">bj")
    (?$(?L3(B . ">h")
    (?$(?L2(B . ">j")
    (?$(?LX(B . ">n")
    (?$(?L](B . ">nJ")
    (?$(?L\(B . ">nU")
    (?$(?L[(B . ">nh")
    (?$(?LZ(B . ">nj")
    (?$(?LH(B . ">u")
    (?$(?LM(B . ">uJ")
    (?$(?LL(B . ">uU")
    (?$(?LK(B . ">uh")
    (?$(?LJ(B . ">uj")
    (?$(?L8(B . ">y")
    (?$(?L=(B . ">yJ")
    (?$(?L<(B . ">yU")
    (?$(?L;(B . ">yh")
    (?$(?L:(B . ">yj")
    (?$(?F0(B . "?")
    (?$(?q0(B . "@")
    (?$(?D0(B . "A")
    (?$(?)7(B . "C!")
    (?$(?)0(B . "C")
    (?$(?)`(B . "C6")
    (?$(?)c(B . "C6h")
    (?$(?)b(B . "C6j")
    (?$(?)P(B . "C7")
    (?$(?)S(B . "C7h")
    (?$(?)R(B . "C7j")
    (?$(?)1(B . "CH")
    (?$(?)x(B . "CM")
    (?$(?)6(B . "CN")
    (?$(?)p(B . "C\"")
    (?$(?)h(B . "C^")
    (?$(?)k(B . "C^h")
    (?$(?)j(B . "C^j")
    (?$(?)@(B . "Cb")
    (?$(?)C(B . "Cbh")
    (?$(?)B(B . "Cbj")
    (?$(?)3(B . "Ch")
    (?$(?)2(B . "Cj")
    (?$(?)X(B . "Cn")
    (?$(?)[(B . "Cnh")
    (?$(?)Z(B . "Cnj")
    (?$(?)H(B . "Cu")
    (?$(?)K(B . "Cuh")
    (?$(?)J(B . "Cuj")
    (?$(?)8(B . "Cy")
    (?$(?);(B . "Cyh")
    (?$(?):(B . "Cyj")
    (?$(?.0(B . "D")
    (?$(?.`(B . "D6")
    (?$(?.e(B . "D6J")
    (?$(?.d(B . "D6U")
    (?$(?.c(B . "D6h")
    (?$(?.b(B . "D6j")
    (?$(?.P(B . "D7")
    (?$(?.U(B . "D7J")
    (?$(?.T(B . "D7U")
    (?$(?.S(B . "D7h")
    (?$(?.R(B . "D7j")
    (?$(?.1(B . "DH")
    (?$(?.5(B . "DJ")
    (?$(?.6(B . "DN")
    (?$(?.4(B . "DU")
    (?$(?.h(B . "D^")
    (?$(?.m(B . "D^J")
    (?$(?.l(B . "D^U")
    (?$(?.k(B . "D^h")
    (?$(?.j(B . "D^j")
    (?$(?.@(B . "Db")
    (?$(?.E(B . "DbJ")
    (?$(?.D(B . "DbU")
    (?$(?.C(B . "Dbh")
    (?$(?.B(B . "Dbj")
    (?$(?.3(B . "Dh")
    (?$(?.2(B . "Dj")
    (?$(?.X(B . "Dn")
    (?$(?.](B . "DnJ")
    (?$(?.\(B . "DnU")
    (?$(?.[(B . "Dnh")
    (?$(?.Z(B . "Dnj")
    (?$(?.H(B . "Du")
    (?$(?.M(B . "DuJ")
    (?$(?.L(B . "DuU")
    (?$(?.K(B . "Duh")
    (?$(?.J(B . "Duj")
    (?$(?.8(B . "Dy")
    (?$(?.=(B . "DyJ")
    (?$(?.<(B . "DyU")
    (?$(?.;(B . "Dyh")
    (?$(?.:(B . "Dyj")
    (?$(?.7(B . "E!")
    (?$(?/7(B . "E!")
    (?$(?/0(B . "E")
    (?$(?/`(B . "E6")
    (?$(?/e(B . "E6J")
    (?$(?/d(B . "E6U")
    (?$(?/c(B . "E6h")
    (?$(?/b(B . "E6j")
    (?$(?/P(B . "E7")
    (?$(?/U(B . "E7J")
    (?$(?/T(B . "E7U")
    (?$(?/S(B . "E7h")
    (?$(?/R(B . "E7j")
    (?$(?/1(B . "EH")
    (?$(?/5(B . "EJ")
    (?$(?.x(B . "EM")
    (?$(?/x(B . "EM")
    (?$(?/6(B . "EN")
    (?$(?/4(B . "EU")
    (?$(?.p(B . "E\"")
    (?$(?/p(B . "E\"")
    (?$(?/h(B . "E^")
    (?$(?/m(B . "E^J")
    (?$(?/l(B . "E^U")
    (?$(?/k(B . "E^h")
    (?$(?/j(B . "E^j")
    (?$(?/@(B . "Eb")
    (?$(?/E(B . "EbJ")
    (?$(?/D(B . "EbU")
    (?$(?/C(B . "Ebh")
    (?$(?/B(B . "Ebj")
    (?$(?/3(B . "Eh")
    (?$(?/2(B . "Ej")
    (?$(?/X(B . "En")
    (?$(?/](B . "EnJ")
    (?$(?/\(B . "EnU")
    (?$(?/[(B . "Enh")
    (?$(?/Z(B . "Enj")
    (?$(?/H(B . "Eu")
    (?$(?/M(B . "EuJ")
    (?$(?/L(B . "EuU")
    (?$(?/K(B . "Euh")
    (?$(?/J(B . "Euj")
    (?$(?/8(B . "Ey")
    (?$(?/=(B . "EyJ")
    (?$(?/<(B . "EyU")
    (?$(?/;(B . "Eyh")
    (?$(?/:(B . "Eyj")
    (?$(?b0(B . "F")
    (?$(?,7(B . "G!")
    (?$(?,0(B . "G")
    (?$(?,`(B . "G6")
    (?$(?,d(B . "G6U")
    (?$(?,c(B . "G6h")
    (?$(?,b(B . "G6j")
    (?$(?,P(B . "G7")
    (?$(?,T(B . "G7U")
    (?$(?,S(B . "G7h")
    (?$(?,R(B . "G7j")
    (?$(?,1(B . "GH")
    (?$(?,x(B . "GM")
    (?$(?,6(B . "GN")
    (?$(?,4(B . "GU")
    (?$(?,p(B . "G\"")
    (?$(?,h(B . "G^")
    (?$(?,l(B . "G^U")
    (?$(?,k(B . "G^h")
    (?$(?,j(B . "G^j")
    (?$(?,@(B . "Gb")
    (?$(?,D(B . "GbU")
    (?$(?,C(B . "Gbh")
    (?$(?,B(B . "Gbj")
    (?$(?,3(B . "Gh")
    (?$(?,2(B . "Gj")
    (?$(?,X(B . "Gn")
    (?$(?,\(B . "GnU")
    (?$(?,[(B . "Gnh")
    (?$(?,Z(B . "Gnj")
    (?$(?,H(B . "Gu")
    (?$(?,L(B . "GuU")
    (?$(?,K(B . "Guh")
    (?$(?,J(B . "Guj")
    (?$(?,8(B . "Gy")
    (?$(?,<(B . "GyU")
    (?$(?,;(B . "Gyh")
    (?$(?,:(B . "Gyj")
    (?$(?g0(B . "H")
    (?$(?37(B . "I!")
    (?$(?30(B . "I")
    (?$(?3`(B . "I6")
    (?$(?3e(B . "I6J")
    (?$(?3d(B . "I6U")
    (?$(?3c(B . "I6h")
    (?$(?3b(B . "I6j")
    (?$(?3P(B . "I7")
    (?$(?3U(B . "I7J")
    (?$(?3T(B . "I7U")
    (?$(?3S(B . "I7h")
    (?$(?3R(B . "I7j")
    (?$(?31(B . "IH")
    (?$(?35(B . "IJ")
    (?$(?3x(B . "IM")
    (?$(?36(B . "IN")
    (?$(?34(B . "IU")
    (?$(?3p(B . "I\"")
    (?$(?3h(B . "I^")
    (?$(?3m(B . "I^J")
    (?$(?3l(B . "I^U")
    (?$(?3k(B . "I^h")
    (?$(?3j(B . "I^j")
    (?$(?3@(B . "Ib")
    (?$(?3E(B . "IbJ")
    (?$(?3D(B . "IbU")
    (?$(?3C(B . "Ibh")
    (?$(?3B(B . "Ibj")
    (?$(?33(B . "Ih")
    (?$(?32(B . "Ij")
    (?$(?3X(B . "In")
    (?$(?3](B . "InJ")
    (?$(?3\(B . "InU")
    (?$(?3[(B . "Inh")
    (?$(?3Z(B . "Inj")
    (?$(?3H(B . "Iu")
    (?$(?3M(B . "IuJ")
    (?$(?3L(B . "IuU")
    (?$(?3K(B . "Iuh")
    (?$(?3J(B . "Iuj")
    (?$(?38(B . "Iy")
    (?$(?3=(B . "IyJ")
    (?$(?3<(B . "IyU")
    (?$(?3;(B . "Iyh")
    (?$(?3:(B . "Iyj")
    (?$(?k0(B . "J")
    (?$(?I7(B . "K!")
    (?$(?I0(B . "K")
    (?$(?I`(B . "K6")
    (?$(?Ic(B . "K6h")
    (?$(?Ib(B . "K6j")
    (?$(?IP(B . "K7")
    (?$(?IS(B . "K7h")
    (?$(?IR(B . "K7j")
    (?$(?I1(B . "KH")
    (?$(?Ix(B . "KM")
    (?$(?I6(B . "KN")
    (?$(?Ip(B . "K\"")
    (?$(?Ih(B . "K^")
    (?$(?Ik(B . "K^h")
    (?$(?Ij(B . "K^j")
    (?$(?I@(B . "Kb")
    (?$(?IC(B . "Kbh")
    (?$(?IB(B . "Kbj")
    (?$(?I3(B . "Kh")
    (?$(?I2(B . "Kj")
    (?$(?IX(B . "Kn")
    (?$(?I[(B . "Knh")
    (?$(?IZ(B . "Knj")
    (?$(?IH(B . "Ku")
    (?$(?IK(B . "Kuh")
    (?$(?IJ(B . "Kuj")
    (?$(?I8(B . "Ky")
    (?$(?I;(B . "Kyh")
    (?$(?I:(B . "Kyj")
    (?$(?H7(B . "L!")
    (?$(?H0(B . "L")
    (?$(?H`(B . "L6")
    (?$(?Hc(B . "L6h")
    (?$(?Hb(B . "L6j")
    (?$(?HP(B . "L7")
    (?$(?HS(B . "L7h")
    (?$(?HR(B . "L7j")
    (?$(?H1(B . "LH")
    (?$(?Hx(B . "LM")
    (?$(?H6(B . "LN")
    (?$(?Hp(B . "L\"")
    (?$(?Hh(B . "L^")
    (?$(?Hk(B . "L^h")
    (?$(?Hj(B . "L^j")
    (?$(?H@(B . "Lb")
    (?$(?HC(B . "Lbh")
    (?$(?HB(B . "Lbj")
    (?$(?H3(B . "Lh")
    (?$(?H2(B . "Lj")
    (?$(?HX(B . "Ln")
    (?$(?H[(B . "Lnh")
    (?$(?HZ(B . "Lnj")
    (?$(?HH(B . "Lu")
    (?$(?HK(B . "Luh")
    (?$(?HJ(B . "Luj")
    (?$(?H8(B . "Ly")
    (?$(?H;(B . "Lyh")
    (?$(?H:(B . "Lyj")
    (?$(?n0(B . "M")
    (?$(?l0(B . "N")
    (?$(?O0(B . "O")
    (?$(?-7(B . "P!")
    (?$(?-0(B . "P")
    (?$(?-`(B . "P6")
    (?$(?-e(B . "P6J")
    (?$(?-d(B . "P6U")
    (?$(?-c(B . "P6h")
    (?$(?-b(B . "P6j")
    (?$(?-P(B . "P7")
    (?$(?-U(B . "P7J")
    (?$(?-T(B . "P7U")
    (?$(?-S(B . "P7h")
    (?$(?-R(B . "P7j")
    (?$(?-1(B . "PH")
    (?$(?-5(B . "PJ")
    (?$(?-x(B . "PM")
    (?$(?-6(B . "PN")
    (?$(?-4(B . "PU")
    (?$(?-p(B . "P\"")
    (?$(?-h(B . "P^")
    (?$(?-m(B . "P^J")
    (?$(?-l(B . "P^U")
    (?$(?-k(B . "P^h")
    (?$(?-j(B . "P^j")
    (?$(?-@(B . "Pb")
    (?$(?-E(B . "PbJ")
    (?$(?-D(B . "PbU")
    (?$(?-C(B . "Pbh")
    (?$(?-B(B . "Pbj")
    (?$(?-3(B . "Ph")
    (?$(?-2(B . "Pj")
    (?$(?-X(B . "Pn")
    (?$(?-](B . "PnJ")
    (?$(?-\(B . "PnU")
    (?$(?-[(B . "Pnh")
    (?$(?-Z(B . "Pnj")
    (?$(?-H(B . "Pu")
    (?$(?-M(B . "PuJ")
    (?$(?-L(B . "PuU")
    (?$(?-K(B . "Puh")
    (?$(?-J(B . "Puj")
    (?$(?-8(B . "Py")
    (?$(?-=(B . "PyJ")
    (?$(?-<(B . "PyU")
    (?$(?-;(B . "Pyh")
    (?$(?-:(B . "Pyj")
    (?$(?p0(B . "Q")
    (?$(?17(B . "R!")
    (?$(?10(B . "R")
    (?$(?1`(B . "R6")
    (?$(?1d(B . "R6U")
    (?$(?1c(B . "R6h")
    (?$(?1b(B . "R6j")
    (?$(?1P(B . "R7")
    (?$(?1T(B . "R7U")
    (?$(?1S(B . "R7h")
    (?$(?1R(B . "R7j")
    (?$(?11(B . "RH")
    (?$(?1x(B . "RM")
    (?$(?16(B . "RN")
    (?$(?14(B . "RU")
    (?$(?1p(B . "R\"")
    (?$(?1h(B . "R^")
    (?$(?1l(B . "R^U")
    (?$(?1k(B . "R^h")
    (?$(?1j(B . "R^j")
    (?$(?1@(B . "Rb")
    (?$(?1D(B . "RbU")
    (?$(?1C(B . "Rbh")
    (?$(?1B(B . "Rbj")
    (?$(?13(B . "Rh")
    (?$(?12(B . "Rj")
    (?$(?1X(B . "Rn")
    (?$(?1\(B . "RnU")
    (?$(?1[(B . "Rnh")
    (?$(?1Z(B . "Rnj")
    (?$(?1H(B . "Ru")
    (?$(?1L(B . "RuU")
    (?$(?1K(B . "Ruh")
    (?$(?1J(B . "Ruj")
    (?$(?18(B . "Ry")
    (?$(?1<(B . "RyU")
    (?$(?1;(B . "Ryh")
    (?$(?1:(B . "Ryj")
    (?$(?&7(B . "S!")
    (?$(?&0(B . "S")
    (?$(?&`(B . "S6")
    (?$(?&d(B . "S6U")
    (?$(?&c(B . "S6h")
    (?$(?&b(B . "S6j")
    (?$(?&P(B . "S7")
    (?$(?&T(B . "S7U")
    (?$(?&S(B . "S7h")
    (?$(?&R(B . "S7j")
    (?$(?&1(B . "SH")
    (?$(?&x(B . "SM")
    (?$(?&6(B . "SN")
    (?$(?&4(B . "SU")
    (?$(?&p(B . "S\"")
    (?$(?&h(B . "S^")
    (?$(?&l(B . "S^U")
    (?$(?&k(B . "S^h")
    (?$(?&j(B . "S^j")
    (?$(?&@(B . "Sb")
    (?$(?&D(B . "SbU")
    (?$(?&C(B . "Sbh")
    (?$(?&B(B . "Sbj")
    (?$(?&3(B . "Sh")
    (?$(?&2(B . "Sj")
    (?$(?&X(B . "Sn")
    (?$(?&\(B . "SnU")
    (?$(?&[(B . "Snh")
    (?$(?&Z(B . "Snj")
    (?$(?&H(B . "Su")
    (?$(?&L(B . "SuU")
    (?$(?&K(B . "Suh")
    (?$(?&J(B . "Suj")
    (?$(?&8(B . "Sy")
    (?$(?&<(B . "SyU")
    (?$(?&;(B . "Syh")
    (?$(?&:(B . "Syj")
    (?$(?87(B . "T!")
    (?$(?80(B . "T")
    (?$(?8`(B . "T6")
    (?$(?8f(B . "T6N")
    (?$(?8d(B . "T6U")
    (?$(?8c(B . "T6h")
    (?$(?8b(B . "T6j")
    (?$(?8P(B . "T7")
    (?$(?8T(B . "T7U")
    (?$(?8S(B . "T7h")
    (?$(?8R(B . "T7j")
    (?$(?81(B . "TH")
    (?$(?8x(B . "TM")
    (?$(?86(B . "TN")
    (?$(?84(B . "TU")
    (?$(?8p(B . "T\"")
    (?$(?8h(B . "T^")
    (?$(?8l(B . "T^U")
    (?$(?8k(B . "T^h")
    (?$(?8j(B . "T^j")
    (?$(?8@(B . "Tb")
    (?$(?8F(B . "TbN")
    (?$(?8D(B . "TbU")
    (?$(?8C(B . "Tbh")
    (?$(?8B(B . "Tbj")
    (?$(?83(B . "Th")
    (?$(?82(B . "Tj")
    (?$(?8X(B . "Tn")
    (?$(?8\(B . "TnU")
    (?$(?8[(B . "Tnh")
    (?$(?8Z(B . "Tnj")
    (?$(?8H(B . "Tu")
    (?$(?8L(B . "TuU")
    (?$(?8K(B . "Tuh")
    (?$(?8J(B . "Tuj")
    (?$(?88(B . "Ty")
    (?$(?8<(B . "TyU")
    (?$(?8;(B . "Tyh")
    (?$(?8:(B . "Tyj")
    (?$(?j0(B . "U")
    (?$(?N7(B . "V!")
    (?$(?N0(B . "V")
    (?$(?N`(B . "V6")
    (?$(?Nd(B . "V6U")
    (?$(?Nc(B . "V6h")
    (?$(?Nb(B . "V6j")
    (?$(?NP(B . "V7")
    (?$(?NT(B . "V7U")
    (?$(?NS(B . "V7h")
    (?$(?NR(B . "V7j")
    (?$(?N1(B . "VH")
    (?$(?Nx(B . "VM")
    (?$(?N6(B . "VN")
    (?$(?N4(B . "VU")
    (?$(?Np(B . "V\"")
    (?$(?Nh(B . "V^")
    (?$(?Nl(B . "V^U")
    (?$(?Nk(B . "V^h")
    (?$(?Nj(B . "V^j")
    (?$(?N@(B . "Vb")
    (?$(?ND(B . "VbU")
    (?$(?NC(B . "Vbh")
    (?$(?NB(B . "Vbj")
    (?$(?N3(B . "Vh")
    (?$(?N2(B . "Vj")
    (?$(?NX(B . "Vn")
    (?$(?N\(B . "VnU")
    (?$(?N[(B . "Vnh")
    (?$(?NZ(B . "Vnj")
    (?$(?NH(B . "Vu")
    (?$(?NL(B . "VuU")
    (?$(?NK(B . "Vuh")
    (?$(?NJ(B . "Vuj")
    (?$(?N8(B . "Vy")
    (?$(?N<(B . "VyU")
    (?$(?N;(B . "Vyh")
    (?$(?N:(B . "Vyj")
    (?$(?:7(B . "[!")
    (?$(?:0(B . "[")
    (?$(?:`(B . "[6")
    (?$(?:e(B . "[6J")
    (?$(?:d(B . "[6U")
    (?$(?:c(B . "[6h")
    (?$(?:b(B . "[6j")
    (?$(?:P(B . "[7")
    (?$(?:U(B . "[7J")
    (?$(?:T(B . "[7U")
    (?$(?:S(B . "[7h")
    (?$(?:R(B . "[7j")
    (?$(?:1(B . "[H")
    (?$(?:5(B . "[J")
    (?$(?:x(B . "[M")
    (?$(?:6(B . "[N")
    (?$(?:4(B . "[U")
    (?$(?:p(B . "[\"")
    (?$(?:h(B . "[^")
    (?$(?:m(B . "[^J")
    (?$(?:l(B . "[^U")
    (?$(?:k(B . "[^h")
    (?$(?:j(B . "[^j")
    (?$(?:@(B . "[b")
    (?$(?:E(B . "[bJ")
    (?$(?:D(B . "[bU")
    (?$(?:C(B . "[bh")
    (?$(?:B(B . "[bj")
    (?$(?:3(B . "[h")
    (?$(?:2(B . "[j")
    (?$(?:X(B . "[n")
    (?$(?:](B . "[nJ")
    (?$(?:\(B . "[nU")
    (?$(?:[(B . "[nh")
    (?$(?:Z(B . "[nj")
    (?$(?:H(B . "[u")
    (?$(?:M(B . "[uJ")
    (?$(?:L(B . "[uU")
    (?$(?:K(B . "[uh")
    (?$(?:J(B . "[uj")
    (?$(?:8(B . "[y")
    (?$(?:=(B . "[yJ")
    (?$(?:<(B . "[yU")
    (?$(?:;(B . "[yh")
    (?$(?::(B . "[yj")
    (?$(?Z0(B . "\"")
    (?$(?E7(B . "]!")
    (?$(?E0(B . "]")
    (?$(?E`(B . "]6")
    (?$(?Ee(B . "]6J")
    (?$(?Ed(B . "]6U")
    (?$(?Ec(B . "]6h")
    (?$(?Eb(B . "]6j")
    (?$(?EP(B . "]7")
    (?$(?EU(B . "]7J")
    (?$(?ET(B . "]7U")
    (?$(?ES(B . "]7h")
    (?$(?ER(B . "]7j")
    (?$(?E1(B . "]H")
    (?$(?E5(B . "]J")
    (?$(?Ex(B . "]M")
    (?$(?E6(B . "]N")
    (?$(?E4(B . "]U")
    (?$(?Ep(B . "]\"")
    (?$(?Eh(B . "]^")
    (?$(?Em(B . "]^J")
    (?$(?El(B . "]^U")
    (?$(?Ek(B . "]^h")
    (?$(?Ej(B . "]^j")
    (?$(?E@(B . "]b")
    (?$(?EE(B . "]bJ")
    (?$(?ED(B . "]bU")
    (?$(?EC(B . "]bh")
    (?$(?EB(B . "]bj")
    (?$(?E3(B . "]h")
    (?$(?E2(B . "]j")
    (?$(?EX(B . "]n")
    (?$(?E](B . "]nJ")
    (?$(?E\(B . "]nU")
    (?$(?E[(B . "]nh")
    (?$(?EZ(B . "]nj")
    (?$(?EH(B . "]u")
    (?$(?EM(B . "]uJ")
    (?$(?EL(B . "]uU")
    (?$(?EK(B . "]uh")
    (?$(?EJ(B . "]uj")
    (?$(?E8(B . "]y")
    (?$(?E=(B . "]yJ")
    (?$(?E<(B . "]yU")
    (?$(?E;(B . "]yh")
    (?$(?E:(B . "]yj")
    (?$(?Y0(B . "^")
    (?$(?x0(B . "_")
    (?$(?#7(B . "`!")
    (?$(?#0(B . "`")
    (?$(?#`(B . "`6")
    (?$(?#c(B . "`6h")
    (?$(?#b(B . "`6j")
    (?$(?#P(B . "`7")
    (?$(?#S(B . "`7h")
    (?$(?#R(B . "`7j")
    (?$(?#1(B . "`H")
    (?$(?#x(B . "`M")
    (?$(?#6(B . "`N")
    (?$(?#p(B . "`\"")
    (?$(?#h(B . "`^")
    (?$(?#k(B . "`^h")
    (?$(?#j(B . "`^j")
    (?$(?#@(B . "`b")
    (?$(?#C(B . "`bh")
    (?$(?#B(B . "`bj")
    (?$(?#3(B . "`h")
    (?$(?#2(B . "`j")
    (?$(?#X(B . "`n")
    (?$(?#[(B . "`nh")
    (?$(?#Z(B . "`nj")
    (?$(?#H(B . "`u")
    (?$(?#K(B . "`uh")
    (?$(?#J(B . "`uj")
    (?$(?#8(B . "`y")
    (?$(?#;(B . "`yh")
    (?$(?#:(B . "`yj")
    (?$(??7(B . "a!")
    (?$(??0(B . "a")
    (?$(??`(B . "a6")
    (?$(??d(B . "a6U")
    (?$(??c(B . "a6h")
    (?$(??b(B . "a6j")
    (?$(??P(B . "a7")
    (?$(??T(B . "a7U")
    (?$(??S(B . "a7h")
    (?$(??R(B . "a7j")
    (?$(??1(B . "aH")
    (?$(??x(B . "aM")
    (?$(??6(B . "aN")
    (?$(??4(B . "aU")
    (?$(??p(B . "a\"")
    (?$(??h(B . "a^")
    (?$(??l(B . "a^U")
    (?$(??k(B . "a^h")
    (?$(??j(B . "a^j")
    (?$(??@(B . "ab")
    (?$(??D(B . "abU")
    (?$(??C(B . "abh")
    (?$(??B(B . "abj")
    (?$(??3(B . "ah")
    (?$(??2(B . "aj")
    (?$(??X(B . "an")
    (?$(??\(B . "anU")
    (?$(??[(B . "anh")
    (?$(??Z(B . "anj")
    (?$(??H(B . "au")
    (?$(??L(B . "auU")
    (?$(??K(B . "auh")
    (?$(??J(B . "auj")
    (?$(??8(B . "ay")
    (?$(??<(B . "ayU")
    (?$(??;(B . "ayh")
    (?$(??:(B . "ayj")
    (?$(?T0(B . "b")
    (?$(?a0(B . "c")
    (?$(?!7(B . "d!")
    (?$(?!0(B . "d")
    (?$(?!`(B . "d6")
    (?$(?!e(B . "d6J")
    (?$(?!d(B . "d6U")
    (?$(?!c(B . "d6h")
    (?$(?!b(B . "d6j")
    (?$(?!P(B . "d7")
    (?$(?!U(B . "d7J")
    (?$(?!T(B . "d7U")
    (?$(?!S(B . "d7h")
    (?$(?!R(B . "d7j")
    (?$(?!1(B . "dH")
    (?$(?!5(B . "dJ")
    (?$(?!x(B . "dM")
    (?$(?!6(B . "dN")
    (?$(?!4(B . "dU")
    (?$(?!p(B . "d\"")
    (?$(?!h(B . "d^")
    (?$(?!m(B . "d^J")
    (?$(?!l(B . "d^U")
    (?$(?!k(B . "d^h")
    (?$(?!j(B . "d^j")
    (?$(?!@(B . "db")
    (?$(?!E(B . "dbJ")
    (?$(?!D(B . "dbU")
    (?$(?!C(B . "dbh")
    (?$(?!B(B . "dbj")
    (?$(?!3(B . "dh")
    (?$(?!2(B . "dj")
    (?$(?!X(B . "dn")
    (?$(?!](B . "dnJ")
    (?$(?!\(B . "dnU")
    (?$(?![(B . "dnh")
    (?$(?!Z(B . "dnj")
    (?$(?!H(B . "du")
    (?$(?!M(B . "duJ")
    (?$(?!L(B . "duU")
    (?$(?!K(B . "duh")
    (?$(?!J(B . "duj")
    (?$(?!8(B . "dy")
    (?$(?!=(B . "dyJ")
    (?$(?!<(B . "dyU")
    (?$(?!;(B . "dyh")
    (?$(?!:(B . "dyj")
    (?$(?S0(B . "e")
    (?$(?47(B . "f!")
    (?$(?40(B . "f")
    (?$(?4`(B . "f6")
    (?$(?4e(B . "f6J")
    (?$(?4d(B . "f6U")
    (?$(?4c(B . "f6h")
    (?$(?4b(B . "f6j")
    (?$(?4P(B . "f7")
    (?$(?4U(B . "f7J")
    (?$(?4T(B . "f7U")
    (?$(?4S(B . "f7h")
    (?$(?4R(B . "f7j")
    (?$(?41(B . "fH")
    (?$(?45(B . "fJ")
    (?$(?4x(B . "fM")
    (?$(?46(B . "fN")
    (?$(?44(B . "fU")
    (?$(?4p(B . "f\"")
    (?$(?4h(B . "f^")
    (?$(?4m(B . "f^J")
    (?$(?4l(B . "f^U")
    (?$(?4k(B . "f^h")
    (?$(?4j(B . "f^j")
    (?$(?4@(B . "fb")
    (?$(?4E(B . "fbJ")
    (?$(?4F(B . "fbN")
    (?$(?4D(B . "fbU")
    (?$(?4C(B . "fbh")
    (?$(?4B(B . "fbj")
    (?$(?43(B . "fh")
    (?$(?42(B . "fj")
    (?$(?4X(B . "fn")
    (?$(?4](B . "fnJ")
    (?$(?4\(B . "fnU")
    (?$(?4[(B . "fnh")
    (?$(?4Z(B . "fnj")
    (?$(?4H(B . "fu")
    (?$(?4M(B . "fuJ")
    (?$(?4L(B . "fuU")
    (?$(?4K(B . "fuh")
    (?$(?4J(B . "fuj")
    (?$(?48(B . "fy")
    (?$(?4=(B . "fyJ")
    (?$(?4<(B . "fyU")
    (?$(?4;(B . "fyh")
    (?$(?4:(B . "fyj")
    (?$(?`0(B . "g")
    (?$(?i0(B . "h")
    (?$(?C7(B . "i!")
    (?$(?C0(B . "i")
    (?$(?C`(B . "i6")
    (?$(?Ce(B . "i6J")
    (?$(?Cd(B . "i6U")
    (?$(?Cc(B . "i6h")
    (?$(?Cb(B . "i6j")
    (?$(?CP(B . "i7")
    (?$(?CU(B . "i7J")
    (?$(?CT(B . "i7U")
    (?$(?CS(B . "i7h")
    (?$(?CR(B . "i7j")
    (?$(?C1(B . "iH")
    (?$(?C5(B . "iJ")
    (?$(?Cx(B . "iM")
    (?$(?C6(B . "iN")
    (?$(?C4(B . "iU")
    (?$(?Cp(B . "i\"")
    (?$(?Ch(B . "i^")
    (?$(?Cm(B . "i^J")
    (?$(?Cl(B . "i^U")
    (?$(?Ck(B . "i^h")
    (?$(?Cj(B . "i^j")
    (?$(?C@(B . "ib")
    (?$(?CE(B . "ibJ")
    (?$(?CD(B . "ibU")
    (?$(?CC(B . "ibh")
    (?$(?CB(B . "ibj")
    (?$(?C3(B . "ih")
    (?$(?C2(B . "ij")
    (?$(?CX(B . "in")
    (?$(?C](B . "inJ")
    (?$(?C\(B . "inU")
    (?$(?C[(B . "inh")
    (?$(?CZ(B . "inj")
    (?$(?CH(B . "iu")
    (?$(?CM(B . "iuJ")
    (?$(?CL(B . "iuU")
    (?$(?CK(B . "iuh")
    (?$(?CJ(B . "iuj")
    (?$(?C8(B . "iy")
    (?$(?C=(B . "iyJ")
    (?$(?C<(B . "iyU")
    (?$(?C;(B . "iyh")
    (?$(?C:(B . "iyj")
    (?$(?h0(B . "j")
    (?$(?R0(B . "k")
    (?$(?J7(B . "l!")
    (?$(?J0(B . "l")
    (?$(?J`(B . "l6")
    (?$(?Jc(B . "l6h")
    (?$(?Jb(B . "l6j")
    (?$(?JP(B . "l7")
    (?$(?JS(B . "l7h")
    (?$(?JR(B . "l7j")
    (?$(?J1(B . "lH")
    (?$(?Jx(B . "lM")
    (?$(?J6(B . "lN")
    (?$(?Jp(B . "l\"")
    (?$(?Jh(B . "l^")
    (?$(?Jk(B . "l^h")
    (?$(?Jj(B . "l^j")
    (?$(?J@(B . "lb")
    (?$(?JC(B . "lbh")
    (?$(?JB(B . "lbj")
    (?$(?J3(B . "lh")
    (?$(?J2(B . "lj")
    (?$(?JX(B . "ln")
    (?$(?J[(B . "lnh")
    (?$(?JZ(B . "lnj")
    (?$(?JH(B . "lu")
    (?$(?JK(B . "luh")
    (?$(?JJ(B . "luj")
    (?$(?J8(B . "ly")
    (?$(?J;(B . "lyh")
    (?$(?J:(B . "lyj")
    (?$(?77(B . "m!")
    (?$(?70(B . "m")
    (?$(?7`(B . "m6")
    (?$(?7f(B . "m6N")
    (?$(?7d(B . "m6U")
    (?$(?7c(B . "m6h")
    (?$(?7b(B . "m6j")
    (?$(?7P(B . "m7")
    (?$(?7T(B . "m7U")
    (?$(?7S(B . "m7h")
    (?$(?7R(B . "m7j")
    (?$(?71(B . "mH")
    (?$(?7x(B . "mM")
    (?$(?76(B . "mN")
    (?$(?74(B . "mU")
    (?$(?7p(B . "m\"")
    (?$(?7h(B . "m^")
    (?$(?7l(B . "m^U")
    (?$(?7k(B . "m^h")
    (?$(?7j(B . "m^j")
    (?$(?7@(B . "mb")
    (?$(?7D(B . "mbU")
    (?$(?7C(B . "mbh")
    (?$(?7B(B . "mbj")
    (?$(?73(B . "mh")
    (?$(?72(B . "mj")
    (?$(?7X(B . "mn")
    (?$(?7\(B . "mnU")
    (?$(?7[(B . "mnh")
    (?$(?7Z(B . "mnj")
    (?$(?7H(B . "mu")
    (?$(?7L(B . "muU")
    (?$(?7K(B . "muh")
    (?$(?7J(B . "muj")
    (?$(?78(B . "my")
    (?$(?7<(B . "myU")
    (?$(?7;(B . "myh")
    (?$(?7:(B . "myj")
    (?$(?W0(B . "n")
    (?$(?97(B . "o!")
    (?$(?90(B . "o")
    (?$(?9`(B . "o6")
    (?$(?9e(B . "o6J")
    (?$(?9d(B . "o6U")
    (?$(?9c(B . "o6h")
    (?$(?9b(B . "o6j")
    (?$(?9P(B . "o7")
    (?$(?9U(B . "o7J")
    (?$(?9T(B . "o7U")
    (?$(?9S(B . "o7h")
    (?$(?9R(B . "o7j")
    (?$(?91(B . "oH")
    (?$(?95(B . "oJ")
    (?$(?9x(B . "oM")
    (?$(?96(B . "oN")
    (?$(?94(B . "oU")
    (?$(?9p(B . "o\"")
    (?$(?9h(B . "o^")
    (?$(?9m(B . "o^J")
    (?$(?9l(B . "o^U")
    (?$(?9k(B . "o^h")
    (?$(?9j(B . "o^j")
    (?$(?9@(B . "ob")
    (?$(?9E(B . "obJ")
    (?$(?9D(B . "obU")
    (?$(?9C(B . "obh")
    (?$(?9B(B . "obj")
    (?$(?93(B . "oh")
    (?$(?92(B . "oj")
    (?$(?9X(B . "on")
    (?$(?9](B . "onJ")
    (?$(?9\(B . "onU")
    (?$(?9[(B . "onh")
    (?$(?9Z(B . "onj")
    (?$(?9H(B . "ou")
    (?$(?9M(B . "ouJ")
    (?$(?9L(B . "ouU")
    (?$(?9K(B . "ouh")
    (?$(?9J(B . "ouj")
    (?$(?98(B . "oy")
    (?$(?9=(B . "oyJ")
    (?$(?9<(B . "oyU")
    (?$(?9;(B . "oyh")
    (?$(?9:(B . "oyj")
    (?$(?B7(B . "p!")
    (?$(?B0(B . "p")
    (?$(?B`(B . "p6")
    (?$(?Be(B . "p6J")
    (?$(?Bd(B . "p6U")
    (?$(?Bc(B . "p6h")
    (?$(?Bb(B . "p6j")
    (?$(?BP(B . "p7")
    (?$(?BU(B . "p7J")
    (?$(?BT(B . "p7U")
    (?$(?BS(B . "p7h")
    (?$(?BR(B . "p7j")
    (?$(?B1(B . "pH")
    (?$(?B5(B . "pJ")
    (?$(?Bx(B . "pM")
    (?$(?B6(B . "pN")
    (?$(?B4(B . "pU")
    (?$(?Bp(B . "p\"")
    (?$(?Bh(B . "p^")
    (?$(?Bm(B . "p^J")
    (?$(?Bl(B . "p^U")
    (?$(?Bk(B . "p^h")
    (?$(?Bj(B . "p^j")
    (?$(?B@(B . "pb")
    (?$(?BE(B . "pbJ")
    (?$(?BD(B . "pbU")
    (?$(?BC(B . "pbh")
    (?$(?BB(B . "pbj")
    (?$(?B3(B . "ph")
    (?$(?B2(B . "pj")
    (?$(?BX(B . "pn")
    (?$(?B](B . "pnJ")
    (?$(?B\(B . "pnU")
    (?$(?B[(B . "pnh")
    (?$(?BZ(B . "pnj")
    (?$(?BH(B . "pu")
    (?$(?BM(B . "puJ")
    (?$(?BL(B . "puU")
    (?$(?BK(B . "puh")
    (?$(?BJ(B . "puj")
    (?$(?B8(B . "py")
    (?$(?B=(B . "pyJ")
    (?$(?B<(B . "pyU")
    (?$(?B;(B . "pyh")
    (?$(?B:(B . "pyj")
    (?$(?f0(B . "q")
    (?$(?>7(B . "r!")
    (?$(?>0(B . "r")
    (?$(?>`(B . "r6")
    (?$(?>d(B . "r6U")
    (?$(?>c(B . "r6h")
    (?$(?>b(B . "r6j")
    (?$(?>P(B . "r7")
    (?$(?>T(B . "r7U")
    (?$(?>S(B . "r7h")
    (?$(?>R(B . "r7j")
    (?$(?>1(B . "rH")
    (?$(?>x(B . "rM")
    (?$(?>6(B . "rN")
    (?$(?>4(B . "rU")
    (?$(?>p(B . "r\"")
    (?$(?>h(B . "r^")
    (?$(?>l(B . "r^U")
    (?$(?>k(B . "r^h")
    (?$(?>j(B . "r^j")
    (?$(?>@(B . "rb")
    (?$(?>D(B . "rbU")
    (?$(?>C(B . "rbh")
    (?$(?>B(B . "rbj")
    (?$(?>3(B . "rh")
    (?$(?>2(B . "rj")
    (?$(?>X(B . "rn")
    (?$(?>\(B . "rnU")
    (?$(?>[(B . "rnh")
    (?$(?>Z(B . "rnj")
    (?$(?>H(B . "ru")
    (?$(?>L(B . "ruU")
    (?$(?>K(B . "ruh")
    (?$(?>J(B . "ruj")
    (?$(?>8(B . "ry")
    (?$(?><(B . "ryU")
    (?$(?>;(B . "ryh")
    (?$(?>:(B . "ryj")
    (?$(?K7(B . "s!")
    (?$(?K0(B . "s")
    (?$(?K`(B . "s6")
    (?$(?Kc(B . "s6h")
    (?$(?Kb(B . "s6j")
    (?$(?KP(B . "s7")
    (?$(?KS(B . "s7h")
    (?$(?KR(B . "s7j")
    (?$(?K1(B . "sH")
    (?$(?Kx(B . "sM")
    (?$(?K6(B . "sN")
    (?$(?Kp(B . "s\"")
    (?$(?Kh(B . "s^")
    (?$(?Kk(B . "s^h")
    (?$(?Kj(B . "s^j")
    (?$(?K@(B . "sb")
    (?$(?KC(B . "sbh")
    (?$(?KB(B . "sbj")
    (?$(?K3(B . "sh")
    (?$(?K2(B . "sj")
    (?$(?KX(B . "sn")
    (?$(?K[(B . "snh")
    (?$(?KZ(B . "snj")
    (?$(?KH(B . "su")
    (?$(?KK(B . "suh")
    (?$(?KJ(B . "suj")
    (?$(?K8(B . "sy")
    (?$(?K;(B . "syh")
    (?$(?K:(B . "syj")
    (?$(?P0(B . "t")
    (?$(?U0(B . "u")
    (?$(?M7(B . "v!")
    (?$(?M0(B . "v")
    (?$(?M`(B . "v6")
    (?$(?Me(B . "v6J")
    (?$(?Md(B . "v6U")
    (?$(?Mc(B . "v6h")
    (?$(?Mb(B . "v6j")
    (?$(?MP(B . "v7")
    (?$(?MU(B . "v7J")
    (?$(?MT(B . "v7U")
    (?$(?MS(B . "v7h")
    (?$(?MR(B . "v7j")
    (?$(?M1(B . "vH")
    (?$(?M5(B . "vJ")
    (?$(?Mx(B . "vM")
    (?$(?M6(B . "vN")
    (?$(?M4(B . "vU")
    (?$(?Mp(B . "v\"")
    (?$(?Mh(B . "v^")
    (?$(?Mm(B . "v^J")
    (?$(?Ml(B . "v^U")
    (?$(?Mk(B . "v^h")
    (?$(?Mj(B . "v^j")
    (?$(?M@(B . "vb")
    (?$(?ME(B . "vbJ")
    (?$(?MD(B . "vbU")
    (?$(?MC(B . "vbh")
    (?$(?MB(B . "vbj")
    (?$(?M3(B . "vh")
    (?$(?M2(B . "vj")
    (?$(?MX(B . "vn")
    (?$(?M](B . "vnJ")
    (?$(?M\(B . "vnU")
    (?$(?M[(B . "vnh")
    (?$(?MZ(B . "vnj")
    (?$(?MH(B . "vu")
    (?$(?MM(B . "vuJ")
    (?$(?ML(B . "vuU")
    (?$(?MK(B . "vuh")
    (?$(?MJ(B . "vuj")
    (?$(?M8(B . "vy")
    (?$(?M=(B . "vyJ")
    (?$(?M<(B . "vyU")
    (?$(?M;(B . "vyh")
    (?$(?M:(B . "vyj")
    (?$(?d0(B . "w")
    (?$(?;7(B . "x!")
    (?$(?;0(B . "x")
    (?$(?;`(B . "x6")
    (?$(?;e(B . "x6J")
    (?$(?;d(B . "x6U")
    (?$(?;c(B . "x6h")
    (?$(?;b(B . "x6j")
    (?$(?;P(B . "x7")
    (?$(?;U(B . "x7J")
    (?$(?;T(B . "x7U")
    (?$(?;S(B . "x7h")
    (?$(?;R(B . "x7j")
    (?$(?;1(B . "xH")
    (?$(?;5(B . "xJ")
    (?$(?;x(B . "xM")
    (?$(?;6(B . "xN")
    (?$(?;4(B . "xU")
    (?$(?;p(B . "x\"")
    (?$(?;h(B . "x^")
    (?$(?;m(B . "x^J")
    (?$(?;l(B . "x^U")
    (?$(?;k(B . "x^h")
    (?$(?;j(B . "x^j")
    (?$(?;@(B . "xb")
    (?$(?;E(B . "xbJ")
    (?$(?;D(B . "xbU")
    (?$(?;C(B . "xbh")
    (?$(?;B(B . "xbj")
    (?$(?;3(B . "xh")
    (?$(?;2(B . "xj")
    (?$(?;X(B . "xn")
    (?$(?;](B . "xnJ")
    (?$(?;\(B . "xnU")
    (?$(?;[(B . "xnh")
    (?$(?;Z(B . "xnj")
    (?$(?;H(B . "xu")
    (?$(?;M(B . "xuJ")
    (?$(?;L(B . "xuU")
    (?$(?;K(B . "xuh")
    (?$(?;J(B . "xuj")
    (?$(?;8(B . "xy")
    (?$(?;=(B . "xyJ")
    (?$(?;<(B . "xyU")
    (?$(?;;(B . "xyh")
    (?$(?;:(B . "xyj")
    (?$(?Q0(B . "y")
    (?$(?<7(B . "z!")
    (?$(?<0(B . "z")
    (?$(?<`(B . "z6")
    (?$(?<c(B . "z6h")
    (?$(?<b(B . "z6j")
    (?$(?<P(B . "z7")
    (?$(?<S(B . "z7h")
    (?$(?<R(B . "z7j")
    (?$(?<1(B . "zH")
    (?$(?<x(B . "zM")
    (?$(?<6(B . "zN")
    (?$(?<p(B . "z\"")
    (?$(?<h(B . "z^")
    (?$(?<k(B . "z^h")
    (?$(?<j(B . "z^j")
    (?$(?<@(B . "zb")
    (?$(?<C(B . "zbh")
    (?$(?<B(B . "zbj")
    (?$(?<3(B . "zh")
    (?$(?<2(B . "zj")
    (?$(?<X(B . "zn")
    (?$(?<[(B . "znh")
    (?$(?<Z(B . "znj")
    (?$(?<H(B . "zu")
    (?$(?<K(B . "zuh")
    (?$(?<J(B . "zuj")
    (?$(?<8(B . "zy")
    (?$(?<;(B . "zyh")
    (?$(?<:(B . "zyj")
    (?$(?07(B . "{!")
    (?$(?00(B . "{")
    (?$(?0`(B . "{6")
    (?$(?0c(B . "{6h")
    (?$(?0b(B . "{6j")
    (?$(?0P(B . "{7")
    (?$(?0S(B . "{7h")
    (?$(?0R(B . "{7j")
    (?$(?01(B . "{H")
    (?$(?0x(B . "{M")
    (?$(?06(B . "{N")
    (?$(?0p(B . "{\"")
    (?$(?0h(B . "{^")
    (?$(?0k(B . "{^h")
    (?$(?0j(B . "{^j")
    (?$(?0@(B . "{b")
    (?$(?0C(B . "{bh")
    (?$(?0B(B . "{bj")
    (?$(?03(B . "{h")
    (?$(?02(B . "{j")
    (?$(?0X(B . "{n")
    (?$(?0[(B . "{nh")
    (?$(?0Z(B . "{nj")
    (?$(?0H(B . "{u")
    (?$(?0K(B . "{uh")
    (?$(?0J(B . "{uj")
    (?$(?08(B . "{y")
    (?$(?0;(B . "{yh")
    (?$(?0:(B . "{yj")
    (?$(?%7(B . "~!")
    (?$(?%0(B . "~")
    (?$(?%`(B . "~6")
    (?$(?%d(B . "~6U")
    (?$(?%c(B . "~6h")
    (?$(?%b(B . "~6j")
    (?$(?%P(B . "~7")
    (?$(?%T(B . "~7U")
    (?$(?%S(B . "~7h")
    (?$(?%R(B . "~7j")
    (?$(?%1(B . "~H")
    (?$(?%x(B . "~M")
    (?$(?%6(B . "~N")
    (?$(?%4(B . "~U")
    (?$(?%p(B . "~\"")
    (?$(?%h(B . "~^")
    (?$(?%l(B . "~^U")
    (?$(?%k(B . "~^h")
    (?$(?%j(B . "~^j")
    (?$(?%@(B . "~b")
    (?$(?%D(B . "~bU")
    (?$(?%C(B . "~bh")
    (?$(?%B(B . "~bj")
    (?$(?%3(B . "~h")
    (?$(?%2(B . "~j")
    (?$(?%X(B . "~n")
    (?$(?%\(B . "~nU")
    (?$(?%[(B . "~nh")
    (?$(?%Z(B . "~nj")
    (?$(?%H(B . "~u")
    (?$(?%L(B . "~uU")
    (?$(?%K(B . "~uh")
    (?$(?%J(B . "~uj")
    (?$(?%8(B . "~y")
    (?$(?%<(B . "~yU")
    (?$(?%;(B . "~yh")
    (?$(?%:(B . "~yj")
    ))

(quail-define-package
 "thai-xtis" "Thai-XTIS" "XTIS" nil
 "Thai input method for XTIS (2-byte Thai code developed at NECTEC)"
 nil t t nil nil nil nil nil
 'quail-thai-update-translation)

(quail-define-rules
 ("d" ?$(?!0(B)
 ("dH" ?$(?!1(B)
 ("dj" ?$(?!2(B)
 ("dh" ?$(?!3(B)
 ("dU" ?$(?!4(B)
 ("dJ" ?$(?!5(B)
 ("dN" ?$(?!6(B)
 ("dy" ?$(?!8(B)
 ("dyj" ?$(?!:(B)
 ("dyh" ?$(?!;(B)
 ("dyU" ?$(?!<(B)
 ("dyJ" ?$(?!=(B)
 ("db" ?$(?!@(B)
 ("dbj" ?$(?!B(B)
 ("dbh" ?$(?!C(B)
 ("dbU" ?$(?!D(B)
 ("dbJ" ?$(?!E(B)
 ("du" ?$(?!H(B)
 ("duj" ?$(?!J(B)
 ("duh" ?$(?!K(B)
 ("duU" ?$(?!L(B)
 ("duJ" ?$(?!M(B)
 ("d7" ?$(?!P(B)
 ("d7j" ?$(?!R(B)
 ("d7h" ?$(?!S(B)
 ("d7U" ?$(?!T(B)
 ("d7J" ?$(?!U(B)
 ("dn" ?$(?!X(B)
 ("dnj" ?$(?!Z(B)
 ("dnh" ?$(?![(B)
 ("dnU" ?$(?!\(B)
 ("dnJ" ?$(?!](B)
 ("d6" ?$(?!`(B)
 ("d6j" ?$(?!b(B)
 ("d6h" ?$(?!c(B)
 ("d6U" ?$(?!d(B)
 ("d6J" ?$(?!e(B)
 ("d^" ?$(?!h(B)
 ("d^j" ?$(?!j(B)
 ("d^h" ?$(?!k(B)
 ("d^U" ?$(?!l(B)
 ("d^J" ?$(?!m(B)
 ("-" ?$(?"0(B)
 ("-H" ?$(?"1(B)
 ("-j" ?$(?"2(B)
 ("-h" ?$(?"3(B)
 ("-N" ?$(?"6(B)
 ("-y" ?$(?"8(B)
 ("-yj" ?$(?":(B)
 ("-yh" ?$(?";(B)
 ("-b" ?$(?"@(B)
 ("-bj" ?$(?"B(B)
 ("-bh" ?$(?"C(B)
 ("-u" ?$(?"H(B)
 ("-uj" ?$(?"J(B)
 ("-uh" ?$(?"K(B)
 ("-7" ?$(?"P(B)
 ("-7j" ?$(?"R(B)
 ("-7h" ?$(?"S(B)
 ("-n" ?$(?"X(B)
 ("-nj" ?$(?"Z(B)
 ("-nh" ?$(?"[(B)
 ("-6" ?$(?"`(B)
 ("-6j" ?$(?"b(B)
 ("-6h" ?$(?"c(B)
 ("-^" ?$(?"h(B)
 ("-^j" ?$(?"j(B)
 ("-^h" ?$(?"k(B)
 ("8" ?$(?$0(B)
 ("8H" ?$(?$1(B)
 ("8j" ?$(?$2(B)
 ("8h" ?$(?$3(B)
 ("8U" ?$(?$4(B)
 ("8N" ?$(?$6(B)
 ("8y" ?$(?$8(B)
 ("8yj" ?$(?$:(B)
 ("8yh" ?$(?$;(B)
 ("8yU" ?$(?$<(B)
 ("8b" ?$(?$@(B)
 ("8bj" ?$(?$B(B)
 ("8bh" ?$(?$C(B)
 ("8bU" ?$(?$D(B)
 ("8u" ?$(?$H(B)
 ("8uj" ?$(?$J(B)
 ("8uh" ?$(?$K(B)
 ("8uU" ?$(?$L(B)
 ("87" ?$(?$P(B)
 ("87j" ?$(?$R(B)
 ("87h" ?$(?$S(B)
 ("87U" ?$(?$T(B)
 ("8n" ?$(?$X(B)
 ("8nj" ?$(?$Z(B)
 ("8nh" ?$(?$[(B)
 ("8nU" ?$(?$\(B)
 ("86" ?$(?$`(B)
 ("86j" ?$(?$b(B)
 ("86h" ?$(?$c(B)
 ("86U" ?$(?$d(B)
 ("8^" ?$(?$h(B)
 ("8^j" ?$(?$j(B)
 ("8^h" ?$(?$k(B)
 ("8^U" ?$(?$l(B)
 ("S" ?$(?&0(B)
 ("SH" ?$(?&1(B)
 ("Sj" ?$(?&2(B)
 ("Sh" ?$(?&3(B)
 ("SU" ?$(?&4(B)
 ("SN" ?$(?&6(B)
 ("Sy" ?$(?&8(B)
 ("Syj" ?$(?&:(B)
 ("Syh" ?$(?&;(B)
 ("SyU" ?$(?&<(B)
 ("Sb" ?$(?&@(B)
 ("Sbj" ?$(?&B(B)
 ("Sbh" ?$(?&C(B)
 ("SbU" ?$(?&D(B)
 ("Su" ?$(?&H(B)
 ("Suj" ?$(?&J(B)
 ("Suh" ?$(?&K(B)
 ("SuU" ?$(?&L(B)
 ("S7" ?$(?&P(B)
 ("S7j" ?$(?&R(B)
 ("S7h" ?$(?&S(B)
 ("S7U" ?$(?&T(B)
 ("Sn" ?$(?&X(B)
 ("Snj" ?$(?&Z(B)
 ("Snh" ?$(?&[(B)
 ("SnU" ?$(?&\(B)
 ("S6" ?$(?&`(B)
 ("S6j" ?$(?&b(B)
 ("S6h" ?$(?&c(B)
 ("S6U" ?$(?&d(B)
 ("S^" ?$(?&h(B)
 ("S^j" ?$(?&j(B)
 ("S^h" ?$(?&k(B)
 ("S^U" ?$(?&l(B)
 ("'" ?$(?'0(B)
 ("'H" ?$(?'1(B)
 ("'j" ?$(?'2(B)
 ("'h" ?$(?'3(B)
 ("'U" ?$(?'4(B)
 ("'J" ?$(?'5(B)
 ("'N" ?$(?'6(B)
 ("'y" ?$(?'8(B)
 ("'yj" ?$(?':(B)
 ("'yh" ?$(?';(B)
 ("'yU" ?$(?'<(B)
 ("'yJ" ?$(?'=(B)
 ("'b" ?$(?'@(B)
 ("'bj" ?$(?'B(B)
 ("'bh" ?$(?'C(B)
 ("'bU" ?$(?'D(B)
 ("'bJ" ?$(?'E(B)
 ("'u" ?$(?'H(B)
 ("'uj" ?$(?'J(B)
 ("'uh" ?$(?'K(B)
 ("'uU" ?$(?'L(B)
 ("'uJ" ?$(?'M(B)
 ("'7" ?$(?'P(B)
 ("'7j" ?$(?'R(B)
 ("'7h" ?$(?'S(B)
 ("'7U" ?$(?'T(B)
 ("'7J" ?$(?'U(B)
 ("'n" ?$(?'X(B)
 ("'nj" ?$(?'Z(B)
 ("'nh" ?$(?'[(B)
 ("'nU" ?$(?'\(B)
 ("'nJ" ?$(?'](B)
 ("'6" ?$(?'`(B)
 ("'6j" ?$(?'b(B)
 ("'6h" ?$(?'c(B)
 ("'6U" ?$(?'d(B)
 ("'6J" ?$(?'e(B)
 ("'^" ?$(?'h(B)
 ("'^j" ?$(?'j(B)
 ("'^h" ?$(?'k(B)
 ("'^U" ?$(?'l(B)
 ("'^J" ?$(?'m(B)
 ("0" ?$(?(0(B)
 ("0H" ?$(?(1(B)
 ("0j" ?$(?(2(B)
 ("0h" ?$(?(3(B)
 ("0U" ?$(?(4(B)
 ("0J" ?$(?(5(B)
 ("0N" ?$(?(6(B)
 ("0y" ?$(?(8(B)
 ("0yj" ?$(?(:(B)
 ("0yh" ?$(?(;(B)
 ("0yU" ?$(?(<(B)
 ("0yJ" ?$(?(=(B)
 ("0b" ?$(?(@(B)
 ("0bj" ?$(?(B(B)
 ("0bh" ?$(?(C(B)
 ("0bU" ?$(?(D(B)
 ("0bJ" ?$(?(E(B)
 ("0u" ?$(?(H(B)
 ("0uj" ?$(?(J(B)
 ("0uh" ?$(?(K(B)
 ("0uU" ?$(?(L(B)
 ("0uJ" ?$(?(M(B)
 ("07" ?$(?(P(B)
 ("07j" ?$(?(R(B)
 ("07h" ?$(?(S(B)
 ("07U" ?$(?(T(B)
 ("07J" ?$(?(U(B)
 ("0n" ?$(?(X(B)
 ("0nj" ?$(?(Z(B)
 ("0nh" ?$(?([(B)
 ("0nU" ?$(?(\(B)
 ("0nJ" ?$(?(](B)
 ("06" ?$(?(`(B)
 ("06j" ?$(?(b(B)
 ("06h" ?$(?(c(B)
 ("06U" ?$(?(d(B)
 ("06J" ?$(?(e(B)
 ("0^" ?$(?(h(B)
 ("0^j" ?$(?(j(B)
 ("0^h" ?$(?(k(B)
 ("0^U" ?$(?(l(B)
 ("0^J" ?$(?(m(B)
 ("C" ?$(?)0(B)
 ("CH" ?$(?)1(B)
 ("Cj" ?$(?)2(B)
 ("Ch" ?$(?)3(B)
 ("CN" ?$(?)6(B)
 ("Cy" ?$(?)8(B)
 ("Cyj" ?$(?):(B)
 ("Cyh" ?$(?);(B)
 ("Cb" ?$(?)@(B)
 ("Cbj" ?$(?)B(B)
 ("Cbh" ?$(?)C(B)
 ("Cu" ?$(?)H(B)
 ("Cuj" ?$(?)J(B)
 ("Cuh" ?$(?)K(B)
 ("C7" ?$(?)P(B)
 ("C7j" ?$(?)R(B)
 ("C7h" ?$(?)S(B)
 ("Cn" ?$(?)X(B)
 ("Cnj" ?$(?)Z(B)
 ("Cnh" ?$(?)[(B)
 ("C6" ?$(?)`(B)
 ("C6j" ?$(?)b(B)
 ("C6h" ?$(?)c(B)
 ("C^" ?$(?)h(B)
 ("C^j" ?$(?)j(B)
 ("C^h" ?$(?)k(B)
 ("=" ?$(?*0(B)
 ("=H" ?$(?*1(B)
 ("=j" ?$(?*2(B)
 ("=h" ?$(?*3(B)
 ("=U" ?$(?*4(B)
 ("=N" ?$(?*6(B)
 ("=y" ?$(?*8(B)
 ("=yj" ?$(?*:(B)
 ("=yh" ?$(?*;(B)
 ("=yU" ?$(?*<(B)
 ("=b" ?$(?*@(B)
 ("=bj" ?$(?*B(B)
 ("=bh" ?$(?*C(B)
 ("=bU" ?$(?*D(B)
 ("=u" ?$(?*H(B)
 ("=uj" ?$(?*J(B)
 ("=uh" ?$(?*K(B)
 ("=uU" ?$(?*L(B)
 ("=7" ?$(?*P(B)
 ("=7j" ?$(?*R(B)
 ("=7h" ?$(?*S(B)
 ("=7U" ?$(?*T(B)
 ("=n" ?$(?*X(B)
 ("=nj" ?$(?*Z(B)
 ("=nh" ?$(?*[(B)
 ("=nU" ?$(?*\(B)
 ("=6" ?$(?*`(B)
 ("=6j" ?$(?*b(B)
 ("=6h" ?$(?*c(B)
 ("=6U" ?$(?*d(B)
 ("=^" ?$(?*h(B)
 ("=^j" ?$(?*j(B)
 ("=^h" ?$(?*k(B)
 ("=^U" ?$(?*l(B)
 (":" ?$(?+0(B)
 (":H" ?$(?+1(B)
 (":j" ?$(?+2(B)
 (":h" ?$(?+3(B)
 (":U" ?$(?+4(B)
 (":N" ?$(?+6(B)
 (":y" ?$(?+8(B)
 (":yj" ?$(?+:(B)
 (":yh" ?$(?+;(B)
 (":yU" ?$(?+<(B)
 (":b" ?$(?+@(B)
 (":bj" ?$(?+B(B)
 (":bh" ?$(?+C(B)
 (":bU" ?$(?+D(B)
 (":u" ?$(?+H(B)
 (":uj" ?$(?+J(B)
 (":uh" ?$(?+K(B)
 (":uU" ?$(?+L(B)
 (":7" ?$(?+P(B)
 (":7j" ?$(?+R(B)
 (":7h" ?$(?+S(B)
 (":7U" ?$(?+T(B)
 (":n" ?$(?+X(B)
 (":nj" ?$(?+Z(B)
 (":nh" ?$(?+[(B)
 (":nU" ?$(?+\(B)
 (":6" ?$(?+`(B)
 (":6j" ?$(?+b(B)
 (":6h" ?$(?+c(B)
 (":6U" ?$(?+d(B)
 (":^" ?$(?+h(B)
 (":^j" ?$(?+j(B)
 (":^h" ?$(?+k(B)
 (":^U" ?$(?+l(B)
 ("G" ?$(?,0(B)
 ("GH" ?$(?,1(B)
 ("Gj" ?$(?,2(B)
 ("Gh" ?$(?,3(B)
 ("GU" ?$(?,4(B)
 ("GN" ?$(?,6(B)
 ("Gy" ?$(?,8(B)
 ("Gyj" ?$(?,:(B)
 ("Gyh" ?$(?,;(B)
 ("GyU" ?$(?,<(B)
 ("Gb" ?$(?,@(B)
 ("Gbj" ?$(?,B(B)
 ("Gbh" ?$(?,C(B)
 ("GbU" ?$(?,D(B)
 ("Gu" ?$(?,H(B)
 ("Guj" ?$(?,J(B)
 ("Guh" ?$(?,K(B)
 ("GuU" ?$(?,L(B)
 ("G7" ?$(?,P(B)
 ("G7j" ?$(?,R(B)
 ("G7h" ?$(?,S(B)
 ("G7U" ?$(?,T(B)
 ("Gn" ?$(?,X(B)
 ("Gnj" ?$(?,Z(B)
 ("Gnh" ?$(?,[(B)
 ("GnU" ?$(?,\(B)
 ("G6" ?$(?,`(B)
 ("G6j" ?$(?,b(B)
 ("G6h" ?$(?,c(B)
 ("G6U" ?$(?,d(B)
 ("G^" ?$(?,h(B)
 ("G^j" ?$(?,j(B)
 ("G^h" ?$(?,k(B)
 ("G^U" ?$(?,l(B)
 ("P" ?$(?-0(B)
 ("PH" ?$(?-1(B)
 ("Pj" ?$(?-2(B)
 ("Ph" ?$(?-3(B)
 ("PU" ?$(?-4(B)
 ("PJ" ?$(?-5(B)
 ("PN" ?$(?-6(B)
 ("Py" ?$(?-8(B)
 ("Pyj" ?$(?-:(B)
 ("Pyh" ?$(?-;(B)
 ("PyU" ?$(?-<(B)
 ("PyJ" ?$(?-=(B)
 ("Pb" ?$(?-@(B)
 ("Pbj" ?$(?-B(B)
 ("Pbh" ?$(?-C(B)
 ("PbU" ?$(?-D(B)
 ("PbJ" ?$(?-E(B)
 ("Pu" ?$(?-H(B)
 ("Puj" ?$(?-J(B)
 ("Puh" ?$(?-K(B)
 ("PuU" ?$(?-L(B)
 ("PuJ" ?$(?-M(B)
 ("P7" ?$(?-P(B)
 ("P7j" ?$(?-R(B)
 ("P7h" ?$(?-S(B)
 ("P7U" ?$(?-T(B)
 ("P7J" ?$(?-U(B)
 ("Pn" ?$(?-X(B)
 ("Pnj" ?$(?-Z(B)
 ("Pnh" ?$(?-[(B)
 ("PnU" ?$(?-\(B)
 ("PnJ" ?$(?-](B)
 ("P6" ?$(?-`(B)
 ("P6j" ?$(?-b(B)
 ("P6h" ?$(?-c(B)
 ("P6U" ?$(?-d(B)
 ("P6J" ?$(?-e(B)
 ("P^" ?$(?-h(B)
 ("P^j" ?$(?-j(B)
 ("P^h" ?$(?-k(B)
 ("P^U" ?$(?-l(B)
 ("P^J" ?$(?-m(B)
 ("D" ?$(?.0(B)
 ("DH" ?$(?.1(B)
 ("Dj" ?$(?.2(B)
 ("Dh" ?$(?.3(B)
 ("DU" ?$(?.4(B)
 ("DJ" ?$(?.5(B)
 ("DN" ?$(?.6(B)
 ("Dy" ?$(?.8(B)
 ("Dyj" ?$(?.:(B)
 ("Dyh" ?$(?.;(B)
 ("DyU" ?$(?.<(B)
 ("DyJ" ?$(?.=(B)
 ("Db" ?$(?.@(B)
 ("Dbj" ?$(?.B(B)
 ("Dbh" ?$(?.C(B)
 ("DbU" ?$(?.D(B)
 ("DbJ" ?$(?.E(B)
 ("Du" ?$(?.H(B)
 ("Duj" ?$(?.J(B)
 ("Duh" ?$(?.K(B)
 ("DuU" ?$(?.L(B)
 ("DuJ" ?$(?.M(B)
 ("D7" ?$(?.P(B)
 ("D7j" ?$(?.R(B)
 ("D7h" ?$(?.S(B)
 ("D7U" ?$(?.T(B)
 ("D7J" ?$(?.U(B)
 ("Dn" ?$(?.X(B)
 ("Dnj" ?$(?.Z(B)
 ("Dnh" ?$(?.[(B)
 ("DnU" ?$(?.\(B)
 ("DnJ" ?$(?.](B)
 ("D6" ?$(?.`(B)
 ("D6j" ?$(?.b(B)
 ("D6h" ?$(?.c(B)
 ("D6U" ?$(?.d(B)
 ("D6J" ?$(?.e(B)
 ("D^" ?$(?.h(B)
 ("D^j" ?$(?.j(B)
 ("D^h" ?$(?.k(B)
 ("D^U" ?$(?.l(B)
 ("D^J" ?$(?.m(B)
 ("E" ?$(?/0(B)
 ("EH" ?$(?/1(B)
 ("Ej" ?$(?/2(B)
 ("Eh" ?$(?/3(B)
 ("EU" ?$(?/4(B)
 ("EJ" ?$(?/5(B)
 ("EN" ?$(?/6(B)
 ("Ey" ?$(?/8(B)
 ("Eyj" ?$(?/:(B)
 ("Eyh" ?$(?/;(B)
 ("EyU" ?$(?/<(B)
 ("EyJ" ?$(?/=(B)
 ("Eb" ?$(?/@(B)
 ("Ebj" ?$(?/B(B)
 ("Ebh" ?$(?/C(B)
 ("EbU" ?$(?/D(B)
 ("EbJ" ?$(?/E(B)
 ("Eu" ?$(?/H(B)
 ("Euj" ?$(?/J(B)
 ("Euh" ?$(?/K(B)
 ("EuU" ?$(?/L(B)
 ("EuJ" ?$(?/M(B)
 ("E7" ?$(?/P(B)
 ("E7j" ?$(?/R(B)
 ("E7h" ?$(?/S(B)
 ("E7U" ?$(?/T(B)
 ("E7J" ?$(?/U(B)
 ("En" ?$(?/X(B)
 ("Enj" ?$(?/Z(B)
 ("Enh" ?$(?/[(B)
 ("EnU" ?$(?/\(B)
 ("EnJ" ?$(?/](B)
 ("E6" ?$(?/`(B)
 ("E6j" ?$(?/b(B)
 ("E6h" ?$(?/c(B)
 ("E6U" ?$(?/d(B)
 ("E6J" ?$(?/e(B)
 ("E^" ?$(?/h(B)
 ("E^j" ?$(?/j(B)
 ("E^h" ?$(?/k(B)
 ("E^U" ?$(?/l(B)
 ("E^J" ?$(?/m(B)
 ("{" ?$(?00(B)
 ("{H" ?$(?01(B)
 ("{j" ?$(?02(B)
 ("{h" ?$(?03(B)
 ("{N" ?$(?06(B)
 ("{y" ?$(?08(B)
 ("{yj" ?$(?0:(B)
 ("{yh" ?$(?0;(B)
 ("{b" ?$(?0@(B)
 ("{bj" ?$(?0B(B)
 ("{bh" ?$(?0C(B)
 ("{u" ?$(?0H(B)
 ("{uj" ?$(?0J(B)
 ("{uh" ?$(?0K(B)
 ("{7" ?$(?0P(B)
 ("{7j" ?$(?0R(B)
 ("{7h" ?$(?0S(B)
 ("{n" ?$(?0X(B)
 ("{nj" ?$(?0Z(B)
 ("{nh" ?$(?0[(B)
 ("{6" ?$(?0`(B)
 ("{6j" ?$(?0b(B)
 ("{6h" ?$(?0c(B)
 ("{^" ?$(?0h(B)
 ("{^j" ?$(?0j(B)
 ("{^h" ?$(?0k(B)
 ("R" ?$(?10(B)
 ("RH" ?$(?11(B)
 ("Rj" ?$(?12(B)
 ("Rh" ?$(?13(B)
 ("RU" ?$(?14(B)
 ("RN" ?$(?16(B)
 ("Ry" ?$(?18(B)
 ("Ryj" ?$(?1:(B)
 ("Ryh" ?$(?1;(B)
 ("RyU" ?$(?1<(B)
 ("Rb" ?$(?1@(B)
 ("Rbj" ?$(?1B(B)
 ("Rbh" ?$(?1C(B)
 ("RbU" ?$(?1D(B)
 ("Ru" ?$(?1H(B)
 ("Ruj" ?$(?1J(B)
 ("Ruh" ?$(?1K(B)
 ("RuU" ?$(?1L(B)
 ("R7" ?$(?1P(B)
 ("R7j" ?$(?1R(B)
 ("R7h" ?$(?1S(B)
 ("R7U" ?$(?1T(B)
 ("Rn" ?$(?1X(B)
 ("Rnj" ?$(?1Z(B)
 ("Rnh" ?$(?1[(B)
 ("RnU" ?$(?1\(B)
 ("R6" ?$(?1`(B)
 ("R6j" ?$(?1b(B)
 ("R6h" ?$(?1c(B)
 ("R6U" ?$(?1d(B)
 ("R^" ?$(?1h(B)
 ("R^j" ?$(?1j(B)
 ("R^h" ?$(?1k(B)
 ("R^U" ?$(?1l(B)
 ("<" ?$(?20(B)
 ("<H" ?$(?21(B)
 ("<j" ?$(?22(B)
 ("<h" ?$(?23(B)
 ("<U" ?$(?24(B)
 ("<N" ?$(?26(B)
 ("<y" ?$(?28(B)
 ("<yj" ?$(?2:(B)
 ("<yh" ?$(?2;(B)
 ("<yU" ?$(?2<(B)
 ("<b" ?$(?2@(B)
 ("<bj" ?$(?2B(B)
 ("<bh" ?$(?2C(B)
 ("<bU" ?$(?2D(B)
 ("<u" ?$(?2H(B)
 ("<uj" ?$(?2J(B)
 ("<uh" ?$(?2K(B)
 ("<uU" ?$(?2L(B)
 ("<7" ?$(?2P(B)
 ("<7j" ?$(?2R(B)
 ("<7h" ?$(?2S(B)
 ("<7U" ?$(?2T(B)
 ("<n" ?$(?2X(B)
 ("<nj" ?$(?2Z(B)
 ("<nh" ?$(?2[(B)
 ("<nU" ?$(?2\(B)
 ("<6" ?$(?2`(B)
 ("<6j" ?$(?2b(B)
 ("<6h" ?$(?2c(B)
 ("<6U" ?$(?2d(B)
 ("<^" ?$(?2h(B)
 ("<^j" ?$(?2j(B)
 ("<^h" ?$(?2k(B)
 ("<^U" ?$(?2l(B)
 ("I" ?$(?30(B)
 ("IH" ?$(?31(B)
 ("Ij" ?$(?32(B)
 ("Ih" ?$(?33(B)
 ("IU" ?$(?34(B)
 ("IJ" ?$(?35(B)
 ("IN" ?$(?36(B)
 ("Iy" ?$(?38(B)
 ("Iyj" ?$(?3:(B)
 ("Iyh" ?$(?3;(B)
 ("IyU" ?$(?3<(B)
 ("IyJ" ?$(?3=(B)
 ("Ib" ?$(?3@(B)
 ("Ibj" ?$(?3B(B)
 ("Ibh" ?$(?3C(B)
 ("IbU" ?$(?3D(B)
 ("IbJ" ?$(?3E(B)
 ("Iu" ?$(?3H(B)
 ("Iuj" ?$(?3J(B)
 ("Iuh" ?$(?3K(B)
 ("IuU" ?$(?3L(B)
 ("IuJ" ?$(?3M(B)
 ("I7" ?$(?3P(B)
 ("I7j" ?$(?3R(B)
 ("I7h" ?$(?3S(B)
 ("I7U" ?$(?3T(B)
 ("I7J" ?$(?3U(B)
 ("In" ?$(?3X(B)
 ("Inj" ?$(?3Z(B)
 ("Inh" ?$(?3[(B)
 ("InU" ?$(?3\(B)
 ("InJ" ?$(?3](B)
 ("I6" ?$(?3`(B)
 ("I6j" ?$(?3b(B)
 ("I6h" ?$(?3c(B)
 ("I6U" ?$(?3d(B)
 ("I6J" ?$(?3e(B)
 ("I^" ?$(?3h(B)
 ("I^j" ?$(?3j(B)
 ("I^h" ?$(?3k(B)
 ("I^U" ?$(?3l(B)
 ("I^J" ?$(?3m(B)
 ("f" ?$(?40(B)
 ("fH" ?$(?41(B)
 ("fj" ?$(?42(B)
 ("fh" ?$(?43(B)
 ("fU" ?$(?44(B)
 ("fJ" ?$(?45(B)
 ("fN" ?$(?46(B)
 ("fy" ?$(?48(B)
 ("fyj" ?$(?4:(B)
 ("fyh" ?$(?4;(B)
 ("fyU" ?$(?4<(B)
 ("fyJ" ?$(?4=(B)
 ("fb" ?$(?4@(B)
 ("fbj" ?$(?4B(B)
 ("fbh" ?$(?4C(B)
 ("fbU" ?$(?4D(B)
 ("fbJ" ?$(?4E(B)
 ("fbN" ?$(?4F(B)
 ("fu" ?$(?4H(B)
 ("fuj" ?$(?4J(B)
 ("fuh" ?$(?4K(B)
 ("fuU" ?$(?4L(B)
 ("fuJ" ?$(?4M(B)
 ("f7" ?$(?4P(B)
 ("f7j" ?$(?4R(B)
 ("f7h" ?$(?4S(B)
 ("f7U" ?$(?4T(B)
 ("f7J" ?$(?4U(B)
 ("fn" ?$(?4X(B)
 ("fnj" ?$(?4Z(B)
 ("fnh" ?$(?4[(B)
 ("fnU" ?$(?4\(B)
 ("fnJ" ?$(?4](B)
 ("f6" ?$(?4`(B)
 ("f6j" ?$(?4b(B)
 ("f6h" ?$(?4c(B)
 ("f6U" ?$(?4d(B)
 ("f6J" ?$(?4e(B)
 ("f^" ?$(?4h(B)
 ("f^j" ?$(?4j(B)
 ("f^h" ?$(?4k(B)
 ("f^U" ?$(?4l(B)
 ("f^J" ?$(?4m(B)
 ("9" ?$(?50(B)
 ("9H" ?$(?51(B)
 ("9j" ?$(?52(B)
 ("9h" ?$(?53(B)
 ("9U" ?$(?54(B)
 ("9J" ?$(?55(B)
 ("9N" ?$(?56(B)
 ("9y" ?$(?58(B)
 ("9yj" ?$(?5:(B)
 ("9yh" ?$(?5;(B)
 ("9yU" ?$(?5<(B)
 ("9yJ" ?$(?5=(B)
 ("9b" ?$(?5@(B)
 ("9bj" ?$(?5B(B)
 ("9bh" ?$(?5C(B)
 ("9bU" ?$(?5D(B)
 ("9bJ" ?$(?5E(B)
 ("9bN" ?$(?5F(B)
 ("9u" ?$(?5H(B)
 ("9uj" ?$(?5J(B)
 ("9uh" ?$(?5K(B)
 ("9uU" ?$(?5L(B)
 ("9uJ" ?$(?5M(B)
 ("97" ?$(?5P(B)
 ("97j" ?$(?5R(B)
 ("97h" ?$(?5S(B)
 ("97U" ?$(?5T(B)
 ("97J" ?$(?5U(B)
 ("9n" ?$(?5X(B)
 ("9nj" ?$(?5Z(B)
 ("9nh" ?$(?5[(B)
 ("9nU" ?$(?5\(B)
 ("9nJ" ?$(?5](B)
 ("96" ?$(?5`(B)
 ("96j" ?$(?5b(B)
 ("96h" ?$(?5c(B)
 ("96U" ?$(?5d(B)
 ("96J" ?$(?5e(B)
 ("9^" ?$(?5h(B)
 ("9^j" ?$(?5j(B)
 ("9^h" ?$(?5k(B)
 ("9^U" ?$(?5l(B)
 ("9^J" ?$(?5m(B)
 ("5" ?$(?60(B)
 ("5H" ?$(?61(B)
 ("5j" ?$(?62(B)
 ("5h" ?$(?63(B)
 ("5N" ?$(?66(B)
 ("5y" ?$(?68(B)
 ("5yj" ?$(?6:(B)
 ("5yh" ?$(?6;(B)
 ("5b" ?$(?6@(B)
 ("5bj" ?$(?6B(B)
 ("5bh" ?$(?6C(B)
 ("5u" ?$(?6H(B)
 ("5uj" ?$(?6J(B)
 ("5uh" ?$(?6K(B)
 ("57" ?$(?6P(B)
 ("57j" ?$(?6R(B)
 ("57h" ?$(?6S(B)
 ("5n" ?$(?6X(B)
 ("5nj" ?$(?6Z(B)
 ("5nh" ?$(?6[(B)
 ("56" ?$(?6`(B)
 ("56j" ?$(?6b(B)
 ("56h" ?$(?6c(B)
 ("56N" ?$(?6f(B)
 ("5^" ?$(?6h(B)
 ("5^j" ?$(?6j(B)
 ("5^h" ?$(?6k(B)
 ("m" ?$(?70(B)
 ("mH" ?$(?71(B)
 ("mj" ?$(?72(B)
 ("mh" ?$(?73(B)
 ("mU" ?$(?74(B)
 ("mN" ?$(?76(B)
 ("my" ?$(?78(B)
 ("myj" ?$(?7:(B)
 ("myh" ?$(?7;(B)
 ("myU" ?$(?7<(B)
 ("mb" ?$(?7@(B)
 ("mbj" ?$(?7B(B)
 ("mbh" ?$(?7C(B)
 ("mbU" ?$(?7D(B)
 ("mu" ?$(?7H(B)
 ("muj" ?$(?7J(B)
 ("muh" ?$(?7K(B)
 ("muU" ?$(?7L(B)
 ("m7" ?$(?7P(B)
 ("m7j" ?$(?7R(B)
 ("m7h" ?$(?7S(B)
 ("m7U" ?$(?7T(B)
 ("mn" ?$(?7X(B)
 ("mnj" ?$(?7Z(B)
 ("mnh" ?$(?7[(B)
 ("mnU" ?$(?7\(B)
 ("m6" ?$(?7`(B)
 ("m6j" ?$(?7b(B)
 ("m6h" ?$(?7c(B)
 ("m6U" ?$(?7d(B)
 ("m6N" ?$(?7f(B)
 ("m^" ?$(?7h(B)
 ("m^j" ?$(?7j(B)
 ("m^h" ?$(?7k(B)
 ("m^U" ?$(?7l(B)
 ("T" ?$(?80(B)
 ("TH" ?$(?81(B)
 ("Tj" ?$(?82(B)
 ("Th" ?$(?83(B)
 ("TU" ?$(?84(B)
 ("TN" ?$(?86(B)
 ("Ty" ?$(?88(B)
 ("Tyj" ?$(?8:(B)
 ("Tyh" ?$(?8;(B)
 ("TyU" ?$(?8<(B)
 ("Tb" ?$(?8@(B)
 ("Tbj" ?$(?8B(B)
 ("Tbh" ?$(?8C(B)
 ("TbU" ?$(?8D(B)
 ("TbN" ?$(?8F(B)
 ("Tu" ?$(?8H(B)
 ("Tuj" ?$(?8J(B)
 ("Tuh" ?$(?8K(B)
 ("TuU" ?$(?8L(B)
 ("T7" ?$(?8P(B)
 ("T7j" ?$(?8R(B)
 ("T7h" ?$(?8S(B)
 ("T7U" ?$(?8T(B)
 ("Tn" ?$(?8X(B)
 ("Tnj" ?$(?8Z(B)
 ("Tnh" ?$(?8[(B)
 ("TnU" ?$(?8\(B)
 ("T6" ?$(?8`(B)
 ("T6j" ?$(?8b(B)
 ("T6h" ?$(?8c(B)
 ("T6U" ?$(?8d(B)
 ("T6N" ?$(?8f(B)
 ("T^" ?$(?8h(B)
 ("T^j" ?$(?8j(B)
 ("T^h" ?$(?8k(B)
 ("T^U" ?$(?8l(B)
 ("o" ?$(?90(B)
 ("oH" ?$(?91(B)
 ("oj" ?$(?92(B)
 ("oh" ?$(?93(B)
 ("oU" ?$(?94(B)
 ("oJ" ?$(?95(B)
 ("oN" ?$(?96(B)
 ("oy" ?$(?98(B)
 ("oyj" ?$(?9:(B)
 ("oyh" ?$(?9;(B)
 ("oyU" ?$(?9<(B)
 ("oyJ" ?$(?9=(B)
 ("ob" ?$(?9@(B)
 ("obj" ?$(?9B(B)
 ("obh" ?$(?9C(B)
 ("obU" ?$(?9D(B)
 ("obJ" ?$(?9E(B)
 ("ou" ?$(?9H(B)
 ("ouj" ?$(?9J(B)
 ("ouh" ?$(?9K(B)
 ("ouU" ?$(?9L(B)
 ("ouJ" ?$(?9M(B)
 ("o7" ?$(?9P(B)
 ("o7j" ?$(?9R(B)
 ("o7h" ?$(?9S(B)
 ("o7U" ?$(?9T(B)
 ("o7J" ?$(?9U(B)
 ("on" ?$(?9X(B)
 ("onj" ?$(?9Z(B)
 ("onh" ?$(?9[(B)
 ("onU" ?$(?9\(B)
 ("onJ" ?$(?9](B)
 ("o6" ?$(?9`(B)
 ("o6j" ?$(?9b(B)
 ("o6h" ?$(?9c(B)
 ("o6U" ?$(?9d(B)
 ("o6J" ?$(?9e(B)
 ("o^" ?$(?9h(B)
 ("o^j" ?$(?9j(B)
 ("o^h" ?$(?9k(B)
 ("o^U" ?$(?9l(B)
 ("o^J" ?$(?9m(B)
 ("[" ?$(?:0(B)
 ("[H" ?$(?:1(B)
 ("[j" ?$(?:2(B)
 ("[h" ?$(?:3(B)
 ("[U" ?$(?:4(B)
 ("[J" ?$(?:5(B)
 ("[N" ?$(?:6(B)
 ("[y" ?$(?:8(B)
 ("[yj" ?$(?::(B)
 ("[yh" ?$(?:;(B)
 ("[yU" ?$(?:<(B)
 ("[yJ" ?$(?:=(B)
 ("[b" ?$(?:@(B)
 ("[bj" ?$(?:B(B)
 ("[bh" ?$(?:C(B)
 ("[bU" ?$(?:D(B)
 ("[bJ" ?$(?:E(B)
 ("[u" ?$(?:H(B)
 ("[uj" ?$(?:J(B)
 ("[uh" ?$(?:K(B)
 ("[uU" ?$(?:L(B)
 ("[uJ" ?$(?:M(B)
 ("[7" ?$(?:P(B)
 ("[7j" ?$(?:R(B)
 ("[7h" ?$(?:S(B)
 ("[7U" ?$(?:T(B)
 ("[7J" ?$(?:U(B)
 ("[n" ?$(?:X(B)
 ("[nj" ?$(?:Z(B)
 ("[nh" ?$(?:[(B)
 ("[nU" ?$(?:\(B)
 ("[nJ" ?$(?:](B)
 ("[6" ?$(?:`(B)
 ("[6j" ?$(?:b(B)
 ("[6h" ?$(?:c(B)
 ("[6U" ?$(?:d(B)
 ("[6J" ?$(?:e(B)
 ("[^" ?$(?:h(B)
 ("[^j" ?$(?:j(B)
 ("[^h" ?$(?:k(B)
 ("[^U" ?$(?:l(B)
 ("[^J" ?$(?:m(B)
 ("x" ?$(?;0(B)
 ("xH" ?$(?;1(B)
 ("xj" ?$(?;2(B)
 ("xh" ?$(?;3(B)
 ("xU" ?$(?;4(B)
 ("xJ" ?$(?;5(B)
 ("xN" ?$(?;6(B)
 ("xy" ?$(?;8(B)
 ("xyj" ?$(?;:(B)
 ("xyh" ?$(?;;(B)
 ("xyU" ?$(?;<(B)
 ("xyJ" ?$(?;=(B)
 ("xb" ?$(?;@(B)
 ("xbj" ?$(?;B(B)
 ("xbh" ?$(?;C(B)
 ("xbU" ?$(?;D(B)
 ("xbJ" ?$(?;E(B)
 ("xu" ?$(?;H(B)
 ("xuj" ?$(?;J(B)
 ("xuh" ?$(?;K(B)
 ("xuU" ?$(?;L(B)
 ("xuJ" ?$(?;M(B)
 ("x7" ?$(?;P(B)
 ("x7j" ?$(?;R(B)
 ("x7h" ?$(?;S(B)
 ("x7U" ?$(?;T(B)
 ("x7J" ?$(?;U(B)
 ("xn" ?$(?;X(B)
 ("xnj" ?$(?;Z(B)
 ("xnh" ?$(?;[(B)
 ("xnU" ?$(?;\(B)
 ("xnJ" ?$(?;](B)
 ("x6" ?$(?;`(B)
 ("x6j" ?$(?;b(B)
 ("x6h" ?$(?;c(B)
 ("x6U" ?$(?;d(B)
 ("x6J" ?$(?;e(B)
 ("x^" ?$(?;h(B)
 ("x^j" ?$(?;j(B)
 ("x^h" ?$(?;k(B)
 ("x^U" ?$(?;l(B)
 ("x^J" ?$(?;m(B)
 ("z" ?$(?<0(B)
 ("zH" ?$(?<1(B)
 ("zj" ?$(?<2(B)
 ("zh" ?$(?<3(B)
 ("zN" ?$(?<6(B)
 ("zy" ?$(?<8(B)
 ("zyj" ?$(?<:(B)
 ("zyh" ?$(?<;(B)
 ("zb" ?$(?<@(B)
 ("zbj" ?$(?<B(B)
 ("zbh" ?$(?<C(B)
 ("zu" ?$(?<H(B)
 ("zuj" ?$(?<J(B)
 ("zuh" ?$(?<K(B)
 ("z7" ?$(?<P(B)
 ("z7j" ?$(?<R(B)
 ("z7h" ?$(?<S(B)
 ("zn" ?$(?<X(B)
 ("znj" ?$(?<Z(B)
 ("znh" ?$(?<[(B)
 ("z6" ?$(?<`(B)
 ("z6j" ?$(?<b(B)
 ("z6h" ?$(?<c(B)
 ("z^" ?$(?<h(B)
 ("z^j" ?$(?<j(B)
 ("z^h" ?$(?<k(B)
 ("/" ?$(?=0(B)
 ("/H" ?$(?=1(B)
 ("/j" ?$(?=2(B)
 ("/h" ?$(?=3(B)
 ("/N" ?$(?=6(B)
 ("/y" ?$(?=8(B)
 ("/yj" ?$(?=:(B)
 ("/yh" ?$(?=;(B)
 ("/b" ?$(?=@(B)
 ("/bj" ?$(?=B(B)
 ("/bh" ?$(?=C(B)
 ("/u" ?$(?=H(B)
 ("/uj" ?$(?=J(B)
 ("/uh" ?$(?=K(B)
 ("/7" ?$(?=P(B)
 ("/7j" ?$(?=R(B)
 ("/7h" ?$(?=S(B)
 ("/n" ?$(?=X(B)
 ("/nj" ?$(?=Z(B)
 ("/nh" ?$(?=[(B)
 ("/6" ?$(?=`(B)
 ("/6j" ?$(?=b(B)
 ("/6h" ?$(?=c(B)
 ("/^" ?$(?=h(B)
 ("/^j" ?$(?=j(B)
 ("/^h" ?$(?=k(B)
 ("r" ?$(?>0(B)
 ("rH" ?$(?>1(B)
 ("rj" ?$(?>2(B)
 ("rh" ?$(?>3(B)
 ("rU" ?$(?>4(B)
 ("rN" ?$(?>6(B)
 ("ry" ?$(?>8(B)
 ("ryj" ?$(?>:(B)
 ("ryh" ?$(?>;(B)
 ("ryU" ?$(?><(B)
 ("rb" ?$(?>@(B)
 ("rbj" ?$(?>B(B)
 ("rbh" ?$(?>C(B)
 ("rbU" ?$(?>D(B)
 ("ru" ?$(?>H(B)
 ("ruj" ?$(?>J(B)
 ("ruh" ?$(?>K(B)
 ("ruU" ?$(?>L(B)
 ("r7" ?$(?>P(B)
 ("r7j" ?$(?>R(B)
 ("r7h" ?$(?>S(B)
 ("r7U" ?$(?>T(B)
 ("rn" ?$(?>X(B)
 ("rnj" ?$(?>Z(B)
 ("rnh" ?$(?>[(B)
 ("rnU" ?$(?>\(B)
 ("r6" ?$(?>`(B)
 ("r6j" ?$(?>b(B)
 ("r6h" ?$(?>c(B)
 ("r6U" ?$(?>d(B)
 ("r^" ?$(?>h(B)
 ("r^j" ?$(?>j(B)
 ("r^h" ?$(?>k(B)
 ("r^U" ?$(?>l(B)
 ("a" ?$(??0(B)
 ("aH" ?$(??1(B)
 ("aj" ?$(??2(B)
 ("ah" ?$(??3(B)
 ("aU" ?$(??4(B)
 ("aN" ?$(??6(B)
 ("ay" ?$(??8(B)
 ("ayj" ?$(??:(B)
 ("ayh" ?$(??;(B)
 ("ayU" ?$(??<(B)
 ("ab" ?$(??@(B)
 ("abj" ?$(??B(B)
 ("abh" ?$(??C(B)
 ("abU" ?$(??D(B)
 ("au" ?$(??H(B)
 ("auj" ?$(??J(B)
 ("auh" ?$(??K(B)
 ("auU" ?$(??L(B)
 ("a7" ?$(??P(B)
 ("a7j" ?$(??R(B)
 ("a7h" ?$(??S(B)
 ("a7U" ?$(??T(B)
 ("an" ?$(??X(B)
 ("anj" ?$(??Z(B)
 ("anh" ?$(??[(B)
 ("anU" ?$(??\(B)
 ("a6" ?$(??`(B)
 ("a6j" ?$(??b(B)
 ("a6h" ?$(??c(B)
 ("a6U" ?$(??d(B)
 ("a^" ?$(??h(B)
 ("a^j" ?$(??j(B)
 ("a^h" ?$(??k(B)
 ("a^U" ?$(??l(B)
 ("4" ?$(?@0(B)
 ("4H" ?$(?@1(B)
 ("4j" ?$(?@2(B)
 ("4h" ?$(?@3(B)
 ("4U" ?$(?@4(B)
 ("4N" ?$(?@6(B)
 ("4y" ?$(?@8(B)
 ("4yj" ?$(?@:(B)
 ("4yh" ?$(?@;(B)
 ("4yU" ?$(?@<(B)
 ("4b" ?$(?@@(B)
 ("4bj" ?$(?@B(B)
 ("4bh" ?$(?@C(B)
 ("4bU" ?$(?@D(B)
 ("4u" ?$(?@H(B)
 ("4uj" ?$(?@J(B)
 ("4uh" ?$(?@K(B)
 ("4uU" ?$(?@L(B)
 ("47" ?$(?@P(B)
 ("47j" ?$(?@R(B)
 ("47h" ?$(?@S(B)
 ("47U" ?$(?@T(B)
 ("4n" ?$(?@X(B)
 ("4nj" ?$(?@Z(B)
 ("4nh" ?$(?@[(B)
 ("4nU" ?$(?@\(B)
 ("46" ?$(?@`(B)
 ("46j" ?$(?@b(B)
 ("46h" ?$(?@c(B)
 ("46U" ?$(?@d(B)
 ("4^" ?$(?@h(B)
 ("4^j" ?$(?@j(B)
 ("4^h" ?$(?@k(B)
 ("4^U" ?$(?@l(B)
 ("," ?$(?A0(B)
 (",H" ?$(?A1(B)
 (",j" ?$(?A2(B)
 (",h" ?$(?A3(B)
 (",U" ?$(?A4(B)
 (",J" ?$(?A5(B)
 (",N" ?$(?A6(B)
 (",y" ?$(?A8(B)
 (",yj" ?$(?A:(B)
 (",yh" ?$(?A;(B)
 (",yU" ?$(?A<(B)
 (",yJ" ?$(?A=(B)
 (",b" ?$(?A@(B)
 (",bj" ?$(?AB(B)
 (",bh" ?$(?AC(B)
 (",bU" ?$(?AD(B)
 (",bJ" ?$(?AE(B)
 (",u" ?$(?AH(B)
 (",uj" ?$(?AJ(B)
 (",uh" ?$(?AK(B)
 (",uU" ?$(?AL(B)
 (",uJ" ?$(?AM(B)
 (",7" ?$(?AP(B)
 (",7j" ?$(?AR(B)
 (",7h" ?$(?AS(B)
 (",7U" ?$(?AT(B)
 (",7J" ?$(?AU(B)
 (",n" ?$(?AX(B)
 (",nj" ?$(?AZ(B)
 (",nh" ?$(?A[(B)
 (",nU" ?$(?A\(B)
 (",nJ" ?$(?A](B)
 (",6" ?$(?A`(B)
 (",6j" ?$(?Ab(B)
 (",6h" ?$(?Ac(B)
 (",6U" ?$(?Ad(B)
 (",6J" ?$(?Ae(B)
 (",^" ?$(?Ah(B)
 (",^j" ?$(?Aj(B)
 (",^h" ?$(?Ak(B)
 (",^U" ?$(?Al(B)
 (",^J" ?$(?Am(B)
 ("p" ?$(?B0(B)
 ("pH" ?$(?B1(B)
 ("pj" ?$(?B2(B)
 ("ph" ?$(?B3(B)
 ("pU" ?$(?B4(B)
 ("pJ" ?$(?B5(B)
 ("pN" ?$(?B6(B)
 ("py" ?$(?B8(B)
 ("pyj" ?$(?B:(B)
 ("pyh" ?$(?B;(B)
 ("pyU" ?$(?B<(B)
 ("pyJ" ?$(?B=(B)
 ("pb" ?$(?B@(B)
 ("pbj" ?$(?BB(B)
 ("pbh" ?$(?BC(B)
 ("pbU" ?$(?BD(B)
 ("pbJ" ?$(?BE(B)
 ("pu" ?$(?BH(B)
 ("puj" ?$(?BJ(B)
 ("puh" ?$(?BK(B)
 ("puU" ?$(?BL(B)
 ("puJ" ?$(?BM(B)
 ("p7" ?$(?BP(B)
 ("p7j" ?$(?BR(B)
 ("p7h" ?$(?BS(B)
 ("p7U" ?$(?BT(B)
 ("p7J" ?$(?BU(B)
 ("pn" ?$(?BX(B)
 ("pnj" ?$(?BZ(B)
 ("pnh" ?$(?B[(B)
 ("pnU" ?$(?B\(B)
 ("pnJ" ?$(?B](B)
 ("p6" ?$(?B`(B)
 ("p6j" ?$(?Bb(B)
 ("p6h" ?$(?Bc(B)
 ("p6U" ?$(?Bd(B)
 ("p6J" ?$(?Be(B)
 ("p^" ?$(?Bh(B)
 ("p^j" ?$(?Bj(B)
 ("p^h" ?$(?Bk(B)
 ("p^U" ?$(?Bl(B)
 ("p^J" ?$(?Bm(B)
 ("i" ?$(?C0(B)
 ("iH" ?$(?C1(B)
 ("ij" ?$(?C2(B)
 ("ih" ?$(?C3(B)
 ("iU" ?$(?C4(B)
 ("iJ" ?$(?C5(B)
 ("iN" ?$(?C6(B)
 ("iy" ?$(?C8(B)
 ("iyj" ?$(?C:(B)
 ("iyh" ?$(?C;(B)
 ("iyU" ?$(?C<(B)
 ("iyJ" ?$(?C=(B)
 ("ib" ?$(?C@(B)
 ("ibj" ?$(?CB(B)
 ("ibh" ?$(?CC(B)
 ("ibU" ?$(?CD(B)
 ("ibJ" ?$(?CE(B)
 ("iu" ?$(?CH(B)
 ("iuj" ?$(?CJ(B)
 ("iuh" ?$(?CK(B)
 ("iuU" ?$(?CL(B)
 ("iuJ" ?$(?CM(B)
 ("i7" ?$(?CP(B)
 ("i7j" ?$(?CR(B)
 ("i7h" ?$(?CS(B)
 ("i7U" ?$(?CT(B)
 ("i7J" ?$(?CU(B)
 ("in" ?$(?CX(B)
 ("inj" ?$(?CZ(B)
 ("inh" ?$(?C[(B)
 ("inU" ?$(?C\(B)
 ("inJ" ?$(?C](B)
 ("i6" ?$(?C`(B)
 ("i6j" ?$(?Cb(B)
 ("i6h" ?$(?Cc(B)
 ("i6U" ?$(?Cd(B)
 ("i6J" ?$(?Ce(B)
 ("i^" ?$(?Ch(B)
 ("i^j" ?$(?Cj(B)
 ("i^h" ?$(?Ck(B)
 ("i^U" ?$(?Cl(B)
 ("i^J" ?$(?Cm(B)
 ("A" ?$(?D0(B)
 ("]" ?$(?E0(B)
 ("]H" ?$(?E1(B)
 ("]j" ?$(?E2(B)
 ("]h" ?$(?E3(B)
 ("]U" ?$(?E4(B)
 ("]J" ?$(?E5(B)
 ("]N" ?$(?E6(B)
 ("]y" ?$(?E8(B)
 ("]yj" ?$(?E:(B)
 ("]yh" ?$(?E;(B)
 ("]yU" ?$(?E<(B)
 ("]yJ" ?$(?E=(B)
 ("]b" ?$(?E@(B)
 ("]bj" ?$(?EB(B)
 ("]bh" ?$(?EC(B)
 ("]bU" ?$(?ED(B)
 ("]bJ" ?$(?EE(B)
 ("]u" ?$(?EH(B)
 ("]uj" ?$(?EJ(B)
 ("]uh" ?$(?EK(B)
 ("]uU" ?$(?EL(B)
 ("]uJ" ?$(?EM(B)
 ("]7" ?$(?EP(B)
 ("]7j" ?$(?ER(B)
 ("]7h" ?$(?ES(B)
 ("]7U" ?$(?ET(B)
 ("]7J" ?$(?EU(B)
 ("]n" ?$(?EX(B)
 ("]nj" ?$(?EZ(B)
 ("]nh" ?$(?E[(B)
 ("]nU" ?$(?E\(B)
 ("]nJ" ?$(?E](B)
 ("]6" ?$(?E`(B)
 ("]6j" ?$(?Eb(B)
 ("]6h" ?$(?Ec(B)
 ("]6U" ?$(?Ed(B)
 ("]6J" ?$(?Ee(B)
 ("]^" ?$(?Eh(B)
 ("]^j" ?$(?Ej(B)
 ("]^h" ?$(?Ek(B)
 ("]^U" ?$(?El(B)
 ("]^J" ?$(?Em(B)
 (";" ?$(?G0(B)
 (";H" ?$(?G1(B)
 (";j" ?$(?G2(B)
 (";h" ?$(?G3(B)
 (";U" ?$(?G4(B)
 (";J" ?$(?G5(B)
 (";N" ?$(?G6(B)
 (";!" ?$(?G7(B)
 (";y" ?$(?G8(B)
 (";yj" ?$(?G:(B)
 (";yh" ?$(?G;(B)
 (";yU" ?$(?G<(B)
 (";yJ" ?$(?G=(B)
 (";b" ?$(?G@(B)
 (";bj" ?$(?GB(B)
 (";bh" ?$(?GC(B)
 (";bU" ?$(?GD(B)
 (";bJ" ?$(?GE(B)
 (";u" ?$(?GH(B)
 (";uj" ?$(?GJ(B)
 (";uh" ?$(?GK(B)
 (";uU" ?$(?GL(B)
 (";uJ" ?$(?GM(B)
 (";7" ?$(?GP(B)
 (";7j" ?$(?GR(B)
 (";7h" ?$(?GS(B)
 (";7U" ?$(?GT(B)
 (";7J" ?$(?GU(B)
 (";n" ?$(?GX(B)
 (";nj" ?$(?GZ(B)
 (";nh" ?$(?G[(B)
 (";nU" ?$(?G\(B)
 (";nJ" ?$(?G](B)
 (";6" ?$(?G`(B)
 (";6j" ?$(?Gb(B)
 (";6h" ?$(?Gc(B)
 (";6U" ?$(?Gd(B)
 (";6J" ?$(?Ge(B)
 (";^" ?$(?Gh(B)
 (";^j" ?$(?Gj(B)
 (";^h" ?$(?Gk(B)
 (";^U" ?$(?Gl(B)
 (";^J" ?$(?Gm(B)
 (";\"" ?$(?Gp(B)
 (";M" ?$(?Gx(B)
 ("L" ?$(?H0(B)
 ("LH" ?$(?H1(B)
 ("Lj" ?$(?H2(B)
 ("Lh" ?$(?H3(B)
 ("LN" ?$(?H6(B)
 ("Ly" ?$(?H8(B)
 ("Lyj" ?$(?H:(B)
 ("Lyh" ?$(?H;(B)
 ("Lb" ?$(?H@(B)
 ("Lbj" ?$(?HB(B)
 ("Lbh" ?$(?HC(B)
 ("Lu" ?$(?HH(B)
 ("Luj" ?$(?HJ(B)
 ("Luh" ?$(?HK(B)
 ("L7" ?$(?HP(B)
 ("L7j" ?$(?HR(B)
 ("L7h" ?$(?HS(B)
 ("Ln" ?$(?HX(B)
 ("Lnj" ?$(?HZ(B)
 ("Lnh" ?$(?H[(B)
 ("L6" ?$(?H`(B)
 ("L6j" ?$(?Hb(B)
 ("L6h" ?$(?Hc(B)
 ("L^" ?$(?Hh(B)
 ("L^j" ?$(?Hj(B)
 ("L^h" ?$(?Hk(B)
 ("K" ?$(?I0(B)
 ("KH" ?$(?I1(B)
 ("Kj" ?$(?I2(B)
 ("Kh" ?$(?I3(B)
 ("KN" ?$(?I6(B)
 ("Ky" ?$(?I8(B)
 ("Kyj" ?$(?I:(B)
 ("Kyh" ?$(?I;(B)
 ("Kb" ?$(?I@(B)
 ("Kbj" ?$(?IB(B)
 ("Kbh" ?$(?IC(B)
 ("Ku" ?$(?IH(B)
 ("Kuj" ?$(?IJ(B)
 ("Kuh" ?$(?IK(B)
 ("K7" ?$(?IP(B)
 ("K7j" ?$(?IR(B)
 ("K7h" ?$(?IS(B)
 ("Kn" ?$(?IX(B)
 ("Knj" ?$(?IZ(B)
 ("Knh" ?$(?I[(B)
 ("K6" ?$(?I`(B)
 ("K6j" ?$(?Ib(B)
 ("K6h" ?$(?Ic(B)
 ("K^" ?$(?Ih(B)
 ("K^j" ?$(?Ij(B)
 ("K^h" ?$(?Ik(B)
 ("l" ?$(?J0(B)
 ("lH" ?$(?J1(B)
 ("lj" ?$(?J2(B)
 ("lh" ?$(?J3(B)
 ("lN" ?$(?J6(B)
 ("ly" ?$(?J8(B)
 ("lyj" ?$(?J:(B)
 ("lyh" ?$(?J;(B)
 ("lb" ?$(?J@(B)
 ("lbj" ?$(?JB(B)
 ("lbh" ?$(?JC(B)
 ("lu" ?$(?JH(B)
 ("luj" ?$(?JJ(B)
 ("luh" ?$(?JK(B)
 ("l7" ?$(?JP(B)
 ("l7j" ?$(?JR(B)
 ("l7h" ?$(?JS(B)
 ("ln" ?$(?JX(B)
 ("lnj" ?$(?JZ(B)
 ("lnh" ?$(?J[(B)
 ("l6" ?$(?J`(B)
 ("l6j" ?$(?Jb(B)
 ("l6h" ?$(?Jc(B)
 ("l^" ?$(?Jh(B)
 ("l^j" ?$(?Jj(B)
 ("l^h" ?$(?Jk(B)
 ("s" ?$(?K0(B)
 ("sH" ?$(?K1(B)
 ("sj" ?$(?K2(B)
 ("sh" ?$(?K3(B)
 ("sN" ?$(?K6(B)
 ("sy" ?$(?K8(B)
 ("syj" ?$(?K:(B)
 ("syh" ?$(?K;(B)
 ("sb" ?$(?K@(B)
 ("sbj" ?$(?KB(B)
 ("sbh" ?$(?KC(B)
 ("su" ?$(?KH(B)
 ("suj" ?$(?KJ(B)
 ("suh" ?$(?KK(B)
 ("s7" ?$(?KP(B)
 ("s7j" ?$(?KR(B)
 ("s7h" ?$(?KS(B)
 ("sn" ?$(?KX(B)
 ("snj" ?$(?KZ(B)
 ("snh" ?$(?K[(B)
 ("s6" ?$(?K`(B)
 ("s6j" ?$(?Kb(B)
 ("s6h" ?$(?Kc(B)
 ("s^" ?$(?Kh(B)
 ("s^j" ?$(?Kj(B)
 ("s^h" ?$(?Kk(B)
 (">" ?$(?L0(B)
 (">H" ?$(?L1(B)
 (">j" ?$(?L2(B)
 (">h" ?$(?L3(B)
 (">U" ?$(?L4(B)
 (">J" ?$(?L5(B)
 (">N" ?$(?L6(B)
 (">y" ?$(?L8(B)
 (">yj" ?$(?L:(B)
 (">yh" ?$(?L;(B)
 (">yU" ?$(?L<(B)
 (">yJ" ?$(?L=(B)
 (">b" ?$(?L@(B)
 (">bj" ?$(?LB(B)
 (">bh" ?$(?LC(B)
 (">bU" ?$(?LD(B)
 (">bJ" ?$(?LE(B)
 (">u" ?$(?LH(B)
 (">uj" ?$(?LJ(B)
 (">uh" ?$(?LK(B)
 (">uU" ?$(?LL(B)
 (">uJ" ?$(?LM(B)
 (">7" ?$(?LP(B)
 (">7j" ?$(?LR(B)
 (">7h" ?$(?LS(B)
 (">7U" ?$(?LT(B)
 (">7J" ?$(?LU(B)
 (">n" ?$(?LX(B)
 (">nj" ?$(?LZ(B)
 (">nh" ?$(?L[(B)
 (">nU" ?$(?L\(B)
 (">nJ" ?$(?L](B)
 (">6" ?$(?L`(B)
 (">6j" ?$(?Lb(B)
 (">6h" ?$(?Lc(B)
 (">6U" ?$(?Ld(B)
 (">6J" ?$(?Le(B)
 (">^" ?$(?Lh(B)
 (">^j" ?$(?Lj(B)
 (">^h" ?$(?Lk(B)
 (">^U" ?$(?Ll(B)
 (">^J" ?$(?Lm(B)
 ("v" ?$(?M0(B)
 ("vH" ?$(?M1(B)
 ("vj" ?$(?M2(B)
 ("vh" ?$(?M3(B)
 ("vU" ?$(?M4(B)
 ("vJ" ?$(?M5(B)
 ("vN" ?$(?M6(B)
 ("vy" ?$(?M8(B)
 ("vyj" ?$(?M:(B)
 ("vyh" ?$(?M;(B)
 ("vyU" ?$(?M<(B)
 ("vyJ" ?$(?M=(B)
 ("vb" ?$(?M@(B)
 ("vbj" ?$(?MB(B)
 ("vbh" ?$(?MC(B)
 ("vbU" ?$(?MD(B)
 ("vbJ" ?$(?ME(B)
 ("vu" ?$(?MH(B)
 ("vuj" ?$(?MJ(B)
 ("vuh" ?$(?MK(B)
 ("vuU" ?$(?ML(B)
 ("vuJ" ?$(?MM(B)
 ("v7" ?$(?MP(B)
 ("v7j" ?$(?MR(B)
 ("v7h" ?$(?MS(B)
 ("v7U" ?$(?MT(B)
 ("v7J" ?$(?MU(B)
 ("vn" ?$(?MX(B)
 ("vnj" ?$(?MZ(B)
 ("vnh" ?$(?M[(B)
 ("vnU" ?$(?M\(B)
 ("vnJ" ?$(?M](B)
 ("v6" ?$(?M`(B)
 ("v6j" ?$(?Mb(B)
 ("v6h" ?$(?Mc(B)
 ("v6U" ?$(?Md(B)
 ("v6J" ?$(?Me(B)
 ("v^" ?$(?Mh(B)
 ("v^j" ?$(?Mj(B)
 ("v^h" ?$(?Mk(B)
 ("v^U" ?$(?Ml(B)
 ("v^J" ?$(?Mm(B)
 ("V" ?$(?N0(B)
 ("VH" ?$(?N1(B)
 ("Vj" ?$(?N2(B)
 ("Vh" ?$(?N3(B)
 ("VU" ?$(?N4(B)
 ("VN" ?$(?N6(B)
 ("Vy" ?$(?N8(B)
 ("Vyj" ?$(?N:(B)
 ("Vyh" ?$(?N;(B)
 ("VyU" ?$(?N<(B)
 ("Vb" ?$(?N@(B)
 ("Vbj" ?$(?NB(B)
 ("Vbh" ?$(?NC(B)
 ("VbU" ?$(?ND(B)
 ("Vu" ?$(?NH(B)
 ("Vuj" ?$(?NJ(B)
 ("Vuh" ?$(?NK(B)
 ("VuU" ?$(?NL(B)
 ("V7" ?$(?NP(B)
 ("V7j" ?$(?NR(B)
 ("V7h" ?$(?NS(B)
 ("V7U" ?$(?NT(B)
 ("Vn" ?$(?NX(B)
 ("Vnj" ?$(?NZ(B)
 ("Vnh" ?$(?N[(B)
 ("VnU" ?$(?N\(B)
 ("V6" ?$(?N`(B)
 ("V6j" ?$(?Nb(B)
 ("V6h" ?$(?Nc(B)
 ("V6U" ?$(?Nd(B)
 ("V^" ?$(?Nh(B)
 ("V^j" ?$(?Nj(B)
 ("V^h" ?$(?Nk(B)
 ("V^U" ?$(?Nl(B)
 ("O" ?$(?O0(B)
 ("t" ?$(?P0(B)
 ("y" ?$(?Q0(B)
 ("k" ?$(?R0(B)
 ("e" ?$(?S0(B)
 ("b" ?$(?T0(B)
 ("u" ?$(?U0(B)
 ("7" ?$(?V0(B)
 ("6" ?$(?X0(B)
 ("^" ?$(?Y0(B)
 ("\"" ?$(?Z0(B)
;(" " ?$(?_0(B)
 ("g" ?$(?`0(B)
 ("c" ?$(?a0(B)
 ("F" ?$(?b0(B)
 ("." ?$(?c0(B)
 ("w" ?$(?d0(B)
 ("q" ?$(?f0(B)
 ("H" ?$(?g0(B)
 ("j" ?$(?h0(B)
 ("h" ?$(?i0(B)
 ("U" ?$(?j0(B)
 ("J" ?$(?k0(B)
 ("N" ?$(?l0(B)
 ("!" ?$(?m0(B)
;(" " ?$(?o0(B)
 ("Q" ?$(?p0(B)
 ("@" ?$(?q0(B)
 ("#" ?$(?r0(B)
 ("$" ?$(?s0(B)
 ("%" ?$(?t0(B)
 ("*" ?$(?u0(B)
 ("(" ?$(?v0(B)
 (")" ?$(?w0(B)
 ("_" ?$(?x0(B)
 ("+" ?$(?y0(B)

;;; The following characters are newly added.

 ("d!" ?$(?!7(B)
 ("d\"" ?$(?!p(B)
 ("dM" ?$(?!x(B)
 ("-!" ?$(?"7(B)
 ("-\"" ?$(?"p(B)
 ("-M" ?$(?"x(B)
 ("`" ?$(?#0(B)
 ("`H" ?$(?#1(B)
 ("`j" ?$(?#2(B)
 ("`h" ?$(?#3(B)
 ("`N" ?$(?#6(B)
 ("`!" ?$(?#7(B)
 ("`y" ?$(?#8(B)
 ("`yj" ?$(?#:(B)
 ("`yh" ?$(?#;(B)
 ("`b" ?$(?#@(B)
 ("`bj" ?$(?#B(B)
 ("`bh" ?$(?#C(B)
 ("`u" ?$(?#H(B)
 ("`uj" ?$(?#J(B)
 ("`uh" ?$(?#K(B)
 ("`7" ?$(?#P(B)
 ("`7j" ?$(?#R(B)
 ("`7h" ?$(?#S(B)
 ("`n" ?$(?#X(B)
 ("`nj" ?$(?#Z(B)
 ("`nh" ?$(?#[(B)
 ("`6" ?$(?#`(B)
 ("`6j" ?$(?#b(B)
 ("`6h" ?$(?#c(B)
 ("`^" ?$(?#h(B)
 ("`^j" ?$(?#j(B)
 ("`^h" ?$(?#k(B)
 ("`\"" ?$(?#p(B)
 ("`M" ?$(?#x(B)
 ("8!" ?$(?$7(B)
 ("8\"" ?$(?$p(B)
 ("8M" ?$(?$x(B)
 ("~" ?$(?%0(B)
 ("~H" ?$(?%1(B)
 ("~j" ?$(?%2(B)
 ("~h" ?$(?%3(B)
 ("~U" ?$(?%4(B)
 ("~N" ?$(?%6(B)
 ("~!" ?$(?%7(B)
 ("~y" ?$(?%8(B)
 ("~yj" ?$(?%:(B)
 ("~yh" ?$(?%;(B)
 ("~yU" ?$(?%<(B)
 ("~b" ?$(?%@(B)
 ("~bj" ?$(?%B(B)
 ("~bh" ?$(?%C(B)
 ("~bU" ?$(?%D(B)
 ("~u" ?$(?%H(B)
 ("~uj" ?$(?%J(B)
 ("~uh" ?$(?%K(B)
 ("~uU" ?$(?%L(B)
 ("~7" ?$(?%P(B)
 ("~7j" ?$(?%R(B)
 ("~7h" ?$(?%S(B)
 ("~7U" ?$(?%T(B)
 ("~n" ?$(?%X(B)
 ("~nj" ?$(?%Z(B)
 ("~nh" ?$(?%[(B)
 ("~nU" ?$(?%\(B)
 ("~6" ?$(?%`(B)
 ("~6j" ?$(?%b(B)
 ("~6h" ?$(?%c(B)
 ("~6U" ?$(?%d(B)
 ("~^" ?$(?%h(B)
 ("~^j" ?$(?%j(B)
 ("~^h" ?$(?%k(B)
 ("~^U" ?$(?%l(B)
 ("~\"" ?$(?%p(B)
 ("~M" ?$(?%x(B)
 ("S!" ?$(?&7(B)
 ("S\"" ?$(?&p(B)
 ("SM" ?$(?&x(B)
 ("'!" ?$(?'7(B)
 ("'\"" ?$(?'p(B)
 ("'M" ?$(?'x(B)
 ("0!" ?$(?(7(B)
 ("0\"" ?$(?(p(B)
 ("0M" ?$(?(x(B)
 ("C!" ?$(?)7(B)
 ("C\"" ?$(?)p(B)
 ("CM" ?$(?)x(B)
 ("=!" ?$(?*7(B)
 ("=\"" ?$(?*p(B)
 ("=M" ?$(?*x(B)
 (":!" ?$(?+7(B)
 (":\"" ?$(?+p(B)
 (":M" ?$(?+x(B)
 ("G!" ?$(?,7(B)
 ("G\"" ?$(?,p(B)
 ("GM" ?$(?,x(B)
 ("P!" ?$(?-7(B)
 ("P\"" ?$(?-p(B)
 ("PM" ?$(?-x(B)
 ("E!" ?$(?.7(B)
 ("E\"" ?$(?.p(B)
 ("EM" ?$(?.x(B)
 ("E!" ?$(?/7(B)
 ("E\"" ?$(?/p(B)
 ("EM" ?$(?/x(B)
 ("{!" ?$(?07(B)
 ("{\"" ?$(?0p(B)
 ("{M" ?$(?0x(B)
 ("R!" ?$(?17(B)
 ("R\"" ?$(?1p(B)
 ("RM" ?$(?1x(B)
 ("<!" ?$(?27(B)
 ("<\"" ?$(?2p(B)
 ("<M" ?$(?2x(B)
 ("I!" ?$(?37(B)
 ("I\"" ?$(?3p(B)
 ("IM" ?$(?3x(B)
 ("f!" ?$(?47(B)
 ("f\"" ?$(?4p(B)
 ("fM" ?$(?4x(B)
 ("9!" ?$(?57(B)
 ("9\"" ?$(?5p(B)
 ("9M" ?$(?5x(B)
 ("5!" ?$(?67(B)
 ("5\"" ?$(?6p(B)
 ("5M" ?$(?6x(B)
 ("m!" ?$(?77(B)
 ("m\"" ?$(?7p(B)
 ("mM" ?$(?7x(B)
 ("T!" ?$(?87(B)
 ("T\"" ?$(?8p(B)
 ("TM" ?$(?8x(B)
 ("o!" ?$(?97(B)
 ("o\"" ?$(?9p(B)
 ("oM" ?$(?9x(B)
 ("[!" ?$(?:7(B)
 ("[\"" ?$(?:p(B)
 ("[M" ?$(?:x(B)
 ("x!" ?$(?;7(B)
 ("x\"" ?$(?;p(B)
 ("xM" ?$(?;x(B)
 ("z!" ?$(?<7(B)
 ("z\"" ?$(?<p(B)
 ("zM" ?$(?<x(B)
 ("/!" ?$(?=7(B)
 ("/\"" ?$(?=p(B)
 ("/M" ?$(?=x(B)
 ("r!" ?$(?>7(B)
 ("r\"" ?$(?>p(B)
 ("rM" ?$(?>x(B)
 ("a!" ?$(??7(B)
 ("a\"" ?$(??p(B)
 ("aM" ?$(??x(B)
 ("4!" ?$(?@7(B)
 ("4\"" ?$(?@p(B)
 ("4M" ?$(?@x(B)
 (",!" ?$(?A7(B)
 (",\"" ?$(?Ap(B)
 (",M" ?$(?Ax(B)
 ("p!" ?$(?B7(B)
 ("p\"" ?$(?Bp(B)
 ("pM" ?$(?Bx(B)
 ("i!" ?$(?C7(B)
 ("i\"" ?$(?Cp(B)
 ("iM" ?$(?Cx(B)
 ("]!" ?$(?E7(B)
 ("]\"" ?$(?Ep(B)
 ("]M" ?$(?Ex(B)
 ("?" ?$(?F0(B)
 ("L!" ?$(?H7(B)
 ("L\"" ?$(?Hp(B)
 ("LM" ?$(?Hx(B)
 ("K!" ?$(?I7(B)
 ("K\"" ?$(?Ip(B)
 ("KM" ?$(?Ix(B)
 ("l!" ?$(?J7(B)
 ("l\"" ?$(?Jp(B)
 ("lM" ?$(?Jx(B)
 ("s!" ?$(?K7(B)
 ("s\"" ?$(?Kp(B)
 ("sM" ?$(?Kx(B)
 (">!" ?$(?L7(B)
 (">\"" ?$(?Lp(B)
 (">M" ?$(?Lx(B)
 ("v!" ?$(?M7(B)
 ("v\"" ?$(?Mp(B)
 ("vM" ?$(?Mx(B)
 ("V!" ?$(?N7(B)
 ("V\"" ?$(?Np(B)
 ("VM" ?$(?Nx(B)
 ("n" ?$(?W0(B)
 ("M" ?$(?n0(B)
 )

(defun quail-thai-update-translation (control-flag)
  "Combine vowel signs and tone marks with the preceding consonant.
Combination occurs even the consonant is out of the current quail sequence."

  (let (start end keyseq)
    (cond

     ((numberp control-flag)
      (setq start (overlay-start quail-overlay)
	    end (overlay-end quail-overlay))
      (insert (or quail-current-str quail-current-key))
      (if (and start end) (delete-region start end))
      (setq unread-command-events
	    (cons (character-to-event (aref quail-current-key control-flag))
		  unread-command-events)))

     ((or (null control-flag)
	  (> (length quail-current-key) 1))
      (setq start (overlay-start quail-overlay)
	    end (overlay-end quail-overlay))
      (insert (or quail-current-str quail-current-key))
      (if (and start end) (delete-region start end)))

   ;; hereafter control-flag == t && (length quail-current-key) == 1

     ((char-equal (aref quail-current-key 0) ?k) ; k is for sara aa
      (setq start (overlay-start quail-overlay)
	    end (overlay-end quail-overlay))
      (if (memq (char-before) '(?$(?D0(B ?$(?F0(B)) ; ru / lu
	  (insert ?$(?e0(B)			; lak khang yao
	(insert ?$(?R0(B)))			; sara aa

     ((setq keyseq (cdr (assq (char-before) thai-reverse-map)))
      (if (quail-lookup-key (concat keyseq quail-current-key))
	  (progn
	    (setq unread-command-events
		  (append 
		   ;; the following mapcar means string-to-char-list
		   (mapcar (function (lambda (x) (character-to-event x)))
			   keyseq)
		   (list (character-to-event (aref quail-current-key 0)))
		   unread-command-events))
	    (delete-backward-char 1))
	(insert quail-current-str)))

     (t
      (insert (or quail-current-str quail-current-key))))))

;;
(provide 'thai-xtis)

;;; thai-xtis.el ends here
