/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CheckStyleTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private Path mClasspath;
    private String mFileName;
    private String mConfigLocation;
    private File mPackageNamesFile = null;
    private boolean mFailOnViolation = true;
    private String mFailureProperty = null;
    private final List mFileSets = new ArrayList();
    private final List mFormatters = new ArrayList();
    private final List mOverrideProps = new ArrayList();
    private File mPropertiesFile;

    public void setFailureProperty(String aPropertyName) {
        this.mFailureProperty = aPropertyName;
    }

    public void setFailOnViolation(boolean aFail) {
        this.mFailOnViolation = aFail;
    }

    public void addFileset(FileSet aFS) {
        this.mFileSets.add(aFS);
    }

    public void addFormatter(Formatter aFormatter) {
        this.mFormatters.add(aFormatter);
    }

    public void addProperty(Property aProperty) {
        this.mOverrideProps.add(aProperty);
    }

    public void setClasspath(Path aClasspath) {
        this.mClasspath = aClasspath;
    }

    public Path createClasspath() {
        if (this.mClasspath == null) {
            this.mClasspath = new Path(this.getProject());
        }
        return this.mClasspath.createPath();
    }

    public void setFile(File aFile) {
        this.mFileName = aFile.getAbsolutePath();
    }

    public void setConfig(File aFile) {
        this.setConfigLocation(aFile.getAbsolutePath());
    }

    public void setConfigURL(URL aURL) {
        this.setConfigLocation(aURL.toExternalForm());
    }

    private void setConfigLocation(String aLocation) {
        if (this.mConfigLocation != null) {
            throw new BuildException("Attributes 'config' and 'configURL' must not be set at the same time");
        }
        this.mConfigLocation = aLocation;
    }

    public void setPackageNamesFile(File aFile) {
        this.mPackageNamesFile = aFile;
    }

    public void setProperties(File aProps) {
        this.mPropertiesFile = aProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation");
        String version = compilationProperties.getString("checkstyle.compile.version");
        String compileTimestamp = compilationProperties.getString("checkstyle.compile.timestamp");
        this.log("checkstyle version " + version, 3);
        this.log("compiled on " + compileTimestamp, 3);
        if (this.mFileName == null && this.mFileSets.size() == 0) {
            throw new BuildException("Must specify atleast one of 'file' or nested 'fileset'.", this.getLocation());
        }
        if (this.mConfigLocation == null) {
            throw new BuildException("Must specify 'config'.", this.getLocation());
        }
        Checker c = null;
        try {
            try {
                Properties props = this.createOverridingProperties();
                Configuration config = ConfigurationLoader.loadConfiguration(this.mConfigLocation, new PropertiesExpander(props));
                DefaultContext context = new DefaultContext();
                AntClassLoader loader = new AntClassLoader(this.getProject(), this.mClasspath);
                context.add("classloader", loader);
                c = new Checker();
                if (this.mPackageNamesFile != null) {
                    ModuleFactory moduleFactory = PackageNamesLoader.loadModuleFactory(this.mPackageNamesFile.getAbsolutePath());
                    c.setModuleFactory(moduleFactory);
                }
                c.contextualize(context);
                c.configure(config);
                AuditListener[] listeners = this.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    c.addListener(listeners[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BuildException("Unable to create a Checker: " + e.getMessage(), (Throwable)e);
            }
            File[] files = this.scanFileSets();
            int numErrs = c.process(files);
            if (numErrs > 0 && this.mFailureProperty != null) {
                this.getProject().setProperty(this.mFailureProperty, "true");
            }
            if (numErrs > 0 && this.mFailOnViolation) {
                throw new BuildException("Got " + numErrs + " errors.", this.getLocation());
            }
            Object var12_13 = null;
            if (c != null) {
                c.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (c != null) {
                c.destroy();
            }
            throw throwable;
        }
    }

    private Properties createOverridingProperties() {
        Properties retVal = new Properties();
        if (this.mPropertiesFile != null) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.mPropertiesFile);
                retVal.load(inStream);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Could not find Properties file '" + this.mPropertiesFile + "'", (Throwable)e, this.getLocation());
            }
            catch (IOException e) {
                throw new BuildException("Error loading Properties file '" + this.mPropertiesFile + "'", (Throwable)e, this.getLocation());
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    throw new BuildException("Error closing Properties file '" + this.mPropertiesFile + "'", (Throwable)e, this.getLocation());
                }
            }
        }
        Hashtable antProps = this.getProject().getProperties();
        Iterator it = antProps.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = String.valueOf(antProps.get(key));
            retVal.put(key, value);
        }
        Iterator it2 = this.mOverrideProps.iterator();
        while (it2.hasNext()) {
            Property p = (Property)it2.next();
            retVal.put(p.getKey(), p.getValue());
        }
        return retVal;
    }

    protected AuditListener[] getListeners() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        int listenerCount = Math.max(1, this.mFormatters.size());
        AuditListener[] listeners = new AuditListener[listenerCount];
        if (this.mFormatters.size() == 0) {
            LogOutputStream debug = new LogOutputStream((Task)this, 4);
            LogOutputStream err = new LogOutputStream((Task)this, 0);
            listeners[0] = new DefaultLogger((OutputStream)debug, true, (OutputStream)err, true);
            return listeners;
        }
        int i = 0;
        while (i < listeners.length) {
            Formatter f = (Formatter)this.mFormatters.get(i);
            listeners[i] = f.createListener(this);
            ++i;
        }
        return listeners;
    }

    protected File[] scanFileSets() {
        ArrayList<File> list = new ArrayList<File>();
        if (this.mFileName != null) {
            this.log("Adding standalone file for audit", 3);
            list.add(new File(this.mFileName));
        }
        int i = 0;
        while (i < this.mFileSets.size()) {
            FileSet fs = (FileSet)this.mFileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] names = ds.getIncludedFiles();
            this.log(i + ") Adding " + names.length + " files from directory " + ds.getBasedir(), 3);
            int j = 0;
            while (j < names.length) {
                String pathname = ds.getBasedir() + File.separator + names[j];
                list.add(new File(pathname));
                ++j;
            }
            ++i;
        }
        return list.toArray(new File[0]);
    }

    public static class Property {
        private String mKey;
        private String mValue;

        public String getKey() {
            return this.mKey;
        }

        public void setKey(String aKey) {
            this.mKey = aKey;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String aValue) {
            this.mValue = aValue;
        }

        public void setFile(File aValue) {
            this.setValue(aValue.getAbsolutePath());
        }
    }

    public static class Formatter {
        private FormatterType mFormatterType = null;
        private File mToFile = null;

        public void setType(FormatterType aType) {
            String val = aType.getValue();
            if (!CheckStyleTask.E_XML.equals(val) && !CheckStyleTask.E_PLAIN.equals(val)) {
                throw new BuildException("Invalid formatter type: " + val);
            }
            this.mFormatterType = aType;
        }

        public void setTofile(File aTo) {
            this.mToFile = aTo;
        }

        public AuditListener createListener(Task aTask) throws IOException {
            if (this.mFormatterType != null && CheckStyleTask.E_XML.equals(this.mFormatterType.getValue())) {
                return this.createXMLLogger(aTask);
            }
            return this.createDefaultLogger(aTask);
        }

        private AuditListener createDefaultLogger(Task aTask) throws IOException {
            if (this.mToFile == null) {
                return new DefaultLogger((OutputStream)new LogOutputStream(aTask, 4), true, (OutputStream)new LogOutputStream(aTask, 0), true);
            }
            return new DefaultLogger(new FileOutputStream(this.mToFile), true);
        }

        private AuditListener createXMLLogger(Task aTask) throws IOException {
            if (this.mToFile == null) {
                return new XMLLogger((OutputStream)new LogOutputStream(aTask, 2), true);
            }
            return new XMLLogger(new FileOutputStream(this.mToFile), true);
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

