/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEvent;
import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class Checker
extends AutomaticBean
implements MessageDispatcher {
    private final ErrorCounter mCounter = new ErrorCounter();
    private final ArrayList mListeners = new ArrayList();
    private final ArrayList mFileSetChecks = new ArrayList();
    private ClassLoader mLoader = Thread.currentThread().getContextClassLoader();
    private String mBasedir;
    private String mLocaleCountry = Locale.getDefault().getCountry();
    private String mLocaleLanguage = Locale.getDefault().getLanguage();
    private ModuleFactory mModuleFactory;
    private Context mChildContext;
    private SeverityLevel mSeverityLevel = SeverityLevel.ERROR;

    public Checker() throws CheckstyleException {
        this.addListener(this.mCounter);
    }

    public void finishLocalSetup() throws CheckstyleException {
        Locale locale = new Locale(this.mLocaleLanguage, this.mLocaleCountry);
        LocalizedMessage.setLocale(locale);
        if (this.mModuleFactory == null) {
            this.mModuleFactory = PackageNamesLoader.loadModuleFactory(this.getClass().getClassLoader());
        }
        DefaultContext context = new DefaultContext();
        context.add("classLoader", this.mLoader);
        context.add("moduleFactory", this.mModuleFactory);
        context.add("severity", this.mSeverityLevel.getName());
        this.mChildContext = context;
    }

    protected void setupChild(Configuration aChildConf) throws CheckstyleException {
        String name = aChildConf.getName();
        try {
            Object module = this.mModuleFactory.createModule(name);
            if (!(module instanceof FileSetCheck)) {
                throw new CheckstyleException(name + " is not allowed as a module in Checker");
            }
            FileSetCheck fsc = (FileSetCheck)module;
            fsc.contextualize(this.mChildContext);
            fsc.configure(aChildConf);
            this.addFileSetCheck(fsc);
        }
        catch (Exception ex) {
            throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
    }

    public void addFileSetCheck(FileSetCheck aFileSetCheck) {
        aFileSetCheck.setMessageDispatcher(this);
        this.mFileSetChecks.add(aFileSetCheck);
    }

    public void destroy() {
        this.mListeners.clear();
    }

    public void addListener(AuditListener aListener) {
        this.mListeners.add(aListener);
    }

    public int process(File[] aFiles) {
        this.fireAuditStarted();
        int i = 0;
        while (i < this.mFileSetChecks.size()) {
            FileSetCheck fileSetCheck = (FileSetCheck)this.mFileSetChecks.get(i);
            fileSetCheck.process(aFiles);
            fileSetCheck.destroy();
            ++i;
        }
        int errorCount = this.mCounter.getCount();
        this.fireAuditFinished();
        return errorCount;
    }

    private String getStrippedFileName(String aFileName) {
        String stripped;
        if (this.mBasedir == null || !aFileName.startsWith(this.mBasedir)) {
            stripped = aFileName;
        } else {
            int skipSep = this.mBasedir.endsWith(File.separator) ? 0 : 1;
            stripped = aFileName.substring(this.mBasedir.length() + skipSep);
        }
        return stripped;
    }

    public void setBasedir(String aBasedir) {
        this.mBasedir = aBasedir;
    }

    protected void fireAuditStarted() {
        AuditEvent evt = new AuditEvent(this);
        Iterator it = this.mListeners.iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.auditStarted(evt);
        }
    }

    protected void fireAuditFinished() {
        AuditEvent evt = new AuditEvent(this);
        Iterator it = this.mListeners.iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.auditFinished(evt);
        }
    }

    public void fireFileStarted(String aFileName) {
        String stripped = this.getStrippedFileName(aFileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        Iterator it = this.mListeners.iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.fileStarted(evt);
        }
    }

    public void fireFileFinished(String aFileName) {
        String stripped = this.getStrippedFileName(aFileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        Iterator it = this.mListeners.iterator();
        while (it.hasNext()) {
            AuditListener listener = (AuditListener)it.next();
            listener.fileFinished(evt);
        }
    }

    public void fireErrors(String aFileName, LocalizedMessage[] aErrors) {
        String stripped = this.getStrippedFileName(aFileName);
        int i = 0;
        while (i < aErrors.length) {
            AuditEvent evt = new AuditEvent(this, stripped, aErrors[i]);
            Iterator it = this.mListeners.iterator();
            while (it.hasNext()) {
                AuditListener listener = (AuditListener)it.next();
                listener.addError(evt);
            }
            ++i;
        }
    }

    public void setModuleFactory(ModuleFactory aModuleFactory) {
        this.mModuleFactory = aModuleFactory;
    }

    public void setLocaleCountry(String aLocaleCountry) {
        this.mLocaleCountry = aLocaleCountry;
    }

    public void setLocaleLanguage(String aLocaleLanguage) {
        this.mLocaleLanguage = aLocaleLanguage;
    }

    public final void setSeverity(String aSeverity) {
        this.mSeverityLevel = SeverityLevel.getInstance(aSeverity);
    }

    public final void setClassloader(ClassLoader aLoader) {
        this.mLoader = aLoader;
    }

    private class ErrorCounter
    implements AuditListener {
        private int mCount = 0;

        private ErrorCounter() {
        }

        public void addError(AuditEvent aEvt) {
            if (SeverityLevel.ERROR.equals(aEvt.getSeverityLevel())) {
                ++this.mCount;
            }
        }

        public void addException(AuditEvent aEvt, Throwable aThrowable) {
            ++this.mCount;
        }

        public void auditStarted(AuditEvent aEvt) {
            this.mCount = 0;
        }

        public void fileStarted(AuditEvent aEvt) {
        }

        public void auditFinished(AuditEvent aEvt) {
        }

        public void fileFinished(AuditEvent aEvt) {
        }

        private int getCount() {
            return this.mCount;
        }
    }
}

