#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#if SYSV
#  if SYSVR3
#    include <sys/unistd.h>
#  endif
#else
#  include <sys/file.h>
#endif

#ifndef R_OK
#define R_OK    4       /* test for read permission */
#define W_OK    2       /* test for write permission */
#define X_OK    1       /* test for execute (search) permission */
#define F_OK    0       /* test for presence of file */
#endif   

#if !defined(SUNOS_4)
extern char *strdup();
#endif

char *resolve_name(ro_path, name)
char *ro_path;
char *name;
{
   char file_name[MAXPATHLEN + 1];
   int name_len;
   char *p;
   char *path;
   char *pathbufp;

   if (name == (char *) NULL || *name == '\0')
      return (char *) NULL;

   if (ro_path == (char *) NULL || *name == '/')
      return (strdup(name));

   if ((pathbufp = path = strdup(ro_path)) == (char *) NULL)
      return (char *) NULL;

   name_len = strlen(name);

   while (*pathbufp != '\0') {
      if ((p = strchr(pathbufp, ':')) != (char *) NULL)
         *p = '\0';
      if (*pathbufp != '\0') {
	 if ((strlen(pathbufp) + name_len + 1) <= MAXPATHLEN) {
	     (void) sprintf(file_name, "%s/%s", pathbufp, name);
	     if (access(file_name, R_OK) == 0) {
		 name = file_name;
		 break;
	     }
	 }
      }
      if (p == (char *) NULL)
         break;
      pathbufp = p + 1;
   }

   free(path);
   return strdup(name);
}
