/* ----------------------------------------------------------------------
 * FILE: rh.h
 * VERSION: 2
 * Written by: Ken Stauffer
 * VERSION 2.8
 * Enhancements and bug fixes by Rick Ohnemus
 * 
 * This header contains the #define's for the tokens.
 * It also contains structure definitions.
 * 
 * ---------------------------------------------------------------------- */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>

#ifndef SUNOS_4
typedef int gid_t;
typedef int uid_t;
#endif

extern char *getenv();
extern char *malloc();

#ifndef FALSE
#define FALSE	0
#endif

#ifndef TRUE
#define TRUE	1
#endif


#define RHRC		".rhrc"		/* start up file */
#define RHENV		"RH"		/* rh environment variable */
#define RHPATHENV	"RHPATH"	/* paths to search for program files */
#define HOMEENV		"HOME"		/* path to your home directory */

/* Definition of returned tokens from the lexical analyzer */

#define OR		256	/* || */
#define AND		257	/* && */
#define LE		258	/* <= */
#define GE		259	/* >= */
#define NE		260	/* != */
#define EQ		261	/* == */
#define SHIFTL		262	/* << */
#define SHIFTR		263	/* >> */
#define NOP		264	/* no-operation */
#define NUMBER		265	/* literal numbers and symbolic constants */
#define STR		266	/* regular expression strings */
#define FIELD		267	/* file fields (size,mode,nlinks) */
#define FUNCTION	268	/* user defined function */
#define RETURN		269	/* return keyword */
#define PARAM		270	/* parameter to functions */
#define IDENTIFIER	271	/* identifier */
#define FSTYPE		272	/* filesystem type */
#define BLTIN		273	/* builtin functions */
#define DATESPEC	274	/* date specification */

#define LENGTH		2000	/* size of stack program */
#define MEM		1000	/* size of stack */
#define IDLENGTH	20	/* length of an identifier */

/* The '- 3' in DEPTH defines is for stdin, stdout, and stderr */

#if BSD
#define strrchr		rindex
#ifdef SUNOS_4
#define    POSIX_DIRECTORY_LIBRARY
#include <sys/time.h>
#include <sys/resource.h>
#ifdef RLIMIT_NOFILE
#define DEPTH		(max_descriptors() - 3)
#else
#define DEPTH		(getdtablesize() - 3)
#endif /* RLIMIT_NOFILE */
#else
#define DEPTH		(getdtablesize() - 3)
#endif /* SUNOS_4 */
#endif /* BSD */

#ifdef SYSV
#define rindex strrchr
#define index strchr
#ifdef SYSVR3
#define    DEPTH        (ulimit(4, 0L) - 3)
#define    POSIX_DIRECTORY_LIBRARY
#else /* SYSVR3 */
/* This value was arbitrarily chosen */
#define DEPTH        (20 - 3)
#endif /* SYSVR3 */
#endif /* SYSV */


/*
 * XXX - on BSD systems, this is defined in <sys/param.h>.
 * On System V Release 3, it's defined inside "nami.c", and is,
 * unfortunately, not in any include file.
 * On systems other than those, no such simple limit exists.
 * On BSD and S5R3 systems, as distributed by Berkeley and AT&T,
 * respectively, it's 1024, so we set it to that.
 */

#ifndef MAXPATHLEN
#  ifdef PATH_MAX
#    define MAXPATHLEN  PATH_MAX
#  else
#    ifdef MAXNAMLEN
#      define MAXPATHLEN  MAXNAMLEN
#    else
#      define MAXPATHLEN  1024
#    endif
#  endif
#endif

#ifndef MAXNAMLEN
#  ifdef PATH_MAX
#    define MAXNAMLEN	PATH_MAX
#  else
#    define MAXNAMLEN	255
#  endif
#endif


#include <string.h>

#if defined(NEED_STRSTR) && !defined(sun)
extern char *strstr();
#endif

/*
 * Some System do not define these macro's.
 * If these macro's are missing, then use these ones:
 */

#ifndef major
#define major(b)	((((unsigned) (b)) >> 8) & 0xff)
#endif

#ifndef minor
#define minor(b)	(((unsigned) (b)) & 0xff)
#endif

#ifndef S_ISBLK
#define	S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#endif

#ifndef S_ISCHR
#define	S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#endif

#ifndef S_ISDIR
#define	S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#endif

#ifdef S_IFIFO
#  ifndef S_ISFIFO
#    define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)
#  endif
#else
#  define S_ISFIFO(m)	(0)
#endif

#ifdef S_IFLNK
#  ifndef S_ISLNK
#    define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#  endif
#else
#  define S_ISLNK(m)	(0)
#endif

#ifndef S_ISREG
#define	S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)
#endif

#ifdef S_IFSOCK
#  ifndef S_ISSOCK
#    define S_ISSOCK(m)	(((m) & S_IFMT) == S_IFSOCK)
#  endif
#else
#  define S_ISSOCK(m)	(0)
#endif

/*
 * Structure of a "rh-assembly" instruction.
 *
 */

struct instr {
   void (*func)();
   long value;
};

/*
 * Structure of a symbol.
 *
 */

struct symbol {
   char *name;
   short type;
   short req_stat;
   long value;
   void (*func)();
   struct symbol *next;
};

/*
 * Structure defining the rh runtime environment.
 *
 */

struct runtime {
   struct stat *buf;	/* stat info of current file */
   char *fname;		/* file name of current file */
   int depth;		/* relative depth of current file */
   void (*func)();	/* examination function */
   char *command;	/* command to exec for current file */
   char *format;	/* format to use for printing file information */

   /* ---------- flags ---------- */
   char dot_special;	/* dot at start of filename special? */
#ifdef S_IFLNK
   char follow_dir;	/* used by file tree walker (follow symbolic links) */
   char follow_file;	/* used by file tree walker (follow symbolic links) */
#endif
   char graphic;	/* display non-graphic characters in filenames as ? */
   char ignore_case;	/* ignore case when comparing filenames */
   char prune;		/* flag to indicate prunning */
   char stat_all;	/* stat() all files */
   char str_owner;	/* print user/group strings instead of numbers */
   char verbose;	/* used by the (*func)() routine */
   char full_date;	/* print full date instead of ls(1) type date */
};

struct fs_info {
    char *fs_type;
    dev_t fs_dev;
    char *fs_dir;
    struct fs_info *next;
};

struct group_info {
   char *name;
   gid_t gid;
   struct group_info *next;
};

struct user_info {
   char *name;
   uid_t uid;
   struct user_info *next;
};

#ifndef DATA
extern char *hex_digits;

extern struct symbol *symbols;

extern struct symbol *tokensym;
extern long tokenval;
extern long token;

extern struct instr StackProgram[];
extern int PC;
extern int startPC;
extern long Stack[];
extern int SP;
extern int FP;	/* frame pointer */

extern struct runtime attr;

extern char *expstr;
extern char *expfname;
extern FILE *expfile;

extern long past_time;

extern struct symbol *now;
#endif

extern void c_and();
extern void c_atime();
extern void c_band();
extern void c_baselen();
extern void c_bnot();
extern void c_bor();
extern void c_bxor();
extern void c_colon();
extern void c_ctime();
extern void c_depth();
extern void c_dev();
extern void c_dirlen();
extern void c_div();
extern void c_eq();
extern void c_func();
extern void c_fstype();
extern void c_ge();
extern void c_gid();
extern void c_gt();
extern void c_ino();
extern void c_isblk();
extern void c_ischr();
extern void c_isdir();
extern void c_isfifo();
extern void c_islnk();
extern void c_isreg();
extern void c_issock();
extern void c_le();
extern void c_lshift();
extern void c_lt();
extern void c_minus();
extern void c_mod();
extern void c_mode();
extern void c_mtime();
extern void c_mul();
extern void c_ne();
extern void c_nlink();
extern void c_nogroup();
extern void c_not();
extern void c_nouser();
extern void c_number();
extern void c_or();
extern void c_param();
extern void c_pathlen();
extern void c_plus();
extern void c_prune();
extern void c_qm();
extern void c_rdev();
extern void c_return();
extern void c_rshift();
extern void c_size();
extern void c_str();
extern void c_uid();
extern void c_uniminus();

extern void error();

extern struct group_info *getgigid();
extern struct group_info *getginam();
extern struct user_info *getuinam();
extern struct user_info *getuiuid();

#if defined(sun)
extern struct fs_info *getfidev();
extern int mounted_fstype();
#endif
