.TH RH 1 "12 December 1990"
.SH NAME
rh \- recursive file locater (rawhide) >> VERSION 2.8 <<
.SH SYNOPSIS
.B rh
[
.B \-DFLVbcdihlqrstv
] [
.B \-f filename
] [
.B \-
] [
.B \-e expression
] [
.B \-p format
] [
.B \-x command
]
.BR file ...
.RE
.SH DESCRIPTION
.B rh
recursively searches the file system starting at each given
.I file
for files that make a C expression true.  If no files
are listed, the current working directory is used.
.PP
Expressions for
.B rh
can come from the command line (with the
.I \-e
option), a file (with the
.I \-f
option), or from the standard input (the default).
The basic form of an
.B rh
expression is a C expression which may optionally define and or call
user defined functions. These C expressions may contain
constants, variables, and all the usual C operators.
.PP
.I Constants
are either numeric or symbolic.  Symbolic constants are based
on the constants defined in the file
.IR /usr/include/sys/stat.h ;
only the useful constants are implemented.
The ``S_'' prefix from the symbol name is omitted.
(eg. S_IFMT would used as IFMT).
.PP
.I Variables
are symbols that specify a field in the
stat structure (e.g., st_size, st_mode) or some other attribute of the file.
For each file examined by
.BR rh ,
these internal variables are updated to match the current
file.  For convenience, the ``st_'' prefix is dropped from variable
names.
.PP
.I Functions
are a means of associating a C expression with a function name.
This allows complex expressions to be easily composed from simpler ones.
The value
of a function call is the value of the expression represented by the
function. For example:
.PP
.RS 8
foo(x)
.br
{
.br
    return( x-1 );
.br
}
.RE
.PP
If the above function were given to
.BR rh ,
it would define a function that could be used later. If
.I foo
were called with 667, then
.I foo
would return 666.
.PP
.SH OPTIONS
.B rh
options can appear in any order; multiple options can be given within
the same argument.
.TP
.I \-
Read expressions from stdin.
.TP
.I \-b
Print leading "./" as directory name if no directories are specified.
.TP
.I \-c
Do not read 
.IR .rhrc .
(See
.SM
.B "Search order"
for more information on
.IR .rhrc .)
.TP
.I \-d
Causes a leading '?' or '*' in a filename pattern to match a
leading '.' in the filename being matched.
.TP
.I \-e expression
Uses
.I expression
as the expression that will be used for the file search. Since many of
the operators are also shell meta-characters and since
.B rh
expressions may contain spaces, it is strongly recommended that the
.I expression
be enclosed in single quotes, ''. If both the
.I \-e
and
.I \-f
options occur together then the
.I -f
option is processed FIRST, followed by the
.I \-e
option. This means that an expression specified with the
.I \-e
option may use functions defined from the 
.I \-f file.
.TP
.I \-f filename
Uses
.I filename
as the name of a file containing a
.B rh
expression. Functions may also be defined in this file.
.TP
.I \-h
Causes
.B rh
to display a help message.  The message
explains the command line usage, a list of
available constants and variables and a list
of valid operators.
.B rh
then continues as though the
.I \-h
option were not present.
.TP
.I \-i
Ignore case of letters when doing matching filenames against a pattern.
.TP
.I \-l
Normally
.B rh
prints each matching filename on a line by itself.  The
.I \-l
option causes the matching files' permission modes and sizes
to be displayed as well, in a format similar to that of the
.IR ls (1)
command.
.TP
.I \-p format
Output file names and/or other file information using
.IR format .
The
.I format
is a string containing three types of objects: normal characters that
are output as is, escaped characters that are converted to control
characters, and substitution markers that indicate which part of a file
name or piece of file information is to be output.
.RS
.PP
Most of the standard C-like escape characters (and possibly a few that
aren't standard) are recognized. Valid escape characters are:
.RE
.RS
.RS
.PD 0
.TP
.B \ea
.SM ALERT
(bell)
.TP
.B \eb
.SM BACKSPACE
.TP
.B \ef
.SM FORMFEED
.TP
.B \en
.SM NEWLINE
.TP
.B \er
.SM RETURN
.TP
.B \et
.SM TAB
.TP
.B \ev
.SM vertical TAB
.TP
.BI \e0 n
the 8-bit character whose
.SM ASCII
code is the 1-, 2-, or 3-digit octal number
.IR n .
.TP
.BI \e0X n
the 8-bit character whose
.SM ASCII
code is the 1- or 2-digit hexadecimal number
.IR n .
The
.RB ` X '
may be either lower or upper case.
.RE
Any other characters preceded by a
.RB ` \e '
are output `as is'. Note that strings containing
.RB ` \e '
characters should be quoted in a way that prevents the shell from
interpretting them.
.PD
.PP
Substition markers are a
.RB ` % '
(percent sign) followed by a character indicating what is to be output.
The substitution characters are:
.RS
.PD 0
.TP
.B a
Last access time of file as an
.IR ls (1)
type time string
.TP
.B A
Last access time of file in seconds
.TP
.B b
Size of file in blocks
.TP
.B B
Filesystem's preferred block size in bytes
.TP
.B c
Last status change time of file as an
.IR ls (1)
type time string
.TP
.B C
Last status change time of file in seconds
.TP
.B d
Parent directory of file
.TP
.B D
Depth of file relative to search starting point
.TP
.B g
Numerical group id of file owner
.TP
.B G
Group name (from /etc/group) of file owner or numerical group id if a
group name is not found
.TP
.B i
File's inode number
.TP
.B l
Number of hard links to file
.TP
.B m
Last modification time of file as an
.IR ls (1)
type time string
.TP
.B M
Last modification time of file in seconds
.TP
.B n
Full path of file
.TP
.B N
Base name of file
.TP
.B p
File permissions in symbolic form
.TP
.B P
File permissions as an octal number
.TP
.B r
If the file is a block or character special device then output the minor
device number, else output `xxxx'.
.TP
.B R
If the file is a block or character special device then output the major
device number, else output `xxxx'.
.TP
.B s
Full path of file
.TP
.B S
Base name of file
.TP
.B u
Numerical user id of file owner
.TP
.B U
User name (from /etc/passwd) of file owner or numerical user id if a
user name is not found
.TP
.B w
The minor device number of device where file resides.
.TP
.B W
The major device number of device where file resides.
.TP
.B z
File size in bytes.
.RE
Any other characters preceded by a
.RB ` % '
are output `as is'.
.RE
.PD
.TP
.I \-q
Display non-graphic (i.e. non-ascii, control, or white space) characters
in filenames as a ?.
.TP
.I \-r
Prevents
.B rh
from recursively searching for files.
.TP
.I \-s
Print owner and group instead of the owner's UID and group's GID when
both 
.I \-l
and 
.I \-v
options are used.
.TP
.I \-t
Print full dates/times instead of \fIls\fR(1) format dates/times when
using the \fI-l\fR and \fI-v\fR switches or any of the date/time
formats with the \fI-p\fR switch.
.TP
.I \-v
Verbose. Causes the \fI-l\fR option to output more information and the
\fI-x\fR option to print out the command executed and the return value.
.TP
.I \-x command
Execute \fIcommand\fR using \fBsystem\fR(3) for each matching file.
The string \fIcommand\fR may contain a \fB%s\fR which will be
substituted with the full path name. A \fB%S\fR (uppercase 'S') will
be substituted with the base name. For example, given the file
/etc/passwd the values for \fB%s\fR and \fB%S\fR would be: /etc/passwd
and passwd, respectively.
.TP
.I \-D
Follow symbolic links that point to directories when searching for files.
.TP
.I \-F
Follow symbolic links that point to non-directories.
.TP
.I \-L
Follow all symbolic links.
.TP
.I \-V
Version. Writes the version of
.B rh
being run on stderr and exits.
.SH USAGE
.SS "rh grammer"
This is the grammer that
.B rh
will accept.
.PP
.TP
<program> ::=
.RS 6
		<function list> <expression> EOF
.br
		| <function list> <expression> ;
.RE
.PP
.TP
<function list> ::=
.RS 6
		<function list> <function>
.br
		| <function>
.br
		| /* empty */
.RE
.PP
.TP
<function> ::=
.RS 6
		<function heading> { RETURN <expression> ; }
.RE
.PP
.TP
<function heading> ::=
.RS 6
		IDENTIFIER
.br
		| IDENTIFIER ( )
.br
		| IDENTIFIER ( <idlist> )
.RE
.PP
.TP
<idlist> ::=
.RS 6
		<idlist> , IDENTIFIER
.br
		| IDENTIFIER
.RE
.PP
.TP
<expression> ::=
.RS 6
		<expression> ? <expression> : <expression>
.br
		| <expression> || <expression>
.br
		| <expression> && <expression>
.br
		| <expression> | <expression>
.br
		| <expression> ^ <expression>
.br
		| <expression> & <expression>
.br
		| <expression> == <expression>
.br
		| <expression> != <expression>
.br
		| <expression> < <expression>
.br
		| <expression> > <expression>
.br
		| <expression> <= <expression>
.br
		| <expression> >= <expression>
.br
		| <expression> >> <expression>
.br
		| <expression> << <expression>
.br
		| <expression> + <expression>
.br
		| <expression> - <expression>
.br
		| <expression> * <expression>
.br
		| <expression> / <expression>
.br
		| <expression> % <expression>
.br
		| ~ <expression>
.br
		| ! <expression>
.br
		| - <expression>
.br
		| <factor>
.RE
.PP
.TP
<factor> ::=
.RS 6
		( <expression> )
.br
		|    NUMBER
.br
		|    <function call>
.br
		|    IDENTIFIER
.br
		|    [ <datetimespec> ]
.br
		|    STRING
.RE
.PP
.TP
<function call> ::=
.RS 6
		IDENTIFIER
.br
		| IDENTIFIER ( <exprlist> )
.br
		| IDENTIFIER ( )
.RE
.PP
.TP
<exprlist> ::=
.RS 6
		<exprlist> , <expression>
.br
		| <expression>
.RE
.PP
.TP
<datetimespec> ::=
.RS 6
		[ <anything getdate will accept> ]
.RE
.PP
.SS "Search order:"
.B rh
initally looks for
.I .rhrc
using the path(s) from the
.B RHPATH
environment variable and if found is read in. If
.B RHPATH
is not set or
.I .rhrc
is not found then
.RB $ HOME /.rhrc
is read in if it exists.
Next, any file specified by the
.I \-f
option is read. After that any expression specified with the
.I \-e
option is read. If after all that, an expression, defined outside of a
function, has not been encountered and the
.RI ` - '
is specified then stdin will be read for such an expression. An error
will result if no expression has been encountered.
.PP
A
.I .rhrc
file usually contains function definitions that may be used in search
expressions.
.PP
.SS "The valid constants are:"
.IP NOW
This constant is set to the current time at the start of
.BR rh .
It is used to make comparisons with atime, ctime, and mtime.
.IP days\ \ \ 
This is equal to the number of seconds in a day.
.IP hours
Number of seconds in an hour.
.IP weeks
Number of seconds in a week.
.IP "IEXEC IFBLK IFCHR IFDIR IFIFO IFLNK IFMT IFREG IFSOCK"
.PD 0
.IP "IREAD IRGRP IROTH IRUSR IRWXG IRWXO IRWXU ISGID ISUID"
.IP "ISVTX IWGRP IWOTH IWRITE IWUSR IXGRP IXOTH IXUSR"
.PD
see
.IR stat (2)
for an explanation.
.SS "The valid variables are:"
.PP
.IP depth
This variable is set to the relative depth in the directory search
that the current file is at.
.IP "strlen or baselen"
This is set to the length of the filename. For example, strlen would be
equal to 4 given the file "/tmp/core" because "core" is 4 characters
long.
.IP dirlen
This is set to the length of directory. For example, dirlen would be
equal to 4 given the file "/tmp/core" because "/tmp" is 4 characters
long. Another example: dirlen would be set to 1 given the file "/vmunix"
because "/" is 1 character long.
.IP pathlen
This is set to the length of the entire path (directory and filename).
For example, pathlen would be equal to 9 given the file "/tmp/core".
.IP prune
This variable always returns 0, but as a side-effect causes the
search path to be "cut-short" when evaluated. This can be used to prune the
directory search.
.I prune
is usually used with the ?: operator to conditionally evaluate the prune
variable.
.IP nogroup
This variable is true if the file belongs to a group that is not in the
system group file.
.IP nouser
This variable is true if the file belongs to a user that is not in the
system user file.
.IP "atime ctime dev gid ino mode mtime nlink rdev size uid"
see
.IR stat (2)
for an explanation.
.IP "owner user"
synonyms for uid.
.IP group
synonym for gid.
.IP isblk
This variable is true if the file is a block special file.
.IP ischr
This variable is true if the file is a character special file.
.IP isdir
This variable is true if the file is a directory file.
.IP isfifo
This variable is true if the file is a pipe or FIFO special file.
.IP islnk
This variable is true if the file is a symbolic link.
.IP isreg
This variable is true if the file is a regular file.
.IP issock
This variable is true if the file is a socket.
.SS "The valid C operators are:"
.PP
!  ~  -  *  /  %  +  <  <=  >  >=  ==  !=  &  ^  |  <<  >>  &&  ||  ?:
.PP
Operator precedence, associativity and semantics are the same as
in C.
.SS "Special operators:"
.IP \fB$\fIusername\fR
This operator evaluates to the integer user id of \fIusername\fP.
As a special case the symbol `\fB$$\fP' evaluates to the
uid of the user currently running
.BR rh .
.IP \fB@\fIgroupname\fR
This operator evaluates to the integer group id of \fIgroupname\fP.
As a special case the symbol `\fB@@\fP' evaluates to the
gid of the user currently running
.BR rh .
.IP \fB\`\fIfilesystem-type\fR
This operator (back-tick) is true if the current file resides on a
filesystem that is of type \fIfilesystem-type\fP.
.IP \fB"\fP*.c\fB"\fP
This operator evaluates to true if the current filename matches
the quoted expression, which is a shell globbing pattern.
The recognized meta-characters are:
.PD 0
.RS
.RS
.IP \fB*\fP
matches any string, including the null string. 
A leading ``.'' is not matched unless the \fI-d\fP switch is specified.
.IP \fB?\fP
matches any single character.
A leading ``.'' is not matched unless the \fI-d\fP switch is specified.
.IP \fB[\fISET\fB]\fR
matches any character in the given set. A range of characters may be
specified by using a hyphen between two characters (e.g. a-l matches
any character lexically between `a' and `l').
.IP \fB[^\fISET\fB]\fR
matches any character not in the given set (ranges are also allowed)
.RE
.PP
`\e' can be used to escape the special meaning of any of the above 
meta-characters.
.br
When doing comparisons, only the base name is examined, not
leading paths.
.RE
.PD
.IP \fB[\fIdate/time\fB]\fR
The \fIdate/time\fP enclosed in the brackets, ``\fB[]\fP'', will evaluate
to a number of seconds past January 1, 1970, which is suitable for
comparing with atime, mtime or ctime.
.br
There are numerous formats that can be used for the date/time specification.
Some examples are:
.PD 0
.RS
.IP
[Thu Mar 02 19:07:25 CST 1992]
.IP
[Mar 02 19:07:25]
.IP
[03/02 19:07:25]
.IP
[12/30/91]
.IP
[10:15]
.RE
.IP
There are many other formats that are acceptable. In addition the special
format ``[yyyy/mm/dd]'' is accepted for compatibility with older versions of 
.BR rh .
.PD
.PP
The special operators have higher precedence than the C operators.
.SS "Lexical conventions:"
.PP
Numbers may be entered in octal by preceding them with a leading zero or
in hexadecimal by preceding them with a leading
.RB ` 0x '
(the
.RB ` x '
may be either lower or upper case). Otherwise numbers are taken to be in
decimal.
.PP
Decimal numbers that are followed by one of
.RB ` mhdw '
with no intervening white space are converted to the number of seconds
in the corresponding number of minutes, hours, days, or weeks,
respectively. Also, decimal numbers that are followed by one of
.RB ` KMG '
with no intervening white space are multiplied by 1024 (kilo-), 1024 *
1024 (mega-), or 1024 * 1024 * 1024 (giga-), respectively.
.PP
Text enclosed in
.B /*
and
.B */
will be ignored. This can be used for commenting
.B rh
expression files.
.PP
The start expression may be terminated by either
a ``;'' or the end of the file or argument.
.SH EXAMPLES
The following are examples of
.B rh
expressions.
.PP
(mode & 022) && (uid == $joe );
.RS 8
Matches all files that have uid equal to username ``joe'' and
are writable by other people.
.RE
.PP
!uid && (mode & ISUID ) && (mode & 02);
.RS 8
Matches all files that are owned by root (uid==0) and that
have set-uid on execution bit set, and are writable.
.RE
.PP
(size > 10K) && (mode & 0111) && (atime <= NOW-24h);
.RS 8
Finds all executable files larger than 10K that
have not been executed in the last 24 hours.
.RE
.PP
size < ( ("*.c") ? 4K : 32K );
.RS 8
Finds C source files smaller than 4K and other files smaller than 32K.
No other files will match.
.RE
.PP
!(size % 1K);
.RS 8
Matches files that are a multiple of 1K.
.RE
.PP
mtime >= [1982/3/1] && mtime <= [1982/3/31];
.RS 8
Finds files that were modified during March, 1982.
.RE
.PP
strlen >= 4 && strlen <= 10;
.RS 8
This expression will print files whose filenames are between
4 and 10 characters in length.
.RE
.PP
depth > 3;
.RS 8
Matches files that are at a RELATIVE depth of 3 or more.
.RE
.PP
( "tmp" || "bin" ) ? prune : "*.c";
.RS 8
This expression does a search for all "*.c" files, however it will
not look into any directories called "bin" or "tmp". This is because when
such a filename is encountered the prune variable is evaluated, causing
further searching with the current path to stop. The general form of this
would be:
.PP
  ("baddir1" || "baddir2" || ... || "baddirn") ?
.br
.RS 8
prune : <search expr>;
.RE
.RE
.PP
.SH "ADVANCED EXAMPLES"
The following examples show the use of function definitions and other
advanced features of
.BR rh .
.PP
Consider:
.PP
.RS 8
dir()
.br
{
.br
    return ( (mode & IFMT) == IFDIR );
.br
}
.br
.RE
.PP
This declares a function that returns true if the current file is a directory
and false otherwise. The function
.I dir
now may be used in other expressions.
.PP
.RS 8
dir() && !mine();
.RE
.PP
This matches files that are directories and are not owned by
the user. This assumes the user has written a mine() function. Since
.I dir
and
.I mine
take no arguments they may be called like:
.PP
.RS 8
dir && !mine;
.RE
.PP
Also when declaring a function that takes no arguments the parenthesis
may be omitted. For example:
.PP
.RS 8
mine
.br
{
.br
    return uid == $joe;
.br
}
.br
.RE
.PP
This declares a function mine, that evaluates true when a file
is owned by user name `joe'. An alternate way to write mine would be:
.PP
.RS 8
mine(who)
.br
{
.br
    return uid == who;
.br
}
.br
.RE
.PP
This would allow mine to be called with an argument, for example:
.PP
.RS 8
mine( $sue ) || mine( $joe );
.RE
.PP
This expression is true of any file owned by user name `sue' or `joe'.
Since the parenthesis are optional for functions that take no arguments,
it would be possible to define functions that can be used exactly like
constants, or handy macros. Suppose the above definition of
.I dir
was placed in a user's 
.I $HOME/.rhrc
Then the command:
.PP
.RS 8
rh -e dir
.RE
.PP
would execute the expression `dir' which will print out all directories.
.PP
.B rh
functions can be recursive.
.SH "FILES"
.TP 10
.SB .rhrc
.B rh
run commands
.PP
.SH "ENVIRONMENT"
.TP 10
.SB RHPATH
A colon-separated list of directories in which to search for an
.B rh
start up file
.RI ( .rhrc ).
.PP
.SH "SEE ALSO"
chmod(1), find(1), ls(1), stat(2), group(5), passwd(5),
.PP
The C programming language.
.SH AUTHOR
Ken Stauffer (University of Calgary)
.br
stauffer@sixk
.PP
Enhancements and modifications by:
.br
Rick Ohnemus (Sterling Software, IMD)
.br
rick@IMD.Sterling.COM  or uunet!sparky!rick
.SH BUGS
The date operator can be off by a day, if the time on the file is close
to midnight. (is this still true???)
