#include "rh.h"
#include <grp.h>
#include <pwd.h>
#if defined(sun)
#include <mntent.h>
#endif

#if SYSV
extern struct group *getgrnam();
extern struct group *getgrgid();
#endif
 
#if !defined(SUNOS_4)
extern char *strdup();
#endif

static struct group_info *groups = (struct group_info *) NULL;
static struct user_info *users = (struct user_info *) NULL;

#if defined(sun)

extern long strtol();

static struct fs_info *file_systems = (struct fs_info *) NULL;

static void init_file_systems()
{
    FILE *mtab;
    char *c_p;
    char *dev_str;
    dev_t device;
    struct fs_info *p;
    struct fs_info *prev;
    struct mntent *info;

    if ((mtab = setmntent(MOUNTED, "r")) == (FILE *) NULL)
	return;
    while ((info = getmntent(mtab)) != (struct mntent *) NULL) {
	if ((dev_str = hasmntopt(info, "dev=")) == (char *) NULL)
	    continue;
	if (*dev_str == '0'
	    && (*(dev_str + 1) == 'x' || *(dev_str + 1) == 'X'))
	    dev_str += 6;
	else
	    dev_str += 4;
	device = (dev_t) strtol(dev_str, &c_p, 16);
	if (device == 0 || (c_p - dev_str) != 4)
	    continue;
	p = (struct fs_info *) malloc((unsigned) sizeof(struct fs_info));
	if ((p->fs_type = strdup(info->mnt_type)) == (char *) NULL)
	    error("no more memory");
	if ((p->fs_dir = strdup(info->mnt_dir)) == (char *) NULL)
	    error("no more memory");
	p->fs_dev = device;
	p->next = (struct fs_info *) NULL;
	if (file_systems == (struct fs_info *) NULL)
	    file_systems = p;
	else
	    prev->next = p;
	prev = p;
    }
    (void) endmntent(mtab);
    return;
}

int mounted_fstype(type)
char *type;
{
    struct fs_info *p;

    if (file_systems == (struct fs_info *) NULL)
	init_file_systems();

    for (p = file_systems; p != (struct fs_info *) NULL; p = p->next)
	if (strcmp(type, p->fs_type) == 0)
	    return 1;
    
    return 0;
}

struct fs_info *getfidev(fs_dev)
dev_t fs_dev;
{
    struct fs_info *p;

    if (file_systems == (struct fs_info *) NULL)
	init_file_systems();

    for (p = file_systems; p != (struct fs_info *) NULL; p = p->next)
	if (fs_dev == p->fs_dev)
	    return p;
    
    return (struct fs_info *) NULL;
}
#endif

struct group_info *getginam(group_name)
char *group_name;
{
   struct group *info;
   struct group_info *p = groups;

   while (p != (struct group_info *) NULL) {
      if (strcmp(group_name, p->name) == 0)
	 return p;
      p = p->next;
   }
   if ((info = getgrnam(group_name)) == (struct group *) NULL)
      return (struct group_info *) NULL;
   p = (struct group_info *) malloc((unsigned) sizeof(struct group_info));
   if (p == (struct group_info *) NULL)
      error("no more memory");
   if ((p->name = strdup(info->gr_name)) == (char *) NULL)
      error("no more memory");
   p->gid = info->gr_gid;
   p->next = groups;
   groups = p;
   return p;
}

struct group_info *getgigid(gid)
gid_t gid;
{
   struct group *info;
   struct group_info *p = groups;

   while (p != (struct group_info *) NULL) {
      if (gid == p->gid)
	 return p;
      p = p->next;
   }
   if ((info = getgrgid(gid)) == (struct group *) NULL)
      return (struct group_info *) NULL;
   p = (struct group_info *) malloc((unsigned) sizeof(struct group_info));
   if (p == (struct group_info *) NULL)
      error("no more memory");
   if ((p->name = strdup(info->gr_name)) == (char *) NULL)
      error("no more memory");
   p->gid = info->gr_gid;
   p->next = groups;
   groups = p;
   return p;
}

struct user_info *getuinam(user_name)
char *user_name;
{
   struct passwd *info;
   struct user_info *p = users;

   while (p != (struct user_info *) NULL) {
      if (strcmp(user_name, p->name) == 0)
	 return p;
      p = p->next;
   }
   if ((info = getpwnam(user_name)) == (struct passwd *) NULL)
      return (struct user_info *) NULL;
   p = (struct user_info *) malloc((unsigned) sizeof(struct user_info));
   if (p == (struct user_info *) NULL)
      error("no more memory");
   if ((p->name = strdup(info->pw_name)) == (char *) NULL)
      error("no more memory");
   p->uid = info->pw_uid;
   p->next = users;
   users = p;
   return p;
}

struct user_info *getuiuid(uid)
uid_t uid;
{
   struct passwd *info;
   struct user_info *p = users;

   while (p != (struct user_info *) NULL) {
      if (uid == p->uid)
	 return p;
      p = p->next;
   }
   if ((info = getpwuid(uid)) == (struct passwd *) NULL)
      return (struct user_info *) NULL;
   p = (struct user_info *) malloc((unsigned) sizeof(struct user_info));
   if (p == (struct user_info *) NULL)
      error("no more memory");
   if ((p->name = strdup(info->pw_name)) == (char *) NULL)
      error("no more memory");
   p->uid = info->pw_uid;
   p->next = users;
   users = p;
   return p;
}
