/* ----------------------------------------------------------------------
 * FILE: rhcmds.c
 * VERSION: 2
 * Written by: Ken Stauffer
 * VERSION 2.8
 * Enhancements and bug fixes by Rick Ohnemus
 * 
 * This file contains the functions that do the evaluation of
 * the stack program.
 * These functions are simple, and behave like RPN operators, that is
 * they use the last two values on the stack, apply an operator
 * and push the result. Similarly for unary ops.
 *
 * ---------------------------------------------------------------------- */

#include "rh.h"

/*ARGSUSED*/
void c_or(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] || Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_and(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] && Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_le(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] <= Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_lt(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] < Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_ge(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] >= Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_gt(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] > Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_ne(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] != Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_eq(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] == Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_bor(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] | Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_band(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] & Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_bxor(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] ^ Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_lshift(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] << Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_rshift(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] >> Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_plus(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] + Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_mul(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] * Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_minus(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2]  -  Stack[SP-1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_div(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] / Stack[SP - 1];
    SP--;
    return;
}

/*ARGSUSED*/
void c_mod(i)
long i;
{
    Stack[SP - 2] = Stack[SP - 2] % Stack[SP - 1];
    SP--;
    return;
}


/* unary instructions */

/*ARGSUSED*/
void c_not(i)
long i;
{
    Stack[SP - 1] = !Stack[SP - 1];
    return;
}

/*ARGSUSED*/
void c_bnot(i)
long i;
{
    Stack[SP - 1] = ~Stack[SP - 1];
    return;
}

/*ARGSUSED*/
void c_uniminus(i)
long i;
{
    Stack[SP - 1] = -Stack[SP - 1];
    return;
}


/* trinary operator ?: */

void c_qm(i)
long i;
{
    PC = (Stack[SP - 1]) ? PC : i;
    SP--;
    return;
}

void c_colon(i)
long i;
{
    PC = i;
    return;
}


/* accessing a parameter */

void c_param(i)
long i;
{
    Stack[SP++] = Stack[FP + i];
    return;
}


/* calling a function */

void c_func(i)
long i;
{
    Stack[SP++] = PC;
    Stack[SP++] = FP;
    PC = i;
    FP = SP - (StackProgram[PC].value + 2);
    return;
}


/* returning from a function */

void c_return(i)
long i;
{
    PC = Stack[SP - 3];
    FP = Stack[SP - 2];
    Stack[SP - (3 + i)] = Stack[SP - 1];
    SP -= (2 + i);
    return;
}


/* operand functions */

void c_number(i)
long i;
{
    Stack[SP++] = i;
    return;
}

/*ARGSUSED*/
void c_atime(i)
long i;
{
    Stack[SP++] = attr.buf->st_atime;
    return;
}

/*ARGSUSED*/
void c_ctime(i)
long i;
{
    Stack[SP++] = attr.buf->st_ctime;
    return;
}

/*ARGSUSED*/
void c_dev(i)
long i;
{
    Stack[SP++] = attr.buf->st_dev;
    return;
}

/*ARGSUSED*/
void c_gid(i)
long i;
{
    Stack[SP++] = attr.buf->st_gid;
    return;
}

/*ARGSUSED*/
void c_ino(i)
long i;
{
    Stack[SP++] = attr.buf->st_ino;
    return;
}

/*ARGSUSED*/
void c_isblk(i)
long i;
{
    Stack[SP++] = S_ISBLK(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_ischr(i)
long i;
{
    Stack[SP++] = S_ISCHR(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_isdir(i)
long i;
{
    Stack[SP++] = S_ISDIR(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_isfifo(i)
long i;
{
    Stack[SP++] = S_ISFIFO(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_islnk(i)
long i;
{
    Stack[SP++] = S_ISLNK(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_isreg(i)
long i;
{
    Stack[SP++] = S_ISREG(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_issock(i)
long i;
{
    Stack[SP++] = S_ISSOCK(attr.buf->st_mode);
    return;
}

/*ARGSUSED*/
void c_mode(i)
long i;
{
    Stack[SP++] = attr.buf->st_mode;
    return;
}

/*ARGSUSED*/
void c_mtime(i)
long i;
{
    Stack[SP++] = attr.buf->st_mtime;
    return;
}

/*ARGSUSED*/
void c_nlink(i)
long i;
{
    Stack[SP++] = attr.buf->st_nlink;
    return;
}

/*ARGSUSED*/
void c_rdev(i)
long i;
{
    Stack[SP++] = attr.buf->st_rdev;
    return;
}

/*ARGSUSED*/
void c_size(i)
long i;
{
    Stack[SP++] = attr.buf->st_size;
    return;
}

/*ARGSUSED*/
void c_uid(i)
long i;
{
    Stack[SP++] = attr.buf->st_uid;
    return;
}

/*ARGSUSED*/
void c_nogroup(i)
long i;
{
    Stack[SP++] = getgigid(attr.buf->st_gid) == (struct group_info *) NULL;
    return;
}

/*ARGSUSED*/
void c_nouser(i)
long i;
{
    Stack[SP++] = getuiuid(attr.buf->st_uid) == (struct user_info *) NULL;
    return;
}

/*ARGSUSED*/
void c_depth(i)
long i;
{
    Stack[SP++] = attr.depth;
    return;
}

/*ARGSUSED*/
void c_prune(i)
long i;
{
    Stack[SP++] = 0;
    attr.prune = TRUE;
    return;
}


/* calculate the filename length */

/*ARGSUSED*/
void c_baselen(i)
long i;
{
    char *c;
    register int len;
    
    len = 0;
    for (c = attr.fname; *c != '\0'; c++)
	if (*c == '/')
	    len = 0;
	else	
	    len += 1;
    Stack[SP++] = len;
    return;
}


/* calculate the length of the directory portion of the path */

/*ARGSUSED*/
void c_dirlen(i)
long i;
{
    char *c;
    char *slash = (char *) NULL;
    int len;

    for (c = attr.fname; *c != '\0'; c++)
	if (*c == '/')
	    slash = c;
    if (slash == (char *) NULL)
	len = 0;
    else
	len = (slash == attr.fname) ? 1 : (slash - attr.fname);
    Stack[SP++] = len;
    return;
}


/* calculate length of the entire path */

/*ARGSUSED*/
void c_pathlen(i)
long i;
{
    Stack[SP++] = strlen(attr.fname);
    return;
}


/* ----------------------------------------------------------------------
 * c_str:
 *    This implements the regular expression stuff.
 *    str is the the actual '\0' terminated string that occured in the
 *    expression (eg "*.BAK" ), minus the quotes "".
 */

void c_str(i)
long i;
{
    extern int wildmat();
    char *str;
    char *tail;
    
    str = (char *) i;
    
    if ((tail = strrchr(attr.fname, '/')) == (char *) NULL)
	tail = attr.fname;
    else
	tail++;
    Stack[SP++] = wildmat((unsigned char *) tail, (unsigned char *) str,
			  attr.dot_special, attr.ignore_case);
    return;
}

#if defined(sun)
void c_fstype(i)
long i;
{
    char *fstype;
    struct fs_info *p;

    fstype = (char *) i;
    Stack[SP] = 0;

    if (fstype != (char *) NULL) {
	if ((p = getfidev(attr.buf->st_dev)) != (struct fs_info *) NULL) {
	    if (strcmp(fstype, p->fs_type) == 0)
		Stack[SP] = 1;
	}
    }
    SP++;
    return;
}
#else
/*ARGSUSED*/
void c_fstype(i)
long i;
{
    Stack[SP++] = 0;
    return;
}
#endif
