/* ----------------------------------------------------------------------
 * FILE: rhdata.c
 * VERSION: 2
 * Written by: Ken Stauffer
 * VERSION 2.8
 * Enhancements and bug fixes by Rick Ohnemus
 * 
 * This file contains the predefined symbol table, and related data
 * structures.
 *
 * ---------------------------------------------------------------------- */

#define DATA
#include "rh.h"

char *hex_digits = "0123456789abcdef";

struct symbol *symbols;

struct symbol *tokensym;
long tokenval;
long token;

struct instr StackProgram[LENGTH];
int PC;
int startPC;

long Stack[MEM + 3];
int SP;
int FP;

struct runtime attr;

/*
 * The following variables specify where the input is comming from.
 * If expstr == (char *) NULL then the input is certainly not from
 * there, and instead is taken from expfile.
 * Otherwise, expstr is used as input.
 *
 */

char *expstr = (char *) NULL;
FILE *expfile = (FILE *) NULL;
char *expfname = (char *) NULL;

/*
 * NOW - 6 months
 */

long past_time;

/*
 * symbol table entry for NOW
 */

struct symbol *now;


static struct symbol init_syms[] = {
   { "NOW",     NUMBER, FALSE, 0,                c_number,  (struct symbol *) NULL },
   { "IFBLK",   NUMBER, FALSE, S_IFBLK,          c_number,  (struct symbol *) NULL },
   { "IFCHR",   NUMBER, FALSE, S_IFCHR,          c_number,  (struct symbol *) NULL },
   { "IFDIR",   NUMBER, FALSE, S_IFDIR,          c_number,  (struct symbol *) NULL },
   { "IFMT",    NUMBER, FALSE, S_IFMT,           c_number,  (struct symbol *) NULL },
   { "IFREG",   NUMBER, FALSE, S_IFREG,          c_number,  (struct symbol *) NULL },
   { "ISGID",   NUMBER, FALSE, S_ISGID,          c_number,  (struct symbol *) NULL },
   { "ISUID",   NUMBER, FALSE, S_ISUID,          c_number,  (struct symbol *) NULL },
   { "ISVTX",   NUMBER, FALSE, S_ISVTX,          c_number,  (struct symbol *) NULL },
#ifdef S_IFLNK
   { "IFLNK",   NUMBER, FALSE, S_IFLNK,          c_number,  (struct symbol *) NULL },
#endif
#ifdef S_IFSOCK
   { "IFSOCK",  NUMBER, FALSE, S_IFSOCK,         c_number,  (struct symbol *) NULL },
#endif
#ifdef S_IFIFO
   { "IFIFO",   NUMBER, FALSE, S_IFIFO,          c_number,  (struct symbol *) NULL },
#endif
#ifdef S_IREAD
   { "IREAD",   NUMBER, FALSE, S_IREAD,          c_number,  (struct symbol *) NULL },
   { "IWRITE",  NUMBER, FALSE, S_IWRITE,         c_number,  (struct symbol *) NULL },
   { "IEXEC",   NUMBER, FALSE, S_IEXEC,          c_number,  (struct symbol *) NULL },
#else
   { "IREAD",   NUMBER, FALSE, 0400,             c_number,  (struct symbol *) NULL },
   { "IWRITE",  NUMBER, FALSE, 0200,             c_number,  (struct symbol *) NULL },
   { "IEXEC",   NUMBER, FALSE, 0100,             c_number,  (struct symbol *) NULL },
#endif
#ifdef S_IRWXU
   { "IRWXU",	NUMBER, FALSE, S_IRWXU,          c_number,  (struct symbol *) NULL },
   { "IRWXG",   NUMBER, FALSE, S_IRWXG,          c_number,  (struct symbol *) NULL },
   { "IRWXO",   NUMBER, FALSE, S_IRWXO,          c_number,  (struct symbol *) NULL },
#else
   { "IRWXU",	NUMBER, FALSE, 0700,             c_number,  (struct symbol *) NULL },
   { "IRWXG",   NUMBER, FALSE, 0070,             c_number,  (struct symbol *) NULL },
   { "IRWXO",   NUMBER, FALSE, 0007,             c_number,  (struct symbol *) NULL },
#endif
#ifdef S_IRUSR
   { "IRUSR",   NUMBER, FALSE, S_IRUSR,          c_number,  (struct symbol *) NULL },
   { "IWUSR",   NUMBER, FALSE, S_IWUSR,          c_number,  (struct symbol *) NULL },
   { "IXUSR",   NUMBER, FALSE, S_IXUSR,          c_number,  (struct symbol *) NULL },
   { "IRGRP",   NUMBER, FALSE, S_IRGRP,          c_number,  (struct symbol *) NULL },
   { "IWGRP",   NUMBER, FALSE, S_IWGRP,          c_number,  (struct symbol *) NULL },
   { "IXGRP",   NUMBER, FALSE, S_IXGRP,          c_number,  (struct symbol *) NULL },
   { "IROTH",   NUMBER, FALSE, S_IROTH,          c_number,  (struct symbol *) NULL },
   { "IWOTH",   NUMBER, FALSE, S_IWOTH,          c_number,  (struct symbol *) NULL },
   { "IXOTH",   NUMBER, FALSE, S_IXOTH,          c_number,  (struct symbol *) NULL },
#else
   { "IRUSR",   NUMBER, FALSE, 0400,             c_number,  (struct symbol *) NULL },
   { "IWUSR",   NUMBER, FALSE, 0200,             c_number,  (struct symbol *) NULL },
   { "IXUSR",   NUMBER, FALSE, 0100,             c_number,  (struct symbol *) NULL },
   { "IRGRP",   NUMBER, FALSE, 0040,             c_number,  (struct symbol *) NULL },
   { "IWGRP",   NUMBER, FALSE, 0020,             c_number,  (struct symbol *) NULL },
   { "IXGRP",   NUMBER, FALSE, 0010,             c_number,  (struct symbol *) NULL },
   { "IROTH",   NUMBER, FALSE, 0004,             c_number,  (struct symbol *) NULL },
   { "IWOTH",   NUMBER, FALSE, 0002,             c_number,  (struct symbol *) NULL },
   { "IXOTH",   NUMBER, FALSE, 0001,             c_number,  (struct symbol *) NULL },
#endif
   { "atime",   FIELD,  TRUE,  0,                c_atime,   (struct symbol *) NULL },
   { "ctime",   FIELD,  TRUE,  0,                c_ctime,   (struct symbol *) NULL },
   { "dev",     FIELD,  TRUE,  0,                c_dev,     (struct symbol *) NULL },
   { "gid",     FIELD,  TRUE,  0,                c_gid,     (struct symbol *) NULL },
   { "group",	FIELD,	TRUE,  0,		 c_gid,     (struct symbol *) NULL },
   { "ino",     FIELD,  TRUE,  0,                c_ino,     (struct symbol *) NULL },
   { "mode",    FIELD,  TRUE,  0,                c_mode,    (struct symbol *) NULL },
   { "mtime",   FIELD,  TRUE,  0,                c_mtime,   (struct symbol *) NULL },
   { "nlink",   FIELD,  TRUE,  0,                c_nlink,   (struct symbol *) NULL },
   { "rdev",    FIELD,  TRUE,  0,                c_rdev,    (struct symbol *) NULL },
   { "size",    FIELD,  TRUE,  0,                c_size,    (struct symbol *) NULL },
   { "uid",     FIELD,  TRUE,  0,                c_uid,     (struct symbol *) NULL },
   { "owner",   FIELD,  TRUE,  0,                c_uid,     (struct symbol *) NULL },
   { "user",    FIELD,  TRUE,  0,                c_uid,     (struct symbol *) NULL },
   { "depth",   BLTIN,  FALSE, 0,                c_depth,   (struct symbol *) NULL },
   { "prune",   BLTIN,  FALSE, 0,                c_prune,   (struct symbol *) NULL },
   { "days",    NUMBER, FALSE, 24 * 60 * 60,     c_number,  (struct symbol *) NULL },
   { "weeks",   NUMBER, FALSE, 24 * 60 * 60 * 7, c_number,  (struct symbol *) NULL },
   { "hours",   NUMBER, FALSE, 3600,             c_number,  (struct symbol *) NULL },
   { "strlen",  BLTIN,  FALSE, 0,                c_baselen, (struct symbol *) NULL },
   { "baselen", BLTIN,  FALSE, 0,                c_baselen, (struct symbol *) NULL },
   { "dirlen",  BLTIN,  FALSE, 0,                c_dirlen,  (struct symbol *) NULL },
   { "pathlen", BLTIN,  FALSE, 0,                c_pathlen, (struct symbol *) NULL },
   { "return",  RETURN, FALSE, 0,                c_return,  (struct symbol *) NULL },
   { "nogroup", BLTIN,  TRUE,  0,                c_nogroup, (struct symbol *) NULL },
   { "nouser",  BLTIN,  TRUE,  0,                c_nouser,  (struct symbol *) NULL },
   { "isblk",	BLTIN,	TRUE,  0,		 c_isblk,   (struct symbol *) NULL },
   { "ischr",	BLTIN,	TRUE,  0,		 c_ischr,   (struct symbol *) NULL },
   { "isdir",	BLTIN,	TRUE,  0,		 c_isdir,   (struct symbol *) NULL },
#ifdef S_IFIFO
   { "isfifo",	BLTIN,	TRUE,  0,		 c_isfifo,  (struct symbol *) NULL },
#endif
#ifdef S_IFLNK
   { "islnk",	BLTIN,	TRUE,  0,		 c_islnk,   (struct symbol *) NULL },
#endif
   { "isreg",	BLTIN,	TRUE,  0,		 c_isreg,   (struct symbol *) NULL },
#ifdef S_IFSOCK
   { "issock",	BLTIN,	TRUE,  0,		 c_issock,  (struct symbol *) NULL }
#endif
};

void rhinit()
{
   extern struct symbol *locatename();
   extern time_t time();

   int i;


   symbols = &init_syms[0];

   for (i = 0; i < (sizeof(init_syms) / sizeof(struct symbol) - 1); i++)
      init_syms[i].next = &init_syms[i + 1];

   /* initialize the NOW variable to the time right now */
   now = locatename("NOW");
   now->value = (long) time((time_t *) 0);

   past_time = now->value - (6L * 30L * 24L * 60L * 60L);

   return;
}

void rhfinish()
{
   struct symbol *s;


   while (symbols->type == PARAM || symbols->type == FUNCTION) {
      s = symbols;
      symbols = symbols->next;
      free(s->name);
      free((char *) s);
   }

   return;
}
