%token			ANDAND
%token			EOF
%token			EQ
%token			GE
%token			IDENTIFIER
%token			LE
%token			LS
%token			NE
%token			NUMBER
%token			OROR
%token			RETURN
%token			RS
%token			STRING

%left	OROR
%left	ANDAND
%left	'>' GE '<' GT EQ NE
%left	'|' '&'
%left	'+' '-'
%left	'*' '/'
%right	'^'

%%
program:	  function_list expression EOF
		| function_list expression ';'
		;

function_list: 	  /* VOID */
		| function function_list
		;

function:	function_heading '{' RETURN expression ';' '}'
		;

function_heading:	  IDENTIFIER
			| IDENTIFIER '(' ')'
			| IDENTIFIER '(' idlist ')'
			;

idlist:		  idlist ',' IDENTIFIER
		| IDENTIFIER
		;

expression:	  expression '?' expression ':' expression
		| expression OROR expression
		| expression ANDAND expression
		| expression '|' expression
		| expression '^' expression
		| expression '&' expression
		| expression EQ expression
		| expression NE expression
		| expression '<' expression
		| expression '>' expression
		| expression LE expression
		| expression GE expression
		| expression RS expression
		| expression LS expression
		| expression '+' expression
		| expression '-' expression
		| expression '*' expression
		| expression '/' expression
		| expression '%' expression
		| '~' expression
		| '!' expression
		| '-' expression
		| factor
		;

factor:		  '(' expression ')'
		| NUMBER
		| function_call
		| IDENTIFIER
		| '[' datespec ']'
		| STRING
		;

function_call:	  IDENTIFIER
		| IDENTIFIER '(' exprlist ')'
		| IDENTIFIER '(' ')'
		;

exprlist:	  exprlist ',' expression
		| expression
		;

datespec:	  '[' NUMBER '/' NUMBER '/' NUMBER ']'
		;
