//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TForm
//	Include File:	tform.h
//	Purpose:	Container for a form.  Does nothing more that track
//				all form conatiners, submits data, and resets
//				to original data.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		07-18-94	created
#include "tform.h"
#include "trace.h"

TForm::TForm(char *cp_act, char *cp_enc, char *cp_met)	{
//	Purpose:	Contructor for an empty form.
//	Arguments:	cp_act	The action URL.
//			cp_enc	The encoding type.
//			cp_net	The method to send a form.
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//		encoding types are not supported as of yet.
//	Revision History:
//		07-18-94	created

	//	Intialize all members.
	cp_action = cp_method = cp_enctype = NULL;

	//	Copy over the members.
	if(cp_act != NULL)	{
		cp_action = newStr(cp_act);
	}
	if(cp_enc != NULL)	{
		cp_enctype = newStr(cp_enc);
	}
	if(cp_met != NULL)	{
		cp_method = newStr(cp_met);
	}

#ifndef RELEASE
	trace("began form " << cp_action << " " << cp_enctype << " " <<
		cp_method);
#endif // RELEASE
}
