//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#define Uses_TKeys
#define Uses_MsgBox
#include"turlview.h"
#include<ctype.h>

void TURLView::handleEvent(TEvent& TE_event)	{
//	Purpose:	Handles any event messages.
//	Arguments:	TE_event	The event occuring.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-11-94	created

	//	Commands through message passing.
	if(TE_event.what & evMessage)	{
		switch(TE_event.message.command)	{
		//	Set the global variable to indicate which view
		//	the user is currently in.  If not, WWW routines
		//	won't know which window to load document into.
		case cmReceivedFocus:
			//	Maybe not.  Creates a bug.  Depend on the
			//	fact that all WWW code is executed during
			//	creation and thereafter has no effect.
			//	TURLV_current = this;
			break;
		case cmNextAnchor:
			//	Select the next anchor.
			AnchorSelectNext();
			clearEvent(TE_event);
			break;
		case cmPreviousAnchor:
			//	Select the previous anchor.
			AnchorSelectPrevious();
			clearEvent(TE_event);
			break;
		case cmSelectAnchor:
			//	Load the anchor.
			LoadChild();
			clearEvent(TE_event);
			break;
		case cmPreviousDocument:
			//	Load the parent.
			LoadParent();
			clearEvent(TE_event);
			break;
		case cmShowDestination:
			//	Show the destiniation of the selected link.
			auto char *cp_childURL = getChild();
			messageBox(cp_childURL, mfInformation | mfOKButton);
			delete(cp_childURL);
			clearEvent(TE_event);
			break;
		case cmSaveDLX:
			save();
			clearEvent(TE_event);
			break;
		case cmPrint:
			print();
			clearEvent(TE_event);
			break;
		case cmSearch:
			search();
			clearEvent(TE_event);
			break;
		case cmSearchAgainDLX:
			search(ca_searchLast);
			clearEvent(TE_event);
			break;
		case cmAddToHotList:
			addToHotList();
			clearEvent(TE_event);
			break;
		}
	}
	//	Commands through the keyboard.
	else if(TE_event.what & evKeyboard)	{
		//	Let's look at the actual character.
		//	Take nothing without scan code.
		//	Map the VI keys.
		if(TE_event.keyDown.charScan.scanCode != 0)	{
			switch(toupper(TE_event.keyDown.charScan.charCode)) {
			case 'H':
			case '4':
				//	Load the parent.
				LoadParent();
				clearEvent(TE_event);
				break;
			case 'J':
			case '2':
				//	Select the next anchor.
				AnchorSelectNext();
				AnchorInView();
				clearEvent(TE_event);
				break;
			case 'K':
			case '8':
				//	Select the previous anchor.
				AnchorSelectPrevious();
				AnchorInView();
				clearEvent(TE_event);
				break;
			case 'L':
			case '6':
				//	Load the anchor.
				LoadChild();
				clearEvent(TE_event);
				break;
			case ' ':
			case '3':
				//	The space bar should also be page
				//	down.
				TE_event.keyDown.keyCode = kbPgDn;
				//	Don't clear the event, will let base
				//	class handle.
				break;
			case '9':
				TE_event.keyDown.keyCode = kbPgUp;
				//	Don't clear the event, will let base
				//	class handle.
				break;
			case '7':
				TE_event.keyDown.keyCode = kbHome;
				break;
			case '1':
				TE_event.keyDown.keyCode = kbEnd;
				break;
			}
		}
	}
	//	Commands through the mouse.
	//	Only handle left button clicks.
	else if((TE_event.what & evMouse) != 0 && TE_event.mouse.buttons ==
		mbLeftButton)	{

		//	First, convert the mouse coordinates to the local
		//	view.
		TPoint TP_local = makeLocal(TE_event.mouse.where);

		//	No matter what, attempt to select an anchor where
		//	the clicks occured, if no anchor, ignore.
		if(AnchorSelectXYView(TP_local.x, TP_local.y) == True)	{
			//	Should redraw to show selection.
			draw();

			//	If double clicked, load the anchor.
			if(TE_event.mouse.doubleClick == True)	{
				LoadChild();
			}

			//	Clear the event.
			clearEvent(TE_event);
		}
	}

	//	Call the base event handler.
	TScroller::handleEvent(TE_event);
}
