.nr N -1
.nr D 5
.TH LYNX l Local
.UC 4
.SH NAME
lynx \- a general purpose distributed information browser for the World Wide Web
.SH SYNOPSIS
.B Lynx
[options] [path or URL]
.PP
use "lynx -help" to display a complete list of current options.
.SH DESCRIPTION
.\" This defines appropriate quote strings for nroff and troff
.ds lq \&"
.ds rq \&"
.if t .ds lq ``
.if t .ds rq ''
.\" Just in case these number registers aren't set yet...
.if \nN==0 .nr N 10
.if \nD==0 .nr D 5
.I
Lynx
is a fully-featured World Wide Web (WWW) client for users
running cursor-addressable, character-cell display devices (e.g.,
vt100 terminals, vt100 emulators running on PCs or Macs, or any
other "curses-oriented" display).  It will display hypertext
markup language (HTML) documents containing links to
files residing on the local system, as well as files residing on
remote systems running Gopher, HTTP, FTP, WAIS, and NNTP servers.
Current versions of
.I
Lynx
run on UNIX and VMS.
.PP
.I
Lynx
can be used to access information on the World Wide Web, or
to build information systems intended primarily for local access.
For example,
.I
Lynx
has been used to build several Campus Wide
Information Systems (CWIS).  In addition,
.I
Lynx
can be used to
build systems isolated within a single LAN.
.SH OPTIONS
At start up, \fILynx\fR will load any local 
file or remote URL specified at the command
line.  For help with URLs, press \fB"?"\fR
or \fB"h"\fR while running \fILynx\fR.
Then follow the link titled, "Help on URL's."
.PP
.TP
.B -anonymous
used to specify the anonymous account.
.TP
.B -auth\fR=\fIID\fR:\fIPASSWD
set authorization ID and password for protected documents at startup.
.TP
.B -case
enable case-sensitive string searching.
.TP
.B -cache\fR=\fINUMBER
set the NUMBER of documents cached in memory.
The default is 10.
.TP
.B -cfg\fR=\fIFILENAME
specifies a Lynx configuration file other than the default
lynx.cfg.
.TP
.B -display\fR=\fIDISPLAY
set the display variable for X rexeced programs.
.TP
.B -dump
dumps the formatted output of the default document or one
specified on the command line to standard out. 
Under UNIX this can be used in the following way: 
lynx -dump http://info.cern.ch/default.html.
.TP
.B -editor\fR=\fIEDITOR
enable edit mode using the specified 
EDITOR. (vi, ed, emacs, etc.)
.TP
.B -emacskeys
enable emacs-like key movement.
.TP
.B -errorfile\fR=\fIFILE
define a file where Lynx will report HTTP access codes.
.TP
.B -fileversions 
include all versions of files in local VMS directory listings.
.TP
.B -force_html 
forces the first document to be interpreted as HTML.
.TP
.B -ftp 
disable ftp access.
.TP
.B -get_data
send form data from stdin using GET method and dump results.
.TP
.B -help
print this Lynx command syntax usage message.
.TP
.B -homepage\fR=\fIURL
set homepage separate from start page.
.TP
.B -index\fR=\fIURL
set the default index file to the specified URL.
.TP
.B -localhost
disable URLs that point to remote hosts.
.TP
.B -mime_header
prints the MIME header of a fetched document along with its source.
.TP
.B -post_data
send form data from stdin using POST method and dump results.
.TP
.B -nobrowse
disable directory browsing.
.TP
.B -noprint
disable print functions.
.TP
.B -noredir
prevents automatic redirection and prints a message with a link
to the new URL.
.TP
.B -nostatus
disable the retrieval status messages.
.TP
.B -print
enable print functions. (default)
.TP
.B -restrictions\fR=\fI[option][,option][,option]...
allows a list of services to be disabled
selectively.  The following list is printed
if no options are specified.

.I all   
- restricts all options.

.I bookmark 
- disallow changing the location of the bookmark 
file. 

.I default 
- same as command line option -anonymous. 
Disables default services for anonymous users. 
Currently set to all restricted except for: 
inside_telnet, outside_telnet, inside_news, 
inside_ftp, outside_ftp, inside_rlogin,
outside_rlogin, jump, mail and goto.  Defaults 
are setable within userdefs.h.

.I disk_save 
- disallow saving binary files to disk in the 
download menu.

.I download
- disallow downloaders in the download menu.

.I editor  
- disallow editing.

.I exec    
- disable execution scripts.

.I exec_frozen
- disallow the user from changing the local 
execution option.

.I file_url 
- disallow using G)oto to go to file: URL's.

.I goto    
- disable the 'g' (goto) command.  

.I inside_ftp
- disallow ftps for people coming from inside your
domain (utmp required for selectivity).

.I inside_news
- disallow USENET news posting for people coming 
from inside your domain (utmp required for selectivity).

.I inside_rlogin
- disallow rlogins for people coming from inside
your domain (utmp required for selectivity).

.I inside_telnet 
- disallow telnets for people coming from inside 
your domain (utmp required for selectivity). 

.I jump
- disable the 'j' (jump) command.

.I mail
- disable mailing feature.

.I news_post
- disable USENET News posting.

.I options_save 
- disallow saving options in .lynxrc.

.I outside_ftp
- disallow ftps for people coming from outside your
domain (utmp required for selectivity).

.I outside_news
- disallow USENET news posting for people coming 
from outside your domain (utmp required for selectivity).

.I outside_rlogin
- disallow rlogins for people coming from outside
your domain (utmp required for selectivity).

.I outside_telnet 
- disallow telnets for people coming from 
outside your domain (utmp required for selectivity). 

.I print   
- disallow most print options. 

.I shell   
- disallow shell escapes and lynxexec G)oto's.

.I suspend 
- disallow Unix Control-Z suspends with escape to shell.

.TP
.B -rlogin
disable recognition of rlogin commands.
.TP
.B -selective   
require .www_browsable files to browse directories.
.TP
.B -show_cursor 
If enabled the cursor will not be hidden in the right hand
corner but will instead be positioned at the start of the
currently selected link. show cursor is the default for systems
without FANCY_CURSES capabilities, and the default
configuration can be changed in userdefs.h.
.TP
.B -source 
works the same as dump but outputs HTML source instead of
formatted text.
.TP
.B -telnet
disable recognition of telnet commands.
.TP
.B -term\fR=\fITERM
tell Lynx what terminal type to assume its talking to.
(This may be useful for remote execution, when, for example,
Lynx connects to a remote TCP/IP port that starts a script that,
in turn, starts another Lynx process.)
.TP
.B -trace
turns on WWW trace mode.
.TP
.B -version
print version information.
.TP
.B -vikeys
enable vi-like key movement.
.SH COMMANDS
o Use \fBUp arrow\fR and \fBDown arrow\fR to scroll through hypertext links.
.br
o \fBRight arrow\fR or \fBReturn\fR will follow a highlighted hypertext link.
.br
o \fBLeft Arrow\fR will retreat from a link.
.br
o Type \fB"h"\fR or \fB"?"\fR for online help and descriptions 
of key-stroke commands.
.br
o Type \fB"k"\fR for a complete list of the current key-stroke 
command mappings.
.SH NOTES
This is the Lynx 2.3-FM Release for UN*X/VMS
.PP
If you wish to contribute to the further development
of \fILynx\fR, subscribe to our mailing list.  Send email to
<listserv@ukanaix.cc.ukans.edu> with "subscribe lynx-dev
<your-name>" as the only line in the body of your message.
.PP
Send bug reports, comments, suggestions to <lynx-dev@ukanaix.cc.ukans.edu>.
Send general help requests to <lynx-help@ukanaix.cc.ukans.edu>.
.SH ACKNOWLEDGMENTS
Lynx has incorporated code from a variety of sources along the way.
The earliest versions of Lynx included code from Earl Fogel of Computing
Services at the University of Saskatchewan, who implemented HYPERREZ
in the UN*X environment.  HYPERREZ was developed by Niel Larson of 
Think.com and served as the model for the early versions of Lynx.
Those versions also incorporated libraries from the UN*X Gopher clients
developed at the University of Minnesota, and the later versions of 
Lynx rely on the WWW client library code developed by Tim Berners-Lee
and the WWW community.  Also a special thanks to Foteos Macrides who ported
much of Lynx to VMS and to everyone on the net who has contributed to Lynx's
development either directly (through comments or bug reports) or indirectly
(through inspiration and development of other systems).
.SH AUTHORS
Michael Grobe, Charles Rezac, Lou Montulli
.br
Academic Computing Services
.br
University of Kansas
.br
Lawrence, Kansas 66047
