/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpBilinearOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        byte[] byArray2 = new byte[n7];
        int n11 = 0;
        while (n11 < n7) {
            byArray2[n11] = (byte)this.backgroundValues[n11];
            ++n11;
        }
        if (this.ctable == null) {
            int n12 = 0;
            while (n12 < n6) {
                int n13 = n10;
                n10 += n8;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
                int n14 = 0;
                int n15 = 0;
                while (n15 < n5) {
                    int n16;
                    float f = fArray[n14++];
                    float f2 = fArray[n14++];
                    int n17 = WarpBilinearOpImage.floor(f);
                    int n18 = WarpBilinearOpImage.floor(f2);
                    float f3 = f - (float)n17;
                    float f4 = f2 - (float)n18;
                    if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                        if (this.setBackground) {
                            n16 = 0;
                            while (n16 < n7) {
                                byArray[n16][n13 + nArray[n16]] = byArray2[n16];
                                ++n16;
                            }
                        }
                    } else {
                        n16 = 0;
                        while (n16 < n7) {
                            int n19 = randomIter.getSample(n17, n18, n16) & 0xFF;
                            int n20 = randomIter.getSample(n17 + 1, n18, n16) & 0xFF;
                            int n21 = randomIter.getSample(n17, n18 + 1, n16) & 0xFF;
                            int n22 = randomIter.getSample(n17 + 1, n18 + 1, n16) & 0xFF;
                            float f5 = (float)(n20 - n19) * f3 + (float)n19;
                            float f6 = (float)(n22 - n21) * f3 + (float)n21;
                            float f7 = (f6 - f5) * f4 + f5;
                            byArray[n16][n13 + nArray[n16]] = (byte)f7;
                            ++n16;
                        }
                    }
                    n13 += n9;
                    ++n15;
                }
                ++n12;
            }
        } else {
            int n23 = 0;
            while (n23 < n6) {
                int n24 = n10;
                n10 += n8;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n23, n5, 1, fArray);
                int n25 = 0;
                int n26 = 0;
                while (n26 < n5) {
                    int n27;
                    float f = fArray[n25++];
                    float f8 = fArray[n25++];
                    int n28 = WarpBilinearOpImage.floor(f);
                    int n29 = WarpBilinearOpImage.floor(f8);
                    float f9 = f - (float)n28;
                    float f10 = f8 - (float)n29;
                    if (n28 < n || n28 >= n2 || n29 < n3 || n29 >= n4) {
                        if (this.setBackground) {
                            n27 = 0;
                            while (n27 < n7) {
                                byArray[n27][n24 + nArray[n27]] = byArray2[n27];
                                ++n27;
                            }
                        }
                    } else {
                        n27 = 0;
                        while (n27 < n7) {
                            byte[] byArray3 = this.ctable[n27];
                            int n30 = byArray3[randomIter.getSample(n28, n29, 0) & 0xFF] & 0xFF;
                            int n31 = byArray3[randomIter.getSample(n28 + 1, n29, 0) & 0xFF] & 0xFF;
                            int n32 = byArray3[randomIter.getSample(n28, n29 + 1, 0) & 0xFF] & 0xFF;
                            int n33 = byArray3[randomIter.getSample(n28 + 1, n29 + 1, 0) & 0xFF] & 0xFF;
                            float f11 = (float)(n31 - n30) * f9 + (float)n30;
                            float f12 = (float)(n33 - n32) * f9 + (float)n32;
                            float f13 = (f12 - f11) * f10 + f11;
                            byArray[n27][n24 + nArray[n27]] = (byte)f13;
                            ++n27;
                        }
                    }
                    n24 += n9;
                    ++n26;
                }
                ++n23;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        short[] sArray2 = new short[n7];
        int n11 = 0;
        while (n11 < n7) {
            sArray2[n11] = (short)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                float f = fArray[n14++];
                float f2 = fArray[n14++];
                int n17 = WarpBilinearOpImage.floor(f);
                int n18 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n17;
                float f4 = f2 - (float)n18;
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            sArray[n16][n13 + nArray[n16]] = sArray2[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        int n19 = randomIter.getSample(n17, n18, n16) & 0xFFFF;
                        int n20 = randomIter.getSample(n17 + 1, n18, n16) & 0xFFFF;
                        int n21 = randomIter.getSample(n17, n18 + 1, n16) & 0xFFFF;
                        int n22 = randomIter.getSample(n17 + 1, n18 + 1, n16) & 0xFFFF;
                        float f5 = (float)(n20 - n19) * f3 + (float)n19;
                        float f6 = (float)(n22 - n21) * f3 + (float)n21;
                        float f7 = (f6 - f5) * f4 + f5;
                        sArray[n16][n13 + nArray[n16]] = (short)f7;
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        short[] sArray2 = new short[n7];
        int n11 = 0;
        while (n11 < n7) {
            sArray2[n11] = (short)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                float f = fArray[n14++];
                float f2 = fArray[n14++];
                int n17 = WarpBilinearOpImage.floor(f);
                int n18 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n17;
                float f4 = f2 - (float)n18;
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            sArray[n16][n13 + nArray[n16]] = sArray2[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        int n19 = randomIter.getSample(n17, n18, n16);
                        int n20 = randomIter.getSample(n17 + 1, n18, n16);
                        int n21 = randomIter.getSample(n17, n18 + 1, n16);
                        int n22 = randomIter.getSample(n17 + 1, n18 + 1, n16);
                        float f5 = (float)(n20 - n19) * f3 + (float)n19;
                        float f6 = (float)(n22 - n21) * f3 + (float)n21;
                        float f7 = (f6 - f5) * f4 + f5;
                        sArray[n16][n13 + nArray[n16]] = (short)f7;
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int[] nArray3 = new int[n7];
        int n11 = 0;
        while (n11 < n7) {
            nArray3[n11] = (int)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                float f = fArray[n14++];
                float f2 = fArray[n14++];
                int n17 = WarpBilinearOpImage.floor(f);
                int n18 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n17;
                float f4 = f2 - (float)n18;
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            nArray2[n16][n13 + nArray[n16]] = nArray3[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        int n19 = randomIter.getSample(n17, n18, n16);
                        int n20 = randomIter.getSample(n17 + 1, n18, n16);
                        int n21 = randomIter.getSample(n17, n18 + 1, n16);
                        int n22 = randomIter.getSample(n17 + 1, n18 + 1, n16);
                        float f5 = (float)(n20 - n19) * f3 + (float)n19;
                        float f6 = (float)(n22 - n21) * f3 + (float)n21;
                        float f7 = (f6 - f5) * f4 + f5;
                        nArray2[n16][n13 + nArray[n16]] = (int)f7;
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n5];
        int n10 = 0;
        float[] fArray3 = new float[n7];
        int n11 = 0;
        while (n11 < n7) {
            fArray3[n11] = (float)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray2);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                float f = fArray2[n14++];
                float f2 = fArray2[n14++];
                int n17 = WarpBilinearOpImage.floor(f);
                int n18 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n17;
                float f4 = f2 - (float)n18;
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            fArray[n16][n13 + nArray[n16]] = fArray3[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        float f5;
                        float f6 = randomIter.getSampleFloat(n17, n18, n16);
                        float f7 = randomIter.getSampleFloat(n17 + 1, n18, n16);
                        float f8 = randomIter.getSampleFloat(n17, n18 + 1, n16);
                        float f9 = randomIter.getSampleFloat(n17 + 1, n18 + 1, n16);
                        float f10 = (f7 - f6) * f3 + f6;
                        float f11 = (f9 - f8) * f3 + f8;
                        fArray[n16][n13 + nArray[n16]] = f5 = (f11 - f10) * f4 + f10;
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15;
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n16 = WarpBilinearOpImage.floor(f);
                int n17 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n16;
                float f4 = f2 - (float)n17;
                if (n16 < n || n16 >= n2 || n17 < n3 || n17 >= n4) {
                    if (this.setBackground) {
                        n15 = 0;
                        while (n15 < n7) {
                            dArray[n15][n12 + nArray[n15]] = this.backgroundValues[n15];
                            ++n15;
                        }
                    }
                } else {
                    n15 = 0;
                    while (n15 < n7) {
                        double d;
                        double d2 = randomIter.getSampleDouble(n16, n17, n15);
                        double d3 = randomIter.getSampleDouble(n16 + 1, n17, n15);
                        double d4 = randomIter.getSampleDouble(n16, n17 + 1, n15);
                        double d5 = randomIter.getSampleDouble(n16 + 1, n17 + 1, n15);
                        double d6 = (d3 - d2) * (double)f3 + d2;
                        double d7 = (d5 - d4) * (double)f3 + d4;
                        dArray[n15][n12 + nArray[n15]] = d = (d7 - d6) * (double)f4 + d6;
                        ++n15;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }
}

