#!/usr/bin/perl -w

use lib '../blib/lib', '../blib/arch';

##  construct_dt_and_classify_one_sample_case4.pl

##  This example script is for purely nemeric features generated by the
##  TrainingDataGeneratorNumeric class using the information in the
##  parameter file param_numeric.txt The training data was generated by
##  script generate_training_data_numeric.pl

##  Now how we tell the module that the class labels are placed in column
##  indexed 1 and that the features are in columns indexed 2 and 3 of the
##  csv file.

##  Remember that column indexing of the csv file is zero-based.

use strict;
use Algorithm::DecisionTree;

my $training_datafile = "training4.csv";
#my $training_datafile = "training_new.csv";

my $dt = Algorithm::DecisionTree->new( 
                              training_datafile => $training_datafile,
                              csv_class_column_index => 1,
                              csv_columns_for_features => [2,3],
                              entropy_threshold => 0.01,
                              max_depth_desired => 3,
                              symbolic_to_numeric_cardinality_threshold => 10,
         );

$dt->get_training_data();
$dt->calculate_first_order_probabilities();
$dt->calculate_class_priors();

#   UNCOMMENT THE NEXT STATEMENT if you would like to see the
#   training data that was read from the disk file:
#$dt->show_training_data();

my $root_node = $dt->construct_decision_tree_classifier();

#   UNCOMMENT THE NEXT TWO STATEMENTs if you would like to see the
#   decision tree displayed in your terminal window:
print "\n\nThe Decision Tree:\n\n";
$root_node->display_decision_tree("     ");           

### The following test_sample is for the training files with names
### like training.dat training2.dat:

#my @test_sample  = qw /  gdp=50.155 return_on_invest=62.095 /;
my @test_sample  = qw /  gdp=48.650 return_on_invest=23.428 /;


#   The classifiy() in the call below returns a reference to a hash
#   whose keys are the class labels and the values the associated 
#   probabilities:

my %classification = %{$dt->classify($root_node, \@test_sample)};

my @solution_path = @{$classification{'solution_path'}};
delete $classification{'solution_path'};
my @which_classes = keys %classification;

@which_classes = sort {$classification{$b} <=> $classification{$a}} 
                                                     @which_classes;
print "\nClassification:\n\n";
print "     class                         probability\n";
print "     ----------                    -----------\n";
foreach my $which_class (@which_classes) {
    my $classstring = sprintf("%-30s", $which_class);
    my $valuestring = sprintf("%-30s", $classification{$which_class});
    print "     $classstring $valuestring\n";

}
print "\nSolution path in the decision tree: @solution_path\n";
print "\nNumber of nodes created: " . $root_node->how_many_nodes() . "\n";

