/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Platform;
import org.openqa.selenium.io.Zip;

public class FileHandler {
    public static void copyResource(File outputDir, Class<?> forClassLoader, String ... names) throws IOException {
        for (String name : names) {
            try (InputStream is = FileHandler.locateResource(forClassLoader, name);){
                Zip.unzipFile(outputDir, is, name);
            }
        }
    }

    private static InputStream locateResource(Class<?> forClassLoader, String name) throws IOException {
        String arch = Objects.requireNonNull(System.getProperty("os.arch")).toLowerCase() + "/";
        List<String> alternatives = Arrays.asList(name, "/" + name, arch + name, "/" + arch + name);
        if (Platform.getCurrent().is(Platform.MAC)) {
            alternatives.add("mac/" + name);
            alternatives.add("/mac/" + name);
        }
        for (String possibility : alternatives) {
            InputStream stream = FileHandler.class.getResourceAsStream(possibility);
            if (stream != null) {
                return stream;
            }
            stream = forClassLoader.getResourceAsStream(possibility);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("Unable to locate: " + name);
    }

    public static boolean createDir(File dir) throws IOException {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) throws IOException {
        return file.canWrite() || file.setWritable(true);
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".xpi");
    }

    public static boolean delete(File toDelete) {
        File[] children;
        boolean deleted = true;
        if (toDelete.isDirectory() && (children = toDelete.listFiles()) != null) {
            for (File child : children) {
                deleted &= child.canWrite() && FileHandler.delete(child);
            }
        }
        return deleted && toDelete.canWrite() && toDelete.delete();
    }

    public static void copy(File from, File to) throws IOException {
        if (!from.exists()) {
            return;
        }
        if (from.isDirectory()) {
            FileHandler.copyDir(from, to);
        } else {
            FileHandler.copyFile(from, to);
        }
    }

    private static void copyDir(File from, File to) throws IOException {
        FileHandler.createDir(to);
        String[] children = from.list();
        if (children == null) {
            throw new IOException("Could not copy directory " + from.getPath());
        }
        for (String child : children) {
            if (".parentlock".equals(child) || "parent.lock".equals(child)) continue;
            FileHandler.copy(new File(from, child), new File(to, child));
        }
    }

    private static void copyFile(File from, File to) throws IOException {
        try (FileOutputStream out = new FileOutputStream(to);){
            long copied = Files.copy(from.toPath(), out);
            long length = from.length();
            if (copied != length) {
                throw new IOException("Could not transfer all bytes from " + from + " to " + to);
            }
        }
    }
}

