/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration.json;

import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.internal.utils.configuration.json.GridJsonConfiguration;
import org.openqa.selenium.json.JsonInput;

public class HubJsonConfiguration
extends GridJsonConfiguration {
    private CapabilityMatcher capabilityMatcher = new DefaultCapabilityMatcher();
    private Integer newSessionWaitTimeout;
    private Prioritizer prioritizer;
    private Boolean throwOnCapabilityNotPresent;
    private String registry;
    private Integer cleanUpCycle;

    private HubJsonConfiguration() {
    }

    public static HubJsonConfiguration loadFromJson(JsonInput source) {
        HubJsonConfiguration config = HubJsonConfiguration.fromJson(source, HubJsonConfiguration.class);
        if (config.getRole() != null && !config.getRole().equals("hub")) {
            throw new RuntimeException("Unable to load hub configuration from " + source + " because it contains configuration for '" + config.getRole() + "' role");
        }
        return config;
    }

    public static HubJsonConfiguration loadFromResourceOrFile(String source) {
        HubJsonConfiguration config = HubJsonConfiguration.fromResourceOrFile(source, HubJsonConfiguration.class);
        if (config.getRole() != null && !config.getRole().equals("hub")) {
            throw new RuntimeException("Unable to load hub configuration from " + source + " because it contains configuration for '" + config.getRole() + "' role");
        }
        return config;
    }

    public CapabilityMatcher getCapabilityMatcher() {
        return this.capabilityMatcher;
    }

    public Integer getNewSessionWaitTimeout() {
        return this.newSessionWaitTimeout;
    }

    public Prioritizer getPrioritizer() {
        return this.prioritizer;
    }

    public Boolean getThrowOnCapabilityNotPresent() {
        return this.throwOnCapabilityNotPresent;
    }

    public String getRegistry() {
        return this.registry;
    }

    public Integer getCleanUpCycle() {
        return this.cleanUpCycle;
    }
}

