/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.plantuml.graph2.Neighborhood2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Singularity2 {
    private final TreeSet<Double> angles = new TreeSet();
    private final Point2D.Double center;

    public Singularity2(Point2D.Double double_) {
        this.center = double_;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.center.toString());
        for (Double d : this.angles) {
            int n = (int)(d * 180.0 / Math.PI);
            stringBuilder.append(' ');
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public void addLineSegment(Line2D.Double double_) {
        if (double_.getP1().equals(this.center)) {
            this.angles.add(Singularity2.convertAngle(Singularity2.getAngle(double_)));
        } else if (double_.getP2().equals(this.center)) {
            this.angles.add(Singularity2.convertAngle(Singularity2.getOppositeAngle(double_)));
        } else {
            throw new IllegalArgumentException();
        }
        assert (this.betweenZeroAndTwoPi());
    }

    static final double getAngle(Line2D.Double double_) {
        if (double_.getP1().equals(double_.getP2())) {
            throw new IllegalArgumentException();
        }
        return Math.atan2(double_.getP2().getY() - double_.getP1().getY(), double_.getP2().getX() - double_.getP1().getX());
    }

    static final double getOppositeAngle(Line2D.Double double_) {
        return Math.atan2(double_.getP1().getY() - double_.getP2().getY(), double_.getP1().getX() - double_.getP2().getX());
    }

    static double convertAngle(double d) {
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    private boolean betweenZeroAndTwoPi() {
        for (Double d : this.angles) {
            assert (d >= 0.0);
            assert (d < Math.PI * 2);
        }
        return true;
    }

    List<Double> getAngles() {
        return new ArrayList<Double>(this.angles);
    }

    public boolean crossing(Point2D.Double double_, Point2D.Double double_2) {
        boolean bl = this.crossingInternal(double_, double_2);
        assert (bl == this.crossingInternal(double_2, double_));
        return bl;
    }

    private boolean crossingInternal(Point2D.Double double_, Point2D.Double double_2) {
        if (this.angles.size() < 2) {
            return false;
        }
        double d = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, double_)));
        double d2 = Singularity2.convertAngle(Singularity2.getAngle(new Line2D.Double(this.center, double_2)));
        Double d3 = null;
        for (Double d4 : this.angles) {
            if (d3 != null) {
                assert (d3 < d4);
                if (this.isBetween(d, d3, d4) && this.isBetween(d2, d3, d4)) {
                    return false;
                }
            }
            d3 = d4;
        }
        double d5 = this.angles.first();
        return !(d <= d5) && !(d >= d3) || !(d2 <= d5) && !(d2 >= d3);
    }

    private boolean isBetween(double d, double d2, double d3) {
        assert (d2 < d3);
        return d >= d2 && d <= d3;
    }

    protected final Point2D.Double getCenter() {
        return this.center;
    }

    public void merge(Singularity2 singularity2) {
        this.angles.addAll(singularity2.angles);
    }

    public List<Neighborhood2> getNeighborhoods() {
        if (this.angles.size() == 0) {
            return Collections.singletonList(new Neighborhood2(this.center));
        }
        ArrayList<Neighborhood2> arrayList = new ArrayList<Neighborhood2>();
        double d = this.angles.last();
        for (Double d2 : this.angles) {
            arrayList.add(new Neighborhood2(this.center, d, d2));
            d = d2;
        }
        return Collections.unmodifiableList(arrayList);
    }
}

