/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eps;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalPosition;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EpsTitler {
    private final List<? extends CharSequence> text;
    private final HorizontalAlignment horizontalAlignment;
    private final VerticalPosition verticalPosition;
    private final int margin;
    private final TextBlock textBloc;
    private final EpsStrategy epsStrategy;
    private final ColorMapper colorMapper;

    public EpsTitler(ColorMapper colorMapper, EpsStrategy epsStrategy, HtmlColor htmlColor, List<? extends CharSequence> list, int n, String string, HorizontalAlignment horizontalAlignment, VerticalPosition verticalPosition, int n2) {
        this.text = list;
        this.colorMapper = colorMapper;
        this.epsStrategy = epsStrategy;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalPosition = verticalPosition;
        this.margin = n2;
        if (list == null || list.size() == 0) {
            this.textBloc = null;
        } else {
            UFont uFont = new UFont(string, 0, n);
            this.textBloc = TextBlockUtils.create(Display.create(list), new FontConfiguration(uFont, htmlColor), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        }
    }

    public double getHeight() {
        if (this.textBloc == null) {
            return 0.0;
        }
        return this.textBloc.calculateDimension(new UGraphicEps(this.colorMapper, this.epsStrategy).getStringBounder()).getHeight() + (double)this.margin;
    }

    public String addTitleEps(String string) throws IOException {
        double d;
        if (this.text == null || this.text.size() == 0) {
            return string;
        }
        int n = string.indexOf("%%BoundingBox:");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + "%%BoundingBox:".length()), " \n\t\r");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        assert (n4 >= n2);
        assert (n5 >= n3);
        double d2 = n4 - n2;
        double d3 = n5 - n3;
        UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, this.epsStrategy);
        Dimension2D dimension2D = this.textBloc.calculateDimension(uGraphicEps.getStringBounder());
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            d = 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            d = d2 - dimension2D.getWidth() - 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            d = (d2 - dimension2D.getWidth()) / 2.0;
        } else {
            d = 0.0;
            assert (false);
        }
        double d4 = this.verticalPosition == VerticalPosition.TOP ? 0.0 : d3 + (double)this.margin;
        this.textBloc.drawU(uGraphicEps.apply(new UTranslate(d, d4)));
        double d5 = this.verticalPosition == VerticalPosition.TOP ? dimension2D.getHeight() : 0.0;
        uGraphicEps.drawEps(string, 0.0, d5);
        uGraphicEps.close();
        return uGraphicEps.getEPSCode();
    }
}

