#!perl -w
use strict;
use Test::More tests => 180;
use Set::Infinite;

for ( split /\s+/m => q%

  [1,3]^[0,4]=1  [1,3]^[1,4]=1  [1,3]^[2,4]=1  [1,3]^[3,4]=1  [1,3]^[4,4]=0

  [1,3]^[0,3]=1  [1,3]^[1,3]=1  [1,3]^[2,3]=1  [1,3]^[3,3]=1

  [1,3]^[0,2]=1  [1,3]^[1,2]=1  [1,3]^[2,2]=1

  [1,3]^[0,1]=1  [1,3]^[1,1]=1

  [1,3]^[0,0]=0


  [1,3]^[0,4)=1  [1,3]^[1,4)=1  [1,3]^[2,4)=1  [1,3]^[3,4)=1  

  [1,3]^[0,3)=1  [1,3]^[1,3)=1  [1,3]^[2,3)=1  

  [1,3]^[0,2)=1  [1,3]^[1,2)=1  

  [1,3]^[0,1)=0  


  [1,3]^(0,4)=1  [1,3]^(1,4)=1  [1,3]^(2,4)=1  [1,3]^(3,4)=0  

  [1,3]^(0,3)=1  [1,3]^(1,3)=1  [1,3]^(2,3)=1  

  [1,3]^(0,2)=1  [1,3]^(1,2)=1  

  [1,3]^(0,1)=0 


  [1,3]^(0,4]=1  [1,3]^(1,4]=1  [1,3]^(2,4]=1  [1,3]^(3,4]=0

  [1,3]^(0,3]=1  [1,3]^(1,3]=1  [1,3]^(2,3]=1  

  [1,3]^(0,2]=1  [1,3]^(1,2]=1  

  [1,3]^(0,1]=1 



  [1,3)^[0,4]=1  [1,3)^[1,4]=1  [1,3)^[2,4]=1  [1,3)^[3,4]=0  [1,3)^[4,4]=0

  [1,3)^[0,3]=1  [1,3)^[1,3]=1  [1,3)^[2,3]=1  [1,3)^[3,3]=0

  [1,3)^[0,2]=1  [1,3)^[1,2]=1  [1,3)^[2,2]=1

  [1,3)^[0,1]=1  [1,3)^[1,1]=1

  [1,3)^[0,0]=0


  [1,3)^[0,4)=1  [1,3)^[1,4)=1  [1,3)^[2,4)=1  [1,3)^[3,4)=0  

  [1,3)^[0,3)=1  [1,3)^[1,3)=1  [1,3)^[2,3)=1  

  [1,3)^[0,2)=1  [1,3)^[1,2)=1  

  [1,3)^[0,1)=0  


  [1,3)^(0,4)=1  [1,3)^(1,4)=1  [1,3)^(2,4)=1  [1,3)^(3,4)=0  

  [1,3)^(0,3)=1  [1,3)^(1,3)=1  [1,3)^(2,3)=1  

  [1,3)^(0,2)=1  [1,3)^(1,2)=1  

  [1,3)^(0,1)=0 


  [1,3)^(0,4]=1  [1,3)^(1,4]=1  [1,3)^(2,4]=1  [1,3)^(3,4]=0

  [1,3)^(0,3]=1  [1,3)^(1,3]=1  [1,3)^(2,3]=1  

  [1,3)^(0,2]=1  [1,3)^(1,2]=1  

  [1,3)^(0,1]=1 



  (1,3]^[0,4]=1  (1,3]^[1,4]=1  (1,3]^[2,4]=1  (1,3]^[3,4]=1  (1,3]^[4,4]=0

  (1,3]^[0,3]=1  (1,3]^[1,3]=1  (1,3]^[2,3]=1  (1,3]^[3,3]=1

  (1,3]^[0,2]=1  (1,3]^[1,2]=1  (1,3]^[2,2]=1

  (1,3]^[0,1]=0  (1,3]^[1,1]=0

  (1,3]^[0,0]=0


  (1,3]^[0,4)=1  (1,3]^[1,4)=1  (1,3]^[2,4)=1  (1,3]^[3,4)=1  

  (1,3]^[0,3)=1  (1,3]^[1,3)=1  (1,3]^[2,3)=1  

  (1,3]^[0,2)=1  (1,3]^[1,2)=1  

  (1,3]^[0,1)=0  


  (1,3]^(0,4)=1  (1,3]^(1,4)=1  (1,3]^(2,4)=1  (1,3]^(3,4)=0  

  (1,3]^(0,3)=1  (1,3]^(1,3)=1  (1,3]^(2,3)=1  

  (1,3]^(0,2)=1  (1,3]^(1,2)=1  

  (1,3]^(0,1)=0 


  (1,3]^(0,4]=1  (1,3]^(1,4]=1  (1,3]^(2,4]=1  (1,3]^(3,4]=0

  (1,3]^(0,3]=1  (1,3]^(1,3]=1  (1,3]^(2,3]=1  

  (1,3]^(0,2]=1  (1,3]^(1,2]=1  

  (1,3]^(0,1]=0 


  (1,3)^[0,4]=1  (1,3)^[1,4]=1  (1,3)^[2,4]=1  (1,3)^[3,4]=0  (1,3)^[4,4]=0

  (1,3)^[0,3]=1  (1,3)^[1,3]=1  (1,3)^[2,3]=1  (1,3)^[3,3]=0

  (1,3)^[0,2]=1  (1,3)^[1,2]=1  (1,3)^[2,2]=1

  (1,3)^[0,1]=0  (1,3)^[1,1]=0

  (1,3)^[0,0]=0


  (1,3)^[0,4)=1  (1,3)^[1,4)=1  (1,3)^[2,4)=1  (1,3)^[3,4)=0  

  (1,3)^[0,3)=1  (1,3)^[1,3)=1  (1,3)^[2,3)=1  

  (1,3)^[0,2)=1  (1,3)^[1,2)=1  

  (1,3)^[0,1)=0  


  (1,3)^(0,4)=1  (1,3)^(1,4)=1  (1,3)^(2,4)=1  (1,3)^(3,4)=0  

  (1,3)^(0,3)=1  (1,3)^(1,3)=1  (1,3)^(2,3)=1  

  (1,3)^(0,2)=1  (1,3)^(1,2)=1  

  (1,3)^(0,1)=0 


  (1,3)^(0,4]=1  (1,3)^(1,4]=1  (1,3)^(2,4]=1  (1,3)^(3,4]=0

  (1,3)^(0,3]=1  (1,3)^(1,3]=1  (1,3)^(2,3]=1  

  (1,3)^(0,2]=1  (1,3)^(1,2]=1  

  (1,3)^(0,1]=0 

% ) {
    # print " test *$_*\n";
    my ( $a1, $b1, $c1, $d1, $op,
         $a2, $b2, $c2, $d2,
         $result ) = /(.)(\d+),(\d+)(.)(.)(.)(\d+),(\d+)(.)=(\d+)/;
    next unless $a1;
    next if $a1 eq '*';
    my $s1 = Set::Infinite->new( $b1, $c1 );
    $s1 = $s1->complement( $b1 ) if $a1 eq '(';
    $s1 = $s1->complement( $c1 ) if $d1 eq ')';
    my $s2 = Set::Infinite->new( $b2, $c2 );
    $s2 = $s2->complement( $b2 ) if $a2 eq '(';
    $s2 = $s2->complement( $c2 ) if $d2 eq ')';
    my $s3;
    $s3 = $s1->intersects( $s2 ) if $op eq '^';
    # print " $s1 $op $s2 = $s3 \n";
    is ( $s3, $result, $op ); 
}

1;

