package Locales::DB::Language::ar;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::ar::VERSION = '0.09';

$Locales::DB::Language::ar::cldr_version = '2.0';

%Locales::DB::Language::ar::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => '٫',
        '_decimal_format_group'   => '٬',
        '_percent_format_percent' => '٪',
        'decimal'                 => "\#\,\#\#0\.\#\#\#\;\#\,\#\#0\.\#\#\#\-",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "اللغة\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ و\ \{1\}",
            'end'    => "\{0\}،\ و\ \{1\}",
            'middle' => "\{0\}،\ \{1\}",
            'start'  => "\{0\}،\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "المنطقة\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'two',
            'few',
            'many',
            'zero',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ mod\ 100\ in\ 3\.\.10",
            'many' => "n\ mod\ 100\ in\ 11\.\.99",
            'one'  => "n\ is\ 1",
            'two'  => "n\ is\ 2",
            'zero' => "n\ is\ 0"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 3 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 10 ) ) ) { return 'few'; }
                return;
            },
            'many' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 11 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 99 ) ) ) { return 'many'; }
                return;
            },
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            },
            'two' => sub {
                if ( ( ( $_[0] == 2 ) ) ) { return 'two'; }
                return;
            },
            'zero' => sub {
                if ( ( ( $_[0] == 0 ) ) ) { return 'zero'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "لا\:ل",
        'yesstr' => "نعم\:ن"
    },
);

%Locales::DB::Language::ar::code_to_name = (
    'aa'     => 'الأفارية',
    'ab'     => 'الأبخازية',
    'ace'    => 'الأتشينيزية',
    'ach'    => 'الأكولية',
    'ada'    => 'الأدانجمية',
    'ady'    => 'الأديجه',
    'ae'     => 'الأفستية',
    'af'     => 'الأفريقية',
    'afa'    => "لغة\ أفرو\ آسيوية",
    'afh'    => 'الأفريهيلية',
    'agq'    => 'agq',
    'ain'    => 'الآينوية',
    'ak'     => 'الأكانية',
    'akk'    => 'الأكادية',
    'ale'    => 'الأليوتية',
    'alg'    => "اللغات\ الأمريكية\ الهندية",
    'alt'    => "الألطائية\ الجنوبية",
    'am'     => 'الأمهرية',
    'an'     => 'الأراجونية',
    'ang'    => "الإنجليزية\ القديمة",
    'anp'    => 'الأنجيكا',
    'apa'    => "اللغات\ الأباتشية",
    'ar'     => 'العربية',
    'arc'    => 'الآرامية',
    'arn'    => 'الأروكانية',
    'arp'    => 'الأراباهو',
    'art'    => "الصناعية\ \-\ أخرى",
    'arw'    => 'الأراواكية',
    'as'     => 'الأسامية',
    'asa'    => 'asa',
    'ast'    => 'الأسترية',
    'ath'    => "اللغة\ الأزباسكانية",
    'aus'    => "اللغة\ الأسترالية",
    'av'     => 'الأفاريكية',
    'awa'    => 'الأوادية',
    'ay'     => 'الأيمارا',
    'az'     => 'الأذرية',
    'ba'     => 'الباشكيرية',
    'bad'    => 'الباندا',
    'bai'    => "اللغة\ الباميليكية",
    'bal'    => 'البلوشية',
    'ban'    => "اللغة\ البالية",
    'bas'    => 'الباسا',
    'bat'    => "اللغة\ البلطيقية",
    'be'     => 'البيلوروسية',
    'bej'    => 'البيجا',
    'bem'    => 'البيمبا',
    'ber'    => 'البربرية',
    'bez'    => 'bez',
    'bg'     => 'البلغارية',
    'bh'     => 'البيهارية',
    'bho'    => 'البهوجبرية',
    'bi'     => 'البيسلامية',
    'bik'    => 'البيكولية',
    'bin'    => 'البينية',
    'bla'    => 'السيكسيكية',
    'bm'     => 'البامبارا',
    'bn'     => 'البنغالية',
    'bnt'    => 'البانتو',
    'bo'     => 'التبتية',
    'br'     => 'البريتونية',
    'bra'    => 'البراجية',
    'brx'    => 'brx',
    'bs'     => 'البوسنية',
    'btk'    => 'الباتاكية',
    'bua'    => 'البرياتية',
    'bug'    => 'البجينيزية',
    'byn'    => 'البلينية',
    'ca'     => 'الكتالانية',
    'cad'    => 'الكادو',
    'cai'    => "اللغة\ الهندية\ الأمريكية\ الوسطى",
    'car'    => 'الكاريبية',
    'cau'    => "القوقازية\ \-\ أخرى",
    'cay'    => 'Cayuga',
    'cch'    => 'الأتسام',
    'ce'     => 'الشيشانية',
    'ceb'    => 'السيبيونو',
    'cel'    => "السلتية\ \-\ أخرى",
    'cgg'    => 'Chiga',
    'ch'     => 'التشامورو',
    'chb'    => 'التشيبشا',
    'chg'    => 'التشاجاتاي',
    'chk'    => 'التشكيزية',
    'chm'    => 'الماري',
    'chn'    => "الشينوك\ جارجون",
    'cho'    => 'الشوكتو',
    'chp'    => 'الشيباوايان',
    'chr'    => 'الشيروكي',
    'chy'    => 'الشايان',
    'cmc'    => "اللغة\ التشاميكية",
    'co'     => 'الكورسيكية',
    'cop'    => 'القبطية',
    'cpe'    => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ على\ أساس\ الأنجليزية",
    'cpf'    => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ على\ أساس\ الفرنسية",
    'cpp'    => "الكرييولي\ واللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ على\ أساس\ البرتغالية",
    'cr'     => 'الكرى',
    'crh'    => "التركية\ الكريمينية",
    'crp'    => "الكرييولى\ و\ اللغات\ المبسطة\ الأخرى\ للتفاهم\ بين\ الشعوب\ \-\ أخرى",
    'cs'     => 'التشيكية',
    'csb'    => 'الكاشبايان',
    'cu'     => "سلافية\ كنسية",
    'cus'    => "اللغة\ الكشيتيكية",
    'cv'     => 'التشفاش',
    'cy'     => 'الولزية',
    'da'     => 'الدانماركية',
    'dak'    => 'الداكوتا',
    'dar'    => 'الدارجوا',
    'dav'    => 'Taita',
    'day'    => 'الدياك',
    'de'     => 'الألمانية',
    'de_at'  => "الألمانية\ النمساوية",
    'de_ch'  => "الألمانية\ العليا\ السويسرية",
    'del'    => 'الديلوير',
    'den'    => 'السلافية',
    'dgr'    => 'الدوجريب',
    'din'    => 'الدنكا',
    'dje'    => 'Zarma',
    'doi'    => 'الدوجري',
    'dra'    => "اللغة\ الدرافيدينية",
    'dsb'    => "الصربية\ السفلى",
    'dua'    => 'الديولا',
    'dum'    => "الهولندية\ الوسطى",
    'dv'     => 'المالديفية',
    'dyo'    => 'dyo',
    'dyu'    => 'الدايلا',
    'dz'     => 'الزونخاية',
    'ebu'    => 'ebu',
    'ee'     => 'الإيوي',
    'efi'    => 'الإفيك',
    'egy'    => "المصرية\ القديمة",
    'eka'    => 'الإكاجك',
    'el'     => 'اليونانية',
    'elx'    => 'الإمايت',
    'en'     => 'الإنجليزية',
    'en_au'  => "الإنجليزية\ الأسترالية",
    'en_ca'  => "الإنجليزية\ الكندية",
    'en_gb'  => "الإنجليزية\ البريطانية",
    'en_us'  => "الإنجليزية\ الولايات\ المتحدة",
    'enm'    => "الإنجليزية\ الوسطى",
    'eo'     => 'الإسبرانتو',
    'es'     => 'الإسبانية',
    'es_419' => "إسبانية\ أمريكا\ اللاتينية",
    'es_es'  => "الإسبانية\ الأيبيرية",
    'et'     => 'الإستونية',
    'eu'     => "لغة\ الباسك",
    'ewo'    => 'الإيوندو',
    'fa'     => 'الفارسية',
    'fan'    => 'الفانج',
    'fat'    => 'الفانتي',
    'ff'     => 'الفلة',
    'fi'     => 'الفنلندية',
    'fil'    => 'الفلبينية',
    'fiu'    => "لغة\ فينو\ أجريانية",
    'fj'     => 'الفيجية',
    'fo'     => 'الفارويز',
    'fon'    => 'الفون',
    'fr'     => 'الفرنسية',
    'fr_ca'  => "الفرنسية\ الكندية",
    'fr_ch'  => "الفرنسية\ السويسرية",
    'frm'    => "الفرنسية\ الوسطى",
    'fro'    => "الفرنسية\ القديمة",
    'frr'    => "الفريزينية\ الشمالية",
    'frs'    => "الفريزينية\ الشرقية",
    'fur'    => 'الفريلايان',
    'fy'     => 'الفريزيان',
    'ga'     => 'الأيرلندية',
    'gaa'    => 'الجا',
    'gay'    => 'الجايو',
    'gba'    => 'الجبيا',
    'gd'     => "الغيلية\ الأسكتلندية",
    'gem'    => "اللغة\ الجرمانية",
    'gez'    => 'الجيز',
    'gil'    => "لغة\ أهل\ جبل\ طارق",
    'gl'     => 'الجاليكية',
    'gmh'    => "الألمانية\ العليا\ الوسطى",
    'gn'     => 'الجواراني',
    'goh'    => "الألمانية\ العليا\ القديمة",
    'gon'    => 'الجندي',
    'gor'    => 'الجورونتالو',
    'got'    => 'القوطية',
    'grb'    => 'الجريبو',
    'grc'    => "اليونانية\ القديمة",
    'gsw'    => "الألمانية\ السويسرية",
    'gu'     => 'الغوجاراتية',
    'guz'    => 'Gusii',
    'gv'     => 'المنكية',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'الهوسا',
    'hai'    => 'الهيدا',
    'haw'    => "لغة\ أهل\ الهاواي",
    'he'     => 'العبرية',
    'hi'     => 'الهندية',
    'hil'    => 'الهيليجينون',
    'him'    => 'الهيماتشالي',
    'hit'    => 'الحثية',
    'hmn'    => 'الهمونجية',
    'ho'     => "الهيري\ موتو",
    'hr'     => 'الكرواتية',
    'hsb'    => "الصربية\ العليا",
    'ht'     => 'الهايتية',
    'hu'     => 'الهنغارية',
    'hup'    => 'الهبا',
    'hy'     => 'الأرمينية',
    'hz'     => 'الهيريرو',
    'ia'     => "اللّغة\ الوسيطة",
    'iba'    => 'الإيبان',
    'id'     => 'الإندونيسية',
    'ie'     => 'الإنترلينج',
    'ig'     => 'الإيجبو',
    'ii'     => "السيتشيون\ يي",
    'ijo'    => 'الإجو',
    'ik'     => 'الإينبياك',
    'ilo'    => 'الإيلوكو',
    'inc'    => "اللغة\ الهندية",
    'ine'    => "الهندية\ الأوروبية\ \-\ أخرى",
    'inh'    => 'الإنجوشية',
    'io'     => 'الإيدو',
    'ira'    => "اللغة\ الإيرانية",
    'iro'    => "اللغة\ الإيروكويانية",
    'is'     => 'الأيسلاندية',
    'it'     => 'الإيطالية',
    'iu'     => 'الإينكتيتت',
    'ja'     => 'اليابانية',
    'jbo'    => 'اللوجبان',
    'jmc'    => 'Machame',
    'jpr'    => "الجيدو\ \-\ الفارسي",
    'jrb'    => "الجيدو\ \-\ العربي",
    'jv'     => 'الجاوية',
    'ka'     => 'الجورجية',
    'kaa'    => "الكارا\-كالباك",
    'kab'    => 'القبيلية',
    'kac'    => 'الكاتشين',
    'kaj'    => 'الجو',
    'kam'    => 'الكامبا',
    'kar'    => 'الكاريين',
    'kaw'    => 'الكوي',
    'kbd'    => 'الكاباردايان',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'kea',
    'kfo'    => 'الكورو',
    'kg'     => 'الكونغو',
    'kha'    => 'الكازية',
    'khi'    => "اللغة\ الخويسانية",
    'kho'    => 'الخوتانيز',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'الكيكيو',
    'kj'     => 'الكيونياما',
    'kk'     => 'الكازاخستانية',
    'kl'     => 'الكالاليست',
    'kln'    => 'Kalenjin',
    'km'     => 'الخميرية',
    'kmb'    => 'الكيمبندو',
    'kn'     => 'الكانادا',
    'ko'     => 'الكورية',
    'kok'    => 'الكونكانية',
    'kos'    => 'الكوسراين',
    'kpe'    => 'الكبيل',
    'kr'     => 'الكانيوري',
    'krc'    => "الكاراتشاي\-بالكار",
    'krl'    => 'الكريلية',
    'kro'    => 'الكرو',
    'kru'    => 'Kurukh',
    'ks'     => 'الكاشميرية',
    'ksb'    => 'Shambala',
    'ksf'    => 'ksf',
    'ksh'    => 'Colognian',
    'ku'     => 'الكردية',
    'kum'    => 'الكميك',
    'kut'    => 'الكتيناي',
    'kv'     => 'الكومي',
    'kw'     => 'الكورنية',
    'ky'     => 'القيرغستانية',
    'la'     => 'اللاتينية',
    'lad'    => 'الإسباعبرية',
    'lag'    => 'Langi',
    'lah'    => 'اللاهندا',
    'lam'    => 'اللامبا',
    'lb'     => 'اللوكسمبرجية',
    'lez'    => 'الليزجهايانية',
    'lg'     => 'الجاندا',
    'li'     => 'الليمبرجيشية',
    'ln'     => 'اللينجالا',
    'lo'     => 'اللاوية',
    'lol'    => 'منغولى',
    'loz'    => 'اللوزي',
    'lt'     => 'اللتوانية',
    'lu'     => "اللبا\-كاتانجا",
    'lua'    => "اللبا\-لؤلؤ",
    'lui'    => 'اللوسينو',
    'lun'    => 'اللوندا',
    'luo'    => 'اللو',
    'lus'    => 'اللشاي',
    'luy'    => 'luy',
    'lv'     => 'اللاتفية',
    'mad'    => 'المادريز',
    'mag'    => 'الماجا',
    'mai'    => 'المايثيلي',
    'mak'    => 'الماكاسار',
    'man'    => 'الماندينغ',
    'map'    => 'الأوسترونيسيان',
    'mas'    => 'الماساي',
    'mdf'    => 'الموكشا',
    'mdr'    => 'الماندار',
    'men'    => 'الميند',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'المالاجاشية',
    'mga'    => "الأيرلندية\ الوسطى",
    'mgh'    => 'mgh',
    'mh'     => 'المارشالية',
    'mi'     => 'الماورية',
    'mic'    => 'الميكماكيونية',
    'min'    => 'المينانجكاباو',
    'mis'    => "اللغة\ المتنوعة",
    'mk'     => 'المقدونية',
    'mkh'    => "لغة\ المون\ \-\ خمير",
    'ml'     => 'الماليالام',
    'mn'     => 'المنغولية',
    'mnc'    => 'المانشو',
    'mni'    => 'المانيبري',
    'mno'    => "لغات\ مانوبو",
    'mo'     => 'المولدوفية',
    'moh'    => 'الموهوك',
    'mos'    => 'الموسي',
    'mr'     => 'الماراثي',
    'ms'     => "لغة\ الملايو",
    'mt'     => 'المالطية',
    'mua'    => 'mua',
    'mul'    => "لغات\ متعددة",
    'mun'    => "لغة\ المندا",
    'mus'    => 'الكريك',
    'mwl'    => 'الميرانديز',
    'mwr'    => 'المارواري',
    'my'     => 'البورمية',
    'myn'    => "لغة\ المايا",
    'myv'    => 'الأرزية',
    'na'     => 'النورو',
    'nah'    => 'الناهيوتل',
    'nai'    => "اللغة\ الهندية\ الأمريكية\ الشمالية",
    'nap'    => "اللغة\ النابولية",
    'naq'    => 'Nama',
    'nb'     => "البوكمالية\ النرويجية",
    'nd'     => "النديبيل\ الشمالي",
    'nds'    => "الألمانية\ السفلى",
    'ne'     => 'النيبالية',
    'new'    => 'النيواري',
    'ng'     => 'الندونجا',
    'nia'    => 'النياس',
    'nic'    => "النيجر\ \-\ كوردوفانايان",
    'niu'    => 'النيوي',
    'nl'     => 'الهولندية',
    'nl_be'  => 'الفلمنك',
    'nmg'    => 'nmg',
    'nn'     => "النينورسك\ النرويجي",
    'no'     => 'النرويجية',
    'nog'    => 'النوجاي',
    'non'    => "النورس\ القديم",
    'nqo'    => 'أنكو',
    'nr'     => "النديبيل\ الجنوبي",
    'nso'    => "السوتو\ الشمالية",
    'nub'    => "لغة\ نوبية",
    'nus'    => 'nus',
    'nv'     => 'النافاجو',
    'nwc'    => "النوارية\ التقليدية",
    'ny'     => 'النيانجا',
    'nym'    => 'النيامويزي',
    'nyn'    => 'النيانكول',
    'nyo'    => 'النيورو',
    'nzi'    => 'النزيما',
    'oc'     => 'الأوكيتانية',
    'oj'     => 'الأوجيبوا',
    'om'     => 'الأورومو',
    'or'     => 'الأورييا',
    'os'     => 'الأوسيتيك',
    'osa'    => 'الأوساج',
    'ota'    => "التركية\ العثمانية",
    'oto'    => "اللغة\ الأوتومية",
    'pa'     => 'البنجابية',
    'paa'    => "اللغة\ الغينية",
    'pag'    => 'البانجاسينان',
    'pal'    => 'البهلوية',
    'pam'    => 'البامبانجا',
    'pap'    => 'البابيامينتو',
    'pau'    => 'البالوان',
    'peo'    => "الفارسية\ القديمة",
    'phi'    => "اللغة\ الفليبينية",
    'phn'    => 'الفينيقية',
    'pi'     => 'البالية',
    'pl'     => 'البولندية',
    'pon'    => 'البوهنبيايان',
    'pra'    => "اللغات\ البراقريطية",
    'pro'    => "البروفانسية\ القديمة",
    'ps'     => 'بشتو',
    'pt'     => 'البرتغالية',
    'pt_br'  => "البرتغالية\ البرازيلية",
    'pt_pt'  => "البرتغالية\ الأيبيرية",
    'qu'     => 'الكويتشوا',
    'raj'    => 'الراجاسثانية',
    'rap'    => 'الراباني',
    'rar'    => 'الراروتونجاني',
    'rm'     => "الرهايتو\-رومانس",
    'rn'     => 'الرندي',
    'ro'     => 'الرومانية',
    'roa'    => "اللغة\ الرومانسية",
    'rof'    => 'Rombo',
    'rom'    => 'غجري',
    'ru'     => 'الروسية',
    'rup'    => 'الأرومانيان',
    'rw'     => 'الكينيارواندا',
    'rwk'    => 'Rwa',
    'sa'     => 'السنسكريتية',
    'sad'    => 'السانداوي',
    'sah'    => 'الساخية',
    'sai'    => "اللغة\ الهندية\ الأمريكية\ الجنوبية",
    'sal'    => "اللغة\ الساليشانية",
    'sam'    => "الآرامية\ السومارية",
    'saq'    => 'Samburu',
    'sas'    => 'الساساك',
    'sat'    => 'السانتالي',
    'sbp'    => 'Sangu',
    'sc'     => 'السردينية',
    'scn'    => 'الصقلية',
    'sco'    => 'الأسكتلندية',
    'sd'     => 'السيندي',
    'se'     => "السامي\ الشمالي",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'السيلكب',
    'sem'    => "لغة\ سامية",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'السانجو',
    'sga'    => "الأيرلندية\ القديمة",
    'sgn'    => "لغات\ الإشارة",
    'sh'     => "Serbo\-Croatian",
    'shi'    => 'Tachelhit',
    'shn'    => 'الشانية',
    'si'     => 'السنهالية',
    'sid'    => 'السيدامو',
    'sio'    => "لغة\ السيويون",
    'sit'    => "اللغة\ الصينية\ التيبتية",
    'sk'     => 'السلوفاكية',
    'sl'     => 'السلوفانية',
    'sla'    => "اللغة\ السلافية",
    'sm'     => 'الساموائية',
    'sma'    => "السامي\ الجنوبي",
    'smi'    => "اللغة\ السامية",
    'smj'    => "اللول\ سامي",
    'smn'    => "الإيناري\ سامي",
    'sms'    => "السكولت\ سامي",
    'sn'     => 'الشونا',
    'snk'    => 'السونينك',
    'so'     => 'الصومالية',
    'sog'    => 'السوجدين',
    'son'    => 'السونجهاي',
    'sq'     => 'الألبانية',
    'sr'     => 'الصربية',
    'srn'    => "السرانان\ تونجو",
    'srr'    => 'السرر',
    'ss'     => 'السواتي',
    'ssa'    => "لغة\ نيلية\ الصحراوية",
    'ssy'    => 'Saho',
    'st'     => "السوتو\ الجنوبية",
    'su'     => 'السودانية',
    'suk'    => 'السوكوما',
    'sus'    => 'السوسو',
    'sux'    => 'السومارية',
    'sv'     => 'السويدية',
    'sw'     => 'السواحلية',
    'swb'    => 'القمرية',
    'swc'    => "Congo\ Swahili",
    'syc'    => "سريانية\ تقليدية",
    'syr'    => 'السريانية',
    'ta'     => 'التاميلية',
    'tai'    => "لغة\ تاي",
    'te'     => 'التيلجو',
    'tem'    => 'التيمن',
    'teo'    => 'Teso',
    'ter'    => 'التيرينو',
    'tet'    => 'التيتم',
    'tg'     => 'الطاجيكية',
    'th'     => 'التايلاندية',
    'ti'     => 'التيجرينيا',
    'tig'    => 'التيجر',
    'tiv'    => 'التيف',
    'tk'     => 'التركمانية',
    'tkl'    => 'التوكيلاو',
    'tl'     => 'التاغالوغية',
    'tlh'    => 'الكلينجون',
    'tli'    => 'التلينغيتية',
    'tmh'    => 'التاماشيك',
    'tn'     => 'التسوانية',
    'to'     => 'التونغية',
    'tog'    => "تونجا\ \-\ نياسا",
    'tpi'    => "التوك\ بيسين",
    'tr'     => 'التركية',
    'trv'    => 'Taroko',
    'ts'     => 'السونجا',
    'tsi'    => 'التسيمشيان',
    'tt'     => 'التتارية',
    'tum'    => 'التامبوكا',
    'tup'    => "اللغة\ التوبية",
    'tut'    => "الألطائية\ \-\ أخرى",
    'tvl'    => 'التوفالو',
    'tw'     => 'التوي',
    'twq'    => 'Tasawaq',
    'ty'     => 'التاهيتية',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'الأدمرت',
    'ug'     => 'الأيغورية',
    'uga'    => 'اليجاريتيك',
    'uk'     => 'الأوكرانية',
    'umb'    => 'الأمبندو',
    'und'    => "لغة\ غير\ معروفة",
    'ur'     => 'الأردية',
    'uz'     => 'الأوزباكية',
    'vai'    => 'الفاي',
    've'     => 'الفيندا',
    'vi'     => 'الفيتنامية',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'الفوتيك',
    'vun'    => 'Vunjo',
    'wa'     => 'الولونية',
    'wae'    => 'Walser',
    'wak'    => "اللغة\ الواكاشانية",
    'wal'    => 'الوالامو',
    'war'    => 'الواراي',
    'was'    => 'الواشو',
    'wen'    => "اللغة\ الصربية",
    'wo'     => 'الولوف',
    'xal'    => 'الكالميك',
    'xh'     => 'الخوسا',
    'xog'    => 'Soga',
    'yao'    => 'الياو',
    'yap'    => 'اليابيز',
    'yav'    => 'Yangben',
    'yi'     => 'اليديشية',
    'yo'     => 'اليوروبية',
    'ypk'    => "اللغة\ اليوبيكية",
    'yue'    => 'الكَنْتُونية',
    'za'     => 'الزهيونج',
    'zap'    => 'الزابوتيك',
    'zbl'    => 'Blissymbols',
    'zen'    => 'الزيناجا',
    'zh'     => 'الصينية',
    'znd'    => 'الزاند',
    'zu'     => 'الزولو',
    'zun'    => 'الزونية',
    'zxx'    => "بدون\ محتوى\ لغوي",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::ar::name_to_code = (
    'agq'                                                                                                                          => 'agq',
    'asa'                                                                                                                          => 'asa',
    'bez'                                                                                                                          => 'bez',
    'blissymbols'                                                                                                                  => 'zbl',
    'brx'                                                                                                                          => 'brx',
    'cayuga'                                                                                                                       => 'cay',
    'centralmoroccotamazight'                                                                                                      => 'tzm',
    'chiga'                                                                                                                        => 'cgg',
    'colognian'                                                                                                                    => 'ksh',
    'congoswahili'                                                                                                                 => 'swc',
    'dyo'                                                                                                                          => 'dyo',
    'ebu'                                                                                                                          => 'ebu',
    'gusii'                                                                                                                        => 'guz',
    "gwich\Ê\¼in"                                                                                                                => 'gwi',
    'kalenjin'                                                                                                                     => 'kln',
    'kea'                                                                                                                          => 'kea',
    'koyraborosenni'                                                                                                               => 'ses',
    'koyrachiini'                                                                                                                  => 'khq',
    'ksf'                                                                                                                          => 'ksf',
    'kurukh'                                                                                                                       => 'kru',
    'langi'                                                                                                                        => 'lag',
    'luy'                                                                                                                          => 'luy',
    'machame'                                                                                                                      => 'jmc',
    'makonde'                                                                                                                      => 'kde',
    'meru'                                                                                                                         => 'mer',
    'mgh'                                                                                                                          => 'mgh',
    'morisyen'                                                                                                                     => 'mfe',
    'mua'                                                                                                                          => 'mua',
    'nama'                                                                                                                         => 'naq',
    'nmg'                                                                                                                          => 'nmg',
    'nus'                                                                                                                          => 'nus',
    'rombo'                                                                                                                        => 'rof',
    'rwa'                                                                                                                          => 'rwk',
    'saho'                                                                                                                         => 'ssy',
    'samburu'                                                                                                                      => 'saq',
    'sangu'                                                                                                                        => 'sbp',
    'sena'                                                                                                                         => 'seh',
    'seneca'                                                                                                                       => 'see',
    'serbocroatian'                                                                                                                => 'sh',
    'shambala'                                                                                                                     => 'ksb',
    'soga'                                                                                                                         => 'xog',
    'tachelhit'                                                                                                                    => 'shi',
    'taita'                                                                                                                        => 'dav',
    'taroko'                                                                                                                       => 'trv',
    'tasawaq'                                                                                                                      => 'twq',
    'teso'                                                                                                                         => 'teo',
    'tuvinian'                                                                                                                     => 'tyv',
    'tyap'                                                                                                                         => 'kcg',
    "volap\Ã\¼k"                                                                                                                 => 'vo',
    'vunjo'                                                                                                                        => 'vun',
    'walser'                                                                                                                       => 'wae',
    'yangben'                                                                                                                      => 'yav',
    'zarma'                                                                                                                        => 'dje',
    'zaza'                                                                                                                         => 'zza',
    'أنكو'                                                                                                                     => 'nqo',
    'إسبانيةأمريكااللاتينية'                                                                                 => 'es_419',
    'الآرامية'                                                                                                             => 'arc',
    'الآراميةالسومارية'                                                                                           => 'sam',
    'الآينوية'                                                                                                             => 'ain',
    'الأبخازية'                                                                                                           => 'ab',
    'الأتسام'                                                                                                               => 'cch',
    'الأتشينيزية'                                                                                                       => 'ace',
    'الأدانجمية'                                                                                                         => 'ada',
    'الأدمرت'                                                                                                               => 'udm',
    'الأديجه'                                                                                                               => 'ady',
    'الأذرية'                                                                                                               => 'az',
    'الأراباهو'                                                                                                           => 'arp',
    'الأراجونية'                                                                                                         => 'an',
    'الأراواكية'                                                                                                         => 'arw',
    'الأردية'                                                                                                               => 'ur',
    'الأرزية'                                                                                                               => 'myv',
    'الأرمينية'                                                                                                           => 'hy',
    'الأروكانية'                                                                                                         => 'arn',
    'الأرومانيان'                                                                                                       => 'rup',
    'الأسامية'                                                                                                             => 'as',
    'الأسترية'                                                                                                             => 'ast',
    'الأسكتلندية'                                                                                                       => 'sco',
    'الأفارية'                                                                                                             => 'aa',
    'الأفاريكية'                                                                                                         => 'av',
    'الأفريقية'                                                                                                           => 'af',
    'الأفريهيلية'                                                                                                       => 'afh',
    'الأفستية'                                                                                                             => 'ae',
    'الأكادية'                                                                                                             => 'akk',
    'الأكانية'                                                                                                             => 'ak',
    'الأكولية'                                                                                                             => 'ach',
    'الألبانية'                                                                                                           => 'sq',
    'الألطائيةأخرى'                                                                                                   => 'tut',
    'الألطائيةالجنوبية'                                                                                           => 'alt',
    'الألمانية'                                                                                                           => 'de',
    'الألمانيةالسفلى'                                                                                               => 'nds',
    'الألمانيةالسويسرية'                                                                                         => 'gsw',
    'الألمانيةالعلياالسويسرية'                                                                             => 'de_ch',
    'الألمانيةالعلياالقديمة'                                                                                 => 'goh',
    'الألمانيةالعلياالوسطى'                                                                                   => 'gmh',
    'الألمانيةالنمساوية'                                                                                         => 'de_at',
    'الأليوتية'                                                                                                           => 'ale',
    'الأمبندو'                                                                                                             => 'umb',
    'الأمهرية'                                                                                                             => 'am',
    'الأنجيكا'                                                                                                             => 'anp',
    'الأوادية'                                                                                                             => 'awa',
    'الأوجيبوا'                                                                                                           => 'oj',
    'الأورومو'                                                                                                             => 'om',
    'الأورييا'                                                                                                             => 'or',
    'الأوزباكية'                                                                                                         => 'uz',
    'الأوساج'                                                                                                               => 'osa',
    'الأوسترونيسيان'                                                                                                 => 'map',
    'الأوسيتيك'                                                                                                           => 'os',
    'الأوكرانية'                                                                                                         => 'uk',
    'الأوكيتانية'                                                                                                       => 'oc',
    'الأيرلندية'                                                                                                         => 'ga',
    'الأيرلنديةالقديمة'                                                                                           => 'sga',
    'الأيرلنديةالوسطى'                                                                                             => 'mga',
    'الأيسلاندية'                                                                                                       => 'is',
    'الأيغورية'                                                                                                           => 'ug',
    'الأيمارا'                                                                                                             => 'ay',
    'الإجو'                                                                                                                   => 'ijo',
    'الإسباعبرية'                                                                                                       => 'lad',
    'الإسبانية'                                                                                                           => 'es',
    'الإسبانيةالأيبيرية'                                                                                         => 'es_es',
    'الإسبرانتو'                                                                                                         => 'eo',
    'الإستونية'                                                                                                           => 'et',
    'الإفيك'                                                                                                                 => 'efi',
    'الإكاجك'                                                                                                               => 'eka',
    'الإمايت'                                                                                                               => 'elx',
    'الإنترلينج'                                                                                                         => 'ie',
    'الإنجليزية'                                                                                                         => 'en',
    'الإنجليزيةالأسترالية'                                                                                     => 'en_au',
    'الإنجليزيةالبريطانية'                                                                                     => 'en_gb',
    'الإنجليزيةالقديمة'                                                                                           => 'ang',
    'الإنجليزيةالكندية'                                                                                           => 'en_ca',
    'الإنجليزيةالوسطى'                                                                                             => 'enm',
    'الإنجليزيةالولاياتالمتحدة'                                                                           => 'en_us',
    'الإنجوشية'                                                                                                           => 'inh',
    'الإندونيسية'                                                                                                       => 'id',
    'الإيبان'                                                                                                               => 'iba',
    'الإيجبو'                                                                                                               => 'ig',
    'الإيدو'                                                                                                                 => 'io',
    'الإيطالية'                                                                                                           => 'it',
    'الإيلوكو'                                                                                                             => 'ilo',
    'الإيناريسامي'                                                                                                     => 'smn',
    'الإينبياك'                                                                                                           => 'ik',
    'الإينكتيتت'                                                                                                         => 'iu',
    'الإيوندو'                                                                                                             => 'ewo',
    'الإيوي'                                                                                                                 => 'ee',
    'البابيامينتو'                                                                                                     => 'pap',
    'الباتاكية'                                                                                                           => 'btk',
    'الباسا'                                                                                                                 => 'bas',
    'الباشكيرية'                                                                                                         => 'ba',
    'البالوان'                                                                                                             => 'pau',
    'البالية'                                                                                                               => 'pi',
    'البامبارا'                                                                                                           => 'bm',
    'البامبانجا'                                                                                                         => 'pam',
    'البانتو'                                                                                                               => 'bnt',
    'البانجاسينان'                                                                                                     => 'pag',
    'الباندا'                                                                                                               => 'bad',
    'البجينيزية'                                                                                                         => 'bug',
    'البراجية'                                                                                                             => 'bra',
    'البربرية'                                                                                                             => 'ber',
    'البرتغالية'                                                                                                         => 'pt',
    'البرتغاليةالأيبيرية'                                                                                       => 'pt_pt',
    'البرتغاليةالبرازيلية'                                                                                     => 'pt_br',
    'البروفانسيةالقديمة'                                                                                         => 'pro',
    'البرياتية'                                                                                                           => 'bua',
    'البريتونية'                                                                                                         => 'br',
    'البلغارية'                                                                                                           => 'bg',
    'البلوشية'                                                                                                             => 'bal',
    'البلينية'                                                                                                             => 'byn',
    'البنجابية'                                                                                                           => 'pa',
    'البنغالية'                                                                                                           => 'bn',
    'البهلوية'                                                                                                             => 'pal',
    'البهوجبرية'                                                                                                         => 'bho',
    'البورمية'                                                                                                             => 'my',
    'البوسنية'                                                                                                             => 'bs',
    'البوكماليةالنرويجية'                                                                                       => 'nb',
    'البولندية'                                                                                                           => 'pl',
    'البوهنبيايان'                                                                                                     => 'pon',
    'البيجا'                                                                                                                 => 'bej',
    'البيسلامية'                                                                                                         => 'bi',
    'البيكولية'                                                                                                           => 'bik',
    'البيلوروسية'                                                                                                       => 'be',
    'البيمبا'                                                                                                               => 'bem',
    'البينية'                                                                                                               => 'bin',
    'البيهارية'                                                                                                           => 'bh',
    'التاغالوغية'                                                                                                       => 'tl',
    'التاماشيك'                                                                                                           => 'tmh',
    'التامبوكا'                                                                                                           => 'tum',
    'التاميلية'                                                                                                           => 'ta',
    'التاهيتية'                                                                                                           => 'ty',
    'التايلاندية'                                                                                                       => 'th',
    'التبتية'                                                                                                               => 'bo',
    'التتارية'                                                                                                             => 'tt',
    'التركمانية'                                                                                                         => 'tk',
    'التركية'                                                                                                               => 'tr',
    'التركيةالعثمانية'                                                                                             => 'ota',
    'التركيةالكريمينية'                                                                                           => 'crh',
    'التسوانية'                                                                                                           => 'tn',
    'التسيمشيان'                                                                                                         => 'tsi',
    'التشاجاتاي'                                                                                                         => 'chg',
    'التشامورو'                                                                                                           => 'ch',
    'التشفاش'                                                                                                               => 'cv',
    'التشكيزية'                                                                                                           => 'chk',
    'التشيبشا'                                                                                                             => 'chb',
    'التشيكية'                                                                                                             => 'cs',
    'التلينغيتية'                                                                                                       => 'tli',
    'التوفالو'                                                                                                             => 'tvl',
    'التوكبيسين'                                                                                                         => 'tpi',
    'التوكيلاو'                                                                                                           => 'tkl',
    'التونغية'                                                                                                             => 'to',
    'التوي'                                                                                                                   => 'tw',
    'التيتم'                                                                                                                 => 'tet',
    'التيجر'                                                                                                                 => 'tig',
    'التيجرينيا'                                                                                                         => 'ti',
    'التيرينو'                                                                                                             => 'ter',
    'التيف'                                                                                                                   => 'tiv',
    'التيلجو'                                                                                                               => 'te',
    'التيمن'                                                                                                                 => 'tem',
    'الجا'                                                                                                                     => 'gaa',
    'الجاليكية'                                                                                                           => 'gl',
    'الجاندا'                                                                                                               => 'lg',
    'الجاوية'                                                                                                               => 'jv',
    'الجايو'                                                                                                                 => 'gay',
    'الجبيا'                                                                                                                 => 'gba',
    'الجريبو'                                                                                                               => 'grb',
    'الجندي'                                                                                                                 => 'gon',
    'الجو'                                                                                                                     => 'kaj',
    'الجواراني'                                                                                                           => 'gn',
    'الجورجية'                                                                                                             => 'ka',
    'الجورونتالو'                                                                                                       => 'gor',
    'الجيدوالعربي'                                                                                                     => 'jrb',
    'الجيدوالفارسي'                                                                                                   => 'jpr',
    'الجيز'                                                                                                                   => 'gez',
    'الحثية'                                                                                                                 => 'hit',
    'الخميرية'                                                                                                             => 'km',
    'الخوتانيز'                                                                                                           => 'kho',
    'الخوسا'                                                                                                                 => 'xh',
    'الدارجوا'                                                                                                             => 'dar',
    'الداكوتا'                                                                                                             => 'dak',
    'الدانماركية'                                                                                                       => 'da',
    'الدايلا'                                                                                                               => 'dyu',
    'الدنكا'                                                                                                                 => 'din',
    'الدوجري'                                                                                                               => 'doi',
    'الدوجريب'                                                                                                             => 'dgr',
    'الدياك'                                                                                                                 => 'day',
    'الديلوير'                                                                                                             => 'del',
    'الديولا'                                                                                                               => 'dua',
    'الراباني'                                                                                                             => 'rap',
    'الراجاسثانية'                                                                                                     => 'raj',
    'الراروتونجاني'                                                                                                   => 'rar',
    'الرندي'                                                                                                                 => 'rn',
    'الرهايتورومانس'                                                                                                 => 'rm',
    'الروسية'                                                                                                               => 'ru',
    'الرومانية'                                                                                                           => 'ro',
    'الزابوتيك'                                                                                                           => 'zap',
    'الزاند'                                                                                                                 => 'znd',
    'الزهيونج'                                                                                                             => 'za',
    'الزولو'                                                                                                                 => 'zu',
    'الزونخاية'                                                                                                           => 'dz',
    'الزونية'                                                                                                               => 'zun',
    'الزيناجا'                                                                                                             => 'zen',
    'الساخية'                                                                                                               => 'sah',
    'الساساك'                                                                                                               => 'sas',
    'الساموائية'                                                                                                         => 'sm',
    'الساميالجنوبي'                                                                                                   => 'sma',
    'الساميالشمالي'                                                                                                   => 'se',
    'السانتالي'                                                                                                           => 'sat',
    'السانجو'                                                                                                               => 'sg',
    'السانداوي'                                                                                                           => 'sad',
    'السرانانتونجو'                                                                                                   => 'srn',
    'السردينية'                                                                                                           => 'sc',
    'السرر'                                                                                                                   => 'srr',
    'السريانية'                                                                                                           => 'syr',
    'السكولتسامي'                                                                                                       => 'sms',
    'السلافية'                                                                                                             => 'den',
    'السلتيةأخرى'                                                                                                       => 'cel',
    'السلوفاكية'                                                                                                         => 'sk',
    'السلوفانية'                                                                                                         => 'sl',
    'السنسكريتية'                                                                                                       => 'sa',
    'السنهالية'                                                                                                           => 'si',
    'السواتي'                                                                                                               => 'ss',
    'السواحلية'                                                                                                           => 'sw',
    'السوتوالجنوبية'                                                                                                 => 'st',
    'السوتوالشمالية'                                                                                                 => 'nso',
    'السوجدين'                                                                                                             => 'sog',
    'السودانية'                                                                                                           => 'su',
    'السوسو'                                                                                                                 => 'sus',
    'السوكوما'                                                                                                             => 'suk',
    'السومارية'                                                                                                           => 'sux',
    'السونجا'                                                                                                               => 'ts',
    'السونجهاي'                                                                                                           => 'son',
    'السونينك'                                                                                                             => 'snk',
    'السويدية'                                                                                                             => 'sv',
    'السيبيونو'                                                                                                           => 'ceb',
    'السيتشيونيي'                                                                                                       => 'ii',
    'السيدامو'                                                                                                             => 'sid',
    'السيكسيكية'                                                                                                         => 'bla',
    'السيلكب'                                                                                                               => 'sel',
    'السيندي'                                                                                                               => 'sd',
    'الشانية'                                                                                                               => 'shn',
    'الشايان'                                                                                                               => 'chy',
    'الشوكتو'                                                                                                               => 'cho',
    'الشونا'                                                                                                                 => 'sn',
    'الشيباوايان'                                                                                                       => 'chp',
    'الشيروكي'                                                                                                             => 'chr',
    'الشيشانية'                                                                                                           => 'ce',
    'الشينوكجارجون'                                                                                                   => 'chn',
    'الصربية'                                                                                                               => 'sr',
    'الصربيةالسفلى'                                                                                                   => 'dsb',
    'الصربيةالعليا'                                                                                                   => 'hsb',
    'الصقلية'                                                                                                               => 'scn',
    'الصناعيةأخرى'                                                                                                     => 'art',
    'الصومالية'                                                                                                           => 'so',
    'الصينية'                                                                                                               => 'zh',
    'الطاجيكية'                                                                                                           => 'tg',
    'العبرية'                                                                                                               => 'he',
    'العربية'                                                                                                               => 'ar',
    'الغوجاراتية'                                                                                                       => 'gu',
    'الغيليةالأسكتلندية'                                                                                         => 'gd',
    'الفارسية'                                                                                                             => 'fa',
    'الفارسيةالقديمة'                                                                                               => 'peo',
    'الفارويز'                                                                                                             => 'fo',
    'الفانتي'                                                                                                               => 'fat',
    'الفانج'                                                                                                                 => 'fan',
    'الفاي'                                                                                                                   => 'vai',
    'الفرنسية'                                                                                                             => 'fr',
    'الفرنسيةالسويسرية'                                                                                           => 'fr_ch',
    'الفرنسيةالقديمة'                                                                                               => 'fro',
    'الفرنسيةالكندية'                                                                                               => 'fr_ca',
    'الفرنسيةالوسطى'                                                                                                 => 'frm',
    'الفريزيان'                                                                                                           => 'fy',
    'الفريزينيةالشرقية'                                                                                           => 'frs',
    'الفريزينيةالشمالية'                                                                                         => 'frr',
    'الفريلايان'                                                                                                         => 'fur',
    'الفلبينية'                                                                                                           => 'fil',
    'الفلة'                                                                                                                   => 'ff',
    'الفلمنك'                                                                                                               => 'nl_be',
    'الفنلندية'                                                                                                           => 'fi',
    'الفوتيك'                                                                                                               => 'vot',
    'الفون'                                                                                                                   => 'fon',
    'الفيتنامية'                                                                                                         => 'vi',
    'الفيجية'                                                                                                               => 'fj',
    'الفيندا'                                                                                                               => 've',
    'الفينيقية'                                                                                                           => 'phn',
    'القبطية'                                                                                                               => 'cop',
    'القبيلية'                                                                                                             => 'kab',
    'القمرية'                                                                                                               => 'swb',
    'القوطية'                                                                                                               => 'got',
    'القوقازيةأخرى'                                                                                                   => 'cau',
    'القيرغستانية'                                                                                                     => 'ky',
    'الكاباردايان'                                                                                                     => 'kbd',
    'الكاتشين'                                                                                                             => 'kac',
    'الكادو'                                                                                                                 => 'cad',
    'الكاراتشايبالكار'                                                                                             => 'krc',
    'الكاراكالباك'                                                                                                     => 'kaa',
    'الكاريبية'                                                                                                           => 'car',
    'الكاريين'                                                                                                             => 'kar',
    'الكازاخستانية'                                                                                                   => 'kk',
    'الكازية'                                                                                                               => 'kha',
    'الكاشبايان'                                                                                                         => 'csb',
    'الكاشميرية'                                                                                                         => 'ks',
    'الكالاليست'                                                                                                         => 'kl',
    'الكالميك'                                                                                                             => 'xal',
    'الكامبا'                                                                                                               => 'kam',
    'الكانادا'                                                                                                             => 'kn',
    'الكانيوري'                                                                                                           => 'kr',
    'الكبيل'                                                                                                                 => 'kpe',
    'الكتالانية'                                                                                                         => 'ca',
    'الكتيناي'                                                                                                             => 'kut',
    'الكردية'                                                                                                               => 'ku',
    'الكرو'                                                                                                                   => 'kro',
    'الكرواتية'                                                                                                           => 'hr',
    'الكرى'                                                                                                                   => 'cr',
    'الكريك'                                                                                                                 => 'mus',
    'الكريلية'                                                                                                             => 'krl',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبأخرى'                           => 'crp',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبعلىأساسالأنجليزية' => 'cpe',
    'الكرييولىواللغاتالمبسطةالأخرىللتفاهمبينالشعوبعلىأساسالفرنسية'     => 'cpf',
    'الكرييوليواللغاتالمبسطةالأخرىللتفاهمبينالشعوبعلىأساسالبرتغالية' => 'cpp',
    'الكلينجون'                                                                                                           => 'tlh',
    'الكميك'                                                                                                                 => 'kum',
    'الكورسيكية'                                                                                                         => 'co',
    'الكورنية'                                                                                                             => 'kw',
    'الكورو'                                                                                                                 => 'kfo',
    'الكورية'                                                                                                               => 'ko',
    'الكوسراين'                                                                                                           => 'kos',
    'الكومي'                                                                                                                 => 'kv',
    'الكونغو'                                                                                                               => 'kg',
    'الكونكانية'                                                                                                         => 'kok',
    'الكوي'                                                                                                                   => 'kaw',
    'الكويتشوا'                                                                                                           => 'qu',
    'الكيكيو'                                                                                                               => 'ki',
    'الكيمبندو'                                                                                                           => 'kmb',
    'الكينيارواندا'                                                                                                   => 'rw',
    'الكيونياما'                                                                                                         => 'kj',
    'الكَنْتُونية'                                                                                                     => 'yue',
    'اللاتفية'                                                                                                             => 'lv',
    'اللاتينية'                                                                                                           => 'la',
    'اللامبا'                                                                                                               => 'lam',
    'اللاهندا'                                                                                                             => 'lah',
    'اللاوية'                                                                                                               => 'lo',
    'اللباكاتانجا'                                                                                                     => 'lu',
    'اللبالؤلؤ'                                                                                                           => 'lua',
    'اللتوانية'                                                                                                           => 'lt',
    'اللشاي'                                                                                                                 => 'lus',
    'اللغاتالأباتشية'                                                                                               => 'apa',
    'اللغاتالأمريكيةالهندية'                                                                                 => 'alg',
    'اللغاتالبراقريطية'                                                                                           => 'pra',
    'اللغةالأزباسكانية'                                                                                           => 'ath',
    'اللغةالأسترالية'                                                                                               => 'aus',
    'اللغةالأوتومية'                                                                                                 => 'oto',
    'اللغةالإيرانية'                                                                                                 => 'ira',
    'اللغةالإيروكويانية'                                                                                         => 'iro',
    'اللغةالبالية'                                                                                                     => 'ban',
    'اللغةالباميليكية'                                                                                             => 'bai',
    'اللغةالبلطيقية'                                                                                                 => 'bat',
    'اللغةالتشاميكية'                                                                                               => 'cmc',
    'اللغةالتوبية'                                                                                                     => 'tup',
    'اللغةالجرمانية'                                                                                                 => 'gem',
    'اللغةالخويسانية'                                                                                               => 'khi',
    'اللغةالدرافيدينية'                                                                                           => 'dra',
    'اللغةالرومانسية'                                                                                               => 'roa',
    'اللغةالساليشانية'                                                                                             => 'sal',
    'اللغةالسامية'                                                                                                     => 'smi',
    'اللغةالسلافية'                                                                                                   => 'sla',
    'اللغةالصربية'                                                                                                     => 'wen',
    'اللغةالصينيةالتيبتية'                                                                                     => 'sit',
    'اللغةالغينية'                                                                                                     => 'paa',
    'اللغةالفليبينية'                                                                                               => 'phi',
    'اللغةالكشيتيكية'                                                                                               => 'cus',
    'اللغةالمتنوعة'                                                                                                   => 'mis',
    'اللغةالنابولية'                                                                                                 => 'nap',
    'اللغةالهندية'                                                                                                     => 'inc',
    'اللغةالهنديةالأمريكيةالجنوبية'                                                                   => 'sai',
    'اللغةالهنديةالأمريكيةالشمالية'                                                                   => 'nai',
    'اللغةالهنديةالأمريكيةالوسطى'                                                                       => 'cai',
    'اللغةالواكاشانية'                                                                                             => 'wak',
    'اللغةاليوبيكية'                                                                                                 => 'ypk',
    'اللو'                                                                                                                     => 'luo',
    'اللوجبان'                                                                                                             => 'jbo',
    'اللوزي'                                                                                                                 => 'loz',
    'اللوسينو'                                                                                                             => 'lui',
    'اللوكسمبرجية'                                                                                                     => 'lb',
    'اللولسامي'                                                                                                           => 'smj',
    'اللوندا'                                                                                                               => 'lun',
    'الليزجهايانية'                                                                                                   => 'lez',
    'الليمبرجيشية'                                                                                                     => 'li',
    'اللينجالا'                                                                                                           => 'ln',
    'اللّغةالوسيطة'                                                                                                   => 'ia',
    'الماجا'                                                                                                                 => 'mag',
    'المادريز'                                                                                                             => 'mad',
    'الماراثي'                                                                                                             => 'mr',
    'المارشالية'                                                                                                         => 'mh',
    'المارواري'                                                                                                           => 'mwr',
    'الماري'                                                                                                                 => 'chm',
    'الماساي'                                                                                                               => 'mas',
    'الماكاسار'                                                                                                           => 'mak',
    'المالاجاشية'                                                                                                       => 'mg',
    'المالديفية'                                                                                                         => 'dv',
    'المالطية'                                                                                                             => 'mt',
    'الماليالام'                                                                                                         => 'ml',
    'الماندار'                                                                                                             => 'mdr',
    'الماندينغ'                                                                                                           => 'man',
    'المانشو'                                                                                                               => 'mnc',
    'المانيبري'                                                                                                           => 'mni',
    'الماورية'                                                                                                             => 'mi',
    'المايثيلي'                                                                                                           => 'mai',
    'المصريةالقديمة'                                                                                                 => 'egy',
    'المقدونية'                                                                                                           => 'mk',
    'المنغولية'                                                                                                           => 'mn',
    'المنكية'                                                                                                               => 'gv',
    'الموسي'                                                                                                                 => 'mos',
    'الموكشا'                                                                                                               => 'mdf',
    'المولدوفية'                                                                                                         => 'mo',
    'الموهوك'                                                                                                               => 'moh',
    'الميرانديز'                                                                                                         => 'mwl',
    'الميكماكيونية'                                                                                                   => 'mic',
    'المينانجكاباو'                                                                                                   => 'min',
    'الميند'                                                                                                                 => 'men',
    'النافاجو'                                                                                                             => 'nv',
    'الناهيوتل'                                                                                                           => 'nah',
    'الندونجا'                                                                                                             => 'ng',
    'النديبيلالجنوبي'                                                                                               => 'nr',
    'النديبيلالشمالي'                                                                                               => 'nd',
    'النرويجية'                                                                                                           => 'no',
    'النزيما'                                                                                                               => 'nzi',
    'النواريةالتقليدية'                                                                                           => 'nwc',
    'النوجاي'                                                                                                               => 'nog',
    'النورسالقديم'                                                                                                     => 'non',
    'النورو'                                                                                                                 => 'na',
    'النياس'                                                                                                                 => 'nia',
    'النيامويزي'                                                                                                         => 'nym',
    'النيانجا'                                                                                                             => 'ny',
    'النيانكول'                                                                                                           => 'nyn',
    'النيبالية'                                                                                                           => 'ne',
    'النيجركوردوفانايان'                                                                                         => 'nic',
    'النينورسكالنرويجي'                                                                                           => 'nn',
    'النيواري'                                                                                                             => 'new',
    'النيورو'                                                                                                               => 'nyo',
    'النيوي'                                                                                                                 => 'niu',
    'الهايتية'                                                                                                             => 'ht',
    'الهبا'                                                                                                                   => 'hup',
    'الهمونجية'                                                                                                           => 'hmn',
    'الهندية'                                                                                                               => 'hi',
    'الهنديةالأوروبيةأخرى'                                                                                     => 'ine',
    'الهنغارية'                                                                                                           => 'hu',
    'الهوسا'                                                                                                                 => 'ha',
    'الهولندية'                                                                                                           => 'nl',
    'الهولنديةالوسطى'                                                                                               => 'dum',
    'الهيدا'                                                                                                                 => 'hai',
    'الهيريرو'                                                                                                             => 'hz',
    'الهيريموتو'                                                                                                         => 'ho',
    'الهيليجينون'                                                                                                       => 'hil',
    'الهيماتشالي'                                                                                                       => 'him',
    'الواراي'                                                                                                               => 'war',
    'الواشو'                                                                                                                 => 'was',
    'الوالامو'                                                                                                             => 'wal',
    'الولزية'                                                                                                               => 'cy',
    'الولوف'                                                                                                                 => 'wo',
    'الولونية'                                                                                                             => 'wa',
    'اليابانية'                                                                                                           => 'ja',
    'اليابيز'                                                                                                               => 'yap',
    'الياو'                                                                                                                   => 'yao',
    'اليجاريتيك'                                                                                                         => 'uga',
    'اليديشية'                                                                                                             => 'yi',
    'اليوروبية'                                                                                                           => 'yo',
    'اليونانية'                                                                                                           => 'el',
    'اليونانيةالقديمة'                                                                                             => 'grc',
    'بدونمحتوىلغوي'                                                                                                   => 'zxx',
    'بشتو'                                                                                                                     => 'ps',
    'تونجانياسا'                                                                                                         => 'tog',
    'سريانيةتقليدية'                                                                                                 => 'syc',
    'سلافيةكنسية'                                                                                                       => 'cu',
    'غجري'                                                                                                                     => 'rom',
    'لغاتالإشارة'                                                                                                       => 'sgn',
    'لغاتمانوبو'                                                                                                         => 'mno',
    'لغاتمتعددة'                                                                                                         => 'mul',
    'لغةأفروآسيوية'                                                                                                   => 'afa',
    'لغةأهلالهاواي'                                                                                                   => 'haw',
    'لغةأهلجبلطارق'                                                                                                   => 'gil',
    'لغةالباسك'                                                                                                           => 'eu',
    'لغةالسيويون'                                                                                                       => 'sio',
    'لغةالمايا'                                                                                                           => 'myn',
    'لغةالملايو'                                                                                                         => 'ms',
    'لغةالمندا'                                                                                                           => 'mun',
    'لغةالمونخمير'                                                                                                     => 'mkh',
    'لغةتاي'                                                                                                                 => 'tai',
    'لغةسامية'                                                                                                             => 'sem',
    'لغةغيرمعروفة'                                                                                                     => 'und',
    'لغةفينوأجريانية'                                                                                               => 'fiu',
    'لغةنوبية'                                                                                                             => 'nub',
    'لغةنيليةالصحراوية'                                                                                           => 'ssa',
    'منغولى'                                                                                                                 => 'lol',
);

1;
