/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragAddUI;
import com.touchgraph.graphlayout.interaction.DragMultiselectUI;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.ComponentInputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GLEditUI
extends TGUserInterface {
    TGPanel tgPanel;
    DragAddUI dragAddUI;
    DragNodeUI dragNodeUI;
    DragMultiselectUI dragMultiselectUI;
    TGAbstractClickUI switchSelectUI;
    TGAbstractDragUI hvDragUI;
    GLEditMouseListener ml;
    GLEditMouseMotionListener mml;
    JPopupMenu nodePopup;
    JPopupMenu edgePopup;
    JPopupMenu backPopup;
    Node popupNode;
    Edge popupEdge;
    AbstractAction deleteSelectAction;
    final KeyStroke deleteKey = KeyStroke.getKeyStroke(127, 0);

    public GLEditUI(TGPanel tGPanel) {
        this.active = false;
        this.tgPanel = tGPanel;
        this.ml = new GLEditMouseListener();
        this.mml = new GLEditMouseMotionListener();
        this.deleteSelectAction = new AbstractAction("DeleteSelect"){

            public void actionPerformed(ActionEvent actionEvent) {
                Node node = GLEditUI.this.tgPanel.getSelect();
                if (node != null) {
                    GLEditUI.this.tgPanel.deleteNode(node);
                    GLEditUI.this.tgPanel.repaint();
                }
            }
        };
        this.dragAddUI = new DragAddUI(this.tgPanel);
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.dragMultiselectUI = new DragMultiselectUI(this.tgPanel);
        this.switchSelectUI = this.tgPanel.getSwitchSelectUI();
        this.setUpNodePopup();
        this.setUpEdgePopup();
        this.setUpBackPopup();
    }

    public GLEditUI(GLPanel gLPanel) {
        this(gLPanel.getTGPanel());
        this.hvDragUI = gLPanel.hvScroll.getHVDragUI();
    }

    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
        this.tgPanel.addMouseMotionListener(this.mml);
        this.tgPanel.getActionMap().put("DeleteSelect", this.deleteSelectAction);
        ComponentInputMap componentInputMap = new ComponentInputMap(this.tgPanel);
        componentInputMap.put(this.deleteKey, "DeleteSelect");
        this.tgPanel.setInputMap(2, componentInputMap);
        this.active = true;
    }

    public void deactivate() {
        if (!this.active) {
            this.dragMultiselectUI.deactivate();
        }
        this.tgPanel.removeMouseListener(this.ml);
        this.tgPanel.removeMouseMotionListener(this.mml);
        this.tgPanel.getInputMap().put(this.deleteKey, null);
        this.tgPanel.getActionMap().put("DeleteSelect", null);
        this.active = false;
    }

    private void setUpNodePopup() {
        this.nodePopup = new JPopupMenu();
        JMenu jMenu = new JMenu("Navigate");
        JMenuItem jMenuItem = new JMenuItem("Delete Node");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.deleteNode(GLEditUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Expand Node");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.expandNode(GLEditUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener2);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Collapse Node");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.collapseNode(GLEditUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener3);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Hide Node");
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Node node = GLEditUI.this.tgPanel.getSelect();
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.hideNode(GLEditUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener4);
        jMenu.add(jMenuItem);
        this.nodePopup.add(jMenu);
        this.nodePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GLEditUI.this.tgPanel.setMaintainMouseOver(false);
                GLEditUI.this.tgPanel.setMouseOverN(null);
                GLEditUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void setUpEdgePopup() {
        this.edgePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Relax Edge");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.popupEdge.setLength(GLEditUI.this.popupEdge.getLength() * 4);
                    GLEditUI.this.tgPanel.resetDamper();
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.edgePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Tighten Edge");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.popupEdge.setLength(GLEditUI.this.popupEdge.getLength() / 4);
                    GLEditUI.this.tgPanel.resetDamper();
                }
            }
        };
        jMenuItem.addActionListener(actionListener2);
        this.edgePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete Edge");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.tgPanel.deleteEdge(GLEditUI.this.popupEdge);
                }
            }
        };
        jMenuItem.addActionListener(actionListener3);
        this.edgePopup.add(jMenuItem);
        this.edgePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GLEditUI.this.tgPanel.setMaintainMouseOver(false);
                GLEditUI.this.tgPanel.setMouseOverE(null);
                GLEditUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void setUpBackPopup() {
        this.backPopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Multi-Select");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLEditUI.this.dragMultiselectUI.activate(GLEditUI.this);
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.backPopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Start Over");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLEditUI.this.tgPanel.clearAll();
                GLEditUI.this.tgPanel.clearSelect();
                try {
                    GLEditUI.this.tgPanel.addNode();
                }
                catch (TGException tGException) {
                    System.err.println(tGException.getMessage());
                    tGException.printStackTrace(System.err);
                }
                GLEditUI.this.tgPanel.fireResetEvent();
                GLEditUI.this.tgPanel.repaint();
            }
        };
        jMenuItem.addActionListener(actionListener2);
        this.backPopup.add(jMenuItem);
    }

    class GLEditMouseMotionListener
    extends MouseMotionAdapter {
        GLEditMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class GLEditMouseListener
    extends MouseAdapter {
        GLEditMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Node node = GLEditUI.this.tgPanel.getMouseOverN();
            Node node2 = GLEditUI.this.tgPanel.getSelect();
            if (mouseEvent.getModifiers() == 16) {
                if (node != null) {
                    if (node != node2) {
                        GLEditUI.this.dragNodeUI.activate(mouseEvent);
                    } else {
                        GLEditUI.this.dragAddUI.activate(mouseEvent);
                    }
                } else if (GLEditUI.this.hvDragUI != null) {
                    GLEditUI.this.hvDragUI.activate(mouseEvent);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                GLEditUI.this.switchSelectUI.activate(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                GLEditUI.this.popupNode = GLEditUI.this.tgPanel.getMouseOverN();
                GLEditUI.this.popupEdge = GLEditUI.this.tgPanel.getMouseOverE();
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.setMaintainMouseOver(true);
                    GLEditUI.this.nodePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.tgPanel.setMaintainMouseOver(true);
                    GLEditUI.this.edgePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    GLEditUI.this.backPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

