/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridIndexToNC {
    private static Logger logger = LoggerFactory.getLogger(GridIndexToNC.class);
    private Map<String, GridHorizCoordSys> hcsHash = new HashMap<String, GridHorizCoordSys>(10);
    private DateFormatter formatter = new DateFormatter();
    private boolean debug = false;
    private String indexFilename;
    private RandomAccessFile raf;

    static String makeLevelName(GridRecord gr, GridTableLookup lookup) {
        if (lookup instanceof Grib2GridTableLookup) {
            String vname = lookup.getLevelName(gr);
            return lookup.isLayer(gr) ? vname + "_layer" : vname;
        }
        return lookup.getLevelName(gr);
    }

    public GridIndexToNC(String filename) {
        this.indexFilename = filename;
    }

    public GridIndexToNC(RandomAccessFile raf) {
        this.indexFilename = raf.getLocation();
        this.raf = raf;
    }

    public void open(GridIndex index, GridTableLookup lookup, int version, NetcdfFile ncfile, FmrcCoordSys fmrcCoordSys, CancelTask cancelTask) throws IOException {
        ArrayList<GridVariable> gribvars;
        String source;
        List hcsList = index.getHorizCoordSys();
        boolean needGroups = hcsList.size() > 1;
        for (GridDefRecord gds : hcsList) {
            Group g = null;
            if (needGroups) {
                g = new Group(ncfile, null, gds.getGroupName());
                ncfile.addGroup(null, g);
            }
            GridHorizCoordSys hcs = new GridHorizCoordSys(gds, lookup, g);
            this.hcsHash.put(gds.getParam("GDSkey"), hcs);
        }
        GridRecord firstRecord = null;
        List records = index.getGridRecords();
        for (GridRecord gridRecord : records) {
            if (firstRecord == null) {
                firstRecord = gridRecord;
            }
            GridHorizCoordSys hcs = this.hcsHash.get(gridRecord.getGridDefRecordId());
            int cdmHash = gridRecord.cdmVariableHash();
            GridVariable pv = hcs.varHash.get(cdmHash);
            if (null == pv) {
                String name = gridRecord.cdmVariableName(lookup, true, true);
                pv = new GridVariable(this.indexFilename, name, hcs, lookup);
                hcs.varHash.put(cdmHash, pv);
                String simpleName = gridRecord.getParameterDescription();
                List<GridVariable> plist = hcs.productHash.get(simpleName);
                if (null == plist) {
                    plist = new ArrayList<GridVariable>();
                    hcs.productHash.put(simpleName, plist);
                }
                plist.add(pv);
            }
            pv.addProduct(gridRecord);
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.4"));
        String center = null;
        String subcenter = null;
        if (lookup instanceof Grib2GridTableLookup) {
            String model;
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
            GribGridRecord ggr = (GribGridRecord)firstRecord;
            center = g2lookup.getFirstCenterName();
            ncfile.addAttribute(null, new Attribute("Originating_center", center));
            subcenter = g2lookup.getFirstSubcenterName();
            if (subcenter != null) {
                ncfile.addAttribute(null, new Attribute("Originating_subcenter", subcenter));
            }
            if ((model = g2lookup.getModel()) != null) {
                ncfile.addAttribute(null, new Attribute("Generating_Model", model));
            }
            if (null != g2lookup.getFirstProductStatusName()) {
                ncfile.addAttribute(null, new Attribute("Product_Status", g2lookup.getFirstProductStatusName()));
            }
            ncfile.addAttribute(null, new Attribute("Product_Type", g2lookup.getFirstProductTypeName()));
        } else if (lookup instanceof Grib1GridTableLookup) {
            String model;
            Grib1GridTableLookup g1lookup = (Grib1GridTableLookup)lookup;
            center = g1lookup.getFirstCenterName();
            subcenter = g1lookup.getFirstSubcenterName();
            ncfile.addAttribute(null, new Attribute("Originating_center", center));
            if (subcenter != null) {
                ncfile.addAttribute(null, new Attribute("Originating_subcenter", subcenter));
            }
            if ((model = g1lookup.getModel()) != null) {
                ncfile.addAttribute(null, new Attribute("Generating_Model", model));
            }
            if (null != g1lookup.getFirstProductStatusName()) {
                ncfile.addAttribute(null, new Attribute("Product_Status", g1lookup.getFirstProductStatusName()));
            }
            ncfile.addAttribute(null, new Attribute("Product_Type", g1lookup.getFirstProductTypeName()));
        }
        ncfile.addAttribute(null, new Attribute("title", lookup.getTitle()));
        if (lookup.getInstitution() != null) {
            ncfile.addAttribute(null, new Attribute("institution", lookup.getInstitution()));
        }
        if ((source = lookup.getSource()) != null && !source.startsWith("Unknown")) {
            ncfile.addAttribute(null, new Attribute("source", source));
        }
        ncfile.addAttribute(null, new Attribute("history", "Direct read of " + lookup.getGridType() + " into NetCDF-Java 4 API"));
        if (lookup.getComment() != null) {
            ncfile.addAttribute(null, new Attribute("comment", lookup.getComment()));
        }
        ncfile.addAttribute(null, new Attribute("CF:feature_type", FeatureType.GRID.toString()));
        ncfile.addAttribute(null, new Attribute("file_format", lookup.getGridType()));
        ncfile.addAttribute(null, new Attribute("location", ncfile.getLocation()));
        ncfile.addAttribute(null, new Attribute("_CoordinateModelRunDate", this.formatter.toDateTimeStringISO(lookup.getFirstBaseTime())));
        this.makeDenseCoordSys(ncfile, lookup, cancelTask);
        if (GridServiceProvider.debugMissing) {
            Formatter f = new Formatter(System.out);
            int count = 0;
            Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
            for (GridHorizCoordSys hcs : hcset) {
                gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
                for (GridVariable gv : gribvars) {
                    count += gv.showMissingSummary(f);
                }
            }
            System.out.println(" total missing= " + count);
        }
        if (GridServiceProvider.debugMissingDetails) {
            Formatter f = new Formatter(System.out);
            Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
            for (GridHorizCoordSys hcs : hcset) {
                f.format("******** Horiz Coordinate= %s%n", hcs.getGridName());
                String lastVertDesc = null;
                gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
                Collections.sort(gribvars, new CompareGridVariableByVertName());
                for (GridVariable gv : gribvars) {
                    String vertDesc = gv.getVertName();
                    if (!vertDesc.equals(lastVertDesc)) {
                        f.format("---Vertical Coordinate= %s%n", vertDesc);
                        lastVertDesc = vertDesc;
                    }
                    gv.showMissing(f);
                }
            }
        }
    }

    public GridHorizCoordSys getHorizCoordSys(GridRecord gribRecord) {
        return this.hcsHash.get(gribRecord.getGridDefRecordId());
    }

    public Map<String, GridHorizCoordSys> getHorizCoordSystems() {
        return this.hcsHash;
    }

    /*
     * WARNING - void declaration
     */
    private void makeDenseCoordSys(NetcdfFile ncfile, GridTableLookup lookup, CancelTask cancelTask) throws IOException {
        ArrayList<GridTimeCoord> timeCoords = new ArrayList<GridTimeCoord>();
        ArrayList<GridVertCoord> vertCoords = new ArrayList<GridVertCoord>();
        ArrayList<GridEnsembleCoord> ensembleCoords = new ArrayList<GridEnsembleCoord>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
        for (GridHorizCoordSys hcs : hcset) {
            if (cancelTask != null && cancelTask.isCancel()) break;
            ArrayList<GridVariable> gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
            for (GridVariable gv : gribvars) {
                void var19_31;
                void var19_29;
                if (cancelTask != null && cancelTask.isCancel()) break;
                List<GridRecord> recordList = gv.getRecords();
                GridRecord record = recordList.get(0);
                String vname = GridIndexToNC.makeLevelName(record, lookup);
                GridVertCoord useVertCoord = null;
                for (GridVertCoord gridVertCoord : vertCoords) {
                    if (!vname.equals(gridVertCoord.getLevelName()) || !gridVertCoord.matchLevels(recordList)) continue;
                    useVertCoord = gridVertCoord;
                }
                if (useVertCoord == null) {
                    useVertCoord = new GridVertCoord(recordList, vname, lookup, hcs);
                    vertCoords.add(useVertCoord);
                }
                gv.setVertCoord(useVertCoord);
                GridTimeCoord useTimeCoord = null;
                for (GridTimeCoord gtc : timeCoords) {
                    if (!gtc.matchTimes(recordList)) continue;
                    useTimeCoord = gtc;
                    break;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GridTimeCoord(recordList);
                    timeCoords.add(useTimeCoord);
                }
                gv.setTimeCoord(useTimeCoord);
                if (!gv.isEnsemble()) continue;
                Object var19_27 = null;
                GridEnsembleCoord ensembleCoord = new GridEnsembleCoord(recordList);
                for (GridEnsembleCoord gec : ensembleCoords) {
                    if (!ensembleCoord.equals(gec)) continue;
                    GridEnsembleCoord gridEnsembleCoord = gec;
                    break;
                }
                if (var19_29 == null) {
                    GridEnsembleCoord gridEnsembleCoord = ensembleCoord;
                    ensembleCoords.add(ensembleCoord);
                }
                gv.setEnsembleCoord((GridEnsembleCoord)var19_31);
            }
            Collections.sort(timeCoords);
            int count = 0;
            for (GridTimeCoord tcs : timeCoords) {
                tcs.setSequence(count++);
                tcs.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            int seqno = 0;
            for (GridEnsembleCoord gec : ensembleCoords) {
                gec.setSequence(seqno++);
                gec.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collections.sort(vertCoords);
            int vcIndex = 0;
            String listName = null;
            int start = 0;
            for (vcIndex = 0; vcIndex < vertCoords.size(); ++vcIndex) {
                GridVertCoord gvcs = (GridVertCoord)vertCoords.get(vcIndex);
                String vname = gvcs.getLevelName();
                if (listName == null) {
                    listName = vname;
                }
                if (vname.equals(listName)) continue;
                this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
                listName = vname;
                start = vcIndex;
            }
            this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
            ArrayList<List<GridVariable>> products = new ArrayList<List<GridVariable>>(hcs.productHash.values());
            for (List list : products) {
                if (cancelTask != null && cancelTask.isCancel()) break;
                if (list.size() == 1) {
                    GridVariable pv = (GridVariable)list.get(0);
                    String name = pv.getFirstRecord().cdmVariableName(lookup, false, false);
                    Variable v = pv.makeVariable(ncfile, hcs.getGroup(), name, this.raf);
                    ncfile.addVariable(hcs.getGroup(), v);
                    continue;
                }
                HashMap<GridVertCoord, VertCollection> vcMap = new HashMap<GridVertCoord, VertCollection>();
                for (GridVariable gv : list) {
                    VertCollection vc = (VertCollection)vcMap.get(gv.getVertCoord());
                    if (vc == null) {
                        vc = new VertCollection(gv);
                        vcMap.put(gv.getVertCoord(), vc);
                    }
                    vc.list.add(gv);
                }
                ArrayList vclist = new ArrayList(vcMap.values());
                Collections.sort(vclist);
                boolean firstVertCoord = true;
                for (VertCollection vc : vclist) {
                    boolean hasMultipleLevels = vc.vc.getNLevels() > 1;
                    boolean noLevelOk = firstVertCoord;
                    List<GridVariable> list2 = vc.list;
                    if (list2.size() == 1) {
                        GridVariable gv = list2.get(0);
                        String name = gv.getFirstRecord().cdmVariableName(lookup, !noLevelOk, false);
                        ncfile.addVariable(hcs.getGroup(), gv.makeVariable(ncfile, hcs.getGroup(), name, this.raf));
                    } else {
                        for (GridVariable gv : list2) {
                            String name = gv.getFirstRecord().cdmVariableName(lookup, !noLevelOk, true);
                            ncfile.addVariable(hcs.getGroup(), gv.makeVariable(ncfile, hcs.getGroup(), name, this.raf));
                        }
                    }
                    firstVertCoord = false;
                }
            }
            for (GridTimeCoord gridTimeCoord : timeCoords) {
                gridTimeCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            for (GridEnsembleCoord gridEnsembleCoord : ensembleCoords) {
                gridEnsembleCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (GridVertCoord gridVertCoord : vertCoords) {
                gridVertCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
    }

    private void makeVerticalDimensions(List<GridVertCoord> vertCoordList, NetcdfFile ncfile, Group group) {
        GridVertCoord gvcs0 = null;
        int maxLevels = 0;
        for (GridVertCoord gvcs : vertCoordList) {
            if (gvcs.getNLevels() <= maxLevels) continue;
            gvcs0 = gvcs;
            maxLevels = gvcs.getNLevels();
        }
        int seqno = 1;
        for (GridVertCoord gvcs : vertCoordList) {
            if (gvcs != gvcs0) {
                gvcs.setSequence(seqno++);
            }
            gvcs.addDimensionsToNetcdfFile(ncfile, group);
        }
    }

    private class CompareGridVariableByNumberVertLevels
    implements Comparator {
        private CompareGridVariableByNumberVertLevels() {
        }

        public int compare(Object o1, Object o2) {
            int n2;
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            int n1 = gv1.getVertCoord().getNLevels();
            if (n1 == (n2 = gv2.getVertCoord().getNLevels())) {
                return gv1.getVertCoord().getLevelName().compareTo(gv2.getVertCoord().getLevelName());
            }
            return n2 - n1;
        }
    }

    private class CompareGridVariableByVertName
    implements Comparator {
        private CompareGridVariableByVertName() {
        }

        public int compare(Object o1, Object o2) {
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            return gv1.getVertName().compareToIgnoreCase(gv2.getVertName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VertCollection
    implements Comparable<VertCollection> {
        GridVertCoord vc;
        List<GridVariable> list = new ArrayList<GridVariable>(3);

        VertCollection(GridVariable gv) {
            this.vc = gv.getVertCoord();
        }

        public int hashCode() {
            return this.vc.hashCode();
        }

        public boolean equals(Object obj) {
            VertCollection oc = (VertCollection)obj;
            return this.vc.equals(oc.vc);
        }

        @Override
        public int compareTo(VertCollection o) {
            int ret = o.vc.getNLevels() - this.vc.getNLevels();
            if (ret == 0) {
                ret = this.vc.getLevelName().compareTo(o.vc.getLevelName());
            }
            return ret;
        }
    }
}

