/* (C) 2001-2002, DIUF, http://www.unifr.ch/diuf
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package iiuf.xmillum;

import iiuf.dom.DOMUtils;

import java.util.ArrayList;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * ElementTagger
 *
 * This object associates a tag to every element of a given DOM structure
 * and allows direct access to these elements by their tag. In addition, the
 * tag is put as an attribute of the "tmp" namespace into the element in
 * question.
 *
 * @author $Author: ohitz $
 * @version $Revision: 1.1 $
 */
public class ElementTagger {
  protected String tagName;
  protected int tagValue;
  protected ArrayList tagged;

  public ElementTagger(Element element, String tag) {
    tagName = tag;
    tagValue = 0;
    tagged = new ArrayList(2048);
    tagElements(element);
  }

  public Element getReferencedElement(Element e) {
    String tag = e.getAttribute("ref");
    if (tag != null) {
      return getElementWithTag(tag);
    }
    return null;
  }

  public Element getElementWithTag(String tag) {
    return getElementWithTag(Integer.parseInt(tag));
  }

  public Element getElementWithTag(int tag) {
    return (Element) tagged.get(tag);
  }

  protected void tagElements(Element element) {
    element.setAttributeNS("tmp", tagName, Integer.toString(tagged.size()));
    tagged.add(element);

    NodeList nl = DOMUtils.getChildElements(element);
    for (int i = 0; i < nl.getLength(); i++) {
      tagElements((Element) nl.item(i));
    }
  }
}
