/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.international.arabic.pipeline.DefaultLexicalMapper;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;

public class ArabicTreeNormalizer
extends BobChrisTreeNormalizer {
    private final boolean retainNPTmp;
    private final boolean retainNPSbj;
    private final boolean markPRDverb;
    private final boolean changeNoLabels;
    private final boolean retainPPClr;
    private final DefaultLexicalMapper lexMapper;
    private final Pattern prdPattern;
    private final TregexPattern prdVerbPattern;
    private final TregexPattern npSbjPattern;
    private final String rootLabel;
    private static final long serialVersionUID = -1592231121068698494L;

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels, boolean retainNPSbj, boolean retainPPClr) {
        super(new ArabicTreebankLanguagePack());
        this.retainNPTmp = retainNPTmp;
        this.retainNPSbj = retainNPSbj;
        this.markPRDverb = markPRDverb;
        this.changeNoLabels = changeNoLabels;
        this.retainPPClr = retainPPClr;
        this.rootLabel = this.tlp.startSymbol();
        try {
            this.prdVerbPattern = TregexPattern.compile("/^V[^P]/ > VP $ /-PRD$/=prd");
            this.prdPattern = Pattern.compile("^[A-Z]+-PRD");
            this.npSbjPattern = TregexPattern.compile("/^NP-SBJ/ !> @VP");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        this.emptyFilter = new ArabicEmptyFilter();
        this.lexMapper = new DefaultLexicalMapper();
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb, boolean changeNoLabels) {
        this(retainNPTmp, markPRDverb, changeNoLabels, false, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp, boolean markPRDverb) {
        this(retainNPTmp, markPRDverb, false);
    }

    public ArabicTreeNormalizer(boolean retainNPTmp) {
        this(retainNPTmp, false);
    }

    public ArabicTreeNormalizer() {
        this(false);
    }

    public String normalizeNonterminal(String category) {
        String normalizedString;
        if (this.changeNoLabels) {
            normalizedString = category;
        } else if (this.retainNPTmp && category != null && category.startsWith("NP-TMP")) {
            normalizedString = "NP-TMP";
        } else if (this.retainNPSbj && category != null && category.startsWith("NP-SBJ")) {
            normalizedString = "NP-SBJ";
        } else if (this.retainPPClr && category != null && category.startsWith("PP-CLR")) {
            normalizedString = "PP-CLR";
        } else if (this.markPRDverb && category != null && this.prdPattern.matcher(category).matches()) {
            normalizedString = category;
        } else {
            return super.normalizeNonterminal(category);
        }
        return normalizedString.intern();
    }

    public String normalizeTerminal(String leaf) {
        if (!this.changeNoLabels) {
            leaf = this.lexMapper.map(null, leaf);
        }
        return leaf.intern();
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        Tree match;
        TregexMatcher m;
        tree = tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
        for (Tree t : tree) {
            if (t.isPreTerminal() && (t.label().value() == null || t.label().value().equals(""))) {
                System.err.printf("%s: missing tag for\n%s\n", this.getClass().getName(), t.pennString());
            }
            if (t.isPreTerminal() || t.isLeaf()) continue;
            int nk = t.numChildren();
            ArrayList<Tree> newKids = new ArrayList<Tree>(nk);
            for (int j = 0; j < nk; ++j) {
                Tree child = t.getChild(j);
                if (child.isLeaf()) {
                    System.err.printf("%s: Splicing in DUMMYTAG for\n%s\n", this.getClass().getName(), t.pennString());
                    newKids.add(tf.newTreeNode("DUMMYTAG", Collections.singletonList(child)));
                    continue;
                }
                newKids.add(child);
            }
            t.setChildren(newKids);
        }
        if (this.markPRDverb) {
            m = this.prdVerbPattern.matcher(tree);
            match = null;
            while (m.find()) {
                if (m.getMatch() == match) continue;
                match = m.getMatch();
                match.label().setValue(match.label().value() + "-PRDverb");
                Tree prd = m.getNode("prd");
                prd.label().setValue(super.normalizeNonterminal(prd.label().value()));
            }
        }
        if (this.retainNPSbj) {
            m = this.npSbjPattern.matcher(tree);
            while (m.find()) {
                match = m.getMatch();
                match.label().setValue("NP");
            }
        }
        if (tree.isPreTerminal()) {
            String val = tree.label().value();
            if (val.equals("CC") || val.equals("PUNC") || val.equals("CONJ")) {
                System.err.printf("%s: Bare tagged word being wrapped in FRAG\n%s\n", this.getClass().getName(), tree.pennString());
                tree = tf.newTreeNode("FRAG", Collections.singletonList(tree));
            } else {
                System.err.printf("%s: Bare tagged word\n%s\n", this.getClass().getName(), tree.pennString());
            }
        }
        while (tree != null && (tree.value() == null || tree.value().equals("")) && tree.numChildren() <= 1) {
            tree = tree.firstChild();
        }
        if (tree != null && !tree.value().equals(this.rootLabel)) {
            tree = tf.newTreeNode(this.rootLabel, Collections.singletonList(tree));
        }
        return tree;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArabicEmptyFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = 7417844982953945964L;

        @Override
        public boolean accept(Tree t) {
            if (t.isPreTerminal() && (t.value().equals("PRON_1S") || t.value().equals("PRP")) && (t.firstChild().value().equals("nullp") || t.firstChild().value().equals("\u0646\u0644\u0644\u0629") || t.firstChild().value().equals("-~a"))) {
                return false;
            }
            return !t.isPreTerminal() || t.value() == null || !t.value().equals("-NONE-");
        }
    }
}

